/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.properties.PropertyMap;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.client.telemetry.ClientTelemetryManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.auth.LoginData;
import ru.vidtu.ias.config.IASConfig;
import ru.vidtu.ias.mixins.MinecraftAccessor;
import ru.vidtu.ias.screen.AccountScreen;
import ru.vidtu.ias.utils.Expression;
import ru.vidtu.ias.utils.IUtils;
import ru.vidtu.ias.utils.exceptions.FriendlyException;

public final class IASMinecraft {
    public static final SystemToast.SystemToastIds NICK_WARN = SystemToast.SystemToastIds.UNSECURE_SERVER_WARNING;
    public static final ResourceLocation SPRITE = new ResourceLocation("ias", "textures/gui/sprite.png");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS/IASMinecraft");
    private static int textX;
    private static int textY;
    private static Component text;

    private IASMinecraft() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void init(Path gameDir, Path configDir, String loader, String modVersion, String loaderVersion) {
        String gameVersion = SharedConstants.m_183709_().m_132493_();
        LOGGER.info("IAS: Booting up... (version: {}, loader: {}, loader version: {}, game version: {})", new Object[]{modVersion, loader, loaderVersion, gameVersion});
        IAS.init(gameDir, configDir, modVersion, loader, loaderVersion, gameVersion);
    }

    public static void close(@NotNull Minecraft minecraft) {
        if (IAS.shuttingDownHack) {
            return;
        }
        IAS.shuttingDownHack = true;
        Screen prevScreen = minecraft.f_91080_;
        minecraft.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"ias.closing")));
        IAS.close();
        minecraft.m_91346_(prevScreen);
        IAS.shuttingDownHack = false;
    }

    public static void onInit(Minecraft minecraft, Screen screen, Consumer<Button> buttonAdder) {
        Font font;
        Integer cy;
        Integer cx;
        ImageButton button;
        int y2;
        int x2;
        int y1;
        int x1;
        LayoutElement le;
        boolean overlapping;
        Integer y;
        Integer x;
        int height;
        int width;
        if (IASConfig.titleButton && screen instanceof TitleScreen) {
            width = screen.f_96543_;
            height = screen.f_96544_;
            x = Expression.parsePosition(IASConfig.titleButtonX, width, height);
            y = Expression.parsePosition(IASConfig.titleButtonY, width, height);
            if (x == null || y == null) {
                x = width / 2 + 104;
                y = height / 4 + 72;
                for (int i = 0; i < 64; ++i) {
                    overlapping = false;
                    for (GuiEventListener child : screen.m_6702_()) {
                        if (!(child instanceof LayoutElement)) continue;
                        le = (LayoutElement)child;
                        if (child instanceof AbstractSelectionList) continue;
                        x1 = le.m_252754_() - 4;
                        y1 = le.m_252907_() - 4;
                        x2 = x1 + le.m_5711_() + 8;
                        y2 = y1 + le.m_93694_() + 8;
                        if (x < x1 || y < y1 || x + 20 > x2 || y + 20 > y2) continue;
                        x = Math.max(x, x2);
                        overlapping = true;
                    }
                    if (!overlapping) break;
                }
            }
            button = new ImageButton(x.intValue(), y.intValue(), 20, 20, 0, 0, 20, SPRITE, 256, 256, btn -> minecraft.m_91152_((Screen)new AccountScreen(screen)), (Component)Component.m_237113_((String)"In-Game Account Switcher"));
            button.m_257544_(Tooltip.m_257550_((Component)button.m_6035_()));
            button.m_257427_(250);
            buttonAdder.accept((Button)button);
        }
        if (IASConfig.serversButton && screen instanceof JoinMultiplayerScreen) {
            width = screen.f_96543_;
            height = screen.f_96544_;
            x = Expression.parsePosition(IASConfig.serversButtonX, width, height);
            y = Expression.parsePosition(IASConfig.serversButtonY, width, height);
            if (x == null || y == null) {
                x = width / 2 + 158;
                y = height - 30;
                for (int i = 0; i < 64; ++i) {
                    overlapping = false;
                    for (GuiEventListener child : screen.m_6702_()) {
                        if (!(child instanceof LayoutElement)) continue;
                        le = (LayoutElement)child;
                        if (child instanceof AbstractSelectionList) continue;
                        x1 = le.m_252754_() - 4;
                        y1 = le.m_252907_() - 4;
                        x2 = x1 + le.m_5711_() + 8;
                        y2 = y1 + le.m_93694_() + 8;
                        if (x < x1 || y < y1 || x + 20 > x2 || y + 20 > y2) continue;
                        x = Math.max(x, x2);
                        overlapping = true;
                    }
                    if (!overlapping) break;
                }
            }
            button = new ImageButton(x.intValue(), y.intValue(), 20, 20, 0, 0, 20, SPRITE, 256, 256, btn -> minecraft.m_91152_((Screen)new AccountScreen(screen)), (Component)Component.m_237113_((String)"In-Game Account Switcher"));
            button.m_257544_(Tooltip.m_257550_((Component)button.m_6035_()));
            button.m_257427_(250);
            buttonAdder.accept((Button)button);
        }
        if (IASConfig.titleText && screen instanceof TitleScreen) {
            int n;
            width = screen.f_96543_;
            height = screen.f_96544_;
            cx = Expression.parsePosition(IASConfig.titleTextX, width, height);
            cy = Expression.parsePosition(IASConfig.titleTextY, width, height);
            font = minecraft.f_91062_;
            User user = minecraft.m_91094_();
            text = Component.m_237110_((String)"ias.title", (Object[])new Object[]{user != null ? user.m_92546_() : "(broken by mods)"});
            if (cx == null || cy == null) {
                n = (width - font.m_92852_((FormattedText)text)) / 2;
            } else {
                switch (IASConfig.titleTextAlign) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LEFT: {
                        n = cx;
                        break;
                    }
                    case CENTER: {
                        n = cx - font.m_92852_((FormattedText)text) / 2;
                        break;
                    }
                    case RIGHT: {
                        n = cx - font.m_92852_((FormattedText)text);
                    }
                }
            }
            textX = n;
            int n2 = textY = cx == null || cy == null ? height / 4 + 164 : cy;
        }
        if (IASConfig.serversText && screen instanceof JoinMultiplayerScreen) {
            int n;
            width = screen.f_96543_;
            height = screen.f_96544_;
            cx = Expression.parsePosition(IASConfig.serversTextX, width, height);
            cy = Expression.parsePosition(IASConfig.serversTextY, width, height);
            font = minecraft.f_91062_;
            User user = minecraft.m_91094_();
            text = Component.m_237110_((String)"ias.title", (Object[])new Object[]{user != null ? user.m_92546_() : "(broken by mods)"});
            if (cx == null || cy == null) {
                n = (width - font.m_92852_((FormattedText)text)) / 2;
            } else {
                switch (IASConfig.serversTextAlign) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LEFT: {
                        n = cx;
                        break;
                    }
                    case CENTER: {
                        n = cx - font.m_92852_((FormattedText)text) / 2;
                        break;
                    }
                    case RIGHT: {
                        n = cx - font.m_92852_((FormattedText)text);
                    }
                }
            }
            textX = n;
            int n3 = textY = cx == null || cy == null ? 5 : cy;
        }
        if (!IASConfig.nickWarns || !(screen instanceof ConnectScreen) || minecraft.m_91300_().m_94926_(SystemToast.class, (Object)NICK_WARN) != null) {
            return;
        }
        User user = minecraft.m_91094_();
        String name = user != null ? user.m_92546_() : "";
        String key = IUtils.warnKey(name);
        if (key == null) {
            return;
        }
        ToastComponent toasts = minecraft.m_91300_();
        toasts.m_94922_((Toast)SystemToast.m_94847_((Minecraft)minecraft, (SystemToast.SystemToastIds)NICK_WARN, (Component)Component.m_237113_((String)"In-Game Account Switcher"), (Component)Component.m_237110_((String)key, (Object[])new Object[]{name})));
    }

    public static void onDraw(Screen screen, Font font, GuiGraphics graphics) {
        if (IASConfig.titleText && screen instanceof TitleScreen) {
            graphics.m_280430_(font, text, textX, textY, -3372920);
        }
        if (IASConfig.serversText && screen instanceof JoinMultiplayerScreen) {
            graphics.m_280430_(font, text, textX, textY, -3372920);
        }
    }

    public static CompletableFuture<Void> account(Minecraft minecraft, LoginData data) {
        LOGGER.info("IAS: Received login request: {}", (Object)data);
        if (minecraft.f_91074_ != null || minecraft.f_91073_ != null || minecraft.m_91403_() != null || minecraft.f_91075_ != null || minecraft.f_91072_ != null || minecraft.m_257720_()) {
            return CompletableFuture.failedFuture(new FriendlyException("Changing accounts in world.", "ias.error.world"));
        }
        return CompletableFuture.runAsync(() -> {
            UserApiService apiService;
            LOGGER.info("IAS: Creating user...");
            boolean online = data.online();
            User.Type type = online ? User.Type.MSA : User.Type.LEGACY;
            User user = new User(data.name(), data.uuid().toString(), data.token(), Optional.empty(), Optional.empty(), type);
            MinecraftAccessor accessor = (MinecraftAccessor)minecraft;
            if (online) {
                try {
                    apiService = accessor.ias$authenticationService().createUserApiService(data.token());
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unable to create user API service.", t);
                }
            } else {
                apiService = UserApiService.OFFLINE;
            }
            PlayerSocialManager social = new PlayerSocialManager(minecraft, apiService);
            ClientTelemetryManager telemetry = new ClientTelemetryManager(minecraft, apiService, user);
            ProfileKeyPairManager keyPair = ProfileKeyPairManager.m_252915_((UserApiService)apiService, (User)user, (Path)minecraft.f_91069_.toPath());
            ReportingContext reporting = ReportingContext.m_239685_((ReportEnvironment)ReportEnvironment.m_239898_(), (UserApiService)apiService);
            GameProfile gameProfile = minecraft.m_91108_().fillProfileProperties(user.m_92548_(), false);
            PropertyMap propertyMap = new PropertyMap();
            propertyMap.putAll((Multimap)gameProfile.getProperties());
            minecraft.execute(() -> {
                LOGGER.info("IAS: Flushing user...");
                accessor.ias$user(user);
                accessor.ias$userApiService(apiService);
                accessor.ias$profileProperties(propertyMap);
                accessor.ias$playerSocialManager(social);
                accessor.ias$telemetryManager(telemetry);
                accessor.ias$profileKeyPairManager(keyPair);
                accessor.ias$reportingContext(reporting);
                minecraft.m_91341_();
                LOGGER.info("IAS: Flushed user.");
            });
        }, IAS.executor()).exceptionally(t -> {
            LOGGER.error("IAS: Unable to log in: {}.", (Object)data, t);
            throw new RuntimeException("Unable to change account to: " + data, (Throwable)t);
        });
    }

    static {
        text = Component.m_237110_((String)"ias.title", (Object[])new Object[]{"(not loaded for some reason)"});
    }
}

