/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import ru.vidtu.ias.IASMinecraft;
import ru.vidtu.ias.screen.ConfigScreen;

@Mod(value="ias")
public final class IASForge {
    public IASForge() {
        String forgeModName;
        boolean isProbablyMcForge;
        boolean allowOnForge = Boolean.getBoolean("ias.allowForgeVersionOnNeoForge");
        if (!allowOnForge && (isProbablyMcForge = "neoforge".equalsIgnoreCase(forgeModName = ModList.get().getModContainerById("forge").map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse("UNKNOWN")))) {
            throw new IllegalStateException("IAS: You've tried to use plain Forge version of the In-Game Account Switcher mod with NeoForge. This is not supported. The IAS mod has its own separate NeoForge version, use that one. If you still want to use Forge version on NeoForge without any support, add '-Dias.allowForgeVersionOnNeoForge=true' to your game JVM start-up flags.");
        }
        if (FMLEnvironment.dist != Dist.CLIENT) {
            throw new UnsupportedOperationException("IAS: You've tried to load the In-Game Account Switcher mod on a server. This won't work.");
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerDisplayTest(IExtensionPoint.DisplayTest.IGNORE_ALL_VERSION);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new ConfigScreen((Screen)screen)));
        String modVersion = ModList.get().getModContainerById("ias").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(Object::toString).orElse("UNKNOWN");
        String loaderVersion = ModList.get().getModContainerById("forge").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(Object::toString).orElse("UNKNOWN");
        IASMinecraft.init(FMLPaths.GAMEDIR.get(), FMLPaths.CONFIGDIR.get(), "Forge", modVersion, loaderVersion);
    }

    @SubscribeEvent
    public void onShutDown(GameShuttingDownEvent event) {
        IASMinecraft.close(Minecraft.m_91087_());
    }

    @SubscribeEvent
    public void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        IASMinecraft.onInit(screen.getMinecraft(), screen, arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0));
    }

    @SubscribeEvent
    public void onScreenDraw(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        IASMinecraft.onDraw(screen, screen.getMinecraft().f_91062_, event.getGuiGraphics());
    }
}

