/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mafuyu404.oelib.OELib;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;

public class CodecUtils {
    private static final Map<Class<?>, Codec<?>> codecCache = new ConcurrentHashMap();

    public static <T> Optional<String> encodeToJson(Class<T> dataClass, Map<ResourceLocation, T> data) {
        try {
            Codec<Map<ResourceLocation, T>> mapCodec = CodecUtils.createMapCodec(dataClass);
            DataResult result = mapCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, data);
            if (result.error().isPresent()) {
                DataResult.PartialResult error = (DataResult.PartialResult)result.error().get();
                OELib.LOGGER.error("Failed to encode {} data: {}", (Object)dataClass.getSimpleName(), (Object)error.message());
                return Optional.empty();
            }
            return result.result().map(JsonElement::toString);
        }
        catch (Exception e) {
            OELib.LOGGER.error("Exception during {} encoding: {}", new Object[]{dataClass.getSimpleName(), e.getMessage(), e});
            return Optional.empty();
        }
    }

    public static <T> Optional<Map<ResourceLocation, T>> decodeFromJson(Class<T> dataClass, String jsonData) {
        try {
            JsonElement jsonElement = JsonParser.parseString((String)jsonData);
            Codec<Map<ResourceLocation, T>> mapCodec = CodecUtils.createMapCodec(dataClass);
            DataResult result = mapCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            if (result.error().isPresent()) {
                DataResult.PartialResult error = (DataResult.PartialResult)result.error().get();
                OELib.LOGGER.error("Failed to decode {} data: {}", (Object)dataClass.getSimpleName(), (Object)error.message());
                return Optional.empty();
            }
            return result.result();
        }
        catch (Exception e) {
            OELib.LOGGER.error("Exception during {} decoding: {}", new Object[]{dataClass.getSimpleName(), e.getMessage(), e});
            return Optional.empty();
        }
    }

    public static <T> Optional<T> decodeSingle(Class<T> dataClass, JsonElement jsonElement) {
        try {
            Codec<T> codec = CodecUtils.getCodec(dataClass);
            DataResult result = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            if (result.error().isPresent()) {
                DataResult.PartialResult error = (DataResult.PartialResult)result.error().get();
                OELib.LOGGER.error("Failed to decode {} data: {}", (Object)dataClass.getSimpleName(), (Object)error.message());
                return Optional.empty();
            }
            return result.result();
        }
        catch (Exception e) {
            OELib.LOGGER.error("Exception during {} decoding: {}", new Object[]{dataClass.getSimpleName(), e.getMessage(), e});
            return Optional.empty();
        }
    }

    private static <T> Codec<Map<ResourceLocation, T>> createMapCodec(Class<T> dataClass) {
        Codec<T> codec = CodecUtils.getCodec(dataClass);
        return Codec.unboundedMap((Codec)ResourceLocation.f_135803_, codec);
    }

    private static <T> Codec<T> getCodec(Class<T> dataClass) {
        return codecCache.computeIfAbsent(dataClass, cls -> {
            try {
                Field codecField = cls.getDeclaredField("CODEC");
                codecField.setAccessible(true);
                return (Codec)codecField.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get CODEC field from " + cls.getSimpleName() + ". Make sure the class has a public static final CODEC field.", e);
            }
        });
    }
}

