/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.network;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.api.net.INetworkManager;
import com.mafuyu404.oelib.api.net.INetworkPacket;
import com.mafuyu404.oelib.api.net.NetworkPacket;
import com.mafuyu404.oelib.api.net.Side;
import com.mafuyu404.oelib.forge.data.net.DataSyncChunkPacket;
import com.mafuyu404.oelib.forge.network.ForgeNetworkContext;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkManager
implements INetworkManager {
    private static final String PROTOCOL_VERSION = "1";
    private static final Map<Class<?>, PacketInfo<?>> registeredPackets = new ConcurrentHashMap();
    private static final Map<String, ChannelContext> channels = new ConcurrentHashMap<String, ChannelContext>();
    private static final Map<Class<?>, String> packetOwnerMod = new ConcurrentHashMap();
    private static NetworkManager instance;

    public static void initialize() {
        NetworkManager.ensureChannel("oelib");
        instance = new NetworkManager();
        com.mafuyu404.oelib.api.net.NetworkManager.setInstance(instance);
        NetworkManager.registerBuiltinPackets();
        OELib.LOGGER.info("Network manager initialized");
    }

    private static ChannelContext ensureChannel(String modid) {
        return channels.computeIfAbsent(modid, id -> {
            SimpleChannel ch = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(id, "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
            ChannelContext ctx = new ChannelContext(ch);
            NetworkManager.internalRegisterPacket(ctx, id, DataSyncChunkPacket.class);
            OELib.LOGGER.info("Created SimpleChannel for mod {}: {}", id, (Object)new ResourceLocation(id, "main"));
            return ctx;
        });
    }

    private static String currentModIdOrDefault() {
        try {
            String id;
            ModContainer container = ModLoadingContext.get().getActiveContainer();
            if (container != null && (id = container.getModId()) != null && !id.isBlank()) {
                return id;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "oelib";
    }

    @Override
    @SafeVarargs
    public final void registerPackets(Class<? extends INetworkPacket<?>> ... packetClasses) {
        List<Class<INetworkPacket<?>>> sortedClasses = Arrays.asList(packetClasses);
        sortedClasses.sort((a, b) -> {
            NetworkPacket annotationA = a.getAnnotation(NetworkPacket.class);
            NetworkPacket annotationB = b.getAnnotation(NetworkPacket.class);
            int priorityA = annotationA != null ? annotationA.priority() : 1000;
            int priorityB = annotationB != null ? annotationB.priority() : 1000;
            return Integer.compare(priorityA, priorityB);
        });
        String modid = NetworkManager.currentModIdOrDefault();
        ChannelContext ctx = NetworkManager.ensureChannel(modid);
        for (Class<? extends INetworkPacket<?>> clazz : sortedClasses) {
            NetworkManager.registerPacketUnchecked(ctx, modid, clazz);
        }
    }

    private static void registerPacketUnchecked(ChannelContext ctx, String modid, Class<? extends INetworkPacket<?>> packetClass) {
        NetworkManager.internalRegisterPacket(ctx, modid, packetClass);
    }

    public static <T extends INetworkPacket<T>> void registerPacket(Class<T> packetClass) {
        ChannelContext ctx = NetworkManager.ensureChannel("oelib");
        NetworkManager.internalRegisterPacket(ctx, "oelib", packetClass);
    }

    private static <T extends INetworkPacket<T>> void internalRegisterPacket(ChannelContext ctx, String modid, Class<T> packetClass) {
        if (!packetClass.isAnnotationPresent(NetworkPacket.class)) {
            throw new IllegalArgumentException("Class " + packetClass.getSimpleName() + " must be annotated with @NetworkPacket");
        }
        if (ctx.packets.containsKey(packetClass)) {
            OELib.LOGGER.warn("Packet {} is already registered for mod {}, skipping", (Object)packetClass.getSimpleName(), (Object)modid);
            return;
        }
        try {
            Method decodeMethod = packetClass.getDeclaredMethod("decode", FriendlyByteBuf.class);
            decodeMethod.setAccessible(true);
            Function<FriendlyByteBuf, INetworkPacket> decoder = buf -> {
                try {
                    return (INetworkPacket)decodeMethod.invoke(null, buf);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to decode packet " + packetClass.getSimpleName(), e);
                }
            };
            PacketInfo<INetworkPacket> info = new PacketInfo<INetworkPacket>(packetClass, decoder);
            ctx.packets.put(packetClass, info);
            registeredPackets.put(packetClass, info);
            packetOwnerMod.put(packetClass, modid);
            NetworkPacket annotation = packetClass.getAnnotation(NetworkPacket.class);
            Side side = annotation.side();
            Optional<NetworkDirection> networkDirection = NetworkManager.getNetworkDirection(side);
            ctx.channel.registerMessage(ctx.nextPacketId++, packetClass, INetworkPacket::encode, decoder, (packet, c) -> {
                ((NetworkEvent.Context)c.get()).enqueueWork(() -> NetworkManager.lambda$internalRegisterPacket$4((Supplier)c, packet));
                ((NetworkEvent.Context)c.get()).setPacketHandled(true);
            }, networkDirection);
            int chunkThreshold = annotation.chunkThreshold();
            OELib.LOGGER.info("Registered network packet: {} (mod: {}, ID: {}, Side: {}, NetworkDirection: {}, Chunk Threshold: {} bytes)", new Object[]{packetClass.getSimpleName(), modid, ctx.nextPacketId - 1, side, networkDirection.map(Enum::name).orElse("BOTH"), chunkThreshold > 0 ? Integer.valueOf(chunkThreshold) : "No chunking"});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register packet " + packetClass.getSimpleName() + " for mod " + modid, e);
        }
    }

    private static Optional<NetworkDirection> getNetworkDirection(Side side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.CLIENT -> Optional.of(NetworkDirection.PLAY_TO_CLIENT);
            case Side.SERVER -> Optional.of(NetworkDirection.PLAY_TO_SERVER);
            case Side.BOTH -> Optional.empty();
        };
    }

    private static SimpleChannel resolveChannelForPacket(Class<?> packetClass) {
        ChannelContext ctx;
        String modid = packetOwnerMod.get(packetClass);
        if (modid != null && (ctx = channels.get(modid)) != null) {
            return ctx.channel;
        }
        OELib.LOGGER.warn("Packet {} has no owner channel, fallback to OELib default channel", (Object)packetClass.getSimpleName());
        return NetworkManager.ensureChannel((String)"oelib").channel;
    }

    @Override
    public <T extends INetworkPacket<T>> void sendToPlayer(T packet, ServerPlayer player) {
        SimpleChannel ch = NetworkManager.resolveChannelForPacket(packet.getClass());
        if (ch == null) {
            throw new IllegalStateException("Network manager not initialized");
        }
        if (player == null) {
            OELib.LOGGER.warn("Cannot send packet {}: player is null", (Object)packet.getClass().getSimpleName());
            return;
        }
        try {
            ch.send(PacketDistributor.PLAYER.with(() -> player), packet);
            OELib.LOGGER.debug("Sent packet {} to player {}", (Object)packet.getClass().getSimpleName(), (Object)player.m_7755_().getString());
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send packet {} to player {}: {}", new Object[]{packet.getClass().getSimpleName(), player.m_7755_().getString(), e.getMessage(), e});
        }
    }

    @Override
    public <T extends INetworkPacket<T>> void sendToAll(T packet) {
        SimpleChannel ch = NetworkManager.resolveChannelForPacket(packet.getClass());
        if (ch == null) {
            throw new IllegalStateException("Network manager not initialized");
        }
        try {
            ch.send(PacketDistributor.ALL.noArg(), packet);
            OELib.LOGGER.debug("Sent packet {} to all players", (Object)packet.getClass().getSimpleName());
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send packet {} to all players: {}", new Object[]{packet.getClass().getSimpleName(), e.getMessage(), e});
        }
    }

    @Override
    public <T extends INetworkPacket<T>> void sendToServer(T packet) {
        SimpleChannel ch = NetworkManager.resolveChannelForPacket(packet.getClass());
        if (ch == null) {
            throw new IllegalStateException("Network manager not initialized");
        }
        try {
            ch.sendToServer(packet);
            OELib.LOGGER.debug("Sent packet {} to server", (Object)packet.getClass().getSimpleName());
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send packet {} to server: {}", new Object[]{packet.getClass().getSimpleName(), e.getMessage(), e});
        }
    }

    @Override
    public <T extends INetworkPacket<T>> void sendToPlayerWithChunking(T packet, ServerPlayer player) {
        SimpleChannel ch = NetworkManager.resolveChannelForPacket(packet.getClass());
        if (ch == null) {
            throw new IllegalStateException("Network manager not initialized");
        }
        if (player == null) {
            OELib.LOGGER.warn("Cannot send packet {}: player is null", (Object)packet.getClass().getSimpleName());
            return;
        }
        NetworkPacket annotation = packet.getClass().getAnnotation(NetworkPacket.class);
        if (annotation != null && annotation.chunkThreshold() > 0) {
            NetworkManager.sendWithChunking(ch, packet, PacketDistributor.PLAYER.with(() -> player), annotation.chunkThreshold());
        } else {
            this.sendToPlayer(packet, player);
        }
    }

    @Override
    public <T extends INetworkPacket<T>> void sendToAllWithChunking(T packet) {
        SimpleChannel ch = NetworkManager.resolveChannelForPacket(packet.getClass());
        if (ch == null) {
            throw new IllegalStateException("Network manager not initialized");
        }
        NetworkPacket annotation = packet.getClass().getAnnotation(NetworkPacket.class);
        if (annotation != null && annotation.chunkThreshold() > 0) {
            NetworkManager.sendWithChunking(ch, packet, PacketDistributor.ALL.noArg(), annotation.chunkThreshold());
        } else {
            this.sendToAll(packet);
        }
    }

    private static <T extends INetworkPacket<T>> void sendWithChunking(SimpleChannel ch, T packet, PacketDistributor.PacketTarget target, int chunkThreshold) {
        try {
            FriendlyByteBuf tempBuf = new FriendlyByteBuf(Unpooled.buffer());
            packet.encode(tempBuf);
            byte[] packetData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(packetData);
            tempBuf.release();
            if (packetData.length <= chunkThreshold) {
                ch.send(target, packet);
                OELib.LOGGER.debug("Sent packet {} without chunking ({} bytes)", (Object)packet.getClass().getSimpleName(), (Object)packetData.length);
            } else {
                NetworkManager.sendChunkedPacket(ch, packetData, packet.getClass().getName(), target, chunkThreshold);
            }
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send packet {} with chunking: {}", new Object[]{packet.getClass().getSimpleName(), e.getMessage(), e});
        }
    }

    private static void sendChunkedPacket(SimpleChannel ch, byte[] data, String packetClassName, PacketDistributor.PacketTarget target, int chunkSize) {
        try {
            UUID sessionId = UUID.randomUUID();
            int totalChunks = (int)Math.ceil((double)data.length / (double)chunkSize);
            OELib.LOGGER.info("Splitting {} packet into {} chunks for session {} ({} bytes total)", new Object[]{packetClassName, totalChunks, sessionId, data.length});
            for (int i = 0; i < totalChunks; ++i) {
                int start = i * chunkSize;
                int end = Math.min(start + chunkSize, data.length);
                int currentChunkSize = end - start;
                byte[] chunkData = new byte[currentChunkSize];
                System.arraycopy(data, start, chunkData, 0, currentChunkSize);
                DataSyncChunkPacket chunk = new DataSyncChunkPacket(sessionId, i, totalChunks, packetClassName, chunkData);
                ch.send(target, (Object)chunk);
                OELib.LOGGER.debug("Sent chunk {}/{} ({} bytes) for {} session {}", new Object[]{i + 1, totalChunks, currentChunkSize, packetClassName, sessionId});
            }
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send chunked packet {}: {}", new Object[]{packetClassName, e.getMessage(), e});
        }
    }

    public static int getRegisteredPacketCount() {
        return registeredPackets.size();
    }

    public static Set<Class<?>> getRegisteredPacketClasses() {
        return new HashSet(registeredPackets.keySet());
    }

    public static SimpleChannel getChannel() {
        return NetworkManager.ensureChannel((String)"oelib").channel;
    }

    private static void registerBuiltinPackets() {
        NetworkManager.internalRegisterPacket(NetworkManager.ensureChannel("oelib"), "oelib", DataSyncChunkPacket.class);
        OELib.LOGGER.info("Registered builtin data sync packets");
    }

    private static /* synthetic */ void lambda$internalRegisterPacket$4(Supplier c, INetworkPacket packet) {
        ForgeNetworkContext context = new ForgeNetworkContext((NetworkEvent.Context)c.get());
        packet.handle(context);
    }

    private static final class ChannelContext {
        final SimpleChannel channel;
        int nextPacketId = 0;
        final Map<Class<?>, PacketInfo<?>> packets = new ConcurrentHashMap();

        ChannelContext(SimpleChannel channel) {
            this.channel = channel;
        }
    }

    private record PacketInfo<T extends INetworkPacket<T>>(Class<T> packetClass, Function<FriendlyByteBuf, T> decoder) {
    }
}

