/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class FunctionRegistryEvent
extends Event {
    private final List<Pair<Class<?>, String>> registered = new ArrayList();
    private final Set<String> requiredFunctions;
    private final boolean smartRegistration;

    public FunctionRegistryEvent() {
        this.requiredFunctions = Collections.emptySet();
        this.smartRegistration = false;
    }

    public FunctionRegistryEvent(Set<String> requiredFunctions) {
        this.requiredFunctions = requiredFunctions != null ? requiredFunctions : Collections.emptySet();
        this.smartRegistration = true;
    }

    public boolean isSmartRegistration() {
        return this.smartRegistration;
    }

    public Set<String> getRequiredFunctions() {
        return this.requiredFunctions;
    }

    public void registerFunctionClass(Class<?> clazz, String modid) {
        if (clazz == null) {
            throw new NullPointerException("Function class cannot be null");
        }
        if (modid == null) {
            throw new NullPointerException("Mod ID cannot be null");
        }
        this.registered.add(Pair.of(clazz, (Object)modid));
    }

    public void registerFunctionClassSmart(Class<?> clazz, String modid) {
        this.registerFunctionClass(clazz, modid);
    }

    public boolean isFunctionRequired(String functionName) {
        if (!this.smartRegistration) {
            return true;
        }
        return this.requiredFunctions.contains(functionName);
    }

    public List<Pair<Class<?>, String>> getRegisteredClasses() {
        return this.registered;
    }
}

