/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.data.mvel;

import com.mafuyu404.oelib.OELib;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

public class FunctionUsageAnalyzer {
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_]*)\\s*\\(");

    public static <T> Set<String> analyzeUsedFunctions(Map<ResourceLocation, T> dataPackData, DataExpressionExtractor<T> dataExtractor) {
        HashSet<String> usedFunctions = new HashSet<String>();
        for (Map.Entry<ResourceLocation, T> entry : dataPackData.entrySet()) {
            T data = entry.getValue();
            if (!FunctionUsageAnalyzer.shouldLoadDataPackFunctions(data, entry.getKey(), dataExtractor)) continue;
            Set<String> fileFunctions = FunctionUsageAnalyzer.analyzeSingleFile(data, dataExtractor);
            usedFunctions.addAll(fileFunctions);
        }
        OELib.LOGGER.debug("Found {} used functions in data packages: {}", (Object)usedFunctions.size(), usedFunctions);
        return usedFunctions;
    }

    private static <T> boolean shouldLoadDataPackFunctions(T data, ResourceLocation location, DataExpressionExtractor<T> dataExtractor) {
        Map<String, String> vars = dataExtractor.extractVariables(data);
        if (vars == null) {
            return true;
        }
        String modLoadedExpression = vars.get("modLoaded");
        if (modLoadedExpression == null) {
            return true;
        }
        try {
            String modId = FunctionUsageAnalyzer.extractModIdFromExpression(modLoadedExpression);
            if (modId != null) {
                boolean isLoaded = ModList.get().isLoaded(modId);
                OELib.LOGGER.debug("Mod '{}' loaded status: {} for datapack {}", new Object[]{modId, isLoaded, location});
                return isLoaded;
            }
        }
        catch (Exception e) {
            OELib.LOGGER.debug("Failed to evaluate modLoaded expression for {}: {}", (Object)location, (Object)e.getMessage());
        }
        return true;
    }

    private static String extractModIdFromExpression(String expression) {
        if (expression == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("isModLoaded\\s*\\(\\s*['\"]([^'\"]+)['\"]\\s*\\)");
        Matcher matcher = pattern.matcher(expression);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static <T> Set<String> analyzeSingleFile(T data, DataExpressionExtractor<T> dataExtractor) {
        HashSet<String> functions = new HashSet<String>();
        Set<String> expressions = dataExtractor.extractAllExpressions(data);
        for (String expression : expressions) {
            functions.addAll(FunctionUsageAnalyzer.extractFunctionsFromExpression(expression));
        }
        return functions;
    }

    public static Set<String> extractFunctionsFromExpression(String expression) {
        HashSet<String> functions = new HashSet<String>();
        if (expression == null || expression.trim().isEmpty()) {
            return functions;
        }
        Matcher matcher = FUNCTION_PATTERN.matcher(expression);
        while (matcher.find()) {
            String functionName = matcher.group(1);
            if (FunctionUsageAnalyzer.isKeyword(functionName)) continue;
            functions.add(functionName);
        }
        return functions;
    }

    private static boolean isKeyword(String word) {
        Set<String> keywords = Set.of("if", "else", "for", "while", "do", "switch", "case", "default", "try", "catch", "finally", "throw", "throws", "return", "break", "continue", "new", "this", "super", "null", "true", "false", "instanceof", "public", "private", "protected", "static", "final", "abstract", "class", "interface", "extends", "implements", "package", "import", "int", "long", "float", "double", "boolean", "char", "byte", "short", "void", "String", "Object", "List", "Map", "Set");
        return keywords.contains(word);
    }

    public static Set<String> getCoreRequiredFunctions() {
        return Set.of("isModLoaded");
    }

    public static interface DataExpressionExtractor<T> {
        public Map<String, String> extractVariables(T var1);

        public Set<String> extractAllExpressions(T var1);
    }
}

