/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.data.mvel;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.api.data.ExpressionFunction;
import com.mafuyu404.oelib.forge.data.mvel.CoreFunctions;
import com.mafuyu404.oelib.forge.data.mvel.FunctionUsageAnalyzer;
import com.mafuyu404.oelib.forge.event.FunctionRegistryEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class ExpressionEngine {
    private static final Set<Class<?>> registeredClasses = ConcurrentHashMap.newKeySet();
    private static final Map<String, Method> functionMap = new ConcurrentHashMap<String, Method>();
    private static final Map<String, Serializable> compiledExpressions = new ConcurrentHashMap<String, Serializable>();
    private static ParserContext parserContext = new ParserContext();
    private static boolean initialized = false;

    public static void registerFunctionClass(Class<?> clazz, String modid) {
        if (clazz == null) {
            throw new NullPointerException("Function class cannot be null");
        }
        if (modid == null) {
            throw new NullPointerException("Mod ID cannot be null");
        }
        registeredClasses.add(clazz);
        if (initialized) {
            ExpressionEngine.scanClass(clazz, modid);
        }
    }

    public static void initialize() {
        ExpressionEngine.initialize(null);
    }

    public static void initialize(Set<String> requiredFunctions) {
        functionMap.clear();
        compiledExpressions.clear();
        parserContext = new ParserContext();
        if (requiredFunctions != null) {
            HashSet<String> allRequiredFunctions = new HashSet<String>(requiredFunctions);
            allRequiredFunctions.addAll(FunctionUsageAnalyzer.getCoreRequiredFunctions());
            requiredFunctions = allRequiredFunctions;
        }
        FunctionRegistryEvent event = requiredFunctions != null ? new FunctionRegistryEvent(requiredFunctions) : new FunctionRegistryEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isSmartRegistration()) {
            ExpressionEngine.scanClassSmart(CoreFunctions.class, "oelib", event.getRequiredFunctions());
        } else {
            ExpressionEngine.scanClass(CoreFunctions.class, "oelib");
        }
        for (Pair<Class<?>, String> pair : event.getRegisteredClasses()) {
            if (event.isSmartRegistration()) {
                ExpressionEngine.scanClassSmart((Class)pair.getLeft(), (String)pair.getRight(), event.getRequiredFunctions());
                continue;
            }
            ExpressionEngine.scanClass((Class)pair.getLeft(), (String)pair.getRight());
        }
        for (Class clazz : registeredClasses) {
            if (clazz == CoreFunctions.class) continue;
            if (event.isSmartRegistration()) {
                ExpressionEngine.scanClassSmart(clazz, "unknown", event.getRequiredFunctions());
                continue;
            }
            ExpressionEngine.scanClass(clazz, "unknown");
        }
        initialized = true;
        OELib.LOGGER.info("Expression engine initialized with {} available functions (smart: {})", (Object)functionMap.size(), (Object)event.isSmartRegistration());
    }

    public static Object evaluate(String expression, Map<String, Object> context) {
        return ExpressionEngine.evaluate(expression, context, true);
    }

    public static Object evaluate(String expression, Map<String, Object> context, boolean logErrors) {
        try {
            if (!initialized) {
                if (expression.contains("isModLoaded")) {
                    ExpressionEngine.initializeCore();
                } else {
                    if (logErrors) {
                        OELib.LOGGER.warn("Expression engine not initialized, skipping expression: {}", (Object)expression);
                    }
                    return null;
                }
            }
            Serializable compiled = compiledExpressions.computeIfAbsent(expression, expr -> MVEL.compileExpression((String)expr, (ParserContext)parserContext));
            return MVEL.executeExpression((Object)compiled, (Map)(context != null ? context : new HashMap()));
        }
        catch (Exception e) {
            if (logErrors) {
                OELib.LOGGER.error("Failed to evaluate expression: {}", (Object)expression, (Object)e);
            }
            throw e;
        }
    }

    private static void initializeCore() {
        if (functionMap.isEmpty()) {
            ExpressionEngine.scanClass(CoreFunctions.class, "oelib");
            OELib.LOGGER.debug("Initialized core functions for mod loading checks");
        }
    }

    public static boolean isValidExpression(String expression) {
        try {
            ExpressionEngine.evaluate(expression, new HashMap<String, Object>(), false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Map<String, Method> getAllFunctions() {
        return new HashMap<String, Method>(functionMap);
    }

    public static void clear() {
        functionMap.clear();
        registeredClasses.clear();
        compiledExpressions.clear();
        initialized = false;
    }

    public static void hotReload() {
        ExpressionEngine.clear();
        ExpressionEngine.initialize();
        OELib.LOGGER.debug("Expression engine hot reload completed");
    }

    public static Map<String, Object> createContext(Map<String, String> vars) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (vars != null) {
            for (Map.Entry<String, String> var : vars.entrySet()) {
                try {
                    Object value = ExpressionEngine.evaluate(var.getValue(), context, false);
                    context.put(var.getKey(), value);
                }
                catch (Exception e) {
                    OELib.LOGGER.debug("Failed to evaluate variable {}: {}", (Object)var.getKey(), (Object)e.getMessage());
                    context.put(var.getKey(), var.getValue());
                }
            }
        }
        return context;
    }

    public static boolean checkConditions(Map<String, String> conditions, Map<String, Object> context) {
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> condition : conditions.entrySet()) {
            String expectedStr;
            Object expectedValue;
            String key = condition.getKey();
            String expression = condition.getValue();
            Object actualValue = context.get(key);
            try {
                expectedValue = ExpressionEngine.evaluate(expression, context, false);
            }
            catch (Exception e) {
                expectedValue = expression;
            }
            if (expectedValue instanceof String && (expectedStr = (String)expectedValue).contains("*")) {
                String pattern = expectedStr.replace("*", ".*");
                if (actualValue != null && actualValue.toString().matches(pattern)) continue;
                return false;
            }
            if (Objects.equals(expectedValue, actualValue)) continue;
            return false;
        }
        return true;
    }

    public static void executeActions(List<String> actions, Map<String, Object> context) {
        if (actions == null) {
            return;
        }
        for (String action : actions) {
            try {
                ExpressionEngine.evaluate(action, context);
            }
            catch (Exception e) {
                OELib.LOGGER.error("Failed to execute action: {}", (Object)action, (Object)e);
            }
        }
    }

    public static boolean checkModLoadedCondition(Map<String, String> vars) {
        if (vars == null || !vars.containsKey("modLoaded")) {
            return true;
        }
        try {
            HashMap<String, Object> tempContext = new HashMap<String, Object>();
            Object result = ExpressionEngine.evaluate(vars.get("modLoaded"), tempContext, false);
            return !Boolean.FALSE.equals(result);
        }
        catch (Exception e) {
            OELib.LOGGER.debug("Failed to evaluate modLoaded condition: {}", (Object)e.getMessage());
            return true;
        }
    }

    private static void scanClassSmart(Class<?> clazz, String modid, Set<String> requiredFunctions) {
        ExpressionEngine.scanClassInternal(clazz, modid, requiredFunctions, true);
    }

    private static void scanClass(Class<?> clazz, String modid) {
        ExpressionEngine.scanClassInternal(clazz, modid, null, false);
    }

    private static void scanClassInternal(Class<?> clazz, String modid, Set<String> requiredFunctions, boolean smart) {
        for (Method method : clazz.getDeclaredMethods()) {
            String name;
            ExpressionFunction ann = method.getAnnotation(ExpressionFunction.class);
            if (ann == null) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                OELib.LOGGER.warn("Expression function must be static: {}.{}", (Object)clazz.getSimpleName(), (Object)method.getName());
                continue;
            }
            String string = name = ann.value().isEmpty() ? method.getName() : ann.value();
            if (smart && (requiredFunctions == null || !requiredFunctions.contains(name))) {
                OELib.LOGGER.debug("Skipping unused function: {} ({})", (Object)name, (Object)clazz.getSimpleName());
                continue;
            }
            if (functionMap.containsKey(name)) {
                Method conflict = functionMap.get(name);
                OELib.LOGGER.warn("Function name conflict: {} conflicts with {}.{}", new Object[]{name, conflict.getDeclaringClass().getSimpleName(), conflict.getName()});
                continue;
            }
            functionMap.put(name, method);
            parserContext.addImport(name, method);
            OELib.LOGGER.debug("Registered expression function{}: {} ({})", new Object[]{smart ? " (smart)" : "", name, clazz.getSimpleName()});
        }
    }
}

