/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.data;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.api.data.DataDriven;
import com.mafuyu404.oelib.api.data.DataValidator;
import com.mafuyu404.oelib.forge.data.DataManager;
import com.mafuyu404.oelib.forge.data.mvel.ExpressionEngine;
import com.mafuyu404.oelib.forge.data.mvel.FunctionUsageAnalyzer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="oelib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DataRegistry {
    private static final Set<Class<?>> registeredTypes = ConcurrentHashMap.newKeySet();
    private static final Map<Class<?>, FunctionUsageAnalyzer.DataExpressionExtractor<?>> extractors = new ConcurrentHashMap();
    private static boolean initialized = false;
    private static boolean expressionEngineInitialized = false;

    public static <T> void register(Class<T> dataClass) {
        if (!dataClass.isAnnotationPresent(DataDriven.class)) {
            throw new IllegalArgumentException("Class " + dataClass.getSimpleName() + " must be annotated with @DataDriven");
        }
        registeredTypes.add(dataClass);
        DataManager.register(dataClass);
        OELib.LOGGER.debug("Registered data-driven type: {}", (Object)dataClass.getSimpleName());
    }

    public static <T> void registerWithNamespaces(Class<T> dataClass, String ... namespaces) {
        DataRegistry.register(dataClass);
        for (String ns : namespaces) {
            if (ns == null || ns.isBlank()) continue;
            DataManager.registerNamespace(dataClass, ns);
            OELib.LOGGER.debug("Registered runtime namespace '{}' for data type {}", (Object)ns, (Object)dataClass.getSimpleName());
        }
    }

    public static <T> void registerNamespaceValidator(Class<T> dataClass, String namespace, Class<? extends DataValidator<?>> validatorClass) {
        DataManager.registerNamespaceValidator(dataClass, namespace, validatorClass);
        OELib.LOGGER.debug("Registered namespace validator '{}' -> {} for {}", new Object[]{namespace, validatorClass.getSimpleName(), dataClass.getSimpleName()});
    }

    public static <T> void registerExtractor(Class<T> dataClass, FunctionUsageAnalyzer.DataExpressionExtractor<T> extractor) {
        extractors.put(dataClass, extractor);
        OELib.LOGGER.debug("Registered expression extractor for: {}", (Object)dataClass.getSimpleName());
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        OELib.LOGGER.info("Data registry initialized with {} registered types", (Object)registeredTypes.size());
    }

    public static void initializeExpressionEngine() {
        if (expressionEngineInitialized) {
            return;
        }
        HashSet<String> allUsedFunctions = new HashSet<String>(FunctionUsageAnalyzer.getCoreRequiredFunctions());
        for (Class<?> dataClass : registeredTypes) {
            DataManager<?> manager;
            FunctionUsageAnalyzer.DataExpressionExtractor<?> extractor = extractors.get(dataClass);
            if (extractor == null || (manager = DataManager.get(dataClass)) == null) continue;
            Map<ResourceLocation, ?> data = manager.getAllData();
            Set<String> usedFunctions = FunctionUsageAnalyzer.analyzeUsedFunctions(data, extractor);
            allUsedFunctions.addAll(usedFunctions);
            OELib.LOGGER.debug("Found {} functions in {}: {}", new Object[]{usedFunctions.size(), dataClass.getSimpleName(), usedFunctions});
        }
        OELib.LOGGER.info("Smart registration: found {} total used functions: {}", (Object)allUsedFunctions.size(), allUsedFunctions);
        ExpressionEngine.initialize(allUsedFunctions);
        expressionEngineInitialized = true;
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        ArrayList sortedTypes = new ArrayList(registeredTypes);
        sortedTypes.sort(Comparator.comparingInt(clazz -> clazz.getAnnotation(DataDriven.class).priority()));
        for (Class clazz2 : sortedTypes) {
            DataManager manager = DataManager.get(clazz2);
            if (manager == null) continue;
            event.addListener(manager);
            OELib.LOGGER.debug("Added reload listener for: {}", (Object)clazz2.getSimpleName());
        }
    }

    public static Set<Class<?>> getRegisteredTypes() {
        return Set.copyOf(registeredTypes);
    }

    public static boolean isRegistered(Class<?> dataClass) {
        return registeredTypes.contains(dataClass);
    }

    public static boolean isExpressionEngineInitialized() {
        return expressionEngineInitialized;
    }

    public static void resetExpressionEngine() {
        expressionEngineInitialized = false;
        ExpressionEngine.clear();
    }
}

