/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.api.data.DataDriven;
import com.mafuyu404.oelib.api.data.DataValidator;
import com.mafuyu404.oelib.forge.data.net.DataSyncPacket;
import com.mafuyu404.oelib.forge.event.DataReloadEvent;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="oelib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DataManager<T>
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final Map<Class<?>, DataManager<?>> managers = new ConcurrentHashMap();
    private static boolean serverStarted = false;
    private static final Map<Class<?>, Set<String>> runtimeRegisteredNamespaces = new ConcurrentHashMap();
    private final Class<T> dataClass;
    private final DataDriven annotation;
    private final Codec<T> codec;
    private final Map<ResourceLocation, T> loadedData = new ConcurrentHashMap<ResourceLocation, T>();
    private final Map<ResourceLocation, T> deferredData = new ConcurrentHashMap<ResourceLocation, T>();
    private final Map<String, Set<T>> cache = new ConcurrentHashMap<String, Set<T>>();
    private final Map<String, Class<? extends DataValidator<?>>> namespaceValidatorClasses = new ConcurrentHashMap();
    private final Map<String, DataValidator<T>> namespaceValidators = new ConcurrentHashMap<String, DataValidator<T>>();
    private final DataValidator<T> defaultValidator;

    private DataManager(Class<T> dataClass) {
        super(GSON, DataManager.getFolder(dataClass));
        this.dataClass = dataClass;
        this.annotation = dataClass.getAnnotation(DataDriven.class);
        this.codec = DataManager.getCodec(dataClass);
        this.defaultValidator = this.createValidator(this.annotation.validator());
        for (DataDriven.ValidatorBinding binding : this.annotation.namespaceValidators()) {
            if (binding == null || binding.namespace() == null || binding.namespace().isBlank() || binding.validator() == null) continue;
            this.namespaceValidatorClasses.put(binding.namespace(), binding.validator());
        }
    }

    public static <T> void registerNamespaceValidator(Class<T> dataClass, String namespace, Class<? extends DataValidator<?>> validatorClass) {
        DataManager<T> mgr = DataManager.get(dataClass);
        if (mgr != null && namespace != null && !namespace.isBlank() && validatorClass != null) {
            mgr.namespaceValidatorClasses.put(namespace, validatorClass);
        }
    }

    private DataValidator<T> getValidatorForNamespace(String namespace) {
        if (namespace == null) {
            return this.defaultValidator;
        }
        return this.namespaceValidators.computeIfAbsent(namespace, ns -> {
            Class<DataValidator<?>> cls = this.namespaceValidatorClasses.get(ns);
            if (cls == null) {
                return this.defaultValidator;
            }
            try {
                return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                OELib.LOGGER.warn("Failed to instantiate validator for namespace '{}', fallback to default", ns, (Object)e);
                return this.defaultValidator;
            }
        });
    }

    public static <T> DataManager<T> register(Class<T> dataClass) {
        if (!dataClass.isAnnotationPresent(DataDriven.class)) {
            throw new IllegalArgumentException("Class " + dataClass.getSimpleName() + " must be annotated with @DataDriven");
        }
        return managers.computeIfAbsent(dataClass, DataManager::new);
    }

    public static <T> void registerNamespace(Class<T> dataClass, String namespace) {
        runtimeRegisteredNamespaces.computeIfAbsent(dataClass, k -> ConcurrentHashMap.newKeySet()).add(namespace);
    }

    public static <T> DataManager<T> get(Class<T> dataClass) {
        return managers.get(dataClass);
    }

    public Map<ResourceLocation, T> getAllData() {
        return new HashMap<ResourceLocation, T>(this.loadedData);
    }

    public T getData(ResourceLocation location) {
        return this.loadedData.get(location);
    }

    public List<T> getDataList() {
        ArrayList<T> result = new ArrayList<T>(this.loadedData.values());
        result.addAll(this.deferredData.values());
        return result;
    }

    public Set<T> getCachedData(String cacheKey) {
        if (!this.annotation.enableCache()) {
            throw new UnsupportedOperationException("Cache is disabled for " + this.dataClass.getSimpleName());
        }
        return this.cache.getOrDefault(cacheKey, Collections.emptySet());
    }

    public void addToCache(String cacheKey, T data) {
        if (this.annotation.enableCache()) {
            this.cache.computeIfAbsent(cacheKey, k -> ConcurrentHashMap.newKeySet()).add(data);
        }
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void updateClientData(Map<ResourceLocation, T> data) {
        this.loadedData.clear();
        this.loadedData.putAll(data);
        this.clearCache();
        if (this.annotation.enableCache()) {
            for (Map.Entry<ResourceLocation, T> entry : data.entrySet()) {
                this.buildCache(entry.getValue());
            }
        }
        OELib.LOGGER.debug("Updated client data for {}: {} entries", (Object)this.dataClass.getSimpleName(), (Object)data.size());
        MinecraftForge.EVENT_BUS.post((Event)new DataReloadEvent(this.dataClass, data.size(), 0));
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.loadedData.clear();
        this.deferredData.clear();
        this.clearCache();
        HashSet<String> allowNamespaces = new HashSet<String>();
        if (!this.annotation.modid().isEmpty()) {
            allowNamespaces.add(this.annotation.modid());
        }
        Set runtimeSet = runtimeRegisteredNamespaces.getOrDefault(this.dataClass, Collections.emptySet());
        allowNamespaces.addAll(runtimeSet);
        Map<ResourceLocation, JsonElement> filteredObject = object.entrySet().stream().filter(entry -> allowNamespaces.isEmpty() || allowNamespaces.contains(((ResourceLocation)entry.getKey()).m_135827_())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        OELib.LOGGER.info("Loading {} data from {} files (namespaces: {})", new Object[]{this.dataClass.getSimpleName(), filteredObject.size(), allowNamespaces});
        int validCount = 0;
        int deferredCount = 0;
        int invalidCount = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry2 : filteredObject.entrySet()) {
            ResourceLocation location = entry2.getKey();
            JsonElement json = entry2.getValue();
            try {
                if (this.annotation.supportArray() && json.isJsonArray()) {
                    JsonArray jsonArray = json.getAsJsonArray();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JsonElement element = jsonArray.get(i);
                        ResourceLocation elementLocation = new ResourceLocation(location.m_135827_(), location.m_135815_() + "_" + i);
                        DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                        if (result.result().isPresent()) {
                            Object data = result.result().get();
                            DataValidator v = this.getValidatorForNamespace(location.m_135827_());
                            DataValidator.ValidationResult vr = v.validate(data, elementLocation);
                            if (vr.valid()) {
                                if (vr.deferrable()) {
                                    this.deferredData.put(elementLocation, data);
                                    ++deferredCount;
                                    continue;
                                }
                                this.loadedData.put(elementLocation, data);
                                if (this.annotation.enableCache()) {
                                    this.buildCache(data);
                                }
                                ++validCount;
                                continue;
                            }
                            ++invalidCount;
                            OELib.LOGGER.warn("Invalid {} data in array[{}] of {}: {}", new Object[]{this.dataClass.getSimpleName(), i, location, vr.message()});
                            continue;
                        }
                        ++invalidCount;
                        OELib.LOGGER.error("Failed to parse {} data from array[{}] of {}: {}", new Object[]{this.dataClass.getSimpleName(), i, location, result.error().orElse(null)});
                    }
                    continue;
                }
                DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                if (result.result().isPresent()) {
                    Object data = result.result().get();
                    DataValidator v = this.getValidatorForNamespace(location.m_135827_());
                    DataValidator.ValidationResult vr = v.validate(data, location);
                    if (vr.valid()) {
                        if (vr.deferrable()) {
                            this.deferredData.put(location, data);
                            ++deferredCount;
                            continue;
                        }
                        this.loadedData.put(location, data);
                        if (this.annotation.enableCache()) {
                            this.buildCache(data);
                        }
                        ++validCount;
                        continue;
                    }
                    ++invalidCount;
                    OELib.LOGGER.warn("Invalid {} data in {}: {}", new Object[]{this.dataClass.getSimpleName(), location, vr.message()});
                    continue;
                }
                ++invalidCount;
                OELib.LOGGER.error("Failed to parse {} data from {}: {}", new Object[]{this.dataClass.getSimpleName(), location, result.error().orElse(null)});
            }
            catch (Exception e) {
                ++invalidCount;
                OELib.LOGGER.error("Error loading {} data from {}", new Object[]{this.dataClass.getSimpleName(), location, e});
            }
        }
        OELib.LOGGER.info("Loaded {} valid {} entries, {} deferred entries, {} invalid entries were skipped", new Object[]{validCount, this.dataClass.getSimpleName(), deferredCount, invalidCount});
        if (this.annotation.syncToClient() && serverStarted) {
            this.syncToAllPlayers();
        }
        MinecraftForge.EVENT_BUS.post((Event)new DataReloadEvent(this.dataClass, validCount + deferredCount, invalidCount));
    }

    protected void buildCache(T data) {
        this.addToCache("all", data);
    }

    private void syncToAllPlayers() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (!(server == null || this.loadedData.isEmpty() && this.deferredData.isEmpty())) {
                HashMap<ResourceLocation, T> allData = new HashMap<ResourceLocation, T>(this.loadedData);
                allData.putAll(this.deferredData);
                DataSyncPacket<T> packet = new DataSyncPacket<T>(this.dataClass, allData);
                packet.sendToAll();
                OELib.LOGGER.debug("Synced {} data to all players", (Object)this.dataClass.getSimpleName());
            }
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to sync {} data to all players", (Object)this.dataClass.getSimpleName(), (Object)e);
        }
    }

    public void syncToPlayer(ServerPlayer player) {
        if (!(!this.annotation.syncToClient() || this.loadedData.isEmpty() && this.deferredData.isEmpty())) {
            try {
                HashMap<ResourceLocation, T> allData = new HashMap<ResourceLocation, T>(this.loadedData);
                allData.putAll(this.deferredData);
                DataSyncPacket<T> packet = new DataSyncPacket<T>(this.dataClass, allData);
                packet.sendTo(player);
                OELib.LOGGER.debug("Synced {} data to player: {}", (Object)this.dataClass.getSimpleName(), (Object)player.m_7755_().getString());
            }
            catch (Exception e) {
                OELib.LOGGER.error("Failed to sync {} data to player {}", new Object[]{this.dataClass.getSimpleName(), player.m_7755_().getString(), e});
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        serverStarted = true;
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (DataManager dataManager : managers.values()) {
                if (!dataManager.annotation.syncToClient()) continue;
                dataManager.syncToPlayer(player2);
            }
        }
    }

    private static String getFolder(Class<?> dataClass) {
        DataDriven annotation = dataClass.getAnnotation(DataDriven.class);
        return annotation.folder();
    }

    private static <T> Codec<T> getCodec(Class<T> dataClass) {
        try {
            Field codecField = dataClass.getDeclaredField("CODEC");
            codecField.setAccessible(true);
            return (Codec)codecField.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get CODEC field from " + dataClass.getSimpleName(), e);
        }
    }

    private DataValidator<T> createValidator(Class<? extends DataValidator<?>> validatorClass) {
        if (validatorClass == DataValidator.NoValidator.class) {
            return new DataValidator.NoValidator();
        }
        try {
            return validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            OELib.LOGGER.warn("Failed to create validator {}, using no validator", (Object)validatorClass.getSimpleName(), (Object)e);
            return new DataValidator.NoValidator();
        }
    }
}

