/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.client.renderer;

import com.mafuyu404.oelib.api.client.renderer.IFluidRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class FluidRenderUtils
implements IFluidRenderer<FluidStack> {
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private static final FluidRenderUtils INSTANCE = new FluidRenderUtils();

    public static void renderFluid(GuiGraphics graphics, FluidStack stack, int x, int y, int width, int height) {
        if (stack == null) {
            return;
        }
        long amount = stack.getAmount();
        long capacity = 1000L;
        INSTANCE.render(graphics, stack, amount, capacity, x, y, width, height);
    }

    @Override
    public void render(GuiGraphics graphics, FluidStack stack, long amount, long capacity, int x, int y, int width, int height) {
        if (stack.isEmpty() || stack.getFluid() == Fluids.f_76191_) {
            return;
        }
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
        int color = props.getTintColor(stack);
        ResourceLocation stillTex = props.getStillTexture(stack);
        if (stillTex == null) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillTex);
        if (sprite.m_247685_() == MissingTextureAtlasSprite.m_118071_()) {
            return;
        }
        int scaledHeight = this.computeScaledHeight(amount, capacity, height, 1);
        this.renderTiledSprite(graphics, sprite, color, x, y, width, scaledHeight, height);
    }

    @Override
    public void renderTiledSprite(GuiGraphics graphics, TextureAtlasSprite sprite, int color, int x, int y, int width, int scaledHeight, int fullHeight) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        int yStart = y + fullHeight;
        int xTileCount = width / 16;
        int xRemainder = width - xTileCount * 16;
        int yTileCount = scaledHeight / 16;
        int yRemainder = scaledHeight - yTileCount * 16;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int tileHeight;
                int tileWidth = xTile == xTileCount ? xRemainder : 16;
                int n = tileHeight = yTile == yTileCount ? yRemainder : 16;
                if (tileWidth <= 0 || tileHeight <= 0) continue;
                int drawX = x + xTile * 16;
                int drawY = yStart - (yTile + 1) * 16;
                float uMin = sprite.m_118409_();
                float uMax = sprite.m_118410_();
                float vMin = sprite.m_118411_();
                float vMax = sprite.m_118412_();
                uMax -= (float)(16 - tileWidth) / 16.0f * (uMax - uMin);
                vMax -= (float)(16 - tileHeight) / 16.0f * (vMax - vMin);
                Tesselator tess = Tesselator.m_85913_();
                BufferBuilder buf = tess.m_85915_();
                RenderSystem.setShader(GameRenderer::m_172817_);
                buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                buf.m_252986_(matrix, (float)drawX, (float)(drawY + tileHeight), 100.0f).m_7421_(uMin, vMax).m_5752_();
                buf.m_252986_(matrix, (float)(drawX + tileWidth), (float)(drawY + tileHeight), 100.0f).m_7421_(uMax, vMax).m_5752_();
                buf.m_252986_(matrix, (float)(drawX + tileWidth), (float)drawY, 100.0f).m_7421_(uMax, vMin).m_5752_();
                buf.m_252986_(matrix, (float)drawX, (float)drawY, 100.0f).m_7421_(uMin, vMin).m_5752_();
                tess.m_85914_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

