# 喧闹法则 剧情总览（含 CB/ST/EX）

- 文档目的：将活动《喧闹法则》的剧情文本整理为结构化、可检索的摘要，便于回顾与检索关键信息。
- 覆盖范围：CB-1…CB-10（前/后）+ ST/EX（单章/后），已全部纳入并校对完成。

## 目录
- 概述
- 主要角色与阵营
- 时间线总览（滚动更新）
- 分章详述（逐关卡）
  - CB-1 6:44 P.M.（前/后）
  - CB-2 7:15 P.M.（前/后）
  - CB-3 7:22 P.M.（前/后）
  - CB-4 7:59 P.M.（前/后）
  - CB-5 8:31 P.M.（前/后）
  - CB-ST1 《晚风轻拂》（单章）
  - CB-6 10:26 P.M.（前/后）
  - CB-7 11:08 P.M.（前/后）
  - CB-8 11:41 P.M.（前/后）
  - CB-ST2 《午夜龙门》（单章）
  - CB-9 0:01 A.M.（前/后）
  - CB-10 1:11 A.M.（前/后）
  - CB-ST3 《破晓时分》（单章）
  - CB-EX1 群架诀窍（后）
  - CB-EX2 南辕北辙（后）
  - CB-EX3 林中小屋（后）
- 关键设定与物件
- 主题与冲突
- 关系与立场变化
- 伏笔与未解
- 结局状态快照（阶段性）
- 附：关卡要点速查

---

## 概述
安魂夜的龙门暗流涌动：峯驰物流少主“拜松”前来企鹅物流“参观学习”，却在绕城公路遭到疑似叙拉古系黑帮的精心伏击。企鹅物流能天使、可颂及时出手，大帝与德克萨斯登场收尾，众人暂避据点；然而据点亦被埋下“糖果盒”炸弹袭扰。其后，因大帝的黑胶珍藏被毁，众人发起市区追击，在“只准和平武器”的规训下上演橡皮弹追车战，终在立交桥酿成连环事故与对峙，幕后的组织手法与狙击火力暴露但未现真身。

## 主要角色与阵营
- 拜松（峯驰物流信使/少主）：为证明自身与了解企鹅物流而来，临时加入行动，持盾防御力强但经验尚浅。
- 大帝（企鹅物流老板）：插科打诨但行事果断，强调“仪式感”“不拘小节”，遵守龙门不动用实弹的规则。
- 德克萨斯（企鹅物流）：驾驶与作战核心，寡言高效。
- 能天使（企鹅物流）：火力与气氛担当，善用各类“和平铳枪”。
- 可颂（企鹅物流）：近战突破与防护，开路能力强。
- 管家（峯驰物流）：忠诚稳重，担心少主卷入企鹅物流的“非常规作风”。
- 甘比诺、卡彭（黑帮）：策动/执行伏击的成员，多次提及“首领”与“鼠王”。
- 空（关联人物）：以“饼干排列”留讯，后于码头出场协助引路。
- 其他过场/市民：孑、槐琥等（中央公园小摊段落出场）。

## 原作顺序与介绍
1. CB-1_6_44P.M.(行动前/后)(行动前/后):年轻的信使拜松遭到了叙拉古黑手党的袭击，而企鹅物流的能天使与可颂及时出手相救。废弃的小巷内，敌人落入了大帝嚣张的陷阱中。被带到据点的拜松被迫接受了企鹅物流“优秀的企业文化”，然而在一片七嘴八舌之中，能天使不小心触发了敌人留下的炸弹陷阱......
2. CB-2_7_15P.M.(行动前/后):因为蒙受了巨大损失，企鹅物流一行人驾车与敌人展开了一场追逐战，并成功把自己也卷入了车祸。公园内，摆摊的孑正在与友人槐琥正在闲聊，迎接了一位神秘的“萨科塔”客人。另一面，擅自追击的拜松也遭到了神秘狙击，并跌落了立交桥。
3. CB-3_7_22P.M.(行动前/后):摔落的拜松遇到了自称企鹅物流一员的神秘信使莫斯提马。在莫斯提马的帮助下，二人混入街道，躲避着黑手党的追捕。优哉游哉的拜松与莫斯提马路过了一家糖果店，却也在此时被黑手党盯上。为了顺利摆脱追踪，拜松跳上了货船，莫斯提马却不知所踪。
4. CB-4_7_59P.M.(行动前/后):迷路的拜松在空的带领下抄小道回到了公园。正好遇上在拷问黑手党的企鹅物流众人，因为失手把人质炸了，所以再度引来乱斗。企鹅物流分组离开，却忘记了临时加入的拜松，迫不得已，拜松只能骑自行车去追其他人。而再一次失手的甘比诺与卡彭，发生了分歧。
5. CB-5_8_31P.M.(行动前/后):眼看着拜松就要跟上众人，甘比诺横插一手打晕了拜松，并以此为要挟，逼迫企鹅物流众人正面决战。敌人为了取得鼠王的情报而在贫民区殴打居民，路过的槐琥与孑路见不平，出手相助，却得知对方的下一个目标正是鱼丸师傅董阿伯。
6. CB-ST1_晚风轻拂:卡彭背叛了甘比诺。莫斯提马救下了拜松。鼠王露出了真面目。龙门晚风轻拂。
7. CB-6(行动前/后):大地的尽头，企鹅物流正进行着无意义的品酒派对。面对追击而来的黑手党，众人选择抄起酒瓶，斗殴正式开始。面对全力以赴的企鹅物流，甘比诺家族迅速败下阵来，但酒吧也已经被破坏殆尽，恼怒的大帝终于下定决心，正面决战拉开帷幕。
8. CB-7_11_08P.M.(行动前/后):就在甘比诺决心要与叛徒卡彭做了断的同时，全面铺开情报网络的企鹅物流也找到了卡彭的据点，战斗一触即发。战局一片混乱，莫斯提马也再次现身并加入战局，游刃有余地牵制住了敌方领袖。然而沙暴突然出现，鼠王毫无征兆地出手打散了众人。
9. CB-8_11_41P.M.(行动前/后):能天使与莫斯提马久别重逢，不过好景不长，莫斯提马很快就告别离开。而能天使与拜松，以及德克萨斯一行，都分别陷入了新的危机。伊斯遭到了某位黎博利的监视，而莫斯提马也早已知晓鼠王存在。重新汇合的企鹅物流众人得到了大帝的联络，前往派对现场。
10. CB-ST2_午夜龙门:甘比诺与卡彭的决斗再次被槐琥与孑打断。这两位龙门年轻人一定要让肆意妄为的黑手党付出代价。同时，鼠王在墓地约见了一位老友。
11. CB-9_0_01A.M.(行动前/后):鼠王出现并救下了槐琥与孑。卡彭也刺伤了甘比诺，并希望以此投诚，却遭到鼠王拒绝。黑手党早已被鼠王吞噬，这一切尽在他的掌握。槐琥二人与企鹅物流一行在露天派对相遇，出于发泄目的，槐琥与德克萨斯打成一团。大帝的演出正值高潮，却突然被鼠王刺穿了身体。
12. CB-10_1_11A.M.(行动前/后):鼠王统领的本地帮派和收编的黑手党一起对企鹅物流发起了猛攻，莫斯提马亲自牵制鼠王，拜松也终于打开心结，加入战局。企鹅物流全员联手，最终靠着拜松管家的偷袭击败了鼠王，为了解除鼠王留下的炸弹，拜松选择舍命一搏，而真相却让人大跌眼镜。
13. CB-ST3_破晓时分:废弃的酒吧里，把酒言欢，畅所欲言，来自拉特兰的苦难陈述者（？）将会带走莫斯提马，而新一轮的斗殴也蓄势待发，日出了。
14. CB-EX1_群架诀窍:看似闹剧的背后，真正的幕后人们相聚在废弃的酒吧。当日出时，老友们并肩而立，看着新的事物缓缓前进。
15. CB-EX2_南辕北辙:负伤逃离龙门的甘比诺与卡彭再次在小径相遇，而他们的决斗依然惯例般的中断——有不速之客出现在了二人面前。
16. CB-EX3_林中小屋:你会错过关于大帝不死之谜的讨论。

## 时间线总览
1) CB-1（前）6:44 P.M.：绕城公路车队遭爆破伏击；能天使救出拜松，可颂抵达开路；黑帮围杀未果。
2) CB-1（后）7:10 P.M.：众人回到企鹅物流据点；大帝打断式会议；以“饼干密码”得知空外出调查；糖果盒陷阱引爆。
3) CB-2（前）7:15 P.M.：因黑胶被毁触发“复仇驱动”，众人驾车追击；遵守市区不许实弹，改用“和平铳枪”进行牵制与骚扰。
4) CB-2（后）7:16 P.M.：镜头切至中央公园，孑与槐琥对话，神秘来客现身；立交桥处追逐引发连环事故，狙击火力干扰，拜松险境，德克萨斯介入。
5) CB-3（前）7:22 P.M.：拜松坠落至安魂夜蜡烛堆脱险，邂逅莫斯提马；黑帮在市区暗巷继续搜捕。
6) CB-3（后）7:22 P.M.：莫斯提马带拜松逛街藏形，糖果摊老人段落揭示其旧忆；桥上遭包围被迫跳船转移，莫斯提马消失。
7) CB-4（前）7:59 P.M.：码头偶遇空，空带路与队伍会合；公园审讯黑帮得出“那一位/鼠王”的风声；确认大帝单独外出求证。
8) CB-4（后）7:59 P.M.：市中心继续巷战，分兵两路“去大地的尽头”定时会合；能天使/可颂、德克萨斯/空各自夺车突围；拜松骑自行车被追，卡彭与甘比诺围绕是否“斩草除根”分歧并启动与鼠王的新交易。
9) CB-5（前）8:31 P.M.：企鹅众人汇合后发现拜松失联；拜松骑自行车被大批黑帮追击；甘比诺以人质要挟，迫使正面应战；德克萨斯定下营救。
10) CB-5（后）8:52 P.M.：贫民窟黑帮恐吓市民追问“鼠王”；孑与槐琥出手强硬击退，获知下一目标为董阿伯，民间支援线浮现。
11) CB-ST1《晚风轻拂》：卡彭与拜松“只取渠道”的交易试探；莫斯提马现身护送拜松穿城，讲述安魂夜由来与天灾见闻，并透露受其父所托“带他见见世面”，指引至“大地的尽头”。
12) CB-6（前）10:26 P.M.：日落大道“大地的尽头”酒吧欢迎派对开启；拜松抵达；黑帮以箭雨突袭，转入室内防守与反击，酒瓶充当临时武器。
13) CB-6（后）10:40 P.M.左右：酒吧内近身混战升级；大帝以“和平特制酒瓶”制服多名敌手；德克萨斯与甘比诺短兵相接，甘比诺以“西西里人”身份挑衅家族旧事；敌人以重弩/爆破制造混乱撤离。
14) CB-7（前）11:08 P.M.：甘比诺判断卡彭已“脱线”，下令各小队按原计划拦截（预料将有小队失联）；其目标转为优先清理“叛徒”；另一头，企鹅获取“指挥塔”线索准备突击。
15) CB-7（后）11:18 P.M.：双方街头近战持续，莫斯提马介入以法杖压制甘比诺，黑帮内部忠诚分裂显性化；突发沙尘/流沙法术导致地面塌陷，战场被强制分割，鼠王现身放话。
16) CB-8（前）11:41 P.M.：沙暴过后临时整队；莫斯提马与能天使寒暄印证“老友关系”；拜松流露对信使职业的向往；另一侧德克萨斯等被“龙门路人”包围，疑为本地势力受指使围堵。
17) CB-8（后）11:50 P.M.左右：莫斯提马与鼠王就“秩序底线”闲谈；大帝广播召集至广场，宣布露天派对与“收网”。
18) CB-ST2《午夜龙门》：槐琥/孑在市区出手；卡彭与甘比诺决裂进入摊牌倒计时；墓地里鼠王与董阿伯论城市与亡者。
19) CB-9（前）0:01 A.M.：卡彭刺杀甘比诺；鼠王压场制止“家人”内斗；黑帮彻底分裂。
20) CB-9（后）0:20 A.M.前后：广场露天派对；鼠王近身“刺大帝”并抛出“特别大礼”悬念，人潮被引导围困。
21) CB-10（前）1:11 A.M.：鼠王劝诫“西西里人”勿越界；广场与周边形成里外三层的人流合围；狙击与流沙压场，队伍被迫分割。
22) CB-10（后）1:30 A.M.+：莫斯提马打碎沙盾、队伍合击；狙击命中鼠王、管家回收遗体；“大礼”被拆解为铁箱与糖果，倒计时后天降“糖果雨”，群情转静。
23) CB-ST3《破晓时分》3:21 A.M.：酒吧善后与庆祝；拜松决定离开企鹅物流寻自我路径；“苦难陈述者”代号登场；大帝为莫斯提马安排下一份“超棘手工作”。
24) CB-EX1《群架诀窍》（后）：鼠王与魏彦吾对谈安魂夜与城市秩序；大帝与欧斐尔加入插科打诨，定下后续合作与克制边界。
25) CB-EX2《南辕北辙》（后）：鼠王与黑帮残部对话“旧规与新局”；甘比诺与卡彭狼狈分离之际遭“拉普兰德”堵截，旧怨挑明，威压逼退。
26) CB-EX3《林中小屋》（后）：市井视角串讲“大帝多次死而复活”的传闻；以戏谑方式巩固“大帝命硬”的都市神话，安魂夜余韵收束。


## 分章详述（逐关卡）

### CB-1 6:44 P.M.（行动前）
- 场景：龙门绕城公路/车内 → 爆破伏击点 → 破败街区死胡同。
- 冲突：黑帮以路障与源石炸药伏击峯驰少主拜松；企鹅物流成员分散接应。
- 发展：能天使救出拜松；可颂破阵开路；卡彭指挥围杀；大帝与德克萨斯压场，照明与阵势扭转局面。
- 结果：拜松与企鹅物流汇合，暂时摆脱包围，朝市区转移，黑帮待援。
- 对白摘要：
  - 拜松：来企鹅物流“参观学习”，盼在家族中证明能力。
  - 管家：担忧企鹅物流“太特殊”，劝少主谨慎。
  - 甘比诺/卡彭：策动爆破、调度包围，称有“首领支援”。
  - 能天使：自嘲“仪式感”与招呼，确认管家无恙。
  - 大帝：亮相宣示“我视线之内，即企鹅帝国国土”。

### CB-1 6:44 P.M.（行动后）
- 场景：企鹅物流据点（杂乱昏暗）。
- 冲突：是否上报近卫局与家族？企鹅物流以“常规业务纠纷”处之；据点潜伏的陷阱引爆。
- 发展：大帝不断插话，会议被“音乐/雪茄/黑胶”打断；“饼干密码”提示空外出追查可疑分子。
- 结果：糖果盒（伪装）爆炸，确认对手准备充分，冲突升级。
- 对白摘要：
  - 拜松：提议严肃追查并上报；质疑“武装运送”的合理性。
  - 大帝：定调“娱乐至死/不拘小节”，但关键点上迅速下令调查。
  - 德克萨斯：要求加班费，执行面沉稳。
  - 能天使/可颂：对企鹅物流“抢单+打架”生态的日常化表述。
  - 空（线索）：“有巧克力的一面是长，尾巴是短”的留讯方法。

### CB-2 7:15 P.M.（行动前）
- 场景：市区公路/高架快速路，车流密集。
- 冲突：对伏击者发起追击；双方在规则限制下（市区禁实弹）展开车战与压制。
- 发展：大帝改用“和平铳枪”（纸板+橡皮筋），能天使以橡皮弹精准骚扰；德克萨斯高速追缠。
- 结果：黑帮车辆控制受干扰，酿成失控与连环追尾的风险。
- 对白摘要：
  - 大帝：宣布“今晚违章罚单全报销”；强调守规矩避免把龙门“炸上天”。
  - 能天使：执行射击任务，嘲讽对手准星与胆量。
  - 德克萨斯：专注驾驶与风险兜底。
  - 拜松：多次提醒道路安全与及周边车辆风险。

### CB-2 7:16 P.M.（行动后）
- 场景：龙门中央公园鳞鱼丸小摊（孑、槐琥）⇄ 高架立交桥事故现场。
- 冲突：神秘来客现身引发怀疑；立交桥追击战升级，远处狙击火力接连压制。
- 发展：围观市民聚拢；拜松试图独自追赶；狙击疑先打燃料箱制造更大风险；德克萨斯展开反制。
- 结果：事故现场局势混乱，敌方组织严密且装备充分，首领仍未露面（悬而未决）。
- 对白摘要：
  - 孑/槐琥：对节日与工作的态度、小摊日常，顺带观察到“可疑来客”。
  - 神秘来客：自称“不赶时间”、随后“提前上工”。
  - 团队内部：安全气囊与车内混乱的插曲，大帝与可颂互相吐槽。

### CB-3 7:22 P.M.（行动前）
- 场景：中央公园旁/商业街/暗巷。
- 冲突：拜松从立交桥坠落后与莫斯提马会合，黑帮在市区搜捕。
- 发展：莫斯提马低调掩护，指点“放弃思考、随机应变”的行事节奏；黑帮分头行动试图在不动明火的前提下抓人。
- 结果：暂避搜索，准备与德克萨斯等人汇合。
- 对白摘要：
  - 黑帮：在市区“只要不动明火”即可行动，讥城市灰色地带。
  - 大帝侧镜头：判断有“她”在，拜松能自保。
  - 莫斯提马：自介企鹅物流信使，倡导随机应变。

### CB-3 7:22 P.M.（行动后）
- 场景：市中心步行街→糖果摊→河桥与小货船。
- 冲突：拜松与莫斯提马边走边侦看；黑帮伪装靠近包围。
- 发展：糖果摊老人段落补充莫斯提马昔年在龙门的踪影；桥上识破包围，莫斯提马建议跳船脱离。
- 结果：二人跳船登上运糖小船成功规避；随后莫斯提马再次消失，留悬念。
- 对白摘要：
  - 莫斯提马：回忆初到龙门的窘境；强调“别急，等队友也可能已清场”。
  - 市民视角：安魂夜狂欢与城市需要释放的对照。

### CB-4 7:59 P.M.（行动前）
- 场景：龙门人工河码头→公园。
- 冲突：拜松在码头与空相遇，确认峯驰身份；团队在公园继续审讯黑帮。
- 发展：空护送拜松沿城市小路回到公园，与德克萨斯/能天使/可颂合流；黑帮口风泄出“那一位默许”“鼠王”关键词。
- 结果：确定背后势力与鼠王有关联；大帝外出核实；团队获取更多情报线索。
- 对白摘要：
  - 空：以“不给糖就捣蛋”的小机关安抚街头儿童，点出安魂夜照不到的角落。
  - 黑帮：否认糖果盒炸弹为“首领”所为，炫耀“那一位的默许”。

### CB-4 7:59 P.M.（行动后）
- 场景：公园与市中心道路，围观群众旁观“常态化斗殴”。
- 冲突：市区禁实弹的限制下持续交锋，决策是否分兵突围。
- 发展：德克萨斯定下分线计划，“去大地的尽头”一小时后会合；能天使/可颂与德克萨斯/空分别夺车突围；拜松夺借自行车被追。
- 结果：战场被引散，敌方追击被牵扯；卡彭与甘比诺战略分歧，卡彭拟与鼠王重谈并清单化拉拢对象。
- 对白摘要：
  - 围观群众：将企鹅物流打架视作“惯例演出”。
  - 德克萨斯：下达分兵与会合口令。
  - 甘比诺/卡彭：关于“斩草除根”与在龙门生存方式的分歧。

### CB-5 8:31 P.M.（行动前）
- 场景：市区街道/巷道追逐。
- 冲突：企鹅众人刚汇合即发现拜松失联；拜松独自骑自行车被大队黑帮追击；甘比诺现身挟持拜松，下战书。
- 发展：能天使/空/德克萨斯意识到“把他忘了”；黑帮沿街设伏尾随；甘比诺以人质迫使正面应战，德克萨斯部署营救。
- 结果：拜松被制伏带走；队伍目标转为“抢回拜松”。
- 对白摘要：
  - 甘比诺：“有人质，你们只能正面应战。”
  - 德克萨斯：“那可真是太好了……抢回拜松。”
  - 能天使/空：自嘲“把他忘了”的插科打诨后立即收心。

### CB-5 8:52 P.M.（行动后）
- 场景：龙门贫民窟/街区。
- 冲突：黑帮以暴力恐吓住民，追问“鼠王”下落；与当地两人发生冲突。
- 发展：槐琥拒绝威胁并迅速击倒多名黑帮；孑控制对方武器化解危局；伤者转移救治并透露黑帮下个目标是董阿伯。
- 结果：黑帮暂退；两人决定分别去救人与报信，形成民间支援线。
- 对白摘要：
  - 槐琥：“那我拒绝。”/“古往今来，邪不压正。”
  - 孑：“慢着，把武器放下，滚出这里。”
  - 居民：“先别管我，快去找你董阿伯！”

### CB-ST1《晚风轻拂》（单章）
- 场景：黑帮车内 → 城市街巷/墓地 → “大地的尽头”外。
- 冲突：卡彭与拜松谈判，抛出“合作只取渠道”的条件以对付甘比诺；莫斯提马现身与其短暂对峙。
- 发展：卡彭以处置手下彰显手腕，强调利益与存续；莫斯提马以“路过的信使”身份护送拜松穿城，讲述安魂夜源流、天灾与城邦迁徙的见闻；途中与市民/长者插曲增添城市质感。
- 结果：确认会合点为日落大道东1301号、门口有巨大企鹅涂鸦的酒吧；莫斯提马透露受拜松父亲委托“带他见见世面”，随后先行离开；拜松独自前往。
- 对白摘要：
  - 卡彭：“做一笔交易——我们只接手渠道。”
  - 拜松：“你口口声声家族，却亲手杀了家人。”
  - 莫斯提马：“我只是路过找包裹的信使。”/“这其实就是一家酒吧。”

### CB-6 10:26 P.M.（行动前）
- 场景：日落大道“大地的尽头”酒吧内。
- 冲突：欢迎派对与作战筹备并行；拜松抵达；敌方以箭雨/投掷突袭，酒吧设施被打穿。
- 发展：大帝承认“准许他跑了”以布置后手；团队讨论行动计划；突袭来临后转入室内防守与反击，临时以酒瓶充当近战武器。
- 结果：战斗打响，室内防御与反冲锋阶段开始。
- 对白摘要：
  - 大帝：“这是备用武器，不是用来喝的——只砸头。”
  - 能天使：“苹果派烤好了！”
  - 德克萨斯：“能天使注意掩护，抢回拜松。”

### CB-6 10:26 P.M.（行动后）
- 场景：酒吧内外混战，弩箭与投掷物交错，室内破坏严重。
- 冲突：甘比诺率黑帮强攻；言语挑衅德克萨斯“西西里”身份，试图撬动其心理防线。
- 发展：大帝、能天使、可颂以酒瓶等和平武器连番制敌；黑帮火力转为重弩/爆破制造混乱撤退；外场“伊斯”与莫斯提马对话，代为保管白色法杖等杂务。
- 结果：敌方未能夺人，选择引爆与撤离；双方进入机动对峙阶段。
- 对白摘要：
  - 大帝：“现在，在我的酒吧里发生了一些意料之内的意外死亡，这没问题吧？”
  - 甘比诺：“一旦拔剑相向，西西里人之间就没有输赢，只有生死！”
  - 德克萨斯：“住口。”

### CB-7 11:08 P.M.（行动前）
- 场景：城市高架/三岔路口与市中心街区，黑帮分队行动。
- 冲突：甘比诺与手下确认多小队失联，怀疑卡彭另起炉灶；下令按原拦截计划行事，并优先解决“叛徒”。
- 发展：黑帮小队在三岔口部署；一线小弟对“计划目的”产生迟疑；企鹅一侧锁定“指挥塔”所在的敌方调度节点。
- 结果：甘比诺决意亲自出手，战场朝总决战聚拢。
- 对白摘要：
  - 甘比诺：“卡彭那个懦夫太过忌惮鼠王和魏彦吾了。”
  - 黑帮A/B：因是否继续听命产生分歧，内部裂隙扩大。
  - 德克萨斯：“找到那里的指挥塔，一了百了。”

### CB-7 11:08 P.M.（行动后）
- 场景：市中心街区混战；莫斯提马与甘比诺正面过招。
- 冲突：莫斯提马以法杖压制甘比诺；黑帮小弟互相质疑忠诚；企鹅侧与黑帮交织拉锯。
- 发展：短促对攻中多次法杖/枪火交换，莫斯提马以“中场休息”打断战意；随即突发大范围沙尘/流沙法术，地面塌陷分隔双方；拜松与莫斯提马短暂结队穿行风沙。
- 结果：战线被强制切割；甘比诺被压制撤走；鼠王借沙暴现身发声。
- 对白摘要：
  - 莫斯提马：“普通的信使啊，不然呢？”
  - 能天使：“差不多四年零三个月哦，莫斯提马。”
  - 莫斯提马：“撤退，快！”

### CB-8 11:41 P.M.（行动前）
- 场景：沙暴后街区整理点；另一侧被围的巷段。
- 冲突：能天使与莫斯提马“互揭黑历史”的插曲后，团队需尽快与德克萨斯侧合流；同时德克萨斯、可颂被“龙门路人”组织包围拦截。
- 发展：拜松表达对信使职业与旅行的向往；莫斯提马判断仍有追踪风险，建议先合流；德克萨斯侧确认对手并非黑帮而是本地势力受指使围堵。
- 结果：企鹅分队决定先汇合再破围，准备转入下一阶段反击。
- 对白摘要：
  - 能天使：“老友聚会互揭疤的必备项目到了。”
  - 莫斯提马：“工作、安魂节促销、顺便看场热闹。”
  - 德克萨斯：“他们把我们包围了。”

### CB-8 11:41 P.M.（行动后）
- 场景：露天咖啡吧→龙门街区夜景→队伍会合通话。
- 冲突：莫斯提马与鼠王正面闲谈，鼠王对黑帮踩线与贫民窟动荡表达不满；大帝以“音乐人”身份宣布将现身露天派对，要求团队跟随并“收网”。
- 发展：鼠王承认未允许黑帮随意践踏贫民窟，暗示对叙拉古势力介入的失望，同时表示“狂欢才刚开始”；德克萨斯等接到大帝通讯，确认下一步在广场进行公开对峙。
- 结果：战场转场至市中心派对，局势由巷战转为公开场合的舆论与武力拉锯。
- 对白摘要：
  - 鼠王：“我从未允许他们随意践踏贫民窟。”/“这出好戏的精彩在于，开销都由演员自担。”
  - 莫斯提马：（打趣式）“别把杀气开太大。”
  - 大帝（通讯）：“今晚在立交街有场安魂夜狂欢盛典……你们只要跟在我身后，把那些想‘解决企鹅物流’的呆瓜一网打尽。”

### CB-ST2《午夜龙门》（单章）
- 场景：商业街→贫民窟巷战→卡彭与甘比诺的会面与决斗→墓地（董阿伯×鼠王）。
- 冲突：槐琥与孑追查黑帮并强力出手；卡彭与甘比诺因路线分歧正式反目；鼠王与董阿伯在墓地闲谈生死与城市。
- 发展：卡彭以冷箭与刀术与甘比诺一再过招，黑帮小弟心态摇摆；董阿伯数说墓地邻人，鼠王回应“龙门的活人需热闹，亡魂才无憾”。
- 结果：卡彭与甘比诺矛盾进入摊牌倒数；市井线（董阿伯）与鼠王关系更明确，鼠王的“秩序守护者”姿态立住。
- 对白摘要：
  - 槐琥：“拳峰不正，如何取胜？”
  - 卡彭：“掌控龙门暗面的怪物，当然是最不该招惹的人。”
  - 董阿伯：“买菜涨价比黑手党要命得多。”/“咱也得想想以后的住处了。”
  - 鼠王：“安魂夜是送别亡者的节日，而龙门终归是我们的城市。”

### CB-9 0:01 A.M.（行动前）
- 场景：街区对峙场；黑帮各系与卡彭阵营夹击；鼠王入场。
- 冲突：甘比诺宣布全面围杀；卡彭反制，宣告与其决裂；鼠王出现“制止家人自相残杀”。
- 发展：鼠王以流沙法术压场并点破黑帮四分五裂；卡彭趁乱刺杀甘比诺，转而谋求与鼠王“交易生路”。
- 结果：甘比诺倒地；卡彭求存之谋显形，黑帮内部彻底崩解；鼠王拒绝结盟但暂不追杀。
- 对白摘要：
  - 甘比诺：“所有人，抬起武器。”
  - 鼠王：“孩子们已离开，这里你们毫无胜算。放下武器，跪下。”
  - 卡彭：（行刺后）“这就是生意。”
  - 鼠王：“我不需要你的忠诚……现在，滚。”

### CB-9 0:01 A.M.（行动后）
- 场景：市中心广场露天派对；大帝舞台播音→鼠王“入镜”。
- 冲突：大帝登台以广播带动人群；鼠王忽至当众以匕首“刺杀”大帝，场面失控；德克萨斯与槐琥约斗，四周大量“路人”实为围堵力量。
- 发展：鼠王借舞台广播宣称叙拉古友人奉上“特别大礼”，已藏于派对某处，暗示时间不多；人潮动向异常整齐，德克萨斯判断遭围。
- 结果：广场成为新战场与舆论场；“礼物”悬念引出下一阶段的拆弹/排险或夺取。
- 对白摘要：
  - 大帝：（电台）“为龙门带来有格调的噪音！”
  - 鼠王：（近身）“晚安，大帝先生，安魂节快乐。”
  - 德克萨斯：“被包围的是我们。”
  - 鼠王（广播）：“我们的叙拉古朋友带来了一份特别大礼，时间不多了。”

### CB-10 1:11 A.M.（行动前）
- 场景：广场上空/高台与屋顶；街区三层包围；队伍分线救援。
- 冲突：鼠王会见叙拉古来客（卡彭系残部）并警告“不要越界”；广场与周边被“路人/黑帮/第三方”分层合围；狙击与流沙把持节奏。
- 发展：莫斯提马与鼠王对话确认其“留情”；鼠王以沙壁护身，德克萨斯等试探；拜松主动呼叫管家支援并组织反制；现场人流密集导致战斗受限。
- 结果：企鹅临时定下“分头压制+拆礼物”的目标；战斗节奏受鼠王控制，需等待破绽。
- 对白摘要：
  - 鼠王：“切记，不要越界。龙门有龙门的规矩。”
  - 莫斯提马：“你不是所有时候都推心置腹的。”
  - 德克萨斯：“一瞬间都不要松懈，会死的。”
  - 拜松：“各按各的来吧。”

### CB-10 1:11 A.M.（行动后）
- 场景：广场正面冲突→屋顶高点→礼物安置点。
- 冲突：队伍合击鼠王沙盾；远处狙击手贯穿干扰；“特别大礼”进入倒计时。
- 发展：莫斯提马以法杖击碎沙盾制造窗口；能天使、可颂、拜松协同压制；狙击命中鼠王，管家上前回收其“遗体”；拜松与莫斯提马联手拆解铁箱。
- 结果：铁箱内为糖果与纸条，随倒计时触发“糖果雨”，人群从躁动转为哗然与平静；敌对势力按信号收手撤出，广场危机解除。
- 对白摘要：
  - 鼠王：“复数的守护铃？真是麻烦的天使。”
  - 能天使：“弹幕射击时间到——！”
  - 管家：“我必须确认他的生死，带走遗体。”
  - 拜松：（读纸条）“安魂夜快乐。”

### CB-ST3《破晓时分》（单章）
- 场景：3:21 A.M. 大地的尽头酒吧（废墟内的庆功）→ 街头/墓地/天台 → 清晨车道追风。
- 冲突：事后复盘与去留抉择；监护方（拉特兰）密切关注莫斯提马；拜松思索身份与未来。
- 发展：团队把酒言欢，大帝宣布“后续账单有人报销”；拜松表达不留在企鹅物流的决定，准备与父亲对话；“苦难陈述者”代号现身，与莫斯提马针锋相对又互相成全；天亮前，再次出车“去码头给拜松找场子”。
- 结果：活动主线落幕；企鹅物流回归日常的喧闹；莫斯提马接到“超棘手的工作”；拜松完成一段成长并离开。
- 对白摘要：
  - 能天使：“今晚真是打了个痛快。”
  - 拜松：“我不会留下的……另有想走的路。”
  - 大帝：“在你离开龙门前，我会安排一份超棘手的工作。”
  - ？？？（苦难陈述者）：“这次的职务在‘公证所’名下。”

### CB-EX1 群架诀窍（行动后）
- 场景：酒吧后场/街口清晨；市政与江湖的对话席。
- 冲突：鼠王与魏彦吾就安魂夜、城市秩序与“用力的边界”进行对谈；大帝与欧斐尔插话，把玩合作与克制的尺度。
- 发展：鼠王反思“摆弄力量会反噬自身”；魏彦吾表态“龙门不缺朋友也不缺对手”；欧斐尔抛出物流行业跃迁方案；大帝以戏谑化解火药味。
- 结果：龙门权力与灰色势力形成新的默契与观察期；各方暂行收束，等待下一次风声。
- 对白摘要：
  - 魏彦吾：“和我们待在同一座城市，是他们的失格。”
  - 鼠王：“也许该到退下的时候了……等她真正长大的那一天。”
  - 大帝：“不要再叫我来这种事了，发票和账单我会寄到你们手上。”
  - 欧斐尔：“从龙门开始，到整个泰拉。”

### CB-EX2 南辕北辙（行动后）
- 场景：龙门街区暗巷与出城口；追逃余波。
- 冲突：黑帮残部向鼠王打探旧规与去留；甘比诺与卡彭决裂后试图逃逸，却被拉普兰德截住，旧怨激化。
- 发展：鼠王强调“龙门有龙门的规矩”，劝残部“莫再越界”；拉普兰德以“熟悉的血腥味”戏谑并压制二人心态，迫使其认清现实。
- 结果：黑帮势力彻底土崩；拉普兰德宣示德克萨斯的变化既成事实，叙拉古旧人于龙门无以为继。
- 对白摘要：
  - 鼠王：“我有我的规矩，别奢求更多。”
  - 拉普兰德：“她变了，你们也别想再按老样子来。”
  - 甘比诺/卡彭：（对视）“就算要死，也别死在她手上。”

### CB-EX3 林中小屋（行动后）
- 场景：郊外木屋/小路，市民间的‘见闻录’式闲聊。
- 冲突：围绕“大帝是否真被刺/早有替身/命硬”等都市传闻展开争执；罗列过往“死里逃生”案例。
- 发展：路人们以半真半假的旧闻与亲历佐证，大帝“打不死”人设被再度放大；舆论对其行事风格褒贬不一。
- 结果：以市井视角为活动作收尾；在玩笑与夸张中巩固“大帝=活着的都市神话”的公共形象。
- 对白摘要：
  - 路人甲：“这也太逼真了吧！”
  - 路人乙：“我亲眼看见他从火里冲出来。”
  - 路人丙：“谁让他是大帝呢。”

## 关键设定与物件（滚动汇总）
- 龙门市区规训：严禁实弹武器；“和平铳枪/橡皮弹”等替代性武力合规。
- 峯驰物流 × 企鹅物流：商业合作/考察背景；拜松为少主兼信使。
- 叙拉古系黑手党：以爆破、围杀、狙击等链路行动，提及“首领/鼠王”。
- 企鹅物流据点生态：杂乱、娱乐至上；“黑胶唱片”珍藏被毁成复仇导火索。
- “饼干密码”：空的情报留置方式，暗示外出追踪。
- 糖果盒陷阱：伪装爆炸物，证明敌方早埋伏触手至据点。
- 莫斯提马与糖果摊记忆：提示她与龙门旧缘；“运糖小船”桥段成为脱身路线。
- “那一位/鼠王”：黑帮供述的背后默许者，牵动龙门灰色势力格局。

- “大地的尽头”酒吧：企鹅物流的私域据点与会合点（门口有巨大企鹅涂鸦），派对即作战室；酒品既是“士气道具”亦可临时充当武器。
- 安魂夜补充设定：传统源自古代萨卡兹祭礼，城中“狂欢与墓园”一墙之隔的两面性由莫斯提马叙述。
- “委托”线索：莫斯提马受拜松父亲重金委托“带拜松见见世面”，影响其成长与判断。
- 黑帮内部分化深化：卡彭主张交易与权衡，甘比诺主张强硬清洗。

- “西西里人”称谓与家族旧事：甘比诺借此挑衅德克萨斯，点明其出身纠葛与仇怨语境。
- 沙暴/流沙法术：大范围地形改造，隔断战线，疑与“鼠王”相关势力或他方术士有关。
- 本地势力介入：出现以“龙门路人”为外衣的围堵力量，幕后指使未明。

- 露天派对与广播操控：大帝以“音乐人”身份公开亮相；鼠王可直接在公共场合操纵局势与人流。
- “特别大礼”悬念：鼠王借叙拉古“礼物”挑动人群与对手，疑似爆炸物/陷阱或引战道具。

- 流沙/沙盾与人群控场：鼠王以地形与人潮双重手段“压场”，形成里外三层包围与短时“不可近身”的沙盾。
- 狙击干预与“回收”：远端狙击可精准介入局势变化；峯驰管家在关键时刻“确认生死并回收遗体”。
- “铁箱+糖果雨”：所谓“礼物”实际为糖果与纸条，倒计时引发漫天糖果，作为安魂夜的戏谑式谢幕。
- “苦难陈述者”与公证所：拉特兰体系的特殊职务代号，暗示对莫斯提马的长期监管与后续任务。


## 主题与冲突（阶段性）
- 规则与暴力：守规矩（禁实弹）下的灰度对抗，如何在秩序与效率间拿捏。
- 家族与个体：拜松欲证明自我能力与判断，与传统家族体系张力显现。
- 商业与江湖：物流“业务纠纷”与黑帮势力互为表里，市井与地下生态交织。
- 娱乐化生存：大帝的“仪式感/不拘小节”与团队玩笑式执行，映照在地化生存术。

## 关系与立场变化（阶段性）
- 拜松 ⇄ 企鹅物流：由外来观察者转为临时成员；对其“武装运送日常化”存疑但被卷入。
- 企鹅物流 ⇄ 黑帮：对抗升级，从伏击转入市区追击，交锋更公开。
- 空 ⇄ 团队：未到场，但以信息留下追踪线索，可能将来回接。
- 拜松 ⇄ 莫斯提马：短暂同行且受其掩护与建议；莫斯提马再度失踪留下悬念。
- 黑帮内部分歧：甘比诺主张极端清除，卡彭主张在龙门规则内权衡并寻求与鼠王交易。

- 拜松 ⇄ 莫斯提马：保护与引导关系明晰，信任提升。
- 拜松 ⇄ 卡彭：处于“被拉拢/拒绝”的对立，卡彭转而另谋途径。
- 槐琥/孑 ⇄ 市民：护民立场确立，形成可动员的民间支援线索。
- 企鹅物流 ⇄ 敌方：从追击转为“据点防守 + 反冲锋”。

- 德克萨斯 ⇄ 甘比诺：由过往宿怨引发的正面冲突升级；德克萨斯拒受激将。
- 企鹅物流 ⇄ 龙门本地势力：出现直接摩擦与围堵，需辨识背后指使。
- 拜松 ⇄ 莫斯提马/“信使”职业：拜松对“信使”的向往增强，态度从观望转为敬仰。

- 甘比诺 ⇄ 卡彭：由路线之争转为生死对立；卡彭行刺甘比诺，黑帮分裂成型。
- 企鹅物流 ⇄ 鼠王：鼠王从暗中调停转为公开在场，以“秩序守护者”的姿态设题，企鹅被迫在公众场合应对。
- 德克萨斯 ⇄ 槐琥：在广场公开“约斗/比试”以界定规矩与责任。

- 企鹅物流 ⇄ 鼠王（广场后）：互为试探与借力关系更清晰，冲突降级为“礼物”谢幕，暂时收束。
- 拜松 ⇄ 管家/家族：拜松主动指挥与承担，管家执行关键“回收”，家族对企鹅的态度从戒备转向“可合作、需解释”。
- 魏彦吾 ⇄ 鼠王：市政秩序与贫民窟“王”的边界对话，彼此承认对方的价值与限度。
- 大帝 ⇄ 欧斐尔：商业谈锋下的试探与互用，扩展到“让物流水平更上一层”。
- 拜松 ⇄ 企鹅物流：以离开作为成长的完成式，关系由“临时成员”转为“彼此尊重的朋友”。
 - 拉普兰德 ⇄ 德克萨斯：以“旧识/宿怨”影子介入龙门事变，向叙拉古残部宣示德克萨斯当下立场。
 - 城市舆论 ⇄ 大帝：经由“林中小屋”闲聊形成的二次叙事，大帝“命硬/不死鸟”形象加固。

## 伏笔与未解（阶段性）
- 幕后“首领/鼠王”身份与动机未现；为何选在安魂夜大动干戈？
- 糖果盒陷阱的安置者与内线可能性。
- “神秘来客”的真实身份与其所谓“上工”的立场归属。
- 狙击手/火力组隶属与目的（制造事故扩大影响或掩护撤离？）。
- 大帝外出核实的对象与证据为何；“大地的尽头”会合点的具体指向。
- 鼠王在本次事件中是默许、操盘还是被借名？

- 卡彭暗示的“别的办法”具体为何？其交易对象可能指向谁（鼠王/龙门高层）？
- 莫斯提马与龙门旧缘细节、她提到的“包裹”究竟为何物？
- 董阿伯与“名册”相关线索的走向。
- 大帝“准许他跑了”是否是更大布局的一环？

- 突发沙暴/流沙的来源与目的：是鼠王现身的手段，还是他方术士介入？
- “龙门路人”围堵的组织者是谁，是否与卡彭/鼠王/更高层相关？
- 德克萨斯“西西里”背景的更多细节与其在龙门的旧因。

- “特别大礼”具体为何物，是否与“糖果盒”同系装置？
- 大帝被“刺杀”的真伪与后续影响：是戏法、调虎离山，抑或真受伤？
- 鼠王与近卫局/龙门高层的默契边界；其“秩序”底线与手段上限。

- 鼠王“生死”与退场方式：被狙击命中后由管家“回收”，其真伤与去向未明。
- 鼠王“女儿”与那件“大衣”的更多背景；其对未来退场的暗示。
- “苦难陈述者”的长期任务与拉特兰对莫斯提马的后续安排。
- 欧斐尔的物流跃迁方案是否会在后续故事落地，如何影响龙门与企鹅物流版图。
 - 拉普兰德来龙去脉与其在龙门的后续动作；与德克萨斯旧怨的下一次交锋。
 - 大帝“多次死而复生”的传闻真假边界何在，替身/戏法/媒体叙事的比例如何？

## 结局状态快照（阶段性）
- 时间节点：至 3:21 A.M.（CB-ST3·破晓）
  - CB-6 后：酒吧混战后敌方撤离，未能夺人；外场“伊斯”与莫斯提马对话，协助代管法杖等物。
  - CB-7 前/后：黑帮内部裂痕扩大，卡彭与甘比诺分道；莫斯提马压制甘比诺；突发沙暴切割战场，鼠王现身。
  - CB-8 前/后：与德克萨斯侧合流在即；鼠王与莫斯提马对话定下“秩序底线”；大帝广播召集至广场。
  - CB-9 前/后：卡彭行刺甘比诺；鼠王以“礼物”悬念引发广场新局，公众场合对峙升级。
  - CB-10 前/后：莫斯提马打碎沙盾，狙击命中鼠王并被管家回收；“特别大礼”化为糖果雨，危机转为谢幕。
  - ST3/EX1：酒吧庆功与去留确定；权力边界对话达成默契；大帝安排新任务，故事收束于清晨出车。

## 附：关卡要点速查
- CB-1（前）：绕城公路爆破伏击；能天使救人、可颂开路；大帝与德克萨斯压场。
- CB-1（后）：据点讨论被陷阱打断；“饼干密码”；糖果盒爆炸。
- CB-2（前）：市区追车，遵规用和平铳枪；橡皮弹精准骚扰导致失控。
- CB-2（后）：公园日常穿插神秘来客；立交桥连环事故与狙击压制，局势未解。
- CB-3（前）：拜松坠落遇莫斯提马；市区暗巷避猎；准备汇合。
- CB-3（后）：糖果摊旧忆；桥上被包围被迫跳船；莫斯提马失踪。
- CB-4（前）：码头遇空回合；公园审讯得“鼠王/那一位”；大帝单独外出求证。
- CB-4（后）：分兵突围“去大地的尽头”；拜松骑行被追；黑帮内部策略分裂并谋与鼠王交易。
- CB-5（前）：拜松被甘比诺制伏为人质；企鹅决定正面夺回。
- CB-5（后）：槐琥/孑在贫民区出手，获“董阿伯”警示。
- CB-ST1：卡彭游说→莫斯提马护送→揭“委托/安魂夜”并前往“大地的尽头”。
- CB-6（前）：酒吧欢迎派对→箭雨突袭→以酒瓶为武器组织反击。
- CB-6（后）：酒吧混战升级；“西西里”挑衅；敌方以爆破撤离。
- CB-7（前）：甘比诺重申计划并先清叛徒；企鹅锁定“指挥塔”。
- CB-7（后）：莫斯提马压制甘比诺；沙暴/流沙切割战场；鼠王发声。
- CB-8（前）：沙暴后整队；与德克萨斯侧会合在即；本地势力围堵。
- CB-8（后）：鼠王与莫斯提马对话立“底线”；大帝广播转场广场收网。
- CB-ST2：槐琥/孑巷战；卡彭与甘比诺摊牌在即；鼠王×董阿伯墓地闲谈。
- CB-9（前）：卡彭行刺甘比诺；鼠王压场，黑帮分裂成型。
- CB-9（后）：广场派对失控；鼠王“刺大帝”并抛出“特别大礼”。
- CB-10（前）：三层合围；鼠王沙盾与狙击压场；分头压制与拆礼物。
- CB-10（后）：沙盾被破；管家回收鼠王；“礼物”化作糖果雨。
- CB-ST3：破晓庆功；拜松决定离开；“苦难陈述者”现身；大帝布置新活。
- CB-EX1（后）：鼠王×魏彦吾对谈；大帝×欧斐尔商议行业跃迁与边界。
- CB-EX2（后）：拉普兰德堵截甘比诺/卡彭；黑帮土崩。
- CB-EX3（后）：市井传闻巩固“大帝命硬”都市神话。
