# 医疗经营系统实现流程

> 本流程用于将 `Script/System/Medical/医疗经营系统.md` 的方案落地为实际代码。每个步骤以待办清单形式呈现，完成后请把对应的 `[ ]` 改为 `[x]` ，再继续下一项。
> 当你需要使用python命令时，你需要使用.conda环境运行。如 ` PS C:\code\erArk> & c:/code/erArk/.conda/python.exe c:/code/erArk/buildconfig.py` 。
> 若中途需要新增步骤，请在相应章节插入新的 `[ ]` 条目并保持编号有序（可用 3.7、4.5 等形式）。
> 你需要加入尽量多的完整注释，包括每个函数的功能说明、参数解释和返回值描述，对于函数内每个段落的实现细节也要在段落前增加清晰的注释说明。

## 0. 准备与基线确认
- [x] **0.1 运行基线**：`python buildconfig.py` → `python game.py`，确认当前医疗逻辑仍沿用旧版收入结算且无新增字段。
- [x] **0.2 代码定位**：熟悉以下文件/目录，确保 IDE/调试器可快速打开：
  - `buildconfig.py`、`Script/Config/config_def.py`
  - `Script/Core/cache_control.py`、`Script/Core/game_init.py`
  - `Script/Design/character_behavior.py`、`Script/Design/settle_behavior.py`
  - `Script/System/Medical/`（新建模块）、`Script/UI/Panel/manage_*`
- [x] **0.3 CSV 校验**：检查 `/data/csv/Medical*.csv` 是否与文档字段一致；缺列时先补 CSV，暂不改代码。

## 1. 数据与配置生成
- [x] **1.1 BodySystem 数据**：
  - 在 `/data/csv/MedicalBodySystem.csv` 补齐 8 大系统 50 部位，并在 `game_config.load_medical_body_system()` 中建立系统/部位双索引与字段校验。
  - `config_def.py` 已存在数据类结构，运行 `buildconfig.py` 验证通过。
- [x] **1.2 并发症细节结构**：
  - `game_config.load_medical_complication()` 已生成 `config_medical_complication_detail`（system → part → severity），并校验严重度配额、部位存在性与部位性别限制（依赖 BodySystem 定义）。
- [x] **1.3 病情等级/医院等级**：完成 `MedicalSeverity/MedicalHospitalLevel` 的索引结构与抽取辅助表，仍维持 `buildconfig.py` 只导出原始数据。
- [x] **1.4 常量与枚举**：当前阶段未新增指令/资源 ID，已确认后续引用可复用既有枚举，若日后出现新需求再补充。

## 2. 运行时缓存与初始化
- [x] **2.1 Cache 字段**：在 `Script/Core/game_type.py` 的 `Rhodes_Island` 中补齐医疗缓存：
  - 新增 `medical_patients_today`、`medical_hospitalized`、`medical_price_ratio`、`medical_bed_limit`、`medical_inventory_accumulator`、`medical_surgery_records`，并以 `medical_income_today/medical_income_total` 取代原 `cure_income*` 字段。
  - `basement.get_base_zero()` 会调用初始化函数，确保任何新建基地对象都自带空字典/列表，药品资源累加器默认包含 21~24 号资源。
  - 字段声明统一使用基础容器或标量类型占位，避免在 `game_type.py` 中直接导入 `medical_constant`；运行期由 `medical_service.init_medical_department_data()` 注入对应的 dataclass 与枚举值。
- [x] **2.2 初始化**：
  - 在 `Script/System/Medical/medical_service.py` 提供 `init_medical_department_data()`，负责重置日度缓存、计算床位上限、分配默认收费系数并支持后续重算（参数可控，避免老档被清空）。
  - `creator_character_flow.game_start()`、`basement.get_base_zero()` 以及 `save_handle.input_load_save()` 分别以 `reset_runtime` 或 `migrate_legacy` 方式调用：新游戏直接清零，读档则保留原数据并迁移旧版 `cure_income`。
- [x] **2.3 全局常量**：在 `Script/System/Medical/medical_constant.py` 定义医疗相关常量（状态字符串、资源 ID 映射）、病人结构体及医疗日度统计结构（均采用 dataclass）。

## 3. 医疗核心服务模块
- [x] **3.1 建立 `medical_service.py`**：位于 `Script/System/Medical/`，负责：
  - 刷新、诊疗进度推进、药物扣除、入院、手术标记等 API
- [x] **3.2 病人刷新**：实现 `refresh_medical_patients(level:int)`，流程符合文档中系统/部位/权重要求，写入 `cache.rhodes_island.medical_patients_today`。
- [x] **3.3 诊疗推进**：提供 `advance_diagnose(patient_id, doctor_character)`，根据医疗能力（ID 46）叠加 `diagnose_progress`，完成后转 `waiting_medication`、累积 `medical_income_today`，并在病人仍留在门诊流程时即时调用 `medical_service.try_consume_medicine()` 结算药费与相关统计。
- [x] **3.4 药物扣除**：实现 `try_consume_medicine(patient)` 与全局 `medical_inventory_accumulator`，按资源 21~24 逐次扣库 → 记录收入或失败结果；门诊病人扣药成功后需切换为 `MedicalPatientState.MEDICINE_GRANTED`，失败则保持 `WAITING_MEDICATION` 等待补货。
- [x] **3.5 入院/住院逻辑**：
  - `try_hospitalize(patient)` 判断床位 → `medical_hospitalized`。
  - 每日调用的 `process_hospitalized_patients()` 处理降档、出院、统计。
  - 诊疗流程结束后若 `severity.require_hospitalization == 1`，需立即调用 `medical_service.try_hospitalize()`，并在失败时写入原因标签，保证重症病人自动排入住院列表。
  - 模块在修改病人状态或访问病人列表时统一使用 `clinic_patient_management.set_patient_state()` 与 `medical_service.get_patient_table()`，避免跨模块直接操作缓存字段。
- [x] **3.6 手术流程支撑**：
  - 管理 `need_surgery` 队列、`surgery_blocked` 状态。
  - 暴露 `evaluate_surgery_preconditions()` 供前提阶段判断医生可执行的病人数量。
  - `attempt_surgery(patient_id, doctor)` 在结算阶段直接处理手术结果，完成病情降级、收入入账与日志记录。
- [x] **3.7 模块拆分**：门诊病人流程迁移至 `clinic_patient_management.py`，住院病人流程拆分到 `hospital_patient_management.py`，医生调度分别位于 `clinic_doctor_service.py` 与 `hospital_doctor_service.py`，通用工具落地在 `medical_core.py`，`medical_service.py` 负责对外协调入口。
- [x] **3.8 优化补充**：
  - 提供 `medical_core._calculate_medical_bed_limit` 供排班与日常结算独立刷新床位上限
- [x] **3.9 分诊策略**：在 `clinic_patient_management._select_triage_candidate()` 中将默认的 `normal` 策略调整为“危重优先 + 队列先来后到”，仅当候选队列不存在危重病人（严重度编号 3）时才按刷新顺序返回首位病人，其他策略保持原有排序逻辑。

## 4. 行为系统与 AI 接入
- [x] **4.1 WorkType 扩展**：在 `data/csv/WorkType.csv` 增加 CID 62 “住院医生”，配置自动行为。
- [x] **4.2 指令/行为**：
  - 更新 `Script/Design/character_behavior.py`：
    - `cure_patient` → 调用新 `medical_service` API。
    - 新增 `ward_round`/`perform_surgery` 行为（必要时新增状态机 ID）。
  - `Script/Design/settle_behavior.py`/`constant_effect.py` 处理对应结算。
  - `character_work_start_surgery()` 调用 `consume_surgery_resources()` 完成病人分配与即时扣药，`handle_perform_surgery()` 使用医生记录的病人 ID 调用手术结算函数。
- [x] **4.3 前提/事件**：
  - 新增 `constant_promise.Premise.MEDICAL_SURGERY_WAIT` 与对应 `handle_medical_surgery_wait()`，仅在存在需要手术且未被阻塞的住院病人时启用相关指令。
  - `handle_medical_ward_wait()` 继续复用住院缓存，满足查房/手术的共通前提。
  - `handle_have_patient_need_surgery_and_can_do()` 调用手术前置校验，确保医生能力与药品库存均满足后才进入手术链。
- [x] **4.4 NPC 调度**：`manage_basement_panel.change_npc_work_out` 以及相关 AI 行为需支持批量派遣 61/62 号医生，并与 Cache 联动。

## 5. UI 面板体系
### 5.1 医疗部总面板 `medical_department_panel.py`
  1. 医生管理（显示人数、能力、接诊策略）
  2. 收费设置（ratio 调节按钮 + 预测）
  3. 医疗明细（病人列表、药物进度）
  4. 手术管理（候补病人、阻塞原因、日志）
  5. 财务报表（日/累计收入与消耗）
- [x] UI 需通过 `medical_service` 暴露的查询接口获取数据；如需新增明细可在 `clinic_patient_management.py`、`hospital_patient_management.py` 等子模块中补充只读辅助函数，仍禁止直接改写核心缓存。
  - 医疗部各子面板读取门诊/住院病人数据与床位占用时统一调用 `medical_service.get_patient_table()`，保持接口一致性，避免直接访问 `cache.rhodes_island` 字段。

### 5.2 玩家诊疗面板 `medical_player_diagnose_panel.py`
- [x] 病人信息展示：年龄/种族/自述/外观指示。
- [x] 治病提示开关：根据 `player_med_level` 逐级揭示。
- [x] 检查方法四级菜单与次数限制；执行时写回检查结果记录。
- [x] 诊疗方法模块 + 药品/收益预估；操作按钮覆盖检查 / 单次结算 / 连续接诊 / 提前结束的完整流程，并在药品需求列表中根据仓库库存附加缺口提示。
- [x] 诊疗结算提示扩展：当药费收益为 0 或扣药失败时，在提示文本中列出缺少的药剂与缺口数量。
- [x] 关闭面板后更新对应病人状态回主流程。

### 5.3 主面板与分科强化
- [x] 新增“经营概览”主面板作为默认入口，集中展示病人数量、床位占用、药品累计与当日收入等关键指标。
- [x] 医生管理面板改为手动分派模式，提供 `[医生增减]` 调用 `manage_basement_panel.change_npc_work_out` 调整医生名单，并支持将门诊/住院医生按 `MedicalBodySystem.csv` 的八个系统加全科共九类进行分科，分配流程参考 `manage_power_system_panel.py` 的主调控员界面，保留接诊优先策略与诊疗耗时预测。
- [x] 医疗明细面板改用中文状态名输出病人状态概览，维持药品扣除进度的明细展示。
- [x] 财务报表面板仅统计已诊疗或已入院病人的药品需求，未诊疗的病人不再提前揭示所需药品数量。

### 5.4 玩家诊疗面板交互调整
- [x] 调整病人概览，仅呈现症状记录的外观与自述，不暴露具体并发症名称或部位。
- [x] 将治病提示状态与“切换提示”按钮合并为居中行，并新增医疗技能提示语。
- [x] 改造检查方法折叠菜单，使各层级条目独立成行且系统/部位展开互斥。
- [x] 仅在条件满足时渲染“确定进行已选的检查方法”“开药并结束诊疗”“开药并接诊下一位”按钮，保持条件与结算逻辑一致。
- [x] 检查菜单始终枚举全部生理系统，确保提示引导时可以直接跳转目标节点。
- [x] 开启治病提示后根据 `player_med_level` 高亮对应的系统、部位与检查条目，以按钮配色取代额外文本提示。
- [x] 诊疗方法模块对未确诊的并发症按 50% 计入药品需求与收益预估，并在结果说明中提示剩余未确认数量。
- [x] 检查菜单按 `gender_limit` 过滤女性专属部位，保证玩家只会看到通用检查节点。
- [x] “提前结束诊疗并返回”按钮仅在未执行任何检查前渲染，执行过检查后不再提供快捷退出。
- [x] 治病提示开关改为读写全局系统设置值（`base_setting[12]`），跨病人保持一致的提示状态。
- [x] 在存在未确诊并发症且仍可继续检查时，先弹出“确认就这样治疗/返回继续检查”二次确认，并将检查结果以彩色标签展示提示类型。

## 6. 日常结算与日志
- [x] **6.1 settle_medical_department()**：在 `Script/System/Medical/medical_service.py` 中新增入口函数，内部按需调用 `clinic_patient_management.py` / `hospital_patient_management.py` / `hospital_doctor_service.py` 的工具方法，`update_base_resouce_newday()` 调用，负责：
  - 日度统计（diagnose_completed/medicine_completed/hospitalized/discharged/medicine_consumed〔药剂资源明细〕/income）
  - 调用 `log_system.append_medical_report()`（若无则新建日志接口）
  - 输出日志时补充 `inventory_detail`，记录各药剂的当日消耗、缺口与剩余库存；渲染日报时需将 `medical_inventory_accumulator` 中的累计扣药进度与 `medicine_consumed` 合并展示。
  - 日志生成后清理 `medical_patients_today` 中状态为 `medicine_granted` 的门诊病人，并兜底移除 `medical_hospitalized` 中残留的已出院条目，防止长时间游玩后缓存膨胀。
  - 重置 `medical_income_today` 与日度计数器。
- [x] **6.2 每日统计输出**：
  - 统计和记录每日的诊疗完成数、用药完成数、住院人数、出院人数、药品消耗明细（按资源拆分）与收入总额，存入基地日志系统。
  - 参考 `manage_power_system_panel.settle_power_system()` 的实现，输出类似格式的医疗经营日报，包含关键数据与趋势分析，在 `basement.update_base_resouce_newday()` 中调用。
  - 日志渲染统一复用 `medical_service.render_medical_reports()`，与财务报表面板的“查看最近经营日志”按钮保持一致。
  - 队列概况需额外展示 `medicine_granted`（已拿药治疗）统计，避免遗漏该状态。

## 7. 测试与验收
- [x] **7.1 单步验证**：分别测试刷新、诊疗、用药、住院、手术；必要时添加 `Script/Design/debug_panel` 按钮触发各流程。
- [x] **7.2 回归**：确保旧医疗收入逻辑完全由新系统替代，不再触发旧字段。
- [x] **7.3 性能**：大量病人/手术情况下观察主循环性能，必要时增加缓存或批处理。
- [x] **7.4 文档更新**：完成实现后同步更新 `README` / 开发文档，记录使用与调试方式。

---
**备注**：
- 若中途需要新增步骤，请在相应章节插入新的 `[ ]` 条目并保持编号有序（可用 3.7、4.5 等形式）。
