# 医疗经营系统

## 概述
医疗经营系统围绕罗德岛医疗部的日常运营，负责刷新源石病病人、安排干员诊治、计算药物消耗与各类收入，并维护入院病人的住院流程。该系统替换原有的医疗收入结算逻辑，为后续扩展多科室、药物链路与医疗事件提供统一入口。

### 模块划分
- `medical_service.py`：提供对 UI、行为循环等入口调用的服务函数，负责载入缓存、刷新病人、统筹住院/手术调度。
- `medical_core.py`：封装缓存初始化、收费倍率、统计字段等跨模块通用工具。
- `clinic_patient_management.py`：负责门诊病人刷新、玩家诊断流程与价格倍率计算。
- `hospital_patient_management.py`：处理住院病人的入院、日常用药、出院与手术所需药品模板。
- `clinic_doctor_service.py`：提供门诊医生分工与病人分配逻辑。
- `hospital_doctor_service.py`：负责住院医生巡诊、手术执行与手术日志记录。

## 概念与约定
- **源石病人**：所有病人均为感染源石病的个体，同时可能携带多种并发症。病人刷新时会生成一份症状档案，病情等级与并发症组合共同决定诊疗耗时、药物需求与收益。
- **病情等级**：至少四档（建议 0~3 表示轻→重），遵循"轻症多、重症少"的分布权重。例如 `轻症:0.46 / 中度:0.30 / 重度:0.18 / 危重:0.06`，可根据医疗部等级或事件动态调整。医疗区等级 <2 仅刷新轻症/中度，≥2 才会解锁重症，≥4 才会解锁危重档位。
- **医疗能力**：干员能力 ID==46；诊治时以 `(基础耗时 ÷ (1 + 能力加成))` 计算效率。
- **坐诊医生**：职业类型 ID==61 的干员才可参与诊治流程，其他干员转入辅助逻辑（后续扩展可用）。
- **药物资源**：
  - 资源 21：普通药物（主要处理并发症）
  - 资源 22~24：源石病特效药，严重病情需要更多种类与更大剂量
- **收费系数**：玩家可设置 `medical_price_ratio`（默认 1.0）。影响病人刷新量、诊疗收入与药物结算收益。
- **收入字段**：所有诊疗收入累加至 `medical_income_today`，供每日医疗区结算统一输出。
- **药物扣除缓存**：所有病人共享 `medical_inventory_accumulator`，按资源 ID 累加小数进度，当值 ≥1 时才扣库存。
- **床位上限**：`medical_bed_limit` 记录基础床位与住院医生加成后的可用数量。
- **医生分工**：坐诊医生（CID 61）负责门诊诊断，住院医生（CID 62）驻守病房并提升床位与康复效率。
- **患者性别**：医疗经营系统当前仅面向女性患者，所有 `MedicalBodySystem`/`MedicalComplication` 数据需保证 `gender_limit` 仅出现 0（女性专属）或 2（通用），杜绝男性限定条目。

## 人体部位数据库
为医疗经营系统新增的 `/data/csv/MedicalBodySystem.csv` 提供数据蓝本，按生理系统（Option A）组织体表与体内部位，共 8 大系统、50 个部位。`part_type=0` 表示体表、`part_type=1` 表示体内；若需性别限制则在 CSV 中以 `gender_limit` 字段标注。

## 并发症数据库结构
并发症数据仍落盘于 `/data/csv/MedicalComplication.csv`，但每条记录需关联 `system_id + part_id + severity_level`，并遵守“每部位轻症 3 种 / 中症 2 种 / 重症 1 种”的配额。字段扩展如下：

| 字段 | 类型 | 说明 |
| --- | --- | --- |
| `complication_id` | int | 全局唯一 ID，建议 `system_id * 1000 + part_id * 10 + severity序号` |
| `system_id` | int | 对应 `MedicalBodySystem` 的系统 ID |
| `part_id` | int | 对应具体部位 |
| `severity_level` | int | 0=轻、1=中、2=重（危重继承 2 并附加标记） |
| `name` | str | 并发症命名 |
| `weight` | float | 该并发症在同部位同等级下的出现权重 |
| `normal_medicine_bonus` | float | 叠加到资源 21 的基础需求 |
| `appearance_indicator` | str | 外观表征（描述体表变化或“无可见异常”） |
| `patient_statement_clear` | str | 清晰自述；包含定位、程度与伴随症状 |
| `patient_statement_vague` | str | 模糊自述；包含概括性、夸大或迁移描述 |
| `exam_method` | str | 常用检查方法（视触诊、影像、体液等） |
| `exam_result_positive` | str | 检查确认有病时的详尽结果 |
| `exam_result_negative` | str | 检查确认健康的详尽结果 |
| `recheck_hint_mild` | str | 检查未能确认、但发现该部位有其他轻症 |
| `recheck_hint_moderate` | str | 检查未能确认、但发现该部位有其他中症 |
| `recheck_hint_severe` | str | 检查未能确认、但发现该部位有其他重症 |
| `treatment_plan` | str | 诊断成立后的标准治疗流程 |
| `requires_surgery` | int | 0=否、1=是；重症固定为 1，并驱动手术状态机 |

填表规则：
- 每部位轻症 3 条、中症 2 条、重症 1 条，且同一部位内各并发症 `name` 不得重复。
- 各描述符合并发症本身情况，符合实际医学中的对应专业知识。
- 外观表征需结合 `MedicalBodySystem.part_type` 撰写，为医生第一次见到患者时的患者的外观状态，所以仅包括肉眼和诊室里的基础设备能发现的外观特征，不涉及需要详细精密检查或者手术检查才能发现的外观表征。
  - 对于确实存在外观表征的并发症，应具体描述该表征。
  - 对于无明显外观表征的并发症，应明确指出“无可见异常”或类似表述。
- 轻症记录必须声明“无可见异常”或“难以肉眼察觉”类表征，治疗方案以门诊、理疗或对症药物为主。
- 中症可在体表部位提供肉眼可见表现；体内部位仍以成像/内镜所见描述，治疗方案包含联合用药或短期留观。
- 重症需描述明显可见或仪器可视化的异常（即便部位为体内），`treatment_plan` 中需包含手术步骤以及术前药物准备，`requires_surgery` 必须为 1。
- 同一部位的自述需互补：清晰自述明确指出疼痛/不适位置与程度，包含定位、程度与伴随症状；模糊自述可扩大范围或夸大强度，为 AI 行为生成多样台词。
- 检查方法为常规医学里对于检查该部位是否有该类病症的常用检查方法，包括视触诊、体液检查、专门的检查仪器等。
- 检查未能确认时，表明当前检查方法没有直接检查出当前并发症，但该检查方法却检查出当前部位有其他异常，可能为：
  - 当前部位有其他异常且病症程度等于轻症
  - 当前部位有其他异常且病症程度等于中症
  - 当前部位有其他异常且病症程度等于重症
- 各类检查结果均需围绕 `exam_method` 撰写，使 UI 能原地展示“确诊/健康/需换检”的各种提示；未确诊时 `surgery_blocked` 应保持 True。
- CSV 更新后必须执行 `python buildconfig.py`，以刷新 `config_def.py` 结构；`config_medical_complication_detail` 等运行期索引需在 `Script/Config/game_config.py` 中新增加载逻辑，禁止把这类派生处理塞进 `buildconfig.py`。

## 核心数据结构
### 1. 病人信息（运行时缓存）
| 字段 | 类型 | 说明 |
| --- | --- | --- |
| `patient_id` | int | 唯一 ID，自增生成 |
| `severity_level` | int | 病情等级，按权重随机 |
| `complications` | list[str] | 并发症标签，用于普通药物需求 |
| `diagnose_progress` | float | 诊疗进度，单位为工时 |
| `need_resources` | dict[int, float] | 药物需求，键为资源 ID，值为累积所需数量（可为小数）|
| `state` | enum | `refreshed / in_treatment / waiting_medication / medicine_granted / hospitalized / discharged` |
| `stay_days` | int | 入院天数，辅助统计 |
| `need_surgery` | bool | 是否等待手术（仅针对重症/危重住院病人）|
| `surgery_blocked` | bool | 是否因条件不足暂缓手术 |
| `personality_type` | enum | `rational / irrational`，刷新时 50% 概率各取其一 |
| `race_id` | int | 从所有非博士种族 ID 中等概率抽取 |
| `age` | int | 10~60 岁的随机整数 |

#### 病人个体属性
- **性格**：`personality_type ∈ {理智, 不理智}`，刷新病人时各占 50% 概率，用于台词/事件差异。
- **种族**：`race_id` 从 `race_config` 中去除博士（ID 0）后均匀抽样，保持罗德岛现有世界观。
- **年龄**：调用 `random.randint(10, 60)`，所有病人年龄落在 10~60 岁闭区间。

### 2. 配置资源
- `/data/csv/MedicalSeverity.csv`：定义每个等级的名称、诊疗基础耗时、诊疗收入基数、药物需求模板（普通药量范围、特效药组合）。
- `/data/csv/MedicalComplication.csv`：并发症列表及普通药增量权重。
- `/data/csv/MedicalHospitalLevel.csv`：医疗区等级 → 每日病人刷新基础量、入院床位上限、收费系数对刷新量的缩放下限/上限。
- `/data/csv/MedicalBodySystem.csv`：医疗系统专用的人体器官/部位数据库，按生理系统（Option A：如神经、呼吸、循环等）分组记录体表与体内部位，替代 `body_part_data.csv` 在该系统中的职能。列定义如下：
   - `system_id (int)`：生理系统唯一 ID，与文档中预设顺序一致。
   - `system_name (str)`：系统中文名，供 UI 分组使用。
   - `part_id (int)`：部位 ID，系统内唯一。
   - `part_name (str)`：部位名称。
   - `part_type (int)`：0=体表、1=体内，用于计算外观异常表现。
   - `gender_limit (int)`：0=仅女、1=仅男、2=通用，沿用既有约定（本系统当前仅使用 0 与 2）。
   - `organ_priority (int)`：用于并发症挑选优先级的可选权重（值越高越优先）。
   - `notes (str)`：补充说明（例如特殊观察角度/检查禁忌）。
  `buildconfig.py` 仍负责把 CSV 写入 JSON，但 `config_medical_body_system` 的解析逻辑要在 `Script/Config/game_config.py`（建议新增 `load_medical_body_system()`）内实现，统一由该模块向医疗系统提供数据。
- `config_medical_severity`、`config_medical_hospital_level`、`config_medical_price_config` 等字典统一在 `Script/Config/game_config.py` 的加载函数中生成，`buildconfig.py` 仅负责生成 `config_def.py` 所需的 dataclass 壳。

### 3. 运行缓存挂载点
- `cache.rhodes_island.medical_patients_today`：当日刷新未处理病人列表。
- `cache.rhodes_island.medical_hospitalized`：在院病人队列。
- `cache.rhodes_island.medical_price_ratio`：玩家设置的收费系数。
- `cache.rhodes_island.medical_bed_limit`：当前医疗区床位上限（等级基础值 + 建筑加成 + 住院医生加成）。
- `cache.rhodes_island.medical_inventory_accumulator`：药物扣除进度缓存，键为资源 ID，值为全局累计小数。
- `cache.rhodes_island.medical_income_today`：医疗板块当日收入（诊疗 + 药物）。
- `cache.rhodes_island.medical_surgery_records`：记录今日已完成手术与待手术病人（供日志与状态机使用）。

上述字段在 `Rhodes_Island` 对象中仅以基础容器或标量形式占位，运行期由 `medical_service.init_medical_department_data()` 写入实际的医疗专用结构与默认值，以避免核心类型之间的循环依赖。

## 病人刷新逻辑
1. 游戏启动时在 `init_medical_department_data()` 中初始化首批病人数量，保证面板首次打开即可展示待诊列表。
2. 每日 00:00 在 `update_base_resouce_newday()` 调用 `refresh_medical_patients()`。
3. 刷新数量计算：
   ```
   base_count = config_medical_hospital_level[level].daily_patient_base
   ratio_penalty = clamp(1.0 / medical_price_ratio, min_ratio, max_ratio)
   refresh_count = floor(base_count * ratio_penalty)
   ```
4. 病情与并发症生成：
  - 按 `MedicalSeverity.csv` 中的权重抽取 `severity_level`，并依据医疗区等级过滤可用档位（<2 仅轻症/中度，≥2 解锁重症，≥4 解锁危重）；该等级配置指明需要的轻/中/重并发症数量。
   - **非危重等级**：先从 `/data/csv/MedicalBodySystem.csv` 中抽取一个系统（按 `organ_priority` 加权可选），随后：
     - 对每个需要的并发症等级依次抽取一个尚未使用的部位（跳过 `gender_limit == 0` 的女性专属部位，同一病人内部位唯一）。
     - 按部位与等级在 `MedicalComplication.csv` 中读取候选条目，按 `weight` 抽取具体并发症，追加到 `complications` 并叠加普通药需求。
  - **危重等级**：先抽取系统 A 以生成 1 个中度并发症 + 1 个重度并发症（部位各自唯一）；再从剩余系统中抽取系统 B，为第二个重度并发症选择部位与条目（同样忽略 `gender_limit == 0` 的部位）。
   - 生成并发症后再根据 `severity_level` 模板设置资源 22~24 的特效药需求。
5. 生成完毕的病人附带性格、种族、年龄字段，加入 `medical_patients_today`，状态设为 `refreshed`。

## 诊治流程
1. 玩家通过医疗面板整体调整坐诊医生数量（职业 ID==61）并选择“优先重症/正常/优先轻症”接诊策略。`data/csv/WorkType.csv` 中已定义其 `auto_ai_move` 与 `auto_ai_work`，可直接接入行为循环。默认的“正常”策略会检查候选队列是否存在危重病人（严重度编号 3），如有则立即接诊该危重病人，若无则保持病人刷新时的先来后到顺序。
2. 诊疗耗时：
   ```
   required_hours = severity_config.base_hours
   actual_speed = doctor.medical_ability (ID 46)
   progress_increment = (1 + actual_speed / ability_scale)
   ```
   可采用行为系统中的工时驱动，或在面板中逐次推进。
3. 诊疗完成：
  - 状态变为 `waiting_medication`，等待药品扣除结果。
  - 若 `MedicalSeverity.require_hospitalization == 1`，系统立即调用 `medical_service.try_hospitalize()`，将符合条件的病人转入住院流程；若床位不足或条件未满足，会在病人元数据中记录失败原因并保留在等待用药状态。
    - 若病人仍停留在门诊列表，系统会立刻调用 `medical_service.try_consume_medicine()` 统一处理药物扣除，并在成功或失败时分别更新 `medicine_completed_outpatient` 与 `outpatient_waiting_medicine` 统计，同时同步药费收益至 `medical_income_today`。
   - 根据病情等级发放诊疗报酬：
     `income = severity_config.diagnose_income * medical_price_ratio`
  - 累加至 `medical_income_today`。

## 药物扣除与收入
1. 对 `waiting_medication` 病人调用 `try_consume_medicine(patient)`。
2. 对每种药物：
   - 将需求小数累加至全局 `medical_inventory_accumulator[resource_id]`。
   - 当累计值 ≥1 时，实际扣除仓库中相应资源并减去 1，若库存不足则消费失败并保留累计值。
3. 扣除成功的处理：
   ```
   medicine_income = resource_price[id] * consumed_units * medicine_income_ratio * medical_price_ratio
   ```
   `medicine_income_ratio` 建议在配置表中定义（重症 > 轻症）。
  - 门诊病人状态更新为 `medicine_granted`，同时记入 `medicine_completed_outpatient` 统计条目。
  - 已消耗药品合计记入 `medicine_consumed`（支持小数，用于记录真实扣除量，界面展示时统一保留两位小数），并刷新当日收入。
4. 扣除失败时：
   - 病人状态留在 `waiting_medication`。
   - 计入“未用药”数量统计。

## 入院流程
1. 对重症/危重病人，在诊疗完成后尝试转入 `hospitalized` 状态：
   - 判断当前在院人数 < `medical_bed_limit`（包含等级基础值与住院医生加成）。
   - 转入后记录 `stay_days = 0`。
   - 入院事件可触发通知或 UI 更新。
2. 未能入院的重症病人保持 `waiting_medication`，待资源补足后直接出院（收益较低）。
3. 对成功住院的重症（CID 2）与危重（CID 3）病人，追加 `need_surgery = True` 标记并进入手术候补列表。

## 住院每日结算
1. 在每日 24:00 的医疗区结算中处理：
   - `stay_days += 1`。
   - 调用 `try_consume_medicine()`，按住院药方再次扣药。
   - 成功：
     - 病情等级下降 1 档；若降至最低档以下视为治愈，进入出院流程。
     - 收入按照 `hospital_income_ratio`（高于普通病人）计算。
   - 失败：
     - 病情保持、只获得 `hospital_base_income`（权重较小）。
2. 出院：
   - 状态设为 `discharged`，从 hospitalized 队列移除。
   - 发放一次性奖励：`severity_config.discharge_bonus * medical_price_ratio`。
   - 统计“今日出院人数”。
3. 对处于暂缓手术状态的病人（`need_surgery` 为真且 `surgery_blocked` 为真）重置标记：在新一天的结算中将其 `surgery_blocked` 复位为 False，以便后续重新尝试手术。

## 手术治疗流程
1. **手术判定**：住院后被标记为 `need_surgery` 的病人需根据病情等级检测手术条件。危重病人对药物与医生等级的需求高于重症病人。
2. **资源与人员需求**：
   - 根据病情等级匹配手术药物配方，需一次性扣除指定资源。
   - 至少一名医生（坐诊或住院）医疗能力达到配置阈值方可执行。
3. **总前提判定**：`handle_have_patient_need_surgery_and_can_do()` 在行为前提阶段遍历全部待手术病人，结合医生医疗能力与当前库存确认可执行数量；无法满足时不会触发手术行为。
4. **进入手术状态**：`character_work_start_surgery()` 在前提通过后重新抽取候选病人，随机分配目标并调用 `consume_surgery_resources()` 立即扣除手术药品，扣除成功则同步医生的 `work.surgery_patient_id`；若扣除失败则记录阻塞原因并结束本次流程。
5. **执行结算**：`handle_perform_surgery()` 依据医生记录的病人 ID 调用 `medical_service.attempt_surgery()`，直接对手术结果进行结算并刷新病情、收入与日志；若结算失败则保留阻塞状态并解除医生绑定。
6. **日志与统计**：手术成功后记录至 `medical_surgery_records`，用于每日汇总展示。

### 住院医生工作（工作类型 ID==62）
- `WorkType.csv` 中新增 CID 62，继承医生职业基础行为，定位于住院病房治疗。
- 在 `Script/System/Medical/medical_service.py` 中统计住院医生数量及其医疗能力：
  - 每位住院医生提供固定床位加成（叠加到 `medical_bed_limit`）。
  - 住院药物成功结算时，按 `1 + ability_factor * doctor_medical_ability` 为住院病人提供额外康复速度（减少所需成功次数或额外降档几率）。
- 行为系统需确保 61 号医生优先处理门诊、62 号医生驻守病房，可结合 AI 行为或面板操作进行调配；UI 允许手动切换。

## 每日统计输出
在 `update_base_resouce_newday()` 中新增 `settle_medical_department()`，替换 `settle_income()` 中旧的医疗结算。
- 统计字段：
  - 诊疗阶段：`diagnose_completed_outpatient`、`diagnose_completed_hospital`（如需总数，请现场求和）
  - 用药阶段：`medicine_completed_outpatient`、`medicine_completed_hospital`（如需总数，请现场求和）
  - 住院动态：`hospitalized_today`、`discharged_today`
  - 待发药统计：`outpatient_waiting_medicine`、`hospital_waiting_medicine`
  - 队列概况：`waiting`、`waiting_medication`、`medicine_granted`、`hospitalized`、`need_surgery`
  - 资源消耗：`medicine_consumed`（字典，键为药剂资源 ID，值为当日累计消耗单位数，支持小数并在界面上保留两位小数，涵盖门诊、住院及手术场景；日志渲染时会进一步叠加 `medical_inventory_accumulator` 中的剩余扣药进度，保证展示的消耗量与仓库待扣资源一致）
  - 库存概览：`inventory_detail`（结算时附加到日志，记录每种药剂的消耗量、缺口量与剩余库存，便于快速排查缺药原因）
  - 特殊事件：`surgeries_performed`
  - 财务数据：`medical_income_today`
  - 所有统计字段由 `MedicalDailyCounters` 数据结构维护，统一以显性字段保存。
- 输出流程：
  1. 调用 `log_system.append_medical_report()` 记录日志，并通过 `medical_service.render_medical_reports()` 统一渲染文本（包含药品库存明细与缺口提示）。
  2. 将统计结果写入 UI 或邮件系统，提示玩家每日医疗部运营情况。
  3. 日志生成后调用 `settle_medical_department()` 内置清理逻辑，将状态为 `medicine_granted` 的门诊病人与已出院但遗留引用的住院病人从缓存表中移除，避免长档案积累导致数据臃肿。
  4. 重置 `medical_income_today` 与日度计数器，为下一天重新计量。

## UI 与交互建议
### 医疗部总面板
- 统一使用 `Script/System/Medical/medical_department_panel.py` 管理医疗部 UI，结构参考 `manage_power_system_panel.py`：
  - **主面板（默认页）**：概览病人数量、床位占用、药物库存与收入摘要等概括性内容，打开医疗经营系统时直接显示。
  - **子面板1（医生管理）**：提供 `[医生增减]` 按钮调用 `manage_basement_panel.change_npc_work_out` 调整参与医生名单，并支持按照 `MedicalBodySystem.csv` 定义的八个系统加全科共九类进行手动分科。门诊与住院医生默认归属全科，可通过分配按钮将个体定向到具体系统以获得医疗能力倍率加成，界面结构参考 `manage_power_system_panel.py` 中 `_panel_operator()` 的“主/副调控员”分配流程，同时保留“优先重症/正常/优先轻症”三种接诊顺序与预计诊疗耗时展示。其中“正常”策略实现为“危重病人优先，否则按病人生成队列顺序排列”，保证危重病例不会被新刷出的轻症挤占诊疗机会。
   - **子面板2（收费设置）**：以百分比呈现收费标准（基础 100%），左右提供 `-10%/-5%/-1%` 与 `+1%/+5%/+10%` 调节按钮，下方同步展示收费变化对应的收益与病人刷新量波动预测。
  - **子面板3（医疗明细）**：显示病人列表（门诊、等待用药、住院）、药品库存与全局扣除进度缓存，并使用中文状态名展示病人状态概览。
   - **子面板4（手术管理）**：列出已标记待手术的病人、所需药物与医生条件、当前阻塞原因，并允许查看手术日志。
  - **子面板5（财务报表）**：呈现今日收入、累计收入、药品消耗与未来消耗预估；未经过诊疗的病人不会显示药品需求，只有已诊疗或已入院的病人会记入药品统计。
   - 每个子面板共用统一导航与返回逻辑，并支持导出日报信息。
  - 面板在读取门诊/住院病人列表与床位占用时，统一通过 `medical_service.get_patient_table()` 获取数据，禁止直接访问缓存字段。

### 玩家诊疗专用面板
- **文件定位**：单独建立 `Script/System/Medical/medical_player_diagnose_panel.py`。该面板仅在玩家亲自诊疗时启用；NPC 诊疗仍沿用旧逻辑。打开面板时依照当前医疗部的“病人抽取顺序”从候选队列中随机挑选一名病人，并将其状态临时标记为 `in_treatment_player`。
- **病人信息展示**：顶部隐藏姓名字段，仅显示“患者”前缀。种族直接读取 `race_id` 对应文本，性别恒为女，年龄显示实际值。根据 `complication_trace` 生成症状记录，仅展示外观观察与病人自述（理智病人展示 `patient_statement_clear`，不理智病人展示 `patient_statement_vague`），不直接暴露并发症名称或部位信息。
- **治病提示开关**：状态文字与“切换提示”按钮合并为居中行，按钮按 `System_Setting.csv` 中“是否开启诊疗病人提示”的六档选项循环（关闭→系统→部位→轻症→中症→重症），并在同一模块下方常驻提示“医疗技能的能力等级越高，就可以获得更多的提示。”切换时会读取 `player_med_level` 校验可用档位，只有当医疗能力等级分别达到 1、2、3、5、7 时才解锁系统/部位/轻症/中症/重症档；能力不足时按钮自动回退到当前能力允许的最高档，并通过反馈文本提示当前档位。
  - 档位 1 仅高亮患者所属的生理系统，档位 2 额外高亮具体部位，档位 3/4/5 依次追加轻症、中症、重症层级的正确检查条目，并始终保留所有低阶档位的提示，使高亮范围严格等同于“玩家选择的档位及以下”。
  - 诊疗面板不再因为医疗能力单独额外暴露更深层的信息，确保提示粒度完全由玩家设定控制，同时仍受医疗能力上限约束。
- **检查方法模块**：在尚未找全正确并发症且 `used_checks < player_med_level * 2` 时绘制。
  - 若存在已选中的怀疑项目则列出“系统 / 部位 / 并发症等级+名称 / 检查方法”，否则显示“当前未选择”。
  - 构建四级菜单：①“展开/收起检查行动”根节点；②每个 `system_name`；③系统下各 `part_name`；④部位下所有并发症条目（含等级标签与 `exam_method`）。菜单默认枚举配置中的全部生理系统，即使当前病人未涉及也会显示空节点以便在提示高亮指引下跳转；系统会自动跳过 `gender_limit == 0` 的女性专属部位。所有层级条目各占一行显示，系统与部位展开互斥（任意时刻只展示一个系统的一个部位）。
  - 允许多选，最大可并行选择数量等于病人并发症数。总检查次数上限为 `player_med_level * 2`。
- **检查结果模块**：只要执行过至少一次检查即显示，结果标签会使用颜色提示（阳性=警示色、阴性=绿色、需再检=蓝色）以便快速判断。逐条列出：
  - 结果判定：“阳性”=确诊该条目；“阴性”=部位无任何并发症；“需再检”=部位存在其他并发症并根据其等级标注轻/中/重。
  - 随结果附上检查名称与对应文案：阳性用 `exam_result_positive`，阴性用 `exam_result_negative`，需再检根据等级使用 `recheck_hint_mild / moderate / severe`。
- **诊疗方法模块**：在已确诊至少一条并发症或检查次数耗尽时呈现。
  - 列表包含每个已确认并发症的等级、名称、`treatment_plan` 与所需药物（含资源 ID 与数量）。
  - 若未确诊但达到上限，则显示“疑似结果”提示，并列出候选条目供玩家参考。
  - 底部给出预计总药品需求与龙门币收益（结合 `medical_price_ratio` 与医疗等级修正）。尚未确诊的并发症仅按 50% 计入药品需求与收益预估，并在说明文本中提示剩余未确认数量。若仓库库存无法覆盖需求，界面会在对应药品后追加“缺口/库存”提示，帮助博士提前准备耗材。
- **操作按钮**：
  - “确定进行已选的检查方法”：仅在未查全、未达上限且已选至少一项时启用，点击后按上述逻辑扣减检查次数并写入结果（条件未满足时按钮不渲染）。
  - “开药并结束诊疗”：在确诊≥1 条或检查次数用尽时启用。若仍有未确诊并发症且还有剩余检查次数，会先弹出“确认就这样治疗”“返回继续检查”双按钮进行二次确认；确认后才会发放诊疗收入，病人状态从 `in_treatment_player` 进入 `waiting_medication` 并触发常规用药流程（条件未满足时按钮不渲染）。
  - “开药并接诊下一位”：在满足“开药并结束诊疗”同等条件时出现，执行诊疗/用药结算后尝试根据当前分诊策略自动抽取下一名待诊病人；若不存在其他病人，则提示队列已空并正常结束面板，否则立即刷新面板内容以继续新的诊疗流程。
  - “提前结束诊疗并返回”：仅在未执行任何检查前显示，可将病人状态重置回原始待诊状态且不产生收益或处罚。
  - 诊疗结算提示会在药费收益后附带缺药清单，明确列出需要补充的药剂及缺口数量。

## 与其他系统的交互
- **资源系统**：药物扣除、龙门币收入，与 `resource_handle` 中的统一接口保持一致。
- **角色行为系统**：诊疗及手术过程可纳入干员日常行为循环；在 `character_behavior.py` 中增加 `cure_patient` 与 `perform_surgery` 行为触发逻辑，协调特殊状态机。
- **建筑系统**：医疗区等级可由基建或设施升级系统维护，需要同步更新床位与刷新公式。

## 扩展点
1. **个性化病人**：引入特定身份或剧情病人，影响奖励与事件。
2. **药物制造链**：与工业生产系统联动，提供药品自给或研发加成。
3. **治疗失败惩罚**：长时间缺药可导致病情恶化或声望下降。
4. **干员疲劳**：连续工作影响诊疗速度，需要排班系统。
5. **手术特效**：引入专属能力或事件，提高手术成功率或追加特殊收益。
6. **跨系统收益**：治愈知名干员触发招募或成就。

## 快速调试示例
1. 在 `config.ini` 中确认 `debug = 1`，并按需求设置 `web_draw` 以选择 Tk 或 Web 渲染模式。
2. 执行 `python buildconfig.py`，确保最新的医疗 CSV 配置被编译进 `config_def.py`。
3. 运行 `python game.py`，进入基建界面后打开“医疗部 → 医疗经营系统”面板。
4. 在“医生管理”页调节坐诊/住院医生数量并切换接诊优先策略，观察综合医生能力后的预计全部诊疗时间与病患分配的实时变化。
5. 切换到“收费设置”页使用百分比按钮（`-10%/-5%/-1%/+1%/+5%/+10%`）调整收费，确认收益与病人刷新量预测即时更新。
6. 使用“医疗明细”页追踪等待用药、住院病患与药品累计进度，必要时通过“财务报表”页核对当日收入。
7. 触发新一天（例如通过时间流逝或调用日结），检查 `settle_medical_department()` 输出的日志与 `log_system.append_medical_report()` 记录，确认药品消耗与收入归集正确。
