# 食物系统说明

## 系统概述

erArk游戏的食物系统是一个复杂的烹饪、购买、存储和食用管理系统，涉及食谱配方、调味料、食物品质、餐厅管理等多个维度。系统支持玩家制作食物、在各种餐厅购买食物、管理食物背包，以及与NPC分享食物等功能。

## 核心组件

### 1. 三大核心面板

#### 1.1 制作食物面板 (make_food_panel.py)
**主要功能：**
- 制作食物界面，支持制作主食、零食、咖啡等不同类型食物
- 提供调味选择功能，包括基础调味(0-10)、精液调味(11-12)、药物调味(102+)
- 集成食谱选择、制作确认、时间管理等功能

**核心类：**
- `Make_food_Panel`: 主面板类，管理食物类型切换和调味选择
- `SeeFoodListByFoodNameDraw`: 食物选项绘制类，处理具体食物的制作流程

**关键特性：**
- 支持普通做饭(type=0)和泡咖啡(type=1)两种模式
- 调味系统分为基础、精液、药物三大类
- 制作过程包含难度判定、时间消耗、品质评估

#### 1.2 食物商店面板 (food_shop_panel.py)
**主要功能：**
- 显示不同餐厅的食物列表
- 支持食堂、各种主题餐厅、地摊小贩等多种食物来源
- 食物购买和背包存储功能

**核心类：**
- `FoodShopPanel`: 主商店面板，根据场景标签自动识别对应餐厅
- `SeeFoodListByFoodNameDraw`: 食物列表绘制类，显示食物详情和购买按钮

**关键特性：**
- 自动场景识别：根据当前位置的scene_tag自动匹配对应餐厅
- 多数据源支持：食堂(dining_hall_data)、餐厅(restaurant_data)、地摊(stall_vendor_data)
- 食物品质标记：显示手制、高品质等标识

#### 1.3 食物背包面板 (food_bag_panel.py)
**主要功能：**
- 显示玩家持有的所有食物
- 区分普通调味和特殊调味食物
- 食物食用和分享功能

**核心类：**
- `FoodBagPanel`: 主背包面板，管理食物分类显示
- `SeeFoodListByFoodNameDraw`: 食物条目绘制类，处理食物食用逻辑

**关键特性：**
- 双列表显示：正常调味食物和特殊调味食物分开显示
- 版本兼容：自动检测和删除因版本更新导致的异常食物数据
- 使用限制：根据饥饿状态、目标状态等条件限制食物使用

### 2. 数据层组件

#### 2.1 食谱系统 (Recipes.csv)
**数据结构：**
```csv
cid, name, type, time, difficulty, money, restaurant, introduce
```

**食物类型分类：**
- 0: 正餐/主食
- 1: 零食
- 2: 饮品
- 3: 酒类
- 4: 乳制品
- 5: 预制食物
- 8: 加料咖啡
- 9: 其他

**关键字段：**
- `difficulty`: 烹饪难度，影响玩家是否能制作
- `restaurant`: 餐厅归属，决定食物在哪个餐厅出现
- `time`: 制作耗时，影响游戏时间流逝

#### 2.2 调味系统 (Seasoning.csv)
**调味分类：**
- **基础调味 (0-10)**: 正常、酸、甜、苦、辣等
- **精液调味 (11-12)**: 
  - 11: 巧妙混入食物中
  - 12: 不作掩饰直接射上去
- **药物调味 (102+)**: 避孕药、媚药、利尿剂、安眠药、排卵促进药等

**使用限制：**
- 精液调味需要进行接受度判定
- 药物调味需要玩家拥有对应道具
- 不同调味对NPC的反应机制不同

#### 2.3 食物品质系统 (Food_Quality.csv)
**品质等级：**
- 0: 粗劣 (技能上限1)
- 1: 逊色 (技能上限3)
- 2: 普通 (技能上限5)
- 3: 美味 (技能上限7)
- 4: 绝珍 (技能上限8)

**品质影响：**
- 由制作者的料理技能决定
- 影响食物的营养价值和NPC反应
- 在商店和背包中显示品质标识

#### 2.4 餐厅系统 (Restaurant.csv)
**餐厅类型：**
- 瓦莱丽蛋糕店 (Walyria_Cake_Shop)
- 山城茶馆 (Teahouse)
- 哥伦比亚咖啡馆 (Café)
- 七城风情餐厅 (Seven_Cities_Restaurant)
- 约翰老妈汉堡店 (Burger)
- 健康快餐店 (Healthy_Diner)
- 龙门食坊 (Lungmen_Eatery)
- 快捷连锁披萨店 (Pizzeria)

**餐厅机制：**
- 每个餐厅有专门的食谱集合
- 根据场景标签自动匹配餐厅
- 支持角色出身地餐厅偏好系统

### 3. 业务逻辑层 (cooking.py)

#### 3.1 核心功能函数

**初始化函数：**
- `init_recipes()`: 初始化菜谱数据
- `init_food_shop_data()`: 初始化商店食物数据
- `init_makefood_data()`: 初始化玩家制作区食物数据

**数据获取函数：**
- `get_food_list_from_food_shop()`: 获取商店食物列表
- `get_cook_from_makefood_data_by_food_type()`: 按类型获取可制作食物
- `get_character_cookable_recipes()`: 获取角色可制作的食谱

**业务判定函数：**
- `judge_accept_special_seasoning_food()`: 判定NPC是否接受特殊调味食物
- `find_character_birthplace_restaurant()`: 根据角色出身地匹配餐厅

#### 3.2 数据流转机制

**制作食物流程：**
1. 玩家选择食谱和调味 → 2. 系统验证制作条件 → 3. 消耗时间和材料 → 4. 生成食物到背包

**购买食物流程：**
1. 进入商店场景 → 2. 系统识别餐厅类型 → 3. 显示对应食物列表 → 4. 购买转移到背包

**食用食物流程：**
1. 从背包选择食物 → 2. 判定使用条件 → 3. 特殊调味进行接受度判定 → 4. 执行食用效果

### 4. 数据存储结构

#### 4.1 食物对象 (Food)
```python
class Food:
    id: str                    # 食物配置ID
    uid: UUID                  # 唯一标识符
    name: str                  # 食物名称
    maker: str                 # 制作者
    quality: int               # 品质等级
    recipe: int                # 所属食谱ID
    special_seasoning: int     # 特殊调味类型
    special_seasoning_amount: int  # 特殊调味量(精液量等)
    milk_ml: int              # 母乳含量
```

#### 4.2 缓存数据结构
- `cache.rhodes_island.dining_hall_data`: 食堂食物数据
- `cache.rhodes_island.restaurant_data`: 各餐厅食物数据
- `cache.rhodes_island.stall_vendor_data`: 地摊小贩食物数据
- `cache.rhodes_island.makefood_data`: 玩家制作区食物数据
- `character_data.food_bag`: 角色食物背包

### 5. 系统交互关系

#### 5.1 与角色系统的关系
- **技能依赖**: 烹饪技能影响可制作食谱和食物品质
- **好感度影响**: 口才和厨艺技能影响特殊调味食物的接受度
- **状态管理**: 饥饿状态影响食物使用，食用后影响角色状态

#### 5.2 与时间系统的关系
- **制作耗时**: 不同食谱有不同制作时间
- **商店刷新**: 新的一天会刷新部分商店食物
- **食物保存**: 食物没有过期机制，可长期保存

#### 5.3 与地图系统的关系
- **场景识别**: 根据当前场景的tag自动匹配对应餐厅
- **移动限制**: 只有在特定场景才能访问对应功能

#### 5.4 与道具系统的关系
- **药物消耗**: 使用药物调味会消耗对应道具
- **精液机制**: 精液调味通过专门的射精面板处理

## 开发和维护要点

### 1. 扩展性设计
- 新增食谱只需在CSV文件中添加记录
- 新增餐厅需要同时更新Restaurant.csv和相关场景标签
- 新增调味类型需要更新Seasoning.csv和相关判定逻辑

### 2. 数据一致性
- 食物品质由制作者技能决定，需要确保技能值和品质等级的对应关系
- 餐厅食谱归属需要与Restaurant.csv中的配置保持一致
- 特殊调味的接受度判定涉及多个角色属性，需要保持逻辑一致性

### 3. 性能考虑
- 商店食物数据会定期刷新，避免一次性生成过多食物对象
- 背包食物显示使用分页机制，避免UI性能问题
- 使用UUID作为食物唯一标识，确保数据操作的准确性

### 4. 版本兼容性
- 食物背包面板包含版本更新检测机制
- 新增食物属性时需要考虑旧存档的兼容性
- 数据结构变更需要提供相应的迁移逻辑

这个食物系统体现了erArk游戏在角色扮演和模拟元素上的丰富设计，通过多层次的数据结构和复杂的交互逻辑，为玩家提供了深度的烹饪和餐饮体验。