# 隐奸系统说明

## 系统概述

隐奸系统是erArk游戏中的一个重要H系统，允许玩家与角色进行隐秘的性行为，通过隐蔽值机制模拟被发现的风险和紧张感。该系统涉及多个代码模块的协作，包括面板显示、行为结算、前提判断、AI处理等。

## 核心概念

### 隐奸模式（Hidden Sex Mode）
- **模式0**：不在隐奸模式中
- **模式1**：双不隐 - 双方身体均暴露在外，仅靠视线遮挡来避免被发现，容易被察觉
- **模式2**：女隐 - 博士不隐藏，干员藏起来不让别人看见，隐蔽程度中等
- **模式3**：男隐 - 干员不隐藏，博士藏起来不让别人看见，隐蔽程度中等
- **模式4**：双隐 - 博士和干员都藏起来不让别人看见，很难被察觉

### 隐蔽值与发现度
基于CSV配置的四个等级：
- **完全隐蔽**（0-30）：不会被发现
- **隐蔽**（31-60）：较安全
- **引人注意**（61-80）：有一定被发现风险
- **随时暴露**（81-95+）：极易被发现

## 核心文件架构

### 主要文件结构
```
Script/UI/Panel/hidden_sex_panel.py         # 隐奸面板主文件
Script/Design/handle_premise_sp_flag.py     # 隐奸模式前提判断
Script/Core/constant_promise.py             # 隐奸相关常量定义
Script/Core/constant/Behavior.py            # 隐奸行为常量
Script/Core/game_type.py                    # 角色数据结构定义
Script/Settle/default.py                    # 隐奸状态结算
Script/Design/character_behavior.py         # 行为处理主循环
Script/Design/handle_instruct.py            # 隐奸指令处理
data/csv/Hidden_Level.csv                   # 隐蔽等级配置
```

## 详细工作流程

### 1. 隐奸模式选择流程

#### 触发条件
- 玩家执行"邀请隐奸"指令（`ASK_HIDDEN_SEX`）
- 需要满足以下前提：
  - 有交互对象
  - 不在H模式中
  - 当前不在隐奸模式中
  - 对象可以配合或没有对象
  - 体力≤74

#### 选择界面（`Select_Hidden_Sex_Mode_Panel`）
```python
# 位置：Script/UI/Panel/hidden_sex_panel.py:376-457
class Select_Hidden_Sex_Mode_Panel:
    def draw(self):
        # 显示四种隐奸模式选项
        # 模式2-4需要场景中只有两人或其他人都无意识
        # debug模式下不限制选择
```

#### 模式设置
```python
def select_this_mode(self, mode_id):
    # 设置玩家和交互对象的隐奸模式
    character_data.sp_flag.hidden_sex_mode = mode_id
    target_character_data.sp_flag.hidden_sex_mode = mode_id
```

### 2. 隐蔽值计算机制

#### 主处理函数（`handle_hidden_sex_flow`）
```python
# 位置：Script/UI/Panel/hidden_sex_panel.py:31-53
def handle_hidden_sex_flow(character_id=0, add_flag=None, now_duration=0, now_intensity=0):
    # 1. 检查场景是否有未处于隐奸模式且有意识的角色
    # 2. 结算隐蔽值变化
    # 3. 判断是否被发现
    # 4. 被发现时执行相应处理
```

#### 隐蔽值结算（`settle_hidden_value_by_action`）
```python
# 位置：Script/UI/Panel/hidden_sex_panel.py:136-202
def settle_hidden_value_by_action(character_id, add_flag, now_duration, now_intensity):
    # 影响因素：
    # 1. 行为类型（猥亵、性爱增加，等待减少）
    # 2. 隐奸模式调整（双不隐×2，双隐×0.5）
    # 3. 行为强度（道具4、插入3、侍奉2、其他1）
    # 4. 隐蔽能力等级影响
    # 5. 在场人数（影响被发现概率）
```

#### 计算公式
```python
# 增加隐蔽值时：
adjust = now_intensity * mode_adjust / abi_adjust * other_chara_adjust
# 减少隐蔽值时：
adjust = -2 / mode_adjust * abi_adjust
# 最终变化：
delta = int(now_duration * adjust)
```

### 3. 发现判定机制

#### 发现概率计算（`check_hidden_sex_discovery`）
```python
# 位置：Script/UI/Panel/hidden_sex_panel.py:204-223
def check_hidden_sex_discovery(now_degree):
    # 小于隐蔽等级2（60点）不会被发现
    # 超过60点的部分×3作为发现概率
    discover_rate = (now_degree - 60) * 3
    # 随机数判定
    return discover_rate >= random.randint(0, 100)
```

### 4. 被发现后的处理

#### 发现结算（`settle_discovered`）
```python
# 位置：Script/UI/Panel/hidden_sex_panel.py:225-289
def settle_discovered(character_id):
    # 1. 退出隐奸模式
    # 2. 寻找能打断的角色
    # 3. 如果有人打断：触发打断事件
    # 4. 如果无人打断：转为群交模式
```

#### 打断情况
- 找到有意识且未陷落的旁观者
- 旁观者触发`DISCOVER_HIDDEN_SEX_AND_INTERRUPT`行为
- 隐奸者触发`HIDDEN_SEX_INTERRUPT`行为

#### 群交情况
- 场景中无有意识旁观者
- 隐奸中的角色转为`HIDDEN_SEX_TO_GROUP_SEX`
- 其他角色触发`DISCOVER_HIDDEN_SEX_AND_JOIN`

### 5. 前提判断系统

#### 关键前提函数（`handle_premise_sp_flag.py`）
```python
# 隐奸模式判断
handle_hidden_sex_mode_0(character_id)      # 不在隐奸模式
handle_hidden_sex_mode_ge_1(character_id)   # 在某个隐奸模式中
handle_hidden_sex_mode_1(character_id)      # 双不隐模式
handle_hidden_sex_mode_2(character_id)      # 女隐模式
handle_hidden_sex_mode_3(character_id)      # 男隐模式
handle_hidden_sex_mode_4(character_id)      # 双隐模式

# 组合判断
handle_hidden_sex_mode_1_or_2(character_id) # 双不隐或女隐
handle_hidden_sex_mode_3_or_4(character_id) # 男隐或双隐
handle_hidden_sex_mode_1_or_3(character_id) # 双不隐或男隐
handle_hidden_sex_mode_2_or_4(character_id) # 女隐或双隐
```

### 6. 行为循环集成

#### 在主行为循环中的调用（`character_behavior.py:388-390`）
```python
# 隐奸的被察觉情况结算
if handle_premise.handle_hidden_sex_mode_ge_1(0):
    from Script.UI.Panel import hidden_sex_panel
    hidden_sex_panel.handle_hidden_sex_flow()
```

### 7. 状态显示系统

#### 信息面板（`See_Hidden_Sex_InfoPanel`）
```python
# 位置：Script/UI/Panel/hidden_sex_panel.py:292-374
class See_Hidden_Sex_InfoPanel:
    # 显示内容：
    # 1. 隐蔽程度文本
    # 2. 当前性行为描述
    # 3. 阴茎插入位置和体位信息
```

### 8. 相关辅助函数

#### 目标获取函数
```python
get_hidden_sex_targets(character_id)                    # 获取隐奸对象列表
get_nearby_conscious_unfallen_characters(character_id)  # 获取可能打断的角色列表
```

#### 等级判断函数
```python
get_hidden_level(value)  # 根据隐蔽值返回等级和名称
```

## 数据结构

### 角色数据中的隐奸相关字段
```python
# game_type.py中的SpecialFlag类
class SpecialFlag:
    hidden_sex_mode: int = 0  # [0否,1双不隐,2女隐,3男隐,4双隐]

# game_type.py中的HStateData类  
class HStateData:
    hidden_sex_discovery_dregree: int = 0  # 隐奸被发现度
```

### 配置数据
```csv
# data/csv/Hidden_Level.csv
cid,name,hidden_point
0,完全隐蔽,30
1,隐蔽,60
2,引人注意,80
3,随时暴露,95
```

## 相关行为常量

### 隐奸相关行为ID
```python
ASK_HIDDEN_SEX = "ask_hidden_sex"                          # 邀请隐奸
ASK_HIDDEN_SEX_FAIL = "ask_hidden_sex_fail"                # 邀请隐奸失败
HIDDEN_SEX_INTERRUPT = "hidden_sex_interrupt"              # 隐奸被打断
DISCOVER_HIDDEN_SEX_AND_INTERRUPT = "discover_hidden_sex_and_interrupt"  # 发现隐奸并打断
HIDDEN_SEX_TO_GROUP_SEX = "hidden_sex_to_group_sex"        # 隐奸转群交
DISCOVER_HIDDEN_SEX_AND_JOIN = "discover_hidden_sex_and_join"  # 发现隐奸并加入
```

## 系统特点

### 优势设计
1. **渐进式风险**：通过隐蔽值累积模拟紧张感
2. **多因素影响**：行为类型、模式、能力、环境等多重因素
3. **动态结果**：被发现后的不同处理路径
4. **平衡性**：不同模式各有优劣

### 技术亮点
1. **模块化设计**：各功能分离，易于维护
2. **配置驱动**：等级配置通过CSV文件管理
3. **前提系统**：完整的前提判断体系
4. **事件驱动**：与行为系统深度集成

## 扩展性

### 可能的扩展方向
1. **环境因素**：不同地点的隐蔽难度
2. **角色特性**：不同角色的隐蔽能力差异
3. **道具系统**：影响隐蔽效果的道具
4. **社交后果**：被发现后的长期影响

### 配置扩展
1. **等级细化**：增加更多隐蔽等级
2. **概率调整**：可配置的发现概率公式
3. **模式扩展**：新的隐奸模式类型

## 开发注意事项

### 代码维护
1. 隐奸逻辑集中在`hidden_sex_panel.py`中
2. 前提判断统一在`handle_premise_sp_flag.py`中
3. 状态结算在`default.py`中处理
4. 与主循环的集成点在`character_behavior.py`中

### 调试支持
- 系统提供debug模式，可跳过某些限制
- 错误处理包含调试信息输出

### 性能考虑
- 隐蔽值计算相对简单，性能开销较小
- 发现判定使用随机数，计算高效
- 前提判断函数设计为快速查找

## 总结

隐奸系统是一个设计精巧的游戏机制，通过多层次的风险管理和动态反馈，为玩家提供了紧张刺激的游戏体验。系统的模块化设计和完整的配置支持使其具有良好的可维护性和扩展性。