# 邀请访客系统说明

## 系统概述

邀请访客系统是erArk游戏中罗德岛基地管理的一个重要功能模块，允许玩家主动邀请或被动接收访客到罗德岛，并管理这些访客的住宿、停留时间以及最终去留决定。该系统涉及基建设施升级、外交机制、角色招募等多个游戏子系统。

## 核心文件结构

### 主要代码文件
- **`Script/UI/Panel/invite_visitor_panel.py`** - 邀请访客UI面板的主要实现
- **`Script/Design/character_handle.py`** - 角色创建和管理相关函数
- **`Script/Design/instuct_judege.py`** - 指令判定系统，用于计算访客留下概率
- **`Script/UI/Panel/recruit_panel.py`** - 招募面板，提供可招募角色列表
- **`Script/UI/Panel/manage_basement_panel.py`** - 基建管理面板，包含人员调配功能

### 数据配置文件
- **`data/csv/Visitor_Stay_Attitude.csv`** - 访客留下态度配置
- **`data/csv/Birthplace.csv`** - 出生地/国家配置
- **`data/csv/Facility.csv`** - 设施基础信息
- **`data/csv/Facility_open.csv`** - 可开放设施配置（包含客房信息）
- **`data/csv/Facility_effect.csv`** - 设施等级效果配置

## 系统架构详解

### 1. 数据存储结构

访客系统的核心数据存储在 `cache.rhodes_island` 对象中：

```python
class Rhodes_Island:
    # 访客区相关
    self.visitor_max: int = 0                    # 访客人数上限
    self.visitor_info: Dict[int, datetime] = {}  # 访客统计数据 访客id:停留结束时间
    self.last_visitor_time: datetime             # 上次访客到来时间
    self.invite_visitor: List[int, float] = {}   # 邀请进度 [目标角色id, 招募进度百分比]
    self.base_move_visitor_flag: bool = False    # 基地移动吸引访客标记
```

### 2. 设施等级系统

访客区设施等级决定了系统的核心功能：

| 等级 | 功能特性 | 访客上限 | 停留时长 | 邀请范围 |
|------|----------|----------|----------|----------|
| 1级  | 被动接受访客 | 1人 | 1天 | 无主动邀请 |
| 2级  | 开放主动邀请 | 2人 | 3天 | 当前所在国家 |
| 3级  | 扩大邀请范围 | 4人 | 7天 | 临近国家 |
| 4级  | 全泰拉邀请 | 8人 | 15天 | 全泰拉 |
| 5级  | 最高规格 | 12人 | 30天 | 全泰拉 |

### 3. 客房管理系统

客房采用ID范围管理：
- 客房ID范围：2001-2099（对应客房1-客房99）
- 每个客房对应访客区的不同等级要求
- 通过 `get_empty_guest_room_id()` 函数动态分配空闲客房

```python
def get_empty_guest_room_id():
    """返回空闲客房ID，如果无空闲客房返回False"""
    guest_rooms = [room_id for room_id in cache.rhodes_island.facility_open if 2000 < room_id < 2100]
    # 检查每个客房是否被占用
```

### 4. 访客生成机制

#### 4.1 触发条件
1. **基地移动触发**：当罗德岛移动到新位置时
2. **时间触发**：基于 `last_visitor_time` 计算的随机概率
   - 每增加一天，访客到来概率增加3%
   - 随机数1-100，小于等于概率值则触发

#### 4.2 访客筛选规则
```python
def settle_visitor_arrivals(visitor_id = 0):
    # 1. 检查是否有空闲客房
    if len(cache.rhodes_island.visitor_info) >= cache.rhodes_island.visitor_max:
        return 0  # 客房满员，无法接收
    
    # 2. 筛选符合条件的角色
    not_recruit_npc_id_list = recruit_panel.find_recruitable_npc()  # 未招募的角色
    now_country_id = cache.rhodes_island.current_location[0]        # 当前所在国家
    
    # 3. 按出生地筛选同国角色
    for npc_id in not_recruit_npc_id_list:
        if cache.character_data[npc_id].relationship.birthplace == now_country_id:
            now_country_npc_id_list.append(npc_id)
```

### 5. 主动邀请系统

#### 5.1 邀请条件
- 访客区等级 ≥ 2
- 有空闲客房
- 目标角色符合邀请范围要求

#### 5.2 邀请进度计算
```python
# 邀请效率加成计算
for chara_id in id_list:
    character_data = cache.character_data[chara_id]
    if character_data.work.work_type == 131:  # 外交官职业
        character_effect = 5 * attr_calculation.get_ability_adjust(character_data.ability[40])  # 话术能力
        all_effect += character_effect
```

#### 5.3 进度更新
- 每日自动增长基础进度
- 外交官加成根据话术能力计算
- 达到100%时触发访客抵达

### 6. 访客去留决定系统

#### 6.1 离开判定时机
- 预定停留期限到达时自动触发
- 管理员可手动提前结算

#### 6.2 留下概率计算
通过 `instuct_judege.calculation_instuct_judege()` 函数计算：
- 基础概率由角色关系、好感度、各种状态综合决定
- 参考指令"访客留下"的前提条件计算

#### 6.3 留下态度系统
根据 `Visitor_Stay_Attitude.csv` 配置：

| 态度ID | 态度名称 | 概率阈值 |
|--------|----------|----------|
| 1 | 毫无兴趣 | 0.25 |
| 2 | 模棱两可 | 0.5 |
| 3 | 有些意动 | 0.75 |
| 4 | 十分心动 | 1.0 |
| 5 | 迫不及待 | 999 |

### 7. 访客转化为正式干员

#### 7.1 转化流程
```python
def visitor_to_operator(character_id: int):
    # 1. 设置访问标记
    character_data.sp_flag.vistor = 2
    
    # 2. 从访客列表移除
    del cache.rhodes_island.visitor_info[character_id]
    
    # 3. 检查并开放对应设施
    for open_cid in game_config.config_facility_open:
        if game_config.config_facility_open[open_cid].NPC_id == character_data.adv:
            cache.rhodes_island.facility_open[open_cid] = True
    
    # 4. 重新分配宿舍
    character_handle.new_character_get_dormitory(character_id)
```

#### 7.2 设施解锁机制
某些特殊角色成为正式干员后，会自动解锁专属设施：
- 通过 `Facility_open.csv` 中的 `NPC_id` 字段关联
- 例如：梅尔(242)解锁梅尔宿舍、鲁特拉等设施

### 8. UI界面系统

#### 8.1 主界面功能
- **当前访客展示**：显示访客列表、居住房间、离开倒计时
- **邀请目标选择**：根据访客区等级显示可邀请范围和目标
- **邀请进度显示**：当前进度百分比和效率加成详情
- **人员管理**：跳转到基建人员调配界面

#### 8.2 目标选择界面
- 显示当前邀请范围（本地/临近/全泰拉）
- 按角色ADV ID排序显示可邀请目标
- 支持更换邀请目标（会重置进度）

#### 8.3 提前结算界面
- 显示所有当前访客按钮
- 每行显示3个访客
- 点击可立即触发该访客的去留判定

### 9. 与其他系统的关联

#### 9.1 招募系统
- 复用 `recruit_panel.find_recruitable_npc()` 获取候选角色
- 访客转化为正式干员后加入招募池

#### 9.2 基建系统
- 依赖访客区设施等级
- 客房作为基建设施的子集管理
- 电力消耗和维护成本计算

#### 9.3 外交系统
- 外交官职业影响邀请效率
- 国家关系可能影响访客生成（未完全实装）

#### 9.4 时间系统
- 基于游戏时间的自动访客生成
- 停留期限的倒计时管理
- 新一天的自动结算

### 10. 关键算法和数据流

#### 10.1 访客生成算法
```
每日检查 -> 计算概率 -> 筛选候选者 -> 分配客房 -> 设定离开时间
```

#### 10.2 邀请进度算法
```
基础进度 + 外交官加成 -> 每日累积 -> 达到100% -> 触发访客抵达
```

#### 10.3 去留判定算法
```
计算留下概率 -> 确定态度等级 -> 随机判定 -> 执行转化或离开
```

#### 10.4 数据流向
```
CSV配置 -> 游戏初始化 -> 运行时状态 -> UI显示 -> 玩家操作 -> 状态更新 -> 持久化存储
```

## 系统特点和设计思路

1. **层次化设施系统**：通过访客区等级逐步解锁功能，增加游戏进程感
2. **地理位置关联**：邀请范围与罗德岛位置相关，体现地理因素影响
3. **多重随机性**：访客生成、去留判定都包含随机因素，增加不确定性
4. **外交官价值体现**：特定职业在特定系统中发挥重要作用
5. **渐进式体验**：从被动接受到主动邀请，从本地到全泰拉的扩展过程

这个系统展现了erArk游戏在模拟经营方面的深度设计，将角色招募、基建管理、时间推进等多个系统有机结合，为玩家提供了丰富的策略选择和管理体验。