# common_default.py 函数说明

这个文件包含了游戏中用于角色状态、属性、好感度等各种数值结算的通用函数。

## 核心结算函数

### 1. base_chara_hp_mp_common_settle
**基础角色体力与气力通用结算函数**

- **功能**: 处理角色的体力(HP)和气力(MP)变化
- **参数**:
  - `character_id`: 角色ID
  - `add_time`: 结算时间
  - `hp_value`: 体力值(-1按程度减少，1按程度增加，其他为具体值)
  - `mp_value`: 气力值(-1按程度减少，1按程度增加，其他为具体值)
  - `degree`: 程度系数(0少，1中，2大)
  - `target_flag`: 是否对交互对象也进行结算
  - `change_data`: 结算信息记录对象
  - `change_data_to_target_change`: 交互对象的结算信息记录对象

- **特殊处理**:
  - 时停状态下不结算
  - 群交模式下消耗减少(玩家减为1/3，NPC减为1/2)
  - 气力为0时，气力消耗会转为体力消耗
  - 气力为0时，体力消耗变为3倍
  - 体力最小为1，气力最小为0
  - 体力降到1时会触发疲劳判定

### 2. base_chara_state_common_settle
**基础角色状态通用结算函数**

- **功能**: 处理角色各种状态值的变化(快感、情绪、心理等)
- **参数**:
  - `character_id`: 角色ID
  - `add_time`: 结算时间
  - `state_id`: 状态ID
  - `base_value`: 基础固定值(默认30)
  - `ability_level`: 系数修正用能力等级
  - `extra_adjust`: 额外系数
  - `tenths_add`: 是否额外增加当前值的1/10(默认True)
  - `change_data`: 结算信息记录对象
  - `change_data_to_target_change`: 交互对象的结算信息记录对象

- **状态分类**:
  - 快感状态: 通过`chara_feel_state_adjust`计算系数
  - 正面状态: 习得(9)、恭顺(10)、好意(11)、欲情(12)、快乐(13)、先导(14)、屈服(15)、羞耻(16)
  - 负面状态: 恐怖(18)、抑郁(19)、反感(20)
  - 身体状态: 润滑(8)、欲情(12)、苦痛(17)
  - 心智状态: 除身体状态外的其他状态

- **特殊处理**:
  - 意识模糊下不结算负面状态
  - 深度无意识下只结算身体物理状态
  - 连续重复指令会递减效果(每次-15%，最低40%)
  - 心控-苦痛快感化: 将苦痛(17)转化为快感(23)
  - 某些状态会触发额外快感结算

### 3. chara_feel_state_adjust
**角色快感系数获得函数**

- **功能**: 计算快感状态的最终系数
- **影响因素**:
  - 部位感觉能力
  - 技巧能力(如果提供)
  - 调香效果(+1)
  - 催眠-敏感(+2)
  - 怀孕状态对V和W快感(+1)
  - 灌肠对V和W快感(+容量*0.2)
  - 眼罩(+0.2)
  - 无觉刻印(无意识状态下增加)
  - 信物加成
  - 群交人数加成(每人+0.02，最多10人)
  - 系统难度修正

### 4. chara_base_state_adjust
**角色状态系数获得函数**

- **功能**: 计算非快感状态的最终系数
- **影响因素**:
  - 能力修正(刻印相关状态使用特殊计算)
  - 素质修正:
    - 勤劳/懒散影响习得、先导
    - 脆弱/坚强影响恭顺、屈服
    - 热情/孤僻影响好意、快乐
    - 羞耻/开放影响欲情、羞耻
    - 施虐狂/受虐狂/感情缺乏等特殊素质
  - 信物修正
  - 调香效果
  - 催眠效果
  - 群交人数加成(每人+0.05，最多10人)
  - 攻略进度(正面+5%/级，负面-20%/级)
  - 系统难度修正

### 5. extra_feel_settle
**额外快感结算函数**

- **功能**: 处理特定状态产生的额外快感
- **触发条件**:
  - 施虐(能力35≥5)对先导(14)产生快感
  - 露出(能力34≥5)对羞耻(16)产生快感
  - 受虐(能力36≥5)对苦痛(17)产生快感
- **快感量**: 原状态值的1/20，最小10

### 6. base_chara_favorability_and_trust_common_settle
**基础角色好感与信赖通用结算函数**

- **功能**: 处理角色间的好感度和信赖度变化
- **参数**:
  - `character_id`: 角色ID
  - `add_time`: 结算时间
  - `favorability_flag`: True为好感，False为信赖
  - `base_value`: 基础固定值
  - `extra_adjust`: 额外系数
  - `change_data`: 结算信息记录对象
  - `target_character_id`: 目标角色ID(默认0)

- **特殊处理**:
  - 防止重复结算
  - 无意识状态下不结算
  - 时停状态下不结算
  - 信物调整(信物干员+0.1，全体+数量*0.01)
  - 连续重复指令递减(同状态结算)
  - 调用专门的计算函数处理具体数值

### 7. calculation_favorability
**好感度计算函数**

- **功能**: 根据角色状态计算最终好感度
- **影响因素**:
  - 状态影响:
    - 恭顺、好意、欲情、快乐每级+10%
    - 羞耻、苦痛每级-10%
    - 恐怖、抑郁、反感每级-30%
  - 能力影响:
    - 亲密、快乐刻印、屈服刻印每级+20%
    - 苦痛刻印、恐怖刻印每级-30%
    - 反发刻印每级-100%
  - 素质影响:
    - 爱情/隶属系素质+25%~100%
    - 受精、妊娠、育儿+50%
    - 感情缺乏-20%
    - 讨厌男性-20%
    - 博士信息素每级+25%
  - 好感香薰+50%
  - 空气催眠时置为0

### 8. calculation_trust
**信赖度计算函数**

- **功能**: 根据角色状态计算最终信赖度
- **计算方式**: 基于时间(分钟)和各种修正系数
- **影响因素**: 与好感度计算类似，但基础值为时间/60

### 9. base_chara_climix_common_settle
**基础角色绝顶通用结算函数**

- **功能**: 处理角色的高潮结算
- **参数**:
  - `character_id`: 角色ID
  - `part_id`: 部位ID(0-7为各性器官，21-23为特殊部位)
  - `base_value`: 基础固定值(默认500)
  - `adjust`: 系数(默认-1，使用随机值0.8-1.2)
  - `degree`: 绝顶程度(-1自动判断，0小1普2强3超)
  - `change_data`: 结算信息记录对象
  - `change_data_to_target_change`: 结算信息记录对象

- **特殊处理**:
  - 只有玩家有P部位(3)
  - 根据之前的高潮次数自动判断程度(每3次循环)
  - 触发对应的二级行为标记
  - P部位触发射精面板

### 10. base_chara_experience_common_settle
**基础角色经验通用结算函数**

- **功能**: 处理角色经验值的增加
- **参数**:
  - `character_id`: 角色ID
  - `experience_id`: 经验ID
  - `base_value`: 基础固定值(默认1)
  - `target_flag`: 是否加到交互对象身上
  - `change_data`: 状态变更信息记录对象
  - `change_data_to_target_change`: 交互对象结算信息记录对象

- **特殊处理**:
  - 深度无意识下部分经验(30-34)不结算
  - 经验值最小为0
  - 支持加到交互对象身上

## 使用说明

这些函数是游戏中所有数值结算的基础，被各种行为结算函数调用。它们处理了：

1. **统一的数值变化逻辑**: 包括上下限限制、状态检查等
2. **复杂的系数计算**: 考虑能力、素质、状态、道具等多方面影响
3. **特殊状态处理**: 时停、无意识、催眠等特殊状态的影响
4. **记录变化信息**: 通过change_data对象记录所有变化，用于UI显示
5. **交互对象处理**: 支持同时处理角色和交互对象的数值变化

这些函数确保了游戏中所有数值变化的一致性和可预测性。