# 载具管理系统

## 系统概述

载具管理系统是erArk游戏中的重要子系统，主要负责管理罗德岛的各种载具，包括载具的购买、出售、派遣和维护。该系统与外勤委托系统紧密结合，为干员执行外勤任务提供交通和辅助支持。

## 核心文件结构

### 主要代码文件
- `Script/UI/Panel/manage_vehicle_panel.py` - 载具管理界面主文件
- `Script/UI/Panel/field_commission_panel.py` - 外勤委托系统（载具派遣）
- `Script/Config/config_def.py` - 载具数据结构定义
- `Script/Config/game_config.py` - 载具配置加载
- `Script/Core/game_type.py` - 载具数据存储结构

### 数据文件
- `data/csv/Vehicle.csv` - 载具基础数据表
- `data/csv/Facility.csv` - 设施数据表（机库设施）
- `data/csv/Facility_effect.csv` - 设施效果数据表

## 数据结构设计

### 载具基础数据结构 (Vehicle类)
```python
class Vehicle:
    cid: int          # 载具id
    name: str         # 名字
    speed: int        # 速度
    capacity: int     # 运载量
    acquiring: str    # 获得方式
    price: int        # 价格
    special: str      # 特殊效果
    description: str  # 介绍
```

### 运行时载具数据结构
- 存储位置：`cache.rhodes_island.vehicles`
- 数据格式：`Dict[int, Tuple[int, int]]`
- 含义：`载具id: [总数量, 外勤中数量]`

### 载具分类
1. **常规载具** - 获得方式为"基础"的载具，可通过购买获得
2. **特殊载具** - 通过特殊途径获得的载具（如委托奖励）

## 系统功能模块

### 1. 载具管理界面 (Manage_Vehicle_Panel)

#### 核心功能
- **载具浏览**：分类显示常规载具和特殊载具
- **载具购买**：购买基础型载具
- **载具出售**：出售闲置的基础型载具
- **载具详情**：查看载具的详细信息

#### 界面元素
- 载具类型切换按钮（常规载具/特殊载具）
- 机库等级和载具数量显示
- 载具列表（名称、数量、速度、运载量、特殊效果）
- 载具详情弹窗

#### 关键方法
- `update_basement_vehicle_data()` - 更新基地载具数据
- `change_panel()` - 切换载具类型面板
- `vehicle_info()` - 显示载具详细信息
- `buy_vehicle()` - 购买载具
- `sell_vehicle()` - 出售载具

### 2. 载具派遣系统（外勤委托集成）

#### 派遣机制
- 载具可在外勤委托中派遣使用
- 派遣的载具会被标记为"外勤中"状态
- 委托完成后载具返回，可能发生损坏

#### 载具效果
- **速度影响**：载具速度影响委托完成时间，每点速度使总时间乘以0.9
- **运载量**：影响可携带的物资数量
- **特殊效果**：提供额外的地区适性或技能强化

#### 损坏机制
- 委托完成时载具有概率损坏
- 损坏概率 = 0.05 × 委托等级
- 损坏后载具数量减少，连续损坏概率递减

### 3. 机库设施系统

#### 设施信息
- **设施ID**：14
- **设施名称**：机库
- **功能**：停放、修理和派出载具

#### 等级限制
- 机库等级决定载具数量上限
- 通过`game_config.config_facility_effect`获取容量限制
- 载具购买受机库容量限制

## 载具配置数据

### CSV数据结构
```csv
cid,name,speed,capacity,acquiring,price,special,description
载具id,名字,速度,运载量,获得方式,价格,特殊效果,介绍
```

### 载具类型示例

#### 基础载具
1. **温顺的武装大驮兽** - 速度1，运载量4，价格10000
2. **两栖摩托快艇** - 速度4，运载量1，价格100000，特殊效果：两栖
3. **动力装甲系列** - 无运载量，提供战斗技能强化

#### 特殊载具
- **安潔莉娜型速攻艇** - 通过委托1104获得，速度5，运载量4

## 系统交互流程

### 载具购买流程
1. 玩家进入载具管理界面
2. 选择常规载具类型
3. 查看载具详情
4. 检查机库容量和资金
5. 确认购买，扣除龙门币
6. 更新载具数量

### 载具派遣流程
1. 玩家选择外勤委托
2. 选择派遣干员
3. 调整派遣载具
4. 系统计算运载量和速度
5. 确认派遣，载具进入"外勤中"状态
6. 委托完成后载具返回，可能损坏

### 载具出售流程
1. 玩家选择要出售的载具
2. 检查载具是否有空闲数量
3. 确认出售，按购入价格0.8倍回收
4. 获得龙门币，减少载具数量

## 代码组件关系

### 核心依赖关系
```
manage_vehicle_panel.py
├── game_config.config_vehicle (载具配置数据)
├── cache.rhodes_island.vehicles (运行时载具数据)
├── game_config.config_facility (机库设施数据)
└── cache.rhodes_island.materials_resouce (资源数据)

field_commission_panel.py
├── manage_vehicle_panel功能集成
├── 载具派遣逻辑
├── 载具损坏机制
└── 载具效果计算
```

### 数据流向
1. **配置加载**：CSV → buildconfig.py → config_def.py → game_config.py
2. **运行时数据**：game_type.py → cache.rhodes_island.vehicles
3. **界面展示**：cache数据 → UI面板渲染
4. **用户操作**：UI交互 → cache数据更新

## 扩展点和优化建议

### 当前限制
1. 特殊效果系统未完全实装
2. 载具维修功能缺失
3. 载具升级系统未实现

### 扩展建议
1. **载具改装系统**：允许玩家改装载具属性
2. **载具维修系统**：损坏载具可通过维修恢复
3. **载具租借系统**：与其他势力进行载具租借
4. **载具任务系统**：特定载具解锁特殊委托

## 性能考虑

### 数据缓存
- 载具数据在游戏启动时一次性加载
- 运行时载具状态存储在内存cache中
- 载具数量变化即时更新，无需持久化等待

### 界面优化
- 载具列表按需渲染，避免大量载具时的性能问题
- 载具图标和详情采用延迟加载
- 界面刷新采用局部更新策略

## 总结

载具管理系统是erArk游戏中一个功能完整、设计合理的子系统。它通过清晰的数据结构、完善的用户界面和与其他系统的良好集成，为玩家提供了丰富的载具管理体验。系统在保持功能完整性的同时，也为未来的功能扩展留下了充足的空间。