# 身体检查与管理系统

## 系统概述

身体检查与管理系统是erArk游戏中的一个重要医疗管理模块，允许玩家对干员进行身体检查、生成检查报告、设置身体管理方案以及调整体检日程。该系统集成了医疗技能、角色能力、前提判断、指令处理等多个游戏系统。

## 核心文件结构

### 主要代码文件

#### 1. 核心面板文件
- **文件路径**: `Script/UI/Panel/physical_check_and_manage.py`
- **核心类**: `Physical_Check_And_Manage_Panel`
- **功能**: 提供身体检查和管理的用户界面，处理检查流程和管理设置

#### 2. 相关配置文件
- **前提处理**: `Script/Design/handle_premise.py`
- **指令处理**: `Script/Design/handle_instruct.py`
- **属性计算**: `Script/Design/attr_calculation.py`
- **游戏类型**: `Script/Core/game_type.py`
- **配置定义**: `Script/Config/config_def.py`

### CSV数据文件

#### 1. 核心配置文件
- **`data/csv/Physical_Exam_Setting.csv`**: 体检日程配置
- **`data/csv/Body_Manage_Requirement.csv`**: 身体管理需求配置
- **`data/csv/Behavior_Data.csv`**: 行为数据（包含43个检查行为：850-892）
- **`data/csv/Behavior_Introduce.csv`**: 行为说明文本

#### 2. 对话文件
- **位置**: `data/talk/obscenity/body_examine/`
- **内容**: 20个身体部位的检查对话文件
- **类型**: 基础检查对话 + 差分对话（*_diff.csv）

#### 3. 设施配置
- **`data/csv/Facility_open.csv`**: 体检科设施（ID: 023）
- **`data/csv/Facility_effect.csv`**: 医疗部门等级效果

## 系统架构

### 数据流图

```
CSV配置文件 → 游戏配置加载 → 缓存数据结构
     ↓
前提系统验证 → 指令系统执行 → 结算系统处理
     ↓
角色数据更新 → UI界面显示 → 存档系统保存
```

### 核心数据结构

#### 1. 角色数据 (Character)
```python
class Character:
    body_manage: Dict[int, int] = {}  # 身体管理状态
    ability: Dict[int, int] = {}      # 能力数据（包含医术等级）
    talent: Dict[int, int] = {}       # 素质数据（包含身体特征）
    action_info.health_check_today: int = 0  # 今日体检时间段
```

#### 2. 罗德岛数据 (RhodesIsland)
```python
class RhodesIsland:
    physical_examination_setting: Dict[int, int] = {}  # 体检设置
    today_physical_examination_chara_id_dict: Dict[int, set] = {}  # 今日已体检数据
    examined_operator_ids: Set[int] = set()  # 周期内已体检干员
    waiting_for_exam_operator_ids: Set[int] = set()  # 等待体检干员
    manually_selected_exam_operator_ids: Set[int] = set()  # 手动选择的体检对象
    manually_selected_exam_week_day_list: List[int] = []  # 手动选择的体检日
```

## 核心功能模块

### 1. 身体检查模块

#### 检查类型分类
- **基础检查**: 头发、口腔、胸部、外阴、肛门等部位的基础检查
- **功能测试**: 在基础检查基础上进行的功能性测试（需要前置检查）
- **特殊检查**: 针对特殊身体部位（尾巴、兽角、翅膀等）的检查

#### 检查前置条件
1. **医术等级限制**: 可进行检查次数 = (医术等级 + 1) × 4 - 已检查次数
2. **前置检查依赖**: 部分高级检查需要先完成基础检查
3. **身体状态限制**: 处女状态影响某些内部检查的可用性
4. **身体特征要求**: 特殊部位检查需要角色具备相应的身体特征

#### 检查行为映射
```python
# 指令与前置指令的对应表
cmd_able_dict = {
    "examine_hair_smoothness": "examine_hair",      # 头发质感测试
    "examine_sucking_and_swallowing": "examine_oral", # 口腔功能测试
    "examine_vagina_firmness": "examine_vagina_and_folds", # 阴道测试
    # ... 更多映射关系
}

# 部位与素质的对应表
body_talent_map = {
    "examine_tail": 113,        # 尾巴素质
    "examine_horn": 112,        # 兽角素质
    "examine_ears": 111,        # 兽耳素质
    "examine_wing": 115,        # 翅膀素质
    # ... 更多映射关系
}
```

### 2. 身体管理模块

#### 管理类型
- **生活管理**: 内裤要求、作息调整等
- **训练管理**: 各种身体部位的训练和练习
- **特殊管理**: 基于角色状态的特殊管理方案

#### 管理条件判断
```python
def judge_manage_requirement(self, manage_cid: int, target_character_id: int):
    """判断是否满足身体管理的要求"""
    # 收藏品数量检查
    # 能力等级检查  
    # 经验值检查
    # 攻略进度检查
    # 催眠程度检查
    # 处女状态检查
    # 冲突检查
```

#### 管理效果
- **二段行为激活**: 激活相应的二段行为ID
- **工作调整**: 自动调整角色工作为性爱练习生
- **状态持续**: 管理状态在次日睡醒后生效

### 3. 体检日程模块

#### 日程配置选项
1. **新员工体检**: 新加入角色的体检安排
2. **定期体检开关**: 是否启用定期体检
3. **体检周期**: 年度/月度/周度/日度重置
4. **体检对象**: 感染者/全体/手动选择
5. **体检范围**: 仅新加入/全体干员
6. **每日人数**: 每天体检的人数设置
7. **体检日期**: 每周的体检日期设置

#### 自动调度逻辑
```python
def settle_health_check():
    """结算体检"""
    # 重置今日体检数据
    # 判断是否为体检日
    # 抽选今日要体检的干员
    # 分配上午/下午体检时段
    # 处理周期重置逻辑
```

### 4. 检查报告模块

#### 报告内容结构
1. **基础档案**: 代号、性别、性交经验、出身地、种族、矿石病感染情况
2. **综合体检测试**: 各项身体能力等级评估
3. **性爱履历**: 初吻、处女等重要记录
4. **检查详情**: 各部位的具体检查结果

#### 报告生成逻辑
```python
# 能力等级映射
level_text_dict = {
    0: "缺陷", 1: "普通", 2: "普通", 3: "标准",
    4: "标准", 5: "标准", 6: "优良", 7: "优良", 8: "卓越"
}

# 指令与能力ID的对应
cmd_ablility_dict = {
    "examine_sucking_and_swallowing": [71, "【舌部机动】"],
    "examine_breast_clamping": [73, "【乳压强度】"],
    # ... 更多映射
}
```

## 系统集成关系

### 1. 前提系统集成
- **`handle_premise.py`**: 提供各种检查和管理的前提条件判断
- **关键函数**:
  - `handle_periodic_health_check_on()`: 检查是否开启定期体检
  - `handle_self_in_health_check_list()`: 验证角色是否在体检名单中
  - `handle_have_virgin()`: 检查处女状态
  - `handle_first_sex_in_today()`: 检查今日是否破处

### 2. 指令系统集成
- **`handle_instruct.py`**: 处理检查指令的执行
- **核心函数**: `chara_handle_instruct_common_settle()`: 通用指令结算
- **参数**: `behavior_id`, `duration`, `force_taget_wait`

### 3. 结算系统集成
- **`settle_behavior.py`**: 处理检查行为的数值变化
- **集成点**: 每个检查行为都会触发相应的结算逻辑

### 4. 角色系统集成
- **能力系统**: 医术技能影响检查次数，检查结果影响角色能力
- **素质系统**: 身体特征决定可进行的检查类型
- **经验系统**: 检查过程会增加相应的经验值

### 5. 工作系统集成
- **地下室系统**: 身体管理可能调整角色的工作分配
- **特殊职业**: 性爱练习生职业与身体管理关联

## 技术实现细节

### 1. 状态管理
```python
class Physical_Check_And_Manage_Panel:
    def __init__(self, width: int):
        self.done_check_behavior_id_set = set()  # 已检查的行为ID集合
        
    def settle_finish_physical_check(self, target_character_id: int):
        """结算完成的体检"""
        # 记录到今日已体检数据
        # 加入周期内已体检名单
        # 从等待体检名单中移除
        # 清零今日体检时间
```

### 2. 数据验证
```python
def settle_target_physical_status(self, behavior_id: str):
    """结算目标角色的身体状态"""
    self.done_check_behavior_id_set.add(behavior_id)  # 添加到已检查集合
    handle_instruct.chara_handle_instruct_common_settle(behavior_id, force_taget_wait=True)
```

### 3. 循环调度
```python
# 每日新一天的处理
def settle_health_check():
    # 重置今日体检数据
    cache.rhodes_island.today_physical_examination_chara_id_dict = {}
    
    # 如果是体检日，抽选今日要体检的干员
    if handle_premise.handle_today_is_healty_check_day(0):
        # 抽选逻辑
        # 时间分配逻辑
    
    # 周期重置逻辑
    if cache.rhodes_island.physical_examination_setting[3] == 0:  # 每年重置
        if cache.game_time.month == 3 and cache.game_time.day == 1:
            cache.rhodes_island.examined_operator_ids = set()
```

## 使用流程

### 1. 玩家操作流程
```
进入医疗部 → 选择体检科 → 选择目标角色 → 进行身体检查
     ↓
选择检查项目 → 执行检查指令 → 查看检查结果 → 生成检查报告
     ↓
设置身体管理 → 配置管理项目 → 调整体检日程 → 完成设置
```

### 2. 系统自动流程
```
每日结算 → 检查体检日程 → 抽选体检对象 → 设置体检标记
     ↓
角色AI → 检查体检状态 → 前往体检科 → 等待体检
     ↓
玩家检查 → 完成检查 → 更新记录 → 移除等待状态
```

## 配置参数说明

### 体检设置参数 (Physical_Exam_Setting)
- **设置0**: 新员工体检 (0:关闭, 1:开启)
- **设置1**: 体检科教程 (0:关闭, 1:开启)  
- **设置2**: 定期体检 (0:关闭, 1:开启)
- **设置3**: 体检周期 (0:年度, 1:月度, 2:周度, 3:日度)
- **设置4**: 体检对象 (0:感染者, 1:全体, 2:手动选择)
- **设置5**: 体检范围 (0:仅新加入, 1:全体干员)
- **设置6**: 每日人数 (1-10人)
- **设置7**: 体检日期 (0:每日, 1:手动选择)

### 身体管理需求 (Body_Manage_Requirement)
- **管理ID**: 身体管理项目的唯一标识
- **二段行为ID**: 关联的二段行为
- **需要检查ID**: 前置检查要求
- **需要数值1/2/3**: 各种数值条件要求

## 总结

身体检查与管理系统是一个复杂的多模块集成系统，涉及UI面板、数据管理、前提判断、指令处理、结算系统等多个组件。该系统通过精心设计的数据结构和流程控制，实现了完整的医疗管理功能，为游戏提供了深度的角色管理和互动体验。系统的模块化设计保证了良好的可扩展性和维护性。