# 资源交易系统

## 系统概述

资源交易系统负责罗德岛内部的物资买卖、自动贸易和市场波动。核心逻辑集中在 `Script/UI/Panel/resource_exchange_panel.py` 中，围绕交易员任命、价格浮动、供需调节与 UI 交互构建。当前版本引入了自动交易阈值、主副交易员话术加成以及每日供需回归模型。

## 核心文件结构

### 主要代码文件
- `Script/UI/Panel/resource_exchange_panel.py` —— 资源交易面板及所有相关逻辑
- `Script/Config/game_config.py` —— 加载 `config_resouce`，提供所有资源配置
- `Script/Config/config_def.py` —— 数据结构定义（`Resource` 等）
- `Script/Core/game_type.py` —— `cache.rhodes_island` 下贸易相关字段的容器
- `Script/Core/constant/__init__.py` —— 面板切换常量

### 主要数据文件
- `data/csv/Resource.csv` —— 资源基础数据与类别
- `data/csv/Nation.csv` —— 国家/势力数据，配合特产判定
- `data/csv/Birthplace.csv` —— 地区数据，决定当前所在地

## 关键数据结构

### 1. Resource 配置 (config_def.py)
```python
class Resource:
    cid: int
    name: str
    type: str
    price: int
    cant_buy: int
    specialty: int
    info: str
```

### 2. 罗德岛贸易缓存 (game_type.py)
```python
class rhodes_island:
    materials_resouce: Dict[int, int]            # 仓储数量
    warehouse_capacity: int                      # 仓库上限
    current_location: List[int]                  # 当前位置 [国家id, 城市id]
    supply_demand_dict: Dict[int, float]         # 各资源供需系数
    today_trade_resource_count: Dict[int, int]   # 今日累计交易量
    trade_operator_ids_list: List[int]           # 参与贸易的干员
    resource_type_main_trader: Dict[str, int]    # 各资源类型主交易员
    resource_type_auto_trade_setting: Dict[int, Dict[str, Any]]
```
`resource_type_auto_trade_setting` 保存每个资源的自动交易开关与阈值，字段包括 `buy_on`、`buy_stock`、`buy_price_percent`、`sell_on`、`sell_stock`、`sell_price_percent`。

## 价格与供需机制

价格由三个因素叠加：
1. **基础价格**：
   - 特产且身处其特产国家时，基础价直接乘 1.5。
   - 其他情况买入使用 `1.1 * base_price`，卖出使用 `0.9 * base_price`。
2. **供需系数**：`cache.rhodes_island.supply_demand_dict` 默认为 1。交易后按每 50 单位触发 `_adjust_supply_demand_after_trade`，买入推动价格上行，卖出推动价格下行。
3. **交易员话术加成**：`calculate_trade_multiplier()` 以主交易员、全部副交易员的 40 号能力（话术）等级计算价格浮动，主、副分别提供 `0.5%` / `0.1%` 的线性加成，并限制买入最低不低于 50%，卖出最高不高于 200%。

`get_resouce_price()` 最终返回整数单价与相对基础价百分比波动，同时保证“买价不得低于卖价/卖价不得高于买价”的安全约束。

## 交易执行流程

- `perform_trade(resouce_id, quantity, buy_flag)`：校验数量、价格、仓容量和货币余额，成功后更新库存、龙门币、供需以及今日交易量，并返回实际成交信息。
- `_adjust_supply_demand_after_trade()`：按交易量分阶改变供需系数，考虑当日累计交易量影响调节幅度。
- `auto_trade_resources()`：当存在交易员时遍历所有资源，若满足阈值即调用 `perform_trade()` 自动买入/卖出，并收集结果展示。

## 自动交易与交易员管理

- `get_trade_resource_types()` 与 `_get_resource_type_key()` 保证资源类型与主交易员映射已初始化。
- `Resource_Exchange_Line_Panel.manage_trade_operator()` 提供交易员增减、主交易员任命与撤销，界面展示主副交易员及其话术等级。
- `auto_trade_setting(res_id)` 打开单个资源的自动交易配置：
  - 买入：目标库存 (`buy_stock`)、触发价百分比 (`buy_price_percent`，相对基础价)。
  - 卖出：保留库存 (`sell_stock`)、触发价百分比 (`sell_price_percent`)。
  - 百分比上限 300%，数值上限受仓库容量约束，可用按键快速调整或重置。
  - 仅当某资源类型存在主交易员时才允许配置并生效。
- `toggle_auto_trade()` 与 `adjust_auto_trade_value()` 封装开关切换及阈值调整。

## 每日供需刷新

`daily_supply_demand_fluctuation()`：
- 对除龙门币外的全部资源执行均值回归 + 随机波动的供需演化，并将结果限制在 `[0.1, +∞)`。
- 重置当日交易统计，并在波动后自动触发一次 `auto_trade_resources()`，实现“每日盘后自动交易”。

## UI 面板交互

`Resource_Exchange_Line_Panel` 作为面板入口，流程如下：
- `draw()`：展示当前资金、选中资源、主副交易员、自动交易摘要、实时买卖价及数量调节按钮；根据条件启用买入/卖出按钮。
- `select_exchange_resouce()`：分类折叠列表浏览全部资源，特产在非本地且库存为零时不显示；同时展示买卖价与库存。
- `execute_trade()`：基于当前数量执行买入/卖出并反馈实际成交数量。
- `settle_quantity()`、`reset_quantity()`、`settle_show_resource_type()`：处理玩家的数量输入与分类展开状态，数量会被仓库容量和持有量共同限制。
- 面板关闭时通过 `cache.now_panel_id` 切回场景界面。

## 业务约束与注意事项
- 价格、供需、自动交易均依赖 `cache.rhodes_island`，任何外部脚本改动库存/资金后应考虑同步供需或刷新自动交易。
- 交易员能力使用角色 `ability[40]`，缺失角色数据会被安全跳过。
- 自动买入需要资源可购买 (`cant_buy == 0`)，自动卖出则默认允许；特产交易仍受所在地与库存限制。
- 每次交易数量以 50 为单位影响供需，如需调试请注意交易量级。

## 相关依赖图

```
resource_exchange_panel.py
├── game_config.config_resouce      # 资源静态配置
├── cache.rhodes_island.*           # 仓储/供需/交易员/自动脚本状态
├── Script.UI.Moudle.draw           # Tk/UI 抽象组件
├── Script.Design.attr_calculation  # 文本宽度与对齐辅助
└── Script.Core.flow_handle         # 交互式选项输入
```

当前设计充分利用数据驱动思路：CSV 定义资源、`cache` 保存运行时状态，面板负责交互与展示。借助自动交易和供需波动，可快速扩展新的资源类型或交易规则。