# 读书系统说明

## 系统概述

erArk游戏中的读书系统是一个完整的图书管理和阅读体验系统，包含借书、读书、图书馆管理等多个功能模块。该系统通过三个主要面板文件实现：`borrow_book_panel.py`（借书面板）、`read_book_panel.py`（读书面板）、`manage_library.py`（图书馆管理面板）。

## 核心组件分析

### 1. 借书面板 (borrow_book_panel.py)

#### 主要功能
- **书籍浏览**：按技能类、娱乐类、色情类分类展示图书
- **书籍借阅**：支持借书和还书操作
- **借书限制**：每个角色最多可借3本书
- **能力检测**：根据书籍难度和角色能力判断是否可以借阅

#### 核心类和函数
- `Borrow_Book_Panel`：主面板类
  - `draw()`：绘制借书界面
  - `show_book(book_cid)`：显示单本书籍详细信息
  - `borrow(book_cid)`：执行借书/还书操作
  - `change_panel(building_type)`：切换书籍分类页面

- 重要函数：
  - `settle_library_book()`：刷新图书馆可借阅书籍，每类最多显示3本
  - `can_read_book(character_id, book_cid)`：检查角色能力是否足够阅读指定书籍
  - `check_return_book(character_id)`：检查并决定NPC是否归还书籍（随机）
  - `check_random_borrow_book(character_id)`：NPC随机借书逻辑
  - `add_borrow_history_record(character_id, book_id)`：添加借书历史记录
  - `update_return_history_record(character_id, book_id)`：更新还书历史记录
  - `update_read_count_in_history(character_id, book_id)`：更新历史记录中的阅读次数

#### 数据结构
```python
# 缓存数据
cache.rhodes_island.now_show_book_cid_of_type[book_type_cid]  # 当前展示的书籍ID列表
cache.rhodes_island.book_borrow_dict[book_id]  # 书籍借阅状态 (-1:可借, 0:被博士借, >0:被NPC借)
character_data.entertainment.borrow_book_id_set  # 角色借阅的书籍ID集合
character_data.entertainment.book_return_possibility  # 角色还书概率
```

### 2. 读书面板 (read_book_panel.py)

#### 主要功能
- **读书执行**：选择已借书籍进行阅读
- **进度显示**：显示每本书的阅读进度
- **内容展示**：随机显示书籍片段内容

#### 核心类和函数
- `Read_Book_Panel`：主面板类
  - `draw()`：绘制已借书籍列表
  - `read(book_id)`：执行读书行为

- `draw_book_fragment(book_id)`：随机绘制书籍片段内容

#### 行为触发机制
```python
character_data.behavior.behavior_id = constant.Behavior.READ_BOOK  # 设置读书行为
character_data.state = constant.CharacterStatus.STATUS_READ_BOOK   # 设置状态
character_data.behavior.book_id = book_id       # 记录阅读的书籍ID
character_data.behavior.book_name = book_name   # 记录书籍名称
character_data.behavior.duration = 30          # 设置行为持续时间（30分钟）
```

### 3. 图书馆管理面板 (manage_library.py)

#### 主要功能
- **催还书**：管理员可催促NPC归还图书
- **阅读推荐**：设置推荐书籍类型（最多3种）
- **读书会**：安排周期性读书活动
- **图书进货**：（待实装功能）
- **借阅历史记录**：查看所有角色的详细借阅历史

#### 核心类和函数
- `Manage_Library_Panel`：主面板类
  - `urge_return_book_list()`：显示已借出书籍列表
  - `return_book(chara_id)`：强制NPC还书
  - `read_recommend()`：推荐书籍类型管理
  - `reading_party()`：读书会日程管理
  - `borrowing_history()`：借阅历史记录查看主函数
  - `show_character_history(character_id)`：显示指定角色的详细借阅历史

- `SelectRecommendBookButton`：推荐书籍类型选择按钮类

#### 管理功能详解
```python
# 催还书：将NPC还书概率设为100%，强制在下次娱乐时间还书
character_data.entertainment.book_return_possibility += 100
character_data.entertainment.entertainment_type = [101] * len(character_data.entertainment.entertainment_type)

# 推荐管理：最多可设置3种推荐书籍类型
cache.rhodes_island.recommend_book_type_set  # 推荐书籍类型集合

# 读书会：在指定星期几安排读书活动
cache.rhodes_island.party_day_of_week[week_day] = 101  # 101为读书会活动ID
```

## 数据配置体系

### 1. CSV数据文件

#### Book.csv - 书籍主表
```csv
cid,name,type,difficulty,use,info
书本id,名字,类型,难度,特殊用途,介绍
```
- **cid**：书籍唯一ID
- **name**：书籍名称
- **type**：书籍类型ID（关联BookType.csv）
- **difficulty**：难度等级（1简单，2普通，3困难）
- **use**：特殊用途标识
- **info**：书籍详细介绍

#### BookType.csv - 书籍类型表
```csv
cid,father_type_name,son_type_name,exp_id,ability_id
书本类型id,书本大类,书本小类,对应经验id,对应能力id
```
- **father_type_name**：大类（技能、娱乐、色情）
- **son_type_name**：小类（具体技能分类）
- **exp_id**：对应的经验值ID
- **ability_id**：对应的能力ID（用于难度判断）

#### Book_Excerpt.csv - 书籍摘录表
```csv
cid,name,excerpt1,excerpt2,excerpt3,excerpt4,excerpt5
```
存储每本书的5个随机片段，用于阅读时展示内容。

### 2. 配置类定义 (config_def.py)

#### Book类
```python
class Book:
    cid: int          # 书本id
    name: str         # 名字
    type: int         # 类型
    difficulty: int   # 难度
    use: int          # 特殊用途
    info: str         # 介绍
```

#### BookType类
```python
class BookType:
    cid: int                  # 书本类型id
    father_type_name: str     # 书本大类
    son_type_name: str        # 书本小类
    exp_id: int              # 对应经验id
    ability_id: int          # 对应能力id
```

#### Book_Excerpt类
```python
class Book_Excerpt:
    cid: int          # 书本id
    name: str         # 名字
    excerpt1: str     # 内容节选1-5
    # ... excerpt2-5
```

### 3. 游戏缓存数据结构

#### 角色娱乐数据 (CHARA_ENTERTAINMENT)
```python
class CHARA_ENTERTAINMENT:
    entertainment_type: list = [0,0,0]              # 娱乐活动类型
    borrow_book_id_set: set = set()                 # 借的书的id集合
    book_return_possibility: int = 0                # 归还书籍的可能性
    read_book_progress: Dict[int, int] = {}         # 阅读进度记录
    borrow_book_history: List[Dict[str, any]] = []  # 借阅历史记录列表
```

#### 借阅历史记录数据结构
```python
# 每条借阅记录的字典结构
{
    'book_id': int,           # 书籍ID
    'book_name': str,         # 书籍名称
    'borrow_time': datetime,  # 借书时间
    'return_time': datetime,  # 还书时间（None表示仍在借阅中）
    'total_read_count': int   # 该次借阅期间的总阅读次数
}
```

#### 罗德岛图书馆数据
```python
# 在cache.rhodes_island中
now_show_book_cid_of_type: Dict[int, List]         # 各类型当前展示的书籍
book_borrow_dict: Dict[int, int]                   # 书籍借阅状态字典
recommend_book_type_set: Set[int]                  # 推荐书籍类型集合
party_day_of_week: List[int]                       # 每周活动安排
```

## 书籍类型体系

### 技能类书籍
提升角色专业能力，包含以下小类：
- **话术**（ability_id: 40, exp_id: 80）
- **指挥**（ability_id: 41, exp_id: 87）
- **战斗**（ability_id: 42, exp_id: 81）
- **料理**（ability_id: 43, exp_id: 83）
- **音乐**（ability_id: 44, exp_id: 85）
- **学识**（ability_id: 45, exp_id: 82）
- **医疗**（ability_id: 46, exp_id: 88）
- **农业**（ability_id: 47, exp_id: 89）
- **制造**（ability_id: 48, exp_id: 90）
- **绘画**（ability_id: 49, exp_id: 91）

### 娱乐类书籍
纯粹娱乐阅读，不提升能力，包含：
- 童话绘本、科幻小说、推理小说、武侠小说、仙侠小说等
- 言情小说、悬疑小说、历史小说、军事小说、诗歌等
- 无能力要求，任何人都可以阅读

### 色情类书籍
成人向内容，分为技巧类和题材类：
- **技巧类**：手交、口交、足交、乳交、本番、肛交、榨精（ability_id: 70-75, 30）
- **题材类**：纯爱、后宫、萝莉、强奸、逆强奸等（无能力要求）
- 所有色情书籍都提供经验ID 93（H书阅读经验）

## 系统交互流程

### 1. 借书流程
1. 玩家进入借书面板 → `Borrow_Book_Panel.draw()`
2. 系统调用 `settle_library_book()` 刷新可借书籍
3. 按分类显示书籍，每类最多3本
4. 玩家选择书籍 → `show_book(book_cid)`
5. 检查能力要求 → `can_read_book(character_id, book_cid)`
6. 执行借书操作 → `borrow(book_cid)`
7. 更新借书状态和角色数据
8. 自动记录借阅历史 → `add_borrow_history_record(character_id, book_id)`

### 2. 读书流程
1. 玩家进入读书面板 → `Read_Book_Panel.draw()`
2. 显示已借书籍和阅读进度
3. 选择书籍开始阅读 → `read(book_id)`
4. 设置读书行为和状态
5. 更新阅读次数记录 → `update_read_count_in_history(character_id, book_id)`
6. 调用 `update.game_update_flow(30)` 执行30分钟读书
7. 系统自动结算阅读进度和能力增长

### 3. NPC自动行为
1. 在每个行为循环中调用：
   - `check_return_book(character_id)` - 检查是否还书
   - `check_random_borrow_book(character_id)` - 检查是否借书
2. NPC根据推荐书籍类型优先选择
3. 能力不足的书籍无法借阅
4. 已读完的书籍不会重复借阅
5. 借书和还书时自动记录历史数据

### 4. 管理员功能
1. **催还书**：强制设置NPC还书概率为100%
2. **推荐管理**：设置最多3种推荐书籍类型，影响NPC借书偏好
3. **读书会**：安排特定星期几的集体读书活动
4. **借阅统计**：查看所有已借出书籍的归属情况
5. **借阅历史记录**：查看所有角色的详细借阅历史，包括借还时间、阅读次数等统计信息

## 能力与经验系统

### 1. 能力要求判断
- **技能类书籍**：
  - 难度2：需要对应能力≥3级
  - 难度3：需要对应能力≥6级
- **色情类书籍**：
  - 仅对NPC进行能力判断
  - 难度要求与技能类相同
- **娱乐类书籍**：无能力要求

### 2. 阅读收益
- 每次阅读增加书籍阅读进度
- 阅读进度达到100%时完成该书
- 根据书籍类型获得对应经验值
- 技能类书籍可提升相关能力等级

### 3. 阅读进度结算
```python
# 在Script/Settle/default.py中的结算逻辑
character_data.entertainment.read_book_progress.setdefault(book_id, 0)
if character_data.entertainment.read_book_progress[book_id] < 100:
    # 计算阅读进度增加
    old_progress = character_data.entertainment.read_book_progress[book_id]
    character_data.entertainment.read_book_progress[book_id] += read_progress
    
    # 阅读完成时设为100%
    if character_data.entertainment.read_book_progress[book_id] >= 100:
        character_data.entertainment.read_book_progress[book_id] = 100
```

## 代码依赖关系

### 1. 核心依赖模块
- `Script.Core.cache_control` - 游戏缓存管理
- `Script.Core.game_type` - 数据类型定义
- `Script.Core.flow_handle` - 界面流程控制
- `Script.Config.game_config` - 配置数据访问
- `Script.UI.Moudle.draw` - UI绘制组件
- `Script.Design.update` - 游戏更新机制
- `Script.Design.instuct_judege` - 指令判断系统
- `Script.Settle.default` - 行为结算系统

### 2. 数据流向
```
CSV文件 → buildconfig.py → JSON配置 → game_config.py → 面板代码
   ↓
角色数据 ← game_type.py ← cache_control.py ← 行为结算系统
```

### 3. 配置数据结构
```python
# 在game_config.py中的全局配置
config_book: Dict[int, config_def.Book] = {}                    # 书籍配表数据
config_book_type: Dict[int, config_def.BookType] = {}          # 书籍类型配表数据
config_book_type_data: Dict[int, Set] = {}                     # 书籍各类型下的id集合数据
config_book_excerpt_data: Dict[int, config_def.Book_Excerpt] = {}  # 书籍摘录数据
config_book_excerpt_list: Dict[int, List] = {}                 # 书籍摘录列表
```

### 4. 系统集成点
- **行为系统**：读书作为一种角色行为，集成到主行为循环
- **能力系统**：书籍阅读影响角色能力值和经验值
- **时间系统**：读书行为消耗游戏时间
- **AI系统**：NPC自动借书还书逻辑
- **结算系统**：读书行为的数值结算和效果应用
- **UI系统**：通过flow_handle处理用户交互
- **存档系统**：读书进度和借阅状态的持久化

## 特殊机制与设计亮点

### 1. 图书馆展示机制
- 每个书籍类型最多同时展示3本书
- 玩家已借的书会强制显示在列表中
- 通过随机选择保证内容的多样性

### 2. NPC智能借阅
- 基于推荐书籍类型的偏好系统
- 能力不足时自动过滤不可借书籍
- 已读完的书籍不会重复借阅
- 还书概率的动态调整机制

### 3. 阅读体验增强
- 随机书籍片段展示，增加沉浸感
- 阅读进度的可视化显示
- 根据角色学识能力调整阅读速度

### 4. 管理员工具
- 催还书功能，解决书籍流通问题
- 推荐系统，引导NPC技能发展方向
- 读书会活动，增加社交元素

## 口上文本集成

### 读书行为口上
- 文件位置：`data/talk/work/read_book.csv`
- 触发条件：`behavior_id = read_book`
- 前提条件：`high_1`
- 内容模板：`{Name}触发了读{BookName}指令的地文`

这个口上系统为读书行为提供了文本反馈，增强了游戏的叙事体验。

## 扩展建议

### 1. 功能增强
- 实装图书进货系统，允许购买新书籍
- 增加书评和评分功能，记录角色对书籍的评价
- 实现图书借阅历史记录，追踪阅读轨迹
- 增加图书收藏功能，收藏喜爱的书籍

### 2. 性能优化
- 缓存书籍推荐列表，减少重复计算
- 优化大量书籍时的显示性能
- 减少重复的能力检查计算
- 实现书籍数据的延迟加载

### 3. 用户体验
- 增加书籍搜索和筛选功能
- 提供个性化推荐算法
- 增加阅读成就和奖励系统
- 实现读书笔记和心得分享
- 添加阅读时间统计功能

### 4. 内容扩展
- 增加季节性特殊书籍
- 实现系列书籍和续集机制
- 添加稀有书籍和限定书籍
- 扩展书籍内容的动态生成

## 新增功能：借阅历史记录系统

### 1. 功能概述
借阅历史记录系统是读书系统的重要增强功能，为游戏提供了完整的图书借阅数据追踪和统计分析能力。

### 2. 核心功能特性
- **完整的借阅记录**：记录每次借书的完整生命周期（借书时间、还书时间、阅读次数）
- **实时阅读追踪**：每次阅读行为都会自动更新对应借阅记录的阅读次数
- **历史数据查看**：管理员可以查看任意角色的完整借阅历史
- **统计信息展示**：提供借阅总数、阅读总次数等统计数据

### 3. 数据持久化
借阅历史数据保存在角色的娱乐数据中（`character_data.entertainment.borrow_book_history`），随存档文件一起保存，确保数据不会丢失。

### 4. 管理功能
- 通过图书馆管理面板的"[005]借阅历史记录"选项访问
- 显示所有有借阅历史的角色列表
- 支持查看单个角色的详细借阅记录
- 包含借书时间、还书时间、阅读次数等详细信息

### 5. 自动化集成
- 借书时自动创建新的历史记录
- 还书时自动更新记录的还书时间
- 阅读时自动增加对应记录的阅读次数
- 无需玩家手动操作，系统完全自动化管理

## 总结

读书系统是erArk游戏中一个功能完整、设计优良的子系统。它通过三个面板提供了完整的图书管理体验，包含数据配置、界面展示、行为逻辑、AI自动化等多个层面。系统设计遵循了良好的分层架构，数据与逻辑分离，便于维护和扩展。

该系统的设计亮点包括：
1. **完整的借阅管理**：从借书到还书的全流程管理，包含详细的历史记录追踪
2. **智能的NPC行为**：基于能力和偏好的自动借阅
3. **丰富的书籍体系**：技能、娱乐、色情三大类别的细致分工
4. **灵活的推荐机制**：可调节的NPC学习方向引导
5. **良好的用户体验**：直观的界面和详细的进度显示
6. **数据统计分析**：借阅历史记录系统提供完整的数据追踪和分析功能

通过CSV配置文件，可以灵活地添加新书籍和调整系统参数，为游戏内容的丰富提供了良好的基础。借阅历史记录系统的加入进一步增强了系统的完整性，为玩家和管理员提供了更好的数据可视化和分析能力。整个系统与游戏的行为系统、能力系统、时间系统等紧密集成，是游戏核心玩法的重要组成部分。