# 角色图片系统说明

## 系统概述

角色图片系统是erArk游戏中负责动态显示角色立绘的核心模块，支持基于角色状态的差分图片显示。该系统包含图片加载、状态判断、差分组合、显示面板等多个子系统。

## 核心组件架构

### 1. 图片管理核心 (`Script/Core/era_image.py`)

#### 功能描述
- 负责游戏启动时加载所有图片资源
- 提供图片数据的全局访问接口
- 支持差分图片的索引和管理

#### 核心数据结构
```python
image_data = {}                    # 图片数据字典，键为图片名，值为PhotoImage对象
image_path_data = {}              # 图片路径数据字典
image_data_index_by_chara = {}    # 按角色名索引的差分图片字典
```

#### 关键功能
- `load_images_from_directory()`: 递归加载指定目录下的所有PNG图片
- 自动缩放图片以适应字体大小
- 差分图片索引：通过`_`分隔符识别差分图片并建立索引

### 2. 角色图片决策引擎 (`Script/Design/character_image.py`)

#### 核心函数：`find_character_image_name(character_id: int) -> str`

该函数是整个系统的核心，负责根据角色当前状态决定显示哪张图片。

#### 决策流程

1. **特殊角色处理**
   - 女儿角色（`father_id == 0`）：优先使用角色同名图片，其次使用母亲的萝莉图片
   - 正常干员角色：使用角色本名作为基础图片名

2. **状态差分计算**
   ```python
   # 差分优先级：萝莉 > 裸体 > 胸部 > 膨腹 > 心情
   diff_list = [child_diff, naked_diff, chest_diff, big_belly_diff, emotion_diff]
   ```

3. **候选图片生成**
   - 构造所有可能的差分组合
   - 按优先级递减生成候选列表
   - 支持全裸/半裸状态的自动降级

4. **图片匹配策略**
   - 优先匹配完全符合的差分组合
   - 逐级降低差分要求直到匹配成功
   - 最终回退到基础立绘

#### 状态判断函数

- `child_judge()`: 判断萝莉状态（`_小`后缀）
- `naked_judge()`: 判断裸体状态（`_全裸`/`_半裸`后缀）
- `chest_judge()`: 判断胸部大小（`_绝壁`/`_贫乳`/`_普乳`/`_巨乳`/`_爆乳`后缀）
- `big_belly_judge()`: 判断膨腹状态（`_膨腹`/`_大膨腹`后缀）
- `emotion_judge()`: 判断心情状态（`_愉快`/`_不爽`/`_愤怒`后缀）

### 3. 图片显示界面 (`Script/UI/Panel/chara_image_list_panel.py`)

#### 主要类

##### `CharacterImageListDraw`
负责绘制角色图片列表界面的主要类。

**功能特性：**
- 优先显示当前交互对象
- 支持大于10人的分页显示
- H状态下支持腔内透视图显示
- 响应式布局设计

**关键方法：**
- `draw()`: 主要绘制逻辑
- `next_page()`: 分页控制

##### `CharacterImageButton`
单个角色图片按钮的绘制类。

**功能特性：**
- 调用`character_image.find_character_image_name()`获取正确图片
- 支持点击切换交互对象
- 自动显示角色名称作为按钮标识

### 4. 断面图系统 (`Script/Design/cross_section_image.py`)

#### 功能描述
在H状态且开启腔内透视时显示的特殊图片系统。

#### 状态判断优先级
1. 精液量状态（精液多/中/少）
2. 怀孕状态（受精/妊娠/临盆）
3. 生理期状态（排卵期/危险期）
4. 默认标准状态

## 数据依赖关系

### 1. 角色数据 (`data/character/*.csv`)

每个角色的CSV文件包含基础信息：
- 姓名、性别、职业、种族等基础属性
- 初始数值和状态
- 关系数据（父母子女关系）

### 2. 前提系统 (`Script/Design/handle_premise.py`)

图片系统大量依赖前提系统来判断角色状态：
- 身体状态前提（裸体、胸部大小等）
- 生理状态前提（怀孕、膨腹等）
- 心情状态前提（愉快、愤怒等）
- 特殊状态前提（萝莉、H状态等）

### 3. 图片资源 (`image/` 目录)

图片命名规范：
```
基础名_差分1_差分2_差分N.png
例如：阿米娅_半裸_普乳_愉快.png
```

## 系统交互流程

### 1. 游戏启动阶段
1. `era_image.load_images_from_directory()`加载所有图片
2. 建立差分图片索引
3. 缓存图片数据供后续使用

### 2. 界面绘制阶段
1. `in_scene_panel.py`调用`chara_image_list_panel.CharacterImageListDraw`
2. 为每个角色创建`CharacterImageButton`
3. 调用`character_image.find_character_image_name()`获取合适图片
4. 绘制图片按钮和相关界面元素

### 3. 状态变化阶段
1. 角色状态发生变化（如脱衣、心情变化等）
2. 下次界面刷新时重新调用图片决策引擎
3. 根据新状态显示对应的差分图片

## 性能优化策略

### 1. 图片预加载
- 游戏启动时一次性加载所有图片
- 避免运行时的IO操作延迟

### 2. 索引优化
- 使用`image_data_index_by_chara`快速查找角色相关图片
- 减少遍历整个图片库的开销

### 3. 缓存机制
- 图片对象在内存中持久化
- 避免重复的图片处理操作

## 扩展性设计

### 1. 差分系统扩展
- 新增差分类型只需在`character_image.py`中添加对应的判断函数
- 修改`diff_list`的组合顺序即可调整优先级

### 2. 图片格式扩展
- 修改`era_image.py`中的文件扩展名过滤即可支持新格式
- 需确保PIL库支持该格式

### 3. 显示界面扩展
- 通过继承或修改现有Panel类实现新的显示方式
- 保持与图片决策引擎的接口一致性

## 开发维护注意事项

### 1. 图片命名规范
- 严格遵循`基础名_差分`的命名格式
- 差分后缀必须与代码中的判断逻辑保持一致

### 2. 状态前提维护
- 新增角色状态时需同步更新前提系统
- 确保前提函数的返回值准确性

### 3. 性能监控
- 大量角色同时显示时可能出现性能问题
- 考虑实现更精细的分页或延迟加载机制

### 4. 内存管理
- 图片对象会占用大量内存
- 在角色数量极多时考虑实现图片的动态加载/卸载

## 相关代码文件关系图

```
era_image.py (图片加载核心)
    ↓ 提供图片数据
character_image.py (图片决策引擎)
    ↓ 提供图片名称
chara_image_list_panel.py (显示界面)
    ↓ 被调用显示
in_scene_panel.py (主界面)
    ↓ 依赖状态判断
handle_premise.py (前提系统)
    ↓ 依赖角色数据
character/*.csv (角色基础数据)
```

这个系统展示了erArk中复杂的数据流和组件协作模式，是游戏视觉表现的核心基础设施之一。