# 装备维护系统

## 系统概述

装备维护系统是erArk游戏中负责管理角色装备状态、维修损坏装备以及保养装备的重要系统。该系统通过铁匠角色执行装备的维修和保养工作，确保外勤委托中的装备处于良好状态。

## 核心组件

### 主要文件

- **`Script/UI/Panel/equipmen_panel.py`** - 装备维护界面和核心逻辑
- **`Script/Core/game_type.py`** - 装备状态数据结构定义
- **`Script/Design/handle_premise_cloth.py`** - 装备状态相关前提条件判断
- **`data/csv/Equipment_Condition.csv`** - 装备状态等级配置
- **`data/csv/Equipment_Damage_Rate.csv`** - 外勤委托装备损坏概率配置
- **`data/csv/Equipment_Maintain_Setting.csv`** - 装备维护策略配置

### 数据结构

#### 装备状态 (equipment_condition)
```python
# 在 Character.cloth 中定义
self.equipment_condition: float = 0
```

装备状态数值对应关系：
- `-3`: 严重损坏
- `-2`: 中度损坏  
- `-1`: 轻微损坏
- `0`: 正常状态
- `1`: 良好保养
- `2`: 完美保养

#### 罗德岛装备维护数据
```python
# 在 Rhodes_Island 中定义
self.equipment_maintain_setting: Dict[int, Tuple[int]] = {}
""" 装备维护设置 设置id:设置值 """

self.equipment_maintain_operator_ids: List[int] = []
""" 手动选择的装备维护对象干员id列表 """

self.maintenance_equipment_chara_id: Dict[int, int] = {}
""" 当前每个角色正在维护中的装备的所属角色id，角色id:角色id """
```

## 主要功能

### 1. 装备状态查询

#### `get_equipment_condition_name(value: float) -> str`
根据装备condition的float值查找对应的装备状态名称。

#### `show_damaged_equipment()`
显示所有装备损坏（equipment_condition < 0）的干员及其装备情况。

#### `show_maintained_equipment()`
显示所有装备保养（equipment_condition > 0）的干员及其装备情况。

### 2. 外勤委托装备损坏

#### `settle_equipment_damage_in_commission(commision_id: int) -> str`
结算外勤委托中装备的损坏：
- 根据委托等级获取损坏概率表
- 对每个派遣人员进行随机损坏判定
- 设置装备损坏等级并返回损坏信息

损坏概率配置示例：
```csv
委托等级,不损坏概率,状况-1概率,状况-2概率,状况-3概率,状况-4概率
1,0.5,0.4,0.1,0,0
2,0.4,0.4,0.2,0,0
3,0.3,0.3,0.3,0.1,0
```

### 3. 装备维修系统

#### `repair_equipment(smith_chara_id: int, target_chara_id: int = 0) -> str`
铁匠角色进行装备维修：
- 基于铁匠的制造技能（ability[48]）计算维修效果
- 维修值 = `attr_calculation.get_ability_adjust(ability_lv) / 2 * random(0.8, 1.2)`
- 支持优先度设置（优先低损坏度/高损坏度）
- 维修后装备状态最大恢复到0（正常状态）

#### `maintain_equipment(smith_chara_id: int, target_chara_id: int = 0) -> str`
铁匠角色进行装备保养：
- 保养值 = `attr_calculation.get_ability_adjust(ability_lv) / 4 * random(0.8, 1.2)`
- 根据设置可保养到良好（1）或完美（2）状态
- 支持全体干员或指定目标保养

#### `smith_maintain_equipment_once(smith_chara_id: int, draw_flag: bool = True) -> str`
铁匠执行一次完整的装备维护流程：
- 检查是否有正在维修中的装备
- 根据设置优先进行维修或保养
- 自动选择维修/保养目标
- 记录维修状态以支持连续维修

### 4. 维护策略配置

#### 维护设置选项
```csv
选项id,选项名,选项介绍,各个选项
0,装备维修优先度,维修时优先选择损坏程度高还是低的装备,优先低损坏度|优先高损坏度
1,是否进行装备保养,除维修之外是否对装备进行保养,不保养|保养到良好|保养到完美
2,装备保养对象,选择需要保养装备的干员范围,全部干员|仅保养指定目标装备
3,是否要优先保养,是否优先对装备进行保养而不是维修,优先维修|优先保养
```

## UI界面系统

### Equipment_Maintain_Panel 类
主要的装备维护界面类，提供以下功能：

1. **主界面选项**：
   - 指定维护策略
   - 变更铁匠人数
   - 干员装备损坏情况一览
   - 干员装备保养情况一览

2. **策略配置界面** (`select_maintain_strategy`):
   - 动态显示所有维护设置选项
   - 支持点击选项标题查看说明
   - 支持循环切换选项值

3. **目标名单管理** (`adjust_target_list`):
   - 使用通用NPC选择面板
   - 支持添加/移除保养目标干员
   - 排除异常状态角色

## 技术实现

### 能力计算
装备维护效果基于角色的制造技能（ability[48]）：
```python
ability_lv = smith_chara_data.ability[48]
maintain_value = attr_calculation.get_ability_adjust(ability_lv) / 2  # 维修
maintain_value = attr_calculation.get_ability_adjust(ability_lv) / 4  # 保养
```

### 状态持久化
- 维修中的角色记录在 `cache.rhodes_island.maintenance_equipment_chara_id`
- 设置选项保存在 `cache.rhodes_island.equipment_maintain_setting`
- 指定目标列表保存在 `cache.rhodes_island.equipment_maintain_operator_ids`

### 前提条件系统
装备状态相关的前提条件判断：
- `TARGET_EQUIPMENT_DAMAGED_GE_2`: 装备损坏程度>=2
- `TARGET_EQUIPMENT_DAMAGED_GE_3`: 装备损坏程度>=3  
- `TARGET_EQUIPMENT_MAINTANCE_GE_2`: 装备保养程度>=2

## 游戏机制集成

### 与外勤委托系统的关系
- 中度损坏的装备降低外勤干员能力值
- 严重损坏的装备无法安排进行外勤委托
- 完美保养的装备为外勤干员提供额外能力加成

### 与工作系统的关系
- 需要铁匠职业的角色执行维护工作
- 通过 `handle_premise.handle_work_is_blacksmith()` 判断角色职业
- 支持多个铁匠同时工作

### 自动化程度
- 支持全自动维修保养（基于设置优先级）
- 支持指定目标的精确控制
- 维修状态记录确保连续性工作

## 配置文件说明

### Equipment_Condition.csv
定义装备状态等级和对应数值：
```csv
cid,name,value
0,严重损坏,-3
1,中度损坏,-2
2,轻微损坏,-1
3,正常状态,0
4,良好保养,1
5,完美保养,2
```

### Equipment_Damage_Rate.csv  
定义不同委托等级的装备损坏概率分布，等级越高损坏概率越大。

### Equipment_Maintain_Setting.csv
定义装备维护的各种策略选项，支持灵活的维护策略配置。

## 扩展性设计

该系统设计具有良好的扩展性：
- 支持新增维护设置选项
- 支持调整损坏概率和维修效果
- 可扩展更多装备状态等级
- 维护逻辑与UI分离，便于系统集成

装备维护系统为游戏的外勤委托提供了重要的支撑，确保角色装备始终处于最佳状态，是游戏管理系统中的关键组成部分。