# 能力升级面板系统说明

## 概述

`ability_up_panel.py` 是 erArk 游戏中角色能力升级系统的核心 UI 面板。该文件实现了角色能力查看、升级、刻印管理等复杂功能，是游戏角色成长系统的重要组成部分。

## 系统架构

### 核心类结构

#### 1. `Characterabi_show_Text` - 能力显示面板
**功能**: 显示角色的所有能力类型及当前等级，提供交互式能力升级入口

**主要方法**:
- `draw()`: 绘制能力列表，按类型分组显示
- `mark_up_show()`: 显示刻印升级界面
- `mark_down_show()`: 显示刻印降级界面
- `mark_up()`: 执行刻印升级操作
- `mark_down()`: 执行刻印降级操作

#### 2. `Characterabi_cmd_Text` - 能力升级指令面板
**功能**: 显示特定能力的升级需求和执行升级操作

**主要方法**:
- `draw()`: 显示升级需求详情
- `level_up()`: 执行能力等级提升

#### 3. `Character_abi_up_main_Handle` - 主面板控制器
**功能**: 管理整个能力升级界面的流程控制

#### 4. `Character_abi_up_sub_Handle` - 子面板控制器
**功能**: 处理不同属性页面之间的切换

#### 5. `Character_abi_up_main_panel` - 主显示面板
**功能**: 组合各个组件，显示角色信息、宝珠、经验、能力等

## 数据结构与文件关系

### CSV 数据文件

#### 1. **Ability.csv** - 能力定义
```csv
cid,ability_type,name
能力id,类型(0:感度,1:扩张,2:刻印,3:基础,4:技能,5:性技),名字
```

**能力类型分类**:
- **0**: 感度 (皮肤感度、胸部感度、阴蒂感度等)
- **1**: 扩张 (阴道扩张、肛肠扩张、尿道扩张等)
- **2**: 刻印 (快乐刻印、屈服刻印、苦痛刻印等)
- **3**: 基础 (体力、意志、智力等基础属性)
- **4**: 技能 (料理、清洁、园艺等生活技能)
- **5**: 性技 (指技、舌技、腰技等亲密技巧)

#### 2. **AbilityUp.csv** - 能力升级需求
```csv
cid,ability_id,now_level,up_need
编号id,能力id,当前等级,升级需求
```

**升级需求格式**:
- `J0|125`: 需要0号宝珠125个
- `E0|5`: 需要0号经验5点
- `A30|3`: 需要30号能力达到3级
- 多个需求用`&`连接: `J0|125&E0|5&E10|1`

#### 3. **Mark_Up.csv** - 刻印升级数据  
```csv
cid,ability_id,now_level,second_behavior,need_state_all_value,need_state_1,need_state_2,need_state_3,need_state_4,need_juel_type
```

**字段说明**:
- `second_behavior`: 升级后获得的二段行为ID
- `need_state_all_value`: 升级需要的总状态值
- `need_state_1-4`: 具体的状态需求，支持权重调整(如 `16|0.2`)
- `need_juel_type`: 可用宝珠类型

#### 4. **Mark_Down.csv** - 刻印降级数据
用于降低负面刻印等级，需要消耗特定宝珠组合

#### 5. **Juel.csv** - 宝珠定义
```csv  
cid,name
珠id,珠名
```

**宝珠类型**:
- 感受类: 皮肤快感珠、胸部快感珠等
- 状态类: 润滑珠、习得珠、恭顺珠等
- 刻印类: 快乐珠、屈服珠、苦痛珠等

### 配置加载系统

#### `game_config.py` 中的相关配置
- `config_ability`: 能力数据字典
- `config_ability_type_data`: 按类型分组的能力列表
- `config_ability_up_data`: 能力升级需求数据
- `config_mark_up_data`: 刻印升级数据
- `config_mark_up_data_by_ability`: 按能力ID索引的刻印升级数据
- `config_juel`: 宝珠数据字典

## 核心业务流程

### 1. 普通能力升级流程

```python
# 1. 显示能力列表 (Characterabi_show_Text.draw)
for anility_type in ability_list:
    for ability_id in type_set:
        # 显示能力名称、等级、经验值
        button_text = name + grade + value
        
# 2. 点击能力进入升级界面 (Characterabi_cmd_Text.draw)
need_list = game_config.config_ability_up_data[ability_id][level]
# 检查升级需求
for need_text in need_list:
    need_type = need_text.split('|')[0][0]  # J=宝珠, E=经验, A=能力  
    need_type_id = int(need_text.split('|')[0][1:])
    need_value = int(need_text.split('|')[1])
    
# 3. 满足条件时执行升级 (level_up)
for juel_id in jule_dict:
    character_data.juel[juel_id] -= required_amount
character_data.ability[ability_id] += 1
```

### 2. 刻印系统特殊处理

#### 刻印升级流程
```python  
# 1. 计算状态需求
now_state_value, state_text = settle_behavior.get_now_state_all_value_and_text_from_mark_up_data(
    mark_up_data_id, character_id
)

# 2. 计算宝珠需求
need_juel = max(need_state_all_value - now_state_value, 0)

# 3. 执行升级
character_data.juel[juel_type_id] -= need_juel
character_data.ability[ability_id] += 1
character_data.second_behavior[second_behavior_id] = 1

# 4. 触发二段行为效果
settle_behavior.second_behavior_effect(character_id, CharacterStatusChange(), [second_behavior_id])
```

#### 刻印降级流程 
```python
# 1. 支持多种宝珠组合
juel_type_id_list = [need_juel_1, need_juel_2, need_juel_3]

# 2. 特殊处理: 如果有快感珠类型'1'，替换为所有快感珠
if '1' in juel_type_id_list:
    juel_type_id_list.remove('1')
    for state_id in game_config.config_character_state:
        if game_config.config_character_state[state_id].type == 0:
            juel_type_id_list.append(str(state_id))

# 3. 关押区设施影响降级成本
if handle_premise.handle_imprisonment_1(character_id):
    need_juel_all_value = int(need_juel_all_value * (1 - facility_effect / 100))
```

### 3. 特殊能力处理

#### 技巧能力(ID=30)的额外要求
```python
if ability_id == 30:
    if character_id == 0:  # 玩家(博士)
        # 需要[指技]、[舌技]、[腰技]、[隐蔽]等级和 >= 技巧等级*2
        required_sum = now_ability_level * 2
    else:  # NPC(干员)  
        # 需要全部性技等级和 >= 技巧等级*3
        required_sum = now_ability_level * 3
```

## 与其他系统的交互

### 1. 结算系统 (`settle_behavior.py`)
- `get_now_state_all_value_and_text_from_mark_up_data()`: 计算刻印升级的状态需求
- `second_behavior_effect()`: 处理刻印升级后的二段行为效果

### 2. 属性计算系统 (`attr_calculation.py`)  
- `judge_grade()`: 将数值能力等级转换为字母等级显示
  - 0以下: G, 1: F, 2: E, 3: D, 4: C, 5: B, 6: A, 7: S, 8以上: EX

### 3. 角色信息面板 (`see_character_info_panel.py`)
- `CharacterInfoHead`: 角色基础信息显示
- `CharacterJuelText`: 宝珠信息显示  
- `CharacterExperienceText`: 经验信息显示

### 4. 素质系统 (`talent_up_panel.py`)
- `Character_talent_show_Text`: 素质升级面板，与能力面板并列显示

## 用户界面设计

### 1. 显示布局
```
角色信息头部
宝珠信息
经验信息
┌─────────────────────────────────┐
│ 能力:                           │
│ [感度类能力] [等级] [数值]       │  
│ [扩张类能力] [等级] [数值]       │
│ [刻印类能力] [等级] [数值]       │
│ [基础类能力] [等级] [数值]       │
│ [技能类能力] [等级] [数值]       │
│ [性技类能力] [等级] [数值]       │
└─────────────────────────────────┘
素质信息 (仅NPC)
[属性升级] 页面切换按钮
[返回]
```

### 2. 交互逻辑
- **左键点击能力**: 进入该能力的升级界面
- **刻印特殊处理**: 
  - 绿色按钮: 可升级的刻印
  - 灰色按钮: 无法升级的刻印  
  - 支持升级和降级两种操作

### 3. 性别过滤机制
```python
# 去掉与性别不符的感度与扩张
if character_data.sex == 0:  # 男性
    if ability_id in {2, 4, 7, 9, 12, 73, 74}:  # 女性专有能力
        continue
elif character_data.sex == 1:  # 女性
    if ability_id == 3:  # 男性专有能力  
        continue
```

## 数据流转图

```
CSV数据文件 → buildconfig.py → game_config.py → ability_up_panel.py
     ↓              ↓               ↓                ↓
Ability.csv → config_ability → 能力定义 → 界面显示
AbilityUp.csv → config_ability_up_data → 升级需求 → 需求检查
Mark_Up.csv → config_mark_up_data → 刻印升级 → 特殊处理
Juel.csv → config_juel → 宝珠信息 → 消耗计算
```

## 调试和开发注意事项

### 1. Debug模式支持
```python
# debug模式下无需判断升级条件
if cache.debug_mode:
    judge = 1
```

### 2. 数据完整性检查
- 能力ID必须在配置文件中存在
- 升级需求格式必须正确
- 刻印升级数据必须完整

### 3. 扩展性考虑
- 能力类型可以通过修改CSV文件扩展
- 升级需求支持多种类型组合
- 刻印系统支持复杂的状态计算

### 4. 性能优化
- 使用字典索引提高查找效率
- 避免重复计算相同数据
- 合理使用缓存减少文件读取

## 总结

能力升级面板系统是 erArk 游戏中最复杂的 UI 系统之一，它整合了：
- **数据驱动**: 通过CSV文件定义游戏内容
- **复杂业务逻辑**: 支持多种升级需求类型和特殊规则
- **用户体验**: 提供直观的等级显示和交互界面
- **系统集成**: 与结算、属性计算、角色信息等多个系统协作

该系统的设计体现了良好的模块化思想，通过清晰的类职责划分和数据结构设计，实现了功能强大且易于维护的角色成长系统。