# 群交系统

## 系统概述

群交系统是erArk游戏中的复杂多人性交互系统，允许玩家与多个NPC同时进行性交互。该系统通过模板化的方式管理不同身体部位的交互关系，支持动态的参与者管理和AI行为控制。

## 核心文件结构

### 主要文件
- **主面板文件**: `Script/UI/Panel/group_sex_panel.py`
- **数据类型定义**: `Script/Core/game_type.py` (BODY_H_STATE类)
- **配置管理**: `Script/Config/game_config.py`
- **前提判断**: `Script/Design/handle_premise.py`
- **对话数据**: `data/talk/sex/start_or_end/` 目录下的相关CSV文件

### 相关CSV数据文件
- `group_sex_end.csv` - 群交结束时的口上文本
- `hidden_sex_to_group_sex.csv` - 隐奸转群交的文本
- `group_sex_to_h.csv` - 群交转普通H的文本
- `group_sex_pl_hp_0_end.csv` - 玩家HP为0时群交结束文本
- `group_sex_npc_hp_0_end.csv` - NPC HP为0时群交结束文本
- `join_group_sex.csv` - 加入群交时的文本

## 数据结构设计

### 群交模板数据结构 (group_sex_body_template_dict)

位于`BODY_H_STATE`类中，结构如下：

```python
group_sex_body_template_dict: dict = {
    "A": [
        {
            "mouth": [-1, -1],      # 嘴部：[交互对象id, 指令状态id]
            "L_hand": [-1, -1],     # 左手：[交互对象id, 指令状态id]
            "R_hand": [-1, -1],     # 右手：[交互对象id, 指令状态id]
            "penis": [-1, -1],      # 阴茎：[交互对象id, 指令状态id]
            "anal": [-1, -1],       # 肛门：[交互对象id, 指令状态id]
        },
        [[-1], -1],                 # 阴茎侍奉：[交互对象id列表, 指令状态id]
    ],
    "B": [                          # 副模板，结构与A相同
        # ... 相同结构
    ],
}
```

### 关键属性说明

- **模板A和B**: 支持双模板切换，可以设置两套不同的群交配置
- **对单部位**: mouth、L_hand、R_hand、penis、anal，每个部位对应一个交互对象
- **阴茎侍奉**: 特殊的多对一交互模式，最多支持4个角色同时侍奉
- **插入与侍奉互斥**: 阴茎插入和阴茎侍奉不能同时进行
- **数值含义**: 
  - `-1` 表示未选择
  - `交互对象id` 为角色的唯一标识符
  - `指令状态id` 对应具体的性交动作

### 其他相关状态

```python
# 群交控制标志
group_sex_lock_flag: bool = False           # 模板锁定标记
all_group_sex_temple_run: bool = False      # 是否启用双模板
npc_ai_type_in_group_sex: int = 0          # NPC AI行为类型
```

## 核心功能模块

### 1. 群交结算函数 (group_sex_settle)

**功能**: 根据玩家的行为自动更新群交模板
**位置**: `group_sex_panel.py:37-96`

**处理逻辑**:
- 检查是否为群交模式和有效的交互
- 根据行为类型分类处理：
  - **插入类**: 更新penis部位，清空侍奉
  - **侍奉类**: 更新侍奉列表，清空penis
  - **口类**: 更新mouth部位
  - **手类**: 智能分配左右手，支持替换逻辑
  - **肛类**: 更新anal部位
- 特殊指令处理（如六九式）

### 2. 模板统计函数

#### count_group_sex_instruct_list()
- **功能**: 统计当前群交模板中的所有指令
- **返回**: 去重的指令ID列表和完整的目标-指令对应关系

#### count_group_sex_character_list()
- **功能**: 统计当前群交模板中的所有参与角色
- **返回**: 去重的角色ID列表

#### get_now_template_part_list()
- **功能**: 分析当前模板的空缺和占用情况
- **返回**: 空缺部位列表和非空缺部位列表

### 3. 指令过滤函数 (get_status_id_list_from_group_sex_body_part)

**功能**: 根据身体部位获取可用的指令列表
**处理逻辑**:
- 根据部位类型映射到对应的行为分类
- 使用指令面板的过滤逻辑检查可用性
- 特殊处理破处判定（处女检查）
- 返回经过筛选的可用指令ID列表

## UI界面系统

### 1. 群交信息显示面板 (SeeGroupSexInfoPanel)

**功能**: 显示当前群交状态的只读面板
**显示内容**:
- 各部位的交互对象和动作
- 侍奉模式的参与者信息
- 格式化的状态描述文本

### 2. 群交编辑面板 (Edit_Group_Sex_Temple_Panel)

**主要功能**:
- **角色选择**: 为每个部位选择交互对象
- **指令选择**: 为每个部位选择具体动作
- **模板管理**: 
  - 重置当前模板
  - 启用/禁用副模板B
  - 切换A/B模板
  - 锁定/解锁模板
- **AI控制**: 设置未在模板中的NPC行为逻辑
- **角色邀请**: 邀请不在场的角色参与群交

#### NPC AI行为类型
- **类型0**: 无行动
- **类型1**: 仅自慰
- **类型2**: 优先自动补位，无位则自慰  
- **类型3**: 每次指令都重置位置后随机抢位

## 配置系统

### 行为分类配置 (config_behavior_id_list_of_group_sex_body_part)

**位置**: `Script/Config/game_config.py:245`
**结构**: `Dict[str, list]` - 按身体部位分类的行为ID列表

**分类标签**:
- `"插入"` - 插入类动作
- `"侍奉"` - 侍奉类动作  
- `"口"` - 口部动作
- `"手"` - 手部动作
- `"肛"` - 肛门动作
- `"道具"` - 道具相关动作

**数据来源**: 从behavior配置的tag字段解析生成

### 前提判断函数

**相关函数** (位于`handle_premise.py`):
- `handle_group_sex_mode_on/off` - 群交模式开关判断
- `handle_all_group_sex_temple_run_on/off` - 双模板启用判断
- `handle_npc_ai_type_*_in_group_sex` - NPC AI类型判断
- `handle_*_group_sex_temple` - 模板数量判断
- `handle_self_*_go_to_join_group_sex` - 角色参与状态判断

## 交互流程设计

### 1. 群交启动流程
1. 进入群交模式 (`cache.group_sex_mode = True`)
2. 初始化群交模板 (默认为全部-1状态)
3. 玩家选择第一个交互对象和动作
4. 系统自动调用`group_sex_settle`更新模板

### 2. 模板编辑流程
1. 打开编辑面板 (`Edit_Group_Sex_Temple_Panel`)
2. 选择身体部位和交互对象
3. 选择对应的动作指令
4. 系统验证配置合法性
5. 保存模板配置

### 3. 角色邀请流程
1. 检查角色是否在场
2. 判断角色的实行值是否足够
3. 设置角色的`go_to_join_group_sex`标志
4. 触发角色移动到当前位置
5. 角色加入群交场景

### 4. 双模板切换流程
1. 启用副模板B
2. 配置B模板的角色和动作
3. 使用切换功能在A/B模板间切换
4. 支持轮流使用两套模板的指令

## 数据验证与约束

### 1. 互斥约束
- **插入与侍奉互斥**: penis插入时自动清空侍奉，反之亦然
- **角色唯一性**: 同一角色不能同时占用多个部位
- **侍奉人数限制**: 最多4人同时侍奉

### 2. 完整性检查
- 角色ID和指令ID必须同时存在或同时为空
- 退出编辑时自动重置不完整的配置项
- 破处判定确保处女角色不会被分配破处动作

### 3. 状态一致性
- 模板锁定时禁止自动调整
- AI类型控制未在模板中的NPC行为
- 角色邀请状态与实际位置同步

## 系统集成点

### 1. 与主行为循环的集成
- 在`character_behavior.py`中被调用
- 每次玩家执行H指令时触发群交结算
- 与角色状态机系统协同工作

### 2. 与指令系统的集成
- 使用`see_instruct_panel`的过滤逻辑
- 依赖`constant.behavior_id_to_instruct_id`映射
- 与前提判断系统紧密结合

### 3. 与AI系统的集成
- NPC AI根据群交模板调整行为
- 支持自动补位和位置竞争
- 与角色移动系统协调

### 4. 与对话系统的集成
- 群交开始/结束时触发特定口上
- 支持多角色参与的文本生成
- 与事件系统联动

## 性能优化考虑

### 1. 数据缓存
- 群交角色列表按需计算并缓存
- 可用指令列表根据前提条件动态生成
- 模板状态变更时及时更新相关缓存

### 2. UI响应性
- 使用分页显示大量角色列表
- 按钮状态根据选择情况动态更新
- 避免不必要的全量重绘

### 3. 逻辑简化
- 模板数据结构设计便于快速查找和更新
- 使用字典和集合进行高效的成员检查
- 前提判断函数尽量保持轻量级

## 扩展性设计

### 1. 模板系统扩展
- 支持添加更多模板类型（当前为A/B）
- 部位类型可以通过配置扩展
- 交互规则通过配置文件定义

### 2. AI行为扩展  
- NPC AI类型通过枚举方式易于扩展
- 行为逻辑与具体实现解耦
- 支持复杂的多步骤AI策略

### 3. UI界面扩展
- 面板系统采用组件化设计
- 绘制逻辑与业务逻辑分离
- 支持Web和桌面双渲染模式

这个群交系统展现了复杂的多对象交互管理、灵活的模板配置机制，以及与游戏其他系统的深度集成，是erArk游戏中最复杂的交互系统之一。