# 系统设置系统

## 系统概述

系统设置系统是erArk游戏中负责管理用户界面设置、游戏难度调整、基础功能开关等配置项的核心系统。该系统通过CSV数据驱动，提供统一的设置界面，支持运行时动态调整，并具备存档持久化功能。

## 核心组件

### 1. 数据定义与配置

#### CSV数据源
- **文件路径**: `data/csv/System_Setting.csv`
- **数据结构**:
  - `cid`: 选项ID (整数)
  - `type`: 选项类型 (`base`基础设置 | `draw`绘制设置 | `difficulty`难度设置)
  - `name`: 选项名称
  - `info`: 选项详细说明
  - `option`: 可选值列表 (用`|`分隔)

#### 配置定义类
- **文件路径**: `Script/Config/config_def.py`
- **类名**: `System_Setting`
- **属性**:
  - `cid`: 选项ID
  - `type`: 选项类型
  - `name`: 选项名称
  - `info`: 选项介绍
  - `option`: 各个选项

#### 游戏配置加载
- **文件路径**: `Script/Config/game_config.py`
- **主要配置字典**:
  - `config_system_setting`: 系统设置数据字典 (设置ID:详细内容)
  - `config_system_setting_option`: 系统设置选项数据字典 (设置ID:选项序号:选项内容)
  - `config_draw_setting`: 绘制设置数据字典
  - `config_draw_setting_option`: 绘制设置选项数据字典
  - `config_difficulty_setting`: 难度设置数据字典
  - `config_difficulty_setting_option`: 难度设置选项数据字典

### 2. 运行时数据结构

#### 系统设置数据容器
- **文件路径**: `Script/Core/game_type.py`
- **类名**: `System_Setting`
- **属性**:
  - `base_setting`: 基础系统设定字典 (`Dict[int, int]`)
  - `draw_setting`: 绘制设定字典 (`Dict[int, int]`)
  - `difficulty_setting`: 难度设定字典 (`Dict[int, int]`)
  - `line_before_main_update`: 主界面刷新前的行数
  - `value_draw`: 数值绘制开关
  - `character_text_version`: 角色文本版本字典

#### 缓存数据集成
- **文件路径**: `Script/Core/game_type.py`
- **类名**: `Cache`
- **相关属性**:
  - `all_system_setting`: 总系统设定实例 (`System_Setting`)
  - `forbidden_npc_id`: 已禁止干员ID集合

### 3. 用户界面系统

#### 系统设置面板类
- **文件路径**: `Script/UI/Panel/system_setting.py`
- **类名**: `System_Setting_Panel`
- **核心方法**:
  - `__init__(width)`: 初始化面板，设置绘制宽度
  - `draw()`: 主绘制方法，渲染整个设置界面
  - `draw_option(type_name, return_list)`: 绘制特定类型的设置选项
  - `change_setting_value(type_name, cid, option_len)`: 修改设置值
  - `option_name_info(type_name, cid)`: 显示选项详细信息
  - `change_ban_list()`: 管理禁止干员列表
  - `chat_ai_setting_panel_draw()`: 跳转到AI设置面板
  - `chat_filter_panel_draw()`: 跳转到指令过滤面板

#### 界面布局特点
1. **分类显示**: 按基础、难度、绘制三大类组织设置项
2. **折叠展开**: 支持点击标题折叠/展开对应类别
3. **选项切换**: 点击选项值循环切换可选项
4. **信息提示**: 点击选项名显示详细说明
5. **扩展功能**: 特定设置项提供额外功能入口

### 4. 设置值处理机制

#### 难度系数计算
- **函数**: `get_difficulty_coefficient(difficulty: int) -> float`
- **系数映射**: `[0.25, 0.5, 0.75, 1.0, 1.25, 2.0, 4.0]`
- **用途**: 将难度等级转换为游戏内修正系数

#### 特殊设置处理
1. **通用文本设置** (绘制设置cid=2):
   - 修改后自动更新所有角色的对应个人设置
   - 全局同步角色文本使用偏好

2. **指令绘制数量** (绘制设置cid=11):
   - 提供输入框让用户输入1-10的数字
   - 自动约束输入范围

3. **禁止干员列表** (基础设置cid=7):
   - 提供专门的干员选择界面
   - 支持动态添加/移除禁止干员
   - 自动处理已招募干员的离岛逻辑

### 5. 数据持久化

#### 存档系统集成
- **文件路径**: `Script/Core/save_handle.py`
- **处理逻辑**:
  - 在存档加载时检查设置完整性
  - 自动补充缺失的新设置项
  - 保持向前兼容性

#### 版本兼容性处理
```python
# 检查并补充缺失的基础设置
if len(loaded_dict["all_system_setting"].base_setting) != len(base_setting):
    for key in base_setting:
        if key not in loaded_dict["all_system_setting"].base_setting:
            loaded_dict["all_system_setting"].base_setting[key] = base_setting[key]
```

## 数据流程图

```
CSV数据源 → buildconfig.py构建 → config_def.py定义
    ↓
game_config.py加载 → cache.all_system_setting运行时存储
    ↓
system_setting.py界面展示 ↔ 用户交互修改
    ↓
save_handle.py存档持久化
```

## 设置类型详解

### 基础设置 (base)
- **ID范围**: 1-8
- **主要功能**:
  - 能力自动升级控制
  - 射精位置选择模式
  - 精液流通功能开关
  - 干员禁止功能
  - 自动精液灌肠

### 难度设置 (difficulty)
- **ID范围**: 101-112
- **主要功能**:
  - 攻略难易度修正
  - 部位敏感度调整
  - 心智强韧度设置
  - 尿意值增长控制

### 绘制设置 (draw)
- **ID范围**: 201-211
- **主要功能**:
  - 界面布局控制
  - 信息显示详细度
  - 文本使用偏好
  - 数据显示开关

## 扩展机制

### 添加新设置项
1. 在`System_Setting.csv`中添加新行
2. 运行`buildconfig.py`重新构建配置
3. 在相应的处理逻辑中添加特殊处理代码
4. 更新存档兼容性检查

### 自定义处理逻辑
系统支持为特定设置项添加自定义处理逻辑，如:
- 输入验证
- 级联更新
- 特殊界面展示
- 关联功能触发

## 依赖关系

### 上游依赖
- CSV数据文件系统
- 配置构建系统
- 缓存控制系统

### 下游影响
- 角色行为系统
- 界面绘制系统
- 游戏难度系统
- 存档系统

## 使用示例

```python
# 获取当前难度系数
difficulty_level = cache.all_system_setting.difficulty_setting[101]
coefficient = get_difficulty_coefficient(difficulty_level)

# 检查是否开启自动升级
auto_upgrade = cache.all_system_setting.base_setting[1]

# 修改绘制设置
cache.all_system_setting.draw_setting[201] = 2  # 设置空行数量为3行
```

## 注意事项

1. **线程安全**: 设置修改直接操作缓存数据，需注意并发访问
2. **即时生效**: 大部分设置修改后立即生效，无需重启
3. **存档兼容**: 新增设置项需要在存档加载时进行兼容性处理
4. **界面同步**: 某些设置修改会触发界面元素的级联更新
5. **数据验证**: 特殊设置项需要进行输入值的有效性验证