# manage_basement_panel.py 代码逻辑说明

## 文件概述

`Script/UI/Panel/manage_basement_panel.py` 是erArk游戏中管理罗德岛基地的核心UI面板模块。该文件实现了基地管理系统的主要界面，包括资源查看、部门管理、干员工作分配等功能。

## 主要类结构

### 1. Manage_Basement_Panel 类

这是基地管理的主面板类，提供了三个主要功能页面：

#### 核心功能：
- **罗德岛资源总览**：显示基地各类资源的存储情况
- **各部门工作概况**：展示各部门的工作人员分配和运行状态  
- **全干员一览**：列出所有干员，可点击查看详情

#### 主要方法：
- `__init__(self, width: int)`: 初始化面板，设置默认显示页面为资源总览
- `draw(self)`: 主绘制循环，处理页面切换和内容显示
- `change_panel(self, now_panel: str)`: 切换当前显示的面板
- `jump_to_son_panel(self, son_panel: str)`: 跳转到各部门的子系统面板
- `show_department(self, department: str)`: 显示特定部门的详细信息
- `settle_show_resource_type(self, resouce_type)`: 控制资源类型的展开/收起
- `see_attr(self, character_id: int)`: 查看干员详细属性

### 2. Change_Npc_Work_Panel 类

用于调整干员工作岗位分配的专门面板。

#### 核心功能：
- 按工作类型分类显示所有干员
- 支持展开/收起各工作类型
- 为干员分配新的工作岗位

#### 主要方法：
- `__init__(self, width: int)`: 初始化，设置工作类型展开状态
- `draw(self)`: 绘制工作分配界面
- `toggle_work_type(self, work_type_id: int)`: 切换工作类型的展开状态
- `expand_all(self)` / `collapse_all(self)`: 展开/收起所有类别
- `button_0(self, character_id: int)`: 显示特定干员的可分配工作列表
- `select_new_work(self, work_id: int, character_id: int)`: 为干员分配新工作

## 数据结构依赖

### 1. cache.rhodes_island (Rhodes_Island类)

主要使用的罗德岛数据包括：
- `facility_level`: 设施等级数据
- `materials_resouce`: 材料资源存储
- `warehouse_capacity`: 仓库容量
- `all_work_npc_set`: 各工作岗位的干员集合
- `work_people_now`: 当前工作人数
- `all_income`: 今日总收入
- 各部门特定数据（如医疗部的patient_now、工程部的facility_damage_data等）

### 2. game_config 配置数据

- `config_facility`: 设施配置数据
- `config_work_type`: 工作类型配置
- `config_resouce`: 资源配置
- `config_commission`: 委托任务配置
- `config_vehicle`: 载具配置

### 3. cache.character_data

干员数据，包含：
- `name`: 干员名字
- `adv`: 干员编号
- `work.work_type`: 当前工作类型
- `ability`: 能力数值
- `dormitory`: 宿舍位置

## 关键业务逻辑

### 1. 基地数据更新流程

在主面板显示前，会调用以下更新函数确保数据最新：
```python
basement.update_work_people()  # 更新工作人员统计
basement.update_facility_people()  # 更新设施人员
basement.get_base_updata()  # 更新基地整体数据
```

### 2. 部门子系统跳转机制

`department_son_panel_button_dict` 定义了各部门对应的子系统：
- 工程部 → 基建系统
- 制造加工区 → 生产系统
- 图书馆 → 图书馆管理系统
- 贸易区 → 资源交易系统
- 文职部 → 招募系统
- 访客区 → 势力外交系统、邀请访客系统
- 机库 → 外勤委托系统、载具管理系统
- 疗养庭院 → 农业系统
- 关押区 → 监禁调教系统

### 3. 工作分配限制

在分配工作时有多重限制检查：
- 必要条件判断（work_data.need）
- 设施开放状态检查
- 幼女只能担任学生工作
- 特殊工作需要额外解锁条件（如监狱长需要有囚犯且角色陷落等级达标）

### 4. 特殊工作处理

监狱长工作的特殊处理：
- 切换监狱长时会重置旧监狱长的工作和宿舍
- 新监狱长会搬到关押区休息室
- 更新cache.rhodes_island.current_warden_id

## 与其他模块的关系

### 1. 依赖的核心模块
- `Script.Core.cache_control`: 游戏缓存管理
- `Script.Core.game_type`: 数据类型定义
- `Script.Design.basement`: 基地功能实现
- `Script.Config.game_config`: 游戏配置数据

### 2. 调用的子面板
- building_panel: 基建系统面板
- manage_assembly_line_panel: 生产管理面板
- manage_library: 图书馆管理面板
- resource_exchange_panel: 资源交易面板
- recruit_panel: 招募面板
- nation_diplomacy_panel: 外交面板
- invite_visitor_panel: 邀请访客面板
- field_commission_panel: 外勤委托面板
- manage_vehicle_panel: 载具管理面板
- agriculture_production_panel: 农业生产面板
- confinement_and_training: 监禁调教面板

### 3. 使用的通用UI组件
- `Script.UI.Moudle.draw`: 各种绘制组件
- `Script.UI.Panel.see_character_info_panel`: 查看角色信息面板

## 注意事项

1. **数据同步**：面板显示前必须调用basement模块的更新函数确保数据最新
2. **权限检查**：监禁调教系统需要有监狱长才能访问
3. **延迟导入**：部分子面板模块使用延迟导入避免循环引用
4. **文本国际化**：所有显示文本使用 `_()` 函数进行国际化处理