# 睡眠系统

## 系统概述

睡眠系统是erArk游戏中的核心时间管理和角色恢复机制，负责处理角色的休息、状态恢复、数值结算、以及与助理服务的联动。系统由用户界面、状态管理、数值结算、助理服务等多个子系统组成。

## 核心文件结构

### 1. 用户界面层
- **`Script/UI/Panel/sleep_panel.py`** - 睡眠选择界面
  - 睡眠时间计算与选择（1小时、4小时、8小时、自定义）
  - 关门选项管理（根据地点类型）
  - HP/MP/疲劳/理智/精液的恢复时间计算
  - 早安服务时间整合
  - 日记功能集成
  - 助理睡眠结算调用

- **`Script/UI/Panel/get_up_panel.py`** - 起床界面
  - 简单的从睡眠状态回到正常游戏的过渡界面

### 2. 数值结算层
- **`Script/Settle/sleep_settle.py`** - 睡眠结算核心
  - `update_sleep()` - 主要睡眠处理函数，处理所有角色
  - `settle_character_juel()` - 状态值转换为宝珠系统
  - `sanity_point_grow()` - 玩家理智值自然成长
  - `refresh_temp_semen_max()` - 临时精液上限刷新
  - `update_save()` - 自动保存功能

### 3. 配置数据层
- **`data/csv/Sleep_Level.csv`** - 睡眠深度等级
  ```csv
  0,半梦半醒,30
  1,浅睡,60
  2,熟睡,80
  3,完全深眠,100
  ```

- **`data/csv/AssistantServices.csv`** - 助理服务配置
  - 早安服务：否|早上叫起床|早安吻|早安咬
  - 晚安服务：否|晚上催睡觉|晚安吻|晚安咬
  - 同居服务：否|是

### 4. 对话文本层
- **`data/talk/daily/sleep.csv`** - 睡眠相关对话文本
  - 包含各种睡眠情境下的描述文本
  - 根据条件提供不同的氛围描述

### 5. 前提条件层
- **`Script/Design/handle_premise.py`** - 睡眠相关前提验证
  - `handle_action_sleep()` - 角色是否在睡眠中
  - `handle_assistant_morning_salutation_on()` - 早安服务是否开启
  - `handle_assistant_night_salutation_on()` - 晚安服务是否开启
  - `handle_assistant_live_together_on()` - 同居服务是否开启

## 睡眠流程详解

### 1. 睡眠时间计算（sleep_panel.py#draw()）
```python
# 体力气力回复时间计算
hit_point_add_base = self.pl_character_data.hit_point_max * 0.0025 + 3
mana_point_add_base = self.pl_character_data.mana_point_max * 0.005 + 6
hp_recover_time = math.ceil((hit_point_max - hit_point) / hit_point_add_base / 60)
mp_recover_time = math.ceil((mana_point_max - mana_point) / mana_point_add_base / 60)

# 其他状态回复时间计算
tired_recover_time = math.ceil(tired_point * 3 / 60)  # 疲劳
sanity_recover_time = math.ceil((sanity_max - sanity) / sanity_max / 0.15)  # 理智
semen_recover_time = math.ceil((semen_max - semen) / sanity_max / 0.15)  # 精液

# 综合回复时间（最大8小时）
all_recover_time = min(max(tired, sanity, semen), 8)
need_time = max(hpmp_need_time, all_recover_time)
```

### 2. 早安服务时间计算（sleep_panel.py#judge_time_to_morning_service()）
```python
# 判断起床时间（12点后算明天，否则今天）
if start_time.hour > 12:
    judge_wake_up_time = game_time.get_sub_date(day=1, old_date=start_time)
else:
    judge_wake_up_time = start_time

# 替换为设定的早安时间
judge_wake_up_time = judge_wake_up_time.replace(hour=wake_time_hour, minute=wake_time_minute)

# 计算睡眠时长
min_to_morning_service = int((judge_wake_up_time - start_time).seconds / 60)
```

### 3. 睡眠执行（sleep_panel.py#draw()确定按钮）
```python
# 设置地点关门状态
if self.close_door_flag:
    cache.scene_data[now_scene_str].close_flag = now_scene_data.close_type

# 设置角色睡眠行为
instuct_judege.init_character_behavior_start_time(0, cache.game_time)
self.pl_character_data.behavior.duration = self.sleep_time_min
self.pl_character_data.behavior.behavior_id = constant.Behavior.SLEEP
self.pl_character_data.state = constant.CharacterStatus.STATUS_SLEEP

# 记录睡眠时间信息
self.pl_character_data.action_info.sleep_time = cache.game_time
self.pl_character_data.action_info.wake_time = game_time.get_sub_date(minute=self.sleep_time_min, old_date=cache.game_time)

# 关闭玩家透视能力
self.pl_character_data.pl_ability.visual = False

# 助理睡眠结算
self.assistant_sleep_settle()

# 游戏时间推进
update.game_update_flow(self.sleep_time_min)
```

## 助理服务集成

### 1. 助理睡眠结算（sleep_panel.py#assistant_sleep_settle()）
```python
# 晚安问候处理
if handle_premise.handle_assistant_night_salutation_on(assistant_id) and handle_premise.handle_night_salutation_flag_0(assistant_id):
    night_salutation_state_machine_id = 708 + assistant_character_data.assistant_services[6]
    constant.handle_state_machine_data[night_salutation_state_machine_id](assistant_id)

# 同居服务处理
if handle_premise.handle_assistant_live_together_on(assistant_id):
    constant.handle_state_machine_data[44](assistant_id)  # 睡觉状态机
    
    # 早安服务时间同步
    if handle_premise.handle_assistant_morning_salutation_on(assistant_id):
        assistant_character_data.behavior.duration = self.min_to_moring_service_min - 10  # 提前10分钟醒来
    else:
        assistant_character_data.behavior.duration = self.sleep_time_min  # 同时醒来
```

### 2. 助理服务配置
- **早安服务等级**：
  - 0: 关闭
  - 1: 早上叫起床（信任≥100）
  - 2: 早安吻（信任≥150）
  - 3: 早安咬（信任≥250）

- **晚安服务等级**：
  - 0: 关闭
  - 1: 晚上催睡觉（信任≥100）
  - 2: 晚安吻（信任≥150）
  - 3: 晚安咬（信任≥250）

## 数值结算系统

### 1. 宝珠结算（sleep_settle.py#settle_character_juel()）
```python
# 状态值转换为宝珠
for status_id in game_config.config_character_state:
    status_value = character_data.status_data[status_id]
    if status_value != 0:
        add_juel = attr_calculation.get_juel(status_value)
        character_data.juel[status_id] += add_juel
        character_data.status_data[status_id] = 0  # 清零状态值

# 反发珠抵消机制
if character_data.juel[20] > 0:  # 反发珠
    for i in [15, 10, 11, 12, 13]:  # 好意相关宝珠
        juel_down = min(character_data.juel[20], character_data.juel[i] * 2)
        character_data.juel[20] -= juel_down
        character_data.juel[i] -= juel_down // 2  # 1好意抵消2反发
```

### 2. 玩家特殊结算（sleep_settle.py#update_sleep()）
```python
# 玩家专属处理
if character_id == 0:
    sanity_point_grow()  # 理智成长
    character_data.eja_point = 0  # 清零射精槽
    handle_ability.gain_ability(character_id)  # 能力获得检查

# NPC处理
else:
    character_data.angry_point = random.randrange(1, 35)  # 重置生气值
    character_data.action_info.h_interrupt = 0  # 清零H被撞破flag
    character_data.first_record.day_first_meet = 1  # 重置每天第一次见面
    pregnancy.check_all_pregnancy(character_id)  # 怀孕检查
    handle_talent.gain_talent(character_id, now_gain_type=3)  # 素质获得
    character_data.h_state = attr_calculation.get_h_state_reset(character_data.h_state)  # 清零H状态
```

### 3. 理智值成长（sleep_settle.py#sanity_point_grow()）
```python
today_cost = character_data.pl_ability.today_sanity_point_cost
character_data.pl_ability.today_sanity_point_cost = 0

# 消耗超过50时进行成长
if today_cost >= 50 and character_data.sanity_point_max < 9999:
    grow_value = round(today_cost / 50)  # 成长值为消耗值的1/50
    character_data.sanity_point_max += grow_value
    character_data.sanity_point_max = min(character_data.sanity_point_max, 9999)
```

### 4. 临时精液上限刷新（sleep_settle.py#refresh_temp_semen_max()）
```python
# 需要睡眠时长至少6小时
if now_semen and character_data.behavior.duration >= 360:
    # 未消耗精液的50%转为次日额外精液
    character_data.tem_extra_semen_point += int(now_semen / 2)
    # 最大为正常上限的4倍
    character_data.tem_extra_semen_point = min(character_data.tem_extra_semen_point, character_data.semen_point_max * 4)
    
    # 获得浓厚精液天赋
    if character_data.tem_extra_semen_point >= character_data.semen_point_max * 4:
        character_data.talent[33] = 1
```

## 地点关门系统

### 地点类型（sleep_panel.py#draw()）
- **type 0**: 无法关门
- **type 1**: 可以关门，关门后其他人无法进入
- **type 2**: 有小隔间，关门后别人无法发现隔间内的人，但仍可进入该地点

### 关门处理
```python
if self.close_door_flag:
    cache.scene_data[now_scene_str].close_flag = now_scene_data.close_type
```

## 自动保存系统

### 保存流程（sleep_settle.py#update_save()）
```python
# 显示游戏提示
info_list = list(game_config.config_tip_data.keys())
info_id = random.choice(info_list)
info_text = game_config.config_tip_data[info_id].info

# 执行自动保存
save_handle.establish_save("auto")
```

## 状态机集成

### 睡眠相关状态机
- **SLEEP = 44**: 主要睡眠状态机
- **START_SLEEP = 78**: 开始睡眠状态
- **708-712**: 晚安服务状态机（根据服务等级）

### 与character_behavior的集成
睡眠系统与主行为循环紧密集成：
1. 睡眠开始时设置behavior.behavior_id = SLEEP
2. 通过update.game_update_flow()推进时间
3. 在睡眠结束时触发sleep_settle.update_sleep()
4. 最终回到常规行为循环

## 系统间依赖关系

### 核心依赖
- **时间系统**: 依赖game_time模块进行时间计算和推进
- **角色系统**: 依赖character数据结构和状态管理
- **宝珠系统**: 通过attr_calculation模块进行状态值到宝珠的转换
- **助理系统**: 与assistant_panel的服务配置系统集成
- **前提系统**: 依赖handle_premise进行各种条件验证
- **保存系统**: 集成自动保存功能

### 数据流向
1. **用户输入** → sleep_panel → 睡眠参数设置
2. **睡眠执行** → character_behavior → 行为状态设置
3. **时间推进** → update.game_update_flow → 触发睡眠结算
4. **数值结算** → sleep_settle → 状态值转换和角色更新
5. **自动保存** → save_handle → 数据持久化

## 开发要点

### 添加新的睡眠功能时需要考虑：
1. **时间计算逻辑** - 确保与现有的恢复公式兼容
2. **助理服务集成** - 新功能是否需要助理参与
3. **数值结算影响** - 是否影响宝珠系统或角色成长
4. **前提条件验证** - 添加相应的handle_premise函数
5. **UI界面更新** - sleep_panel的界面元素调整
6. **状态机配合** - 是否需要新的状态机支持

### 性能考虑：
- 睡眠结算会处理所有已获得的NPC，大量角色时需要注意性能
- 宝珠计算和状态值转换是计算密集型操作
- 自动保存会进行文件I/O操作，可能造成短暂卡顿

### 测试要点：
- 不同睡眠时长的恢复计算准确性
- 助理服务的时间同步正确性
- 宝珠结算的数值转换无误
- 自动保存的完整性和错误处理
- 各种前提条件的验证逻辑