# 监禁调教系统说明

## 系统概述

监禁调教系统是erArk游戏中的囚犯管理系统，负责处理角色的囚禁、逃脱、调教准备和助手AI等功能。该系统主要集中在 `Script/UI/Panel/confinement_and_training.py` 文件中实现。

## 核心数据结构

### Rhodes_Island 类中的相关属性
```python
# 关押区相关属性 (game_type.py:1108-1124)
self.current_warden_id: int = 0                              # 当前监狱长的干员id
self.current_prisoners: Dict[int, Tuple[datetime.datetime, int]] = {}  # 当前囚犯数据，干员id: (被关押时间, 逃脱概率)
self.confinement_training_setting: Dict[int, Tuple[int]] = {}  # 监禁调教设置 设置id:设置值
self.pre_training_cleaning: bool = False                     # 调教前清洗准备
self.pre_training_lubrication: bool = False                  # 调教前润滑准备
self.pre_training_tool_dict: Dict[int, Tuple[int]] = {}      # 调教前道具使用字典
self.sex_assistant_ai_behavior_id_list: list = []            # 调教助手AI行为列表
self.sex_assistant_ai_ban_behavior_id_list: list = []        # 调教助手AI禁止行为列表
```

## 主要功能模块

### 1. 囚犯管理系统

#### 1.1 囚犯结算 (`settle_prisoners()`)
- **调用位置**: `Script/Design/basement.py:269` (每日结算时调用)
- **主要流程**:
  1. 遍历所有囚犯 (`cache.rhodes_island.current_prisoners`)
  2. 计算逃脱概率 (`calculate_escape_probability()`)
  3. 判断是否能逃脱 (`judge_can_escape()`)
  4. 处理逃脱成功/失败结果

#### 1.2 逃脱概率计算 (`calculate_escape_probability()`)
```python
# 逃脱概率公式
escape_probability = (战斗技能 + 学识技能) * 系数
```
- **影响因素**:
  - 战斗技能 (`character_data.ability[42]`)
  - 学识技能 (`character_data.ability[45]`)
  - 生活水平系数 (`confinement_training_setting[4]`)
  - 屈服刻印减少系数 (`character_data.ability[14] * 0.1`)
  - 反发刻印增加系数 (`character_data.ability[18] * 0.2`)
  - 陷落降低系数 (`now_fall * 0.2`)

#### 1.3 逃脱判断 (`judge_can_escape()`)
- **判断条件**:
  1. 无监狱长时：逃脱概率 > 30%
  2. 有监狱长时：逃脱概率 > (50 + 关押区效果)，最高99%
  3. 囚犯与监狱长的战斗力对比

#### 1.4 角色成为囚犯 (`chara_become_prisoner()`)
- **调用位置**:
  - `Script/Settle/default.py:7965` (投入监牢指令)
  - `Script/UI/Panel/field_commission_panel.py:69` (抓捕逃犯)
- **处理流程**:
  1. 设置囚禁标志 (`sp_flag.imprisonment = 1`)
  2. 重置身体管理数据
  3. 处理囚犯服装 (`clothing.handle_prisoner_clothing()`)
  4. 分配牢房宿舍
  5. 添加刻印效果 (屈服、恐怖、反发)

### 2. 调教准备系统

#### 2.1 调教前准备 (`prepare_training()`)
- **调用位置**: `Script/Design/handle_instruct.py:2043` (调教前准备指令)
- **准备流程**:
  1. 移动玩家、交互对象、监狱长到调教室
  2. 清洗处理 (如果开启)
  3. 润滑处理 (如果开启并有润滑液)
  4. 道具使用处理
  5. 等待10分钟准备时间

#### 2.2 道具使用系统
支持的道具类型 (参考 `h_item_shop_panel.body_item_list`):
- **消耗类道具** (8-13号):
  - 利尿剂 (8)
  - 安眠药 (9)  
  - 排卵促进药 (10)
  - 事前避孕药 (11)
  - 事后避孕药 (12)
  - 避孕套 (13)
- **持续性道具**: 其他编号道具

### 3. 调教助手AI系统

#### 3.1 助手行为获取 (`get_behavior_id_of_sex_assistant()`)
- **工作模式**:
  1. **同部位模式**: 与玩家选择相同部位
  2. **异部位模式**: 与玩家选择不同部位  
  3. **指定列表模式**: 从预设指令列表随机选择

#### 3.2 可用行为筛选 (`get_all_can_use_behavior_id_for_sex_assistant()`)
- **筛选条件**:
  - 基于群交部位配置 (`config_behavior_id_list_of_group_sex_body_part`)
  - 排除仅玩家可用指令 (`behavior_data.trigger == 'pl'`)
  - 排除被ban的指令
  - 排除破处类指令 (针对处女角色)

## 配置数据系统

### CSV配置文件

#### 1. 监禁调教设置 (`Confinement_Training_Setting.csv`)
| ID | 设置名 | 说明 | 选项 |
|----|--------|------|------|
| 1 | 囚犯训练管理 | 监狱长对囚犯的日常训练 | 不训练/部位快感/部位扩张/苦痛快感/性爱技巧/身体锻炼/心理服从 |
| 2 | 囚犯服装管理 | 囚犯的服装提供 | 全裸/囚犯服装/正常服装 |
| 3 | 囚犯内衣管理 | 囚犯的内衣提供 | 不提供/情趣内衣/正常内衣 |
| 4 | 囚犯生活条件 | 影响体力气力回复和逃脱概率 | 艰苦/标准/舒适 |
| 11 | 调教前准备 | 调教前的准备工作 | 清洗/润滑/道具 |
| 12 | 调教助手 | AI助手的工作模式 | 否/同部位/异部位/指定列表 |
| 13 | 调教目标 | 调教对象范围 | 仅囚犯/所有干员 |

#### 2. 训练对话 (`training.csv`)
- 包含训练场景的对话文本
- 支持格斗训练和射击训练场景
- 提供随机化的训练描述文本

## 系统集成关系

### 1. 与基地系统的集成
- **每日结算**: 在 `basement.py` 的每日结算中调用囚犯逃脱检查
- **设施等级**: 关押区等级影响囚犯逃脱难度
- **牢房管理**: 自动分配可用牢房 (`get_unused_prison_dormitory()`)

### 2. 与指令系统的集成
- **调教前准备指令**: 通过 `handle_instruct.py` 调用
- **投入监牢指令**: 通过 `default.py` 的行为结算调用

### 3. 与外勤系统的集成
- **逃犯追捕**: 逃脱成功时自动创建追捕委托
- **抓捕完成**: 追捕成功时重新囚禁角色

### 4. 与服装系统的集成
- **囚犯服装**: 调用 `clothing.handle_prisoner_clothing()` 处理服装
- **服装管理**: 根据设置提供不同级别的服装

## 界面管理系统

### Confinement_And_Training_Manage_Panel 类
- **主界面**: 显示当前囚犯列表和各项设置
- **设置管理**: 提供选项切换和详细说明
- **道具管理**: 调教前道具使用的开关控制
- **指令管理**: 调教助手指令列表的选择和禁用

### 界面交互流程
1. 显示囚犯信息和当前设置
2. 提供设置选项的点击切换
3. 支持详细说明的弹出显示
4. 道具和指令的专门管理界面

## 数据流程图

```
每日结算 → 囚犯逃脱检查
    ↓
计算逃脱概率 → 判断是否逃脱
    ↓
逃脱成功 → 创建追捕委托
    ↓
抓捕成功 → 重新囚禁

玩家指令 → 调教前准备
    ↓
移动到调教室 → 清洗/润滑/道具
    ↓
调教助手AI → 选择辅助行为
    ↓
执行调教指令
```

## 技术特点

### 1. 模块化设计
- 核心逻辑与界面分离
- 数据结构集中管理
- 功能模块独立可测

### 2. 配置驱动
- CSV文件配置设置选项
- 动态加载配置数据
- 支持本地化翻译

### 3. 事件驱动
- 基于时间的自动结算
- 指令触发的即时处理
- 状态变化的联动响应

### 4. AI智能化
- 调教助手的智能行为选择
- 基于条件的动态筛选
- 可配置的行为列表

## 扩展性设计

### 1. 新增囚犯类型
- 通过扩展配置文件支持
- 添加新的判断条件和属性

### 2. 新增调教模式
- 扩展助手AI的行为模式
- 增加新的指令筛选规则

### 3. 新增管理功能
- 添加新的设置选项到CSV
- 扩展界面管理类的功能

该系统展现了复杂游戏机制的良好架构设计，通过合理的模块划分、数据驱动和事件响应机制，实现了功能丰富且易于维护扩展的监禁调教管理系统。