# 源石技艺系统

## 系统概述

源石技艺系统是erArk游戏中一个核心的特殊能力系统，为玩家（博士）提供了多种超能力，包括催眠、时间控制、激素控制、视觉穿透等能力。该系统通过消耗特定资源（主要是理智和至纯源石）来实现各种超自然效果。

## 核心文件结构

### 主要代码文件

1. **Script/UI/Panel/originium_arts.py** - 源石技艺主面板，提供用户界面和核心逻辑
2. **Script/Design/handle_talent.py** - 素质处理模块，包含催眠、激素、视觉等能力检测
3. **Script/Design/handle_instruct.py** - 指令处理模块，处理源石技艺相关指令
4. **Script/Core/game_type.py** - 数据结构定义，包含催眠数据结构体

### 配置数据文件

1. **data/csv/Talent_Of_Arts.csv** - 源石技艺素质配置表
2. **data/csv/Hypnosis_Type.csv** - 催眠类型配置表
3. **data/csv/Hypnosis_Talent_Of_Pl.csv** - 玩家催眠素质配置表
4. **data/csv/Roleplay.csv** - 角色扮演配置表

## 系统架构

### 1. 能力分类体系

源石技艺系统主要分为以下几大类：

#### 1.1 催眠系能力（核心能力）
- **平然催眠**（素质ID 331）：基础催眠，目标接受不合理行为
- **空气催眠**（素质ID 333）：目标视博士为空气
- **体控催眠**（素质ID 334）：控制目标身体
- **心控催眠**（素质ID 334）：控制目标心理

#### 1.2 时间系能力
- **窄域时停**（素质ID 316）：小范围时间停止
- **广域时停**（素质ID 317）：大范围时间停止
- **完全时停**（素质ID 318）：未实装

#### 1.3 激素系能力
- **博士信息素**（素质ID 304）：基础信息素
- **博士信息素集组**（素质ID 305）：群体信息素
- **博士信息素阵列**（素质ID 306）：高级信息素

#### 1.4 视觉系能力
- **内衣透视**（素质ID 307）：透视内衣
- **腔内透视**（素质ID 308）：透视体内
- **生理透视**（素质ID 309）：透视生理状态

#### 1.5 触觉系能力（未实装）
- 预留给未来扩展的触觉类能力

### 2. 数据结构设计

#### 2.1 催眠数据结构（HYPNOSIS类）
```python
class HYPNOSIS:
    hypnosis_degree: float = 0          # 催眠程度（0-200%）
    increase_body_sensitivity: bool     # 体控-敏感度提升
    force_ovulation: bool              # 体控-强制排卵
    blockhead: bool                    # 体控-木头人
    active_h: bool                     # 体控-逆推
    roleplay: int = 0                  # 心控-角色扮演类型
    pain_as_pleasure: bool             # 心控-苦痛快感化
```

#### 2.2 玩家能力数据（pl_ability）
```python
hypnosis_type: int = 0                 # 当前选择的催眠类型
air_hypnosis_position: str = ""        # 空气催眠位置记录
```

### 3. 能力获得机制

#### 3.1 通用获得方式
- **至纯源石消费**：花费10^(等级-1)个至纯源石直接获得
- **特定条件解锁**：满足特殊条件自动解锁

#### 3.2 特殊解锁条件
- **博士信息素**：单干员最高好感度≥1000，最高信赖度≥100
- **视觉系能力**：需要收集内裤、射精量、绝顶经验等数据
- **时间系能力**：需要无意识性交和绝顶经验
- **催眠系能力**：需要催眠经验和总催眠深度

### 4. 催眠系统详细机制

#### 4.1 催眠深度计算
```python
def hypnosis_degree_calculation(target_character_id: int) -> float:
    # 基础增长值
    base_addition = 1
    
    # 根据玩家催眠能力调整系数
    hypnosis_degree_adjust = 2-6  # 根据素质等级
    
    # 调香加成
    if 调香状态 == 6: hypnosis_degree_adjust += 5
    
    # 无觉刻印能力加成
    hypnosis_degree_adjust *= 能力调整系数
    
    # 随机系数0.5-1.5
    hypnosis_degree_adjust *= random.uniform(0.5, 1.5)
    
    return base_addition * hypnosis_degree_adjust
```

#### 4.2 催眠理智消耗
```python
def calculate_hypnosis_sanity_cost(character_id: int) -> int:
    base_cost = 10
    if 有高级催眠素质: return 1
    elif 有中级催眠素质: return base_cost + 20
    elif 有初级催眠素质: return base_cost + 15
    else: return base_cost + 10
```

#### 4.3 催眠类型效果

| 催眠类型 | 需要素质 | 催眠深度要求 | 效果描述 |
|---------|----------|-------------|----------|
| 无 | 331 | 50% | 手动选择催眠类型 |
| 平然 | 331 | 50% | 目标接受不合理行为 |
| 空气 | 333 | 100% | 目标视博士为空气 |
| 体控 | 334 | 200% | 控制目标身体 |
| 心控 | 334 | 200% | 控制目标心理 |

#### 4.4 角色扮演系统
心控催眠可以让目标进行角色扮演：
- **家庭类**：妻子、姐姐、妹妹、女儿、妈妈
- **职业类**：女仆、老师、学生、护士、警察
- **宠物类**：宠物猫、宠物狗
- **场景类**：电车痴汉、户外当众、公共厕所

### 5. 特殊功能

#### 5.1 消除负面刻印
- 消耗目标角色5条内裤
- 可降低苦痛刻印、反发刻印、恐怖刻印等级
- 优先消耗重复款式的内裤

#### 5.2 Re:败者食尘
- 需要游戏时间超过一年或debug模式
- 重新开始新周目，继承部分数据

#### 5.3 视觉系能力消耗
- 每级能力每小时消耗5理智
- 时间系能力每分钟消耗2理智

## 系统交互流程

### 1. 主面板交互流程
```
Originium_Arts_Panel.draw() 
├── 消除负面刻印 → Down_Negative_Talent_Panel
├── 时间系能力 → arts_show(2)
├── 催眠系能力 → Chose_Hypnosis_Type_Panel
├── 激素系能力 → arts_show(5)
├── 视觉系能力 → arts_show(6)
├── 能力获得与升级 → gain_and_upgrade_ability()
└── Re:败者食尘 → new_round_for_sure()
```

### 2. 催眠执行流程
```
选择催眠类型 → 消耗理智 → 增加催眠深度 → 判断催眠完成 
├── 完成 → 设置无意识状态 → 可执行特殊指令
└── 未完成 → 提示需要更深催眠
```

### 3. 能力升级流程
```
检查解锁条件 → 消耗至纯源石/满足特殊条件 → 获得素质 → 解锁新功能
```

## 与其他系统的关联

### 1. 角色行为系统
- 催眠状态影响角色行为判断
- 无意识状态下的特殊行为选项

### 2. 指令系统
- 体控和心控催眠解锁特殊指令
- 指令的前提判断包含催眠状态

### 3. 素质系统
- 源石技艺本质上是特殊素质
- 与角色素质获得系统共享底层逻辑

### 4. 资源系统
- 消耗理智、至纯源石等资源
- 与罗德岛资源管理系统关联

### 5. 收藏系统
- 部分能力解锁需要收藏品数据
- 消除负面刻印需要消耗内裤收藏

## 配置表说明

### Talent_Of_Arts.csv
| 字段 | 说明 |
|------|------|
| cid | 配置ID |
| talent_id | 对应素质ID |
| need_id | 前置需求素质ID |
| level | 能力等级 |
| lv_up_value1/2 | 升级用数值参数 |
| todo | 是否未实装 |

### Hypnosis_Type.csv
| 字段 | 说明 |
|------|------|
| cid | 催眠类型ID |
| name | 催眠类型名称 |
| talent_id | 需要的素质ID |
| hypnosis_degree | 需要的催眠程度 |
| introduce | 催眠类型介绍 |

## 开发注意事项

1. **理智消耗平衡**：各能力的理智消耗需要与游戏平衡性匹配
2. **催眠深度计算**：包含随机性，需要考虑数值波动
3. **前提判断**：各能力都有复杂的前提条件判断逻辑
4. **状态持续性**：不同催眠类型有不同的持续条件
5. **UI交互**：面板系统需要处理复杂的嵌套选择逻辑
6. **数据一致性**：催眠状态需要与其他角色状态保持一致

## 扩展性考虑

1. **新能力类型**：系统架构支持添加新的能力分类
2. **配置驱动**：大部分逻辑通过CSV配置表驱动，便于扩展
3. **模块化设计**：各子系统相对独立，便于单独修改
4. **数据结构预留**：为未来功能预留了数据结构空间