# 服装系统说明

## 概述
erArk的服装系统是一个复杂的角色装备管理系统，支持多部位穿戴、脱衣互动、衣物收集、污渍系统等功能。系统通过CSV配置文件定义服装数据，通过Python代码实现服装的穿脱逻辑和UI交互。

## 系统架构

### 1. 核心数据结构

#### 1.1 服装类型（ClothingType.csv）
定义了14个服装部位（0-13）：
- 0: 帽子（Hat）
- 1: 眼镜（Glasses）
- 2: 耳饰（Earrings）
- 3: 脖饰（Necklace）
- 4: 口饰（Mouth accessory）
- 5: 上衣（Upper clothing）
- 6: 胸衣（Bra/Chest clothing）
- 7: 手套（Gloves）
- 8: 下衣（Lower clothing）
- 9: 内裤（Underwear）
- 10: 袜子（Socks）
- 11: 鞋子（Shoes）
- 12: 武器（Weapon）
- 13: 附属物（Accessories）

每个类型包含液体容量和流动模式配置：
- `volume_table`: 容量等级表
- `normal_flow_table`: 正常流动模式
- `full_flow_table`: 满载流动模式
- `extra_flow_table`: 额外流动模式

#### 1.2 服装模板（ClothingTem.csv）
定义具体的服装物品，包含：
- `cid`: 模板ID
- `name`: 服装名称
- `clothing_type`: 服装类型（对应ClothingType的ID）
- `npc`: 角色限定（0表示通用，其他数字表示特定角色）
- `tag`: 使用标签（对应ClothingUseType）
- `describe`: 描述信息

#### 1.3 服装使用类型（ClothingUseType.csv）
定义7种服装分类（0-6）：
- 0: 基础（Basic）
- 1: 童装（Children's clothing）
- 2: 情趣（Erotic/Lingerie）
- 3: 泳装（Swimwear）
- 4: 裤子（Pants）
- 5: 裙子（Skirt）
- 6: 饰品（Accessories）

### 2. 角色服装数据结构（CLOTH类）

```python
class CLOTH:
    clothing_tem: List              # 角色专属的服装模板列表
    cloth_wear: Dict[int, List]     # 当前穿着：{部位: [服装ID列表]}
    cloth_off: Dict[int, List]      # 已脱下：{部位: [服装ID列表]}
    cloth_locker_in_shower: Dict    # 淋浴间衣柜中的衣服
    cloth_locker_in_dormitory: Dict # 宿舍衣柜中的衣服
    cloth_see: Dict[int, bool]      # 可见性状态（主要用于内衣）
```

## 核心功能模块

### 1. 服装穿戴系统（clothing.py）

#### 1.1 基础穿戴功能
- `get_npc_cloth(character_id)`: 根据角色CSV配置穿戴默认服装
- `get_underwear(character_id, part_flag, type_cid)`: 随机穿戴内衣
  - 支持正常、童装、情趣三种类型
  - 根据角色素质和好感度自动选择
- `get_socks(character_id)`: 随机穿戴袜子

#### 1.2 特殊场景服装
- `get_shower_cloth(character_id)`: 洗澡时穿浴袍
- `get_sleep_cloth(character_id)`: 睡觉时穿睡衣
- `get_swim_cloth(character_id)`: 游泳时穿泳装
- `get_prison_cloth(character_id)`: 监禁时穿囚服
- `handle_prisoner_clothing(character_id)`: 处理囚犯服装逻辑

#### 1.3 衣柜系统
- `get_cloth_from_dormitory_locker(character_id)`: 从宿舍衣柜穿衣
- `locker_cloth_semen_to_wear_cloth_semen(character_id)`: 转移衣柜衣物污渍

#### 1.4 脱衣功能
- `undress_out_cloth(character_id)`: 脱掉外衣（上衣、下衣）
- `strip_down_till_socks_and_gloves_left(character_id)`: 脱到只剩袜子手套
- `get_all_cloth_off(character_id)`: 脱成全裸

### 2. 收集系统

#### 2.1 内衣收集
- `pl_get_chara_pan(character_id)`: 玩家获得角色内裤
  - 添加到玩家收藏
  - 记录获取行为
  - 处理无意识状态标记
- `pl_get_chara_socks(character_id)`: 玩家获得角色袜子

### 3. UI面板系统（cloth_panel.py）

#### 3.1 SeeCharacterClothPanel类
显示角色当前服装状态：
- 按部位分类显示穿着的衣物
- 特殊处理内衣可见性（需要透视能力或外衣已脱）
- 显示衣物污渍信息
- 在H模式下显示已脱下的衣物

#### 3.2 Undress_Panel类
提供脱衣操作界面：
- 脱到只穿内衣
- 脱到只穿袜子手套
- 脱到全裸
- 收走内裤

#### 3.3 SwitchCharacterClothPanel类
可切换穿脱状态的服装面板：
- 每件衣服显示为按钮
- 点击可切换穿着/脱下状态
- 实时刷新显示

### 4. 污渍系统

服装支持精液污渍：
- 每个部位记录污渍等级（1-3级）
- 根据设置显示简略或完整污渍描述
- 污渍可在衣物间转移

### 5. 特殊机制

#### 5.1 可见性控制
- 内衣（部位6、9）默认不可见
- 需要透视能力或外衣已脱才能看到
- debug模式下始终可见

#### 5.2 角色专属衣物
- 通过`npc`字段限定特定角色才能穿戴
- 如阿米娅的抑制环（ID: 4000-4005）

#### 5.3 自动穿戴逻辑
- `chara_special_wear_cloth()`: 处理角色必须穿戴的特殊物品
- 囚犯服装根据监禁设置自动调整
- 每日自动更换袜子功能

## 数据流程

### 1. 初始化流程
1. 从CSV加载服装配置数据
2. 初始化角色CLOTH对象
3. 根据角色模板穿戴默认服装
4. 随机选择内衣

### 2. 日常穿衣流程
1. 检查是否被监禁（特殊处理）
2. 检查宿舍衣柜是否有衣服
3. 如有则穿衣柜中的衣服，否则穿默认服装
4. 更换内衣内裤
5. 处理特殊穿戴需求

### 3. 脱衣交互流程
1. 玩家选择脱衣指令
2. 系统计算可脱的衣物
3. 更新cloth_wear和cloth_off数据
4. 执行后处理（去重、整理）
5. 刷新UI显示

## 相关文件

### 核心代码文件
- `/Script/Design/clothing.py`: 服装系统核心逻辑
- `/Script/UI/Panel/cloth_panel.py`: 服装UI面板
- `/Script/UI/Panel/check_locker_panel.py`: 衣柜检查面板
- `/Script/Settle/default_cloth.py`: 服装相关行为结算

### 配置文件
- `/data/csv/ClothingType.csv`: 服装类型定义
- `/data/csv/ClothingTem.csv`: 服装模板数据
- `/data/csv/ClothingUseType.csv`: 服装使用类型
- `/data/character/*.csv`: 角色默认服装配置

### 游戏类型定义
- `/Script/Core/game_type.py`: CLOTH类定义
- `/Script/Config/config_def.py`: 服装配置类定义

## 扩展说明

### 添加新服装
1. 在ClothingTem.csv中添加新条目
2. 设置正确的clothing_type和tag
3. 如需角色专属，设置npc字段
4. 重新构建配置文件

### 添加新服装类型
1. 修改ClothingType.csv添加新类型
2. 更新相关代码中的类型判断
3. 调整UI显示逻辑

### 实现新的穿脱逻辑
1. 在clothing.py中添加新函数
2. 在cloth_panel.py中添加UI支持
3. 在行为结算中处理相关效果