# 时间停止系统

## 系统概述

时间停止系统是erArk游戏中源石技艺的一个重要分支，允许玩家（博士）停止时间的流动，在静止的世界中进行各种行为。该系统通过复杂的状态管理和前提判断，实现了丰富的时停交互玩法。

## 核心机制

### 1. 时停模式状态

时间停止系统的核心是全局状态 `cache.time_stop_mode`：
- **True**：时停开启状态，时间静止
- **False**：时停关闭状态，时间正常流动

### 2. 能力等级体系

时间停止能力分为三个等级：

#### 2.1 窄域时停（素质ID：316）
- **解锁条件**：
  - 全干员无意识性交经验 ≥ 50
  - 全干员总无意识绝顶经验 ≥ 10
  - 或消耗1个至纯源石直接解锁
- **功能**：基础时停能力，可以停止和恢复时间流动
- **理智消耗**：每分钟消耗2理智

#### 2.2 广域时停（素质ID：317）
- **解锁条件**：
  - 需要先获得窄域时停
  - 对干员的时姦经验 ≥ 200
  - 全干员总无意识绝顶经验 ≥ 50
  - 或消耗10个至纯源石直接解锁
- **功能**：中级时停能力，新增搬运功能
- **理智消耗**：每分钟消耗2理智

#### 2.3 完全时停（素质ID：318）
- **状态**：未实装
- **预期功能**：高级时停能力，允许目标在时停中自由活动

### 3. 时停状态管理

#### 3.1 开启时停
```python
@settle_behavior.add_settle_behavior_effect(constant_effect.BehaviorEffect.TIME_STOP_ON)
def handle_time_stop_on():
    # 设置全局时停状态
    cache.time_stop_mode = True
    
    # 所有NPC设置为时停无意识状态
    for chara_id in cache.npc_id_got:
        chara_data = cache.character_data[chara_id]
        chara_data.sp_flag.unconscious_h = 3  # 时停无意识状态
        
        # 重置时停高潮计数
        for state_id in game_config.config_character_state:
            if game_config.config_character_state[state_id].type == 0:
                chara_data.h_state.time_stop_orgasm_count[state_id] = 0
```

#### 3.2 关闭时停
```python
@settle_behavior.add_settle_behavior_effect(constant_effect.BehaviorEffect.TIME_STOP_OFF)
def handle_time_stop_off():
    # 关闭全局时停状态
    cache.time_stop_mode = False
    
    # 所有NPC恢复正常意识状态
    for chara_id in cache.npc_id_got:
        chara_data = cache.character_data[chara_id]
        chara_data.sp_flag.unconscious_h = 0  # 恢复正常状态
```

### 4. 时间机制

#### 4.1 时间回退机制
```python
# 在角色行为控制循环中
def init_character_behavior():
    while 1:
        # 先结算玩家部分
        while 0 not in cache.over_behavior_character:
            pl_start_time = cache.character_data[0].behavior.start_time
            pl_duration = cache.character_data[0].behavior.duration
            character_behavior(0, cache.game_time, pl_start_time)
            
        # 如果当前是时停模式，则回退时间，然后结束循环
        if cache.time_stop_mode:
            game_time.sub_time_now(minute = -pl_duration)  # 时间回退
            break  # 终止NPC行为循环
```

#### 4.2 时间流动控制
- **时停开启时**：只有玩家行动，行动完成后时间回退，NPC不会行动
- **时停关闭时**：正常的时间流动，所有角色按时间顺序行动

### 5. 前提判断系统

时间停止系统拥有完整的前提判断机制：

#### 5.1 能力前提
```python
@add_premise(constant_promise.Premise.PRIMARY_TIME_STOP)
def handle_primary_time_stop(character_id: int) -> int:
    """自己拥有初级时停"""
    character_data = cache.character_data[character_id]
    return 1 if character_data.talent[316] else 0

@add_premise(constant_promise.Premise.INTERMEDIATE_TIME_STOP)
def handle_intermediate_time_stop(character_id: int) -> int:
    """自己拥有中级时停"""
    character_data = cache.character_data[character_id]
    return 1 if character_data.talent[317] else 0
```

#### 5.2 状态前提
```python
@add_premise(constant_promise.Premise.TIME_STOP_ON)
def handle_time_stop_on(character_id: int) -> int:
    """时停开启中"""
    return cache.time_stop_mode

@add_premise(constant_promise.Premise.TIME_STOP_OFF)
def handle_time_stop_off(character_id: int) -> int:
    """时停关闭中"""
    return not cache.time_stop_mode
```

#### 5.3 移动前提
```python
@add_premise(constant_promise.Premise.TIME_STOP_JUDGE_FOR_MOVE)
def handle_time_stop_judge_for_move(character_id: int) -> int:
    """(移动用)未开启时停，或时停开启且有中级时停"""
    if handle_time_stop_off(character_id):
        return 1
    else:
        return handle_intermediate_time_stop(character_id)
```

### 6. 时停搬运系统

#### 6.1 搬运机制
广域时停解锁后可以搬运角色：

```python
# 搬运状态记录
character_data.pl_ability.carry_chara_id_in_time_stop = target_character_id

# 搬运前提判断
@add_premise(constant_promise.Premise.NOT_CARRY_ANYBODY_IN_TIME_STOP)
def handle_not_carry_anybody_in_time_stop(character_id: int) -> int:
    """没有在时停中搬运干员"""
    pl_character_data = cache.character_data[0]
    return 0 if pl_character_data.pl_ability.carry_chara_id_in_time_stop > 0 else 1
```

#### 6.2 搬运指令
- **搬运对方**：将目标设置为搬运状态
- **停止搬运对方**：清除搬运状态

### 7. 自由活动系统（未实装）

#### 7.1 设计概念
完全时停解锁后，可以让指定角色在时停中自由活动：

```python
# 自由活动状态记录
character_data.pl_ability.free_in_time_stop_chara_id = target_character_id

# 理智消耗
character_data.sanity_point = max(character_data.sanity_point - 50, 0)
```

#### 7.2 前提判断
```python
@add_premise(constant_promise.Premise.SELF_FREE_IN_TIME_STOP)
def handle_self_free_in_time_stop(character_id: int) -> int:
    """自己是在时停中自由活动的干员"""
    pl_character_data = cache.character_data[0]
    if character_id > 0 and character_id == pl_character_data.pl_ability.free_in_time_stop_chara_id:
        return 1
    return 0
```

### 8. 时停绝顶系统

#### 8.1 时停绝顶计数
每个角色维护时停状态下的绝顶计数：
```python
# 数据结构
chara_data.h_state.time_stop_orgasm_count[state_id] = 0

# 重置机制
for state_id in game_config.config_character_state:
    if game_config.config_character_state[state_id].type == 0:
        chara_data.h_state.time_stop_orgasm_count[state_id] = 0
```

#### 8.2 时停解放
```python
@settle_behavior.add_settle_behavior_effect(constant_effect.BehaviorEffect.TIME_STOP_ORGASM_RELEASE)
def handle_time_stop_orgasm_release():
    """（解除时停）交互对象变为时停解放状态，结算时停绝顶和时停精液"""
    for chara_id in cache.npc_id_got:
        if chara_id == 0:
            continue
        character_data = cache.character_data[chara_id]
        character_data.h_state.time_stop_release = True
```

### 9. 指令系统集成

#### 9.1 时停控制指令

**时间停止流动**
```python
@add_instruct(
    constant.Instruct.TIME_STOP_ON,
    constant.InstructType.ARTS,
    _("时间停止流动"),
    {constant_promise.Premise.PRIMARY_TIME_STOP,
     constant_promise.Premise.TIME_STOP_OFF,
     constant_promise.Premise.SANITY_POINT_G_0,
     constant_promise.Premise.TIRED_LE_84},
    constant.Behavior.TIME_STOP_ON,
)
```

**时间重新流动**
```python
@add_instruct(
    constant.Instruct.TIME_STOP_OFF,
    constant.InstructType.ARTS,
    _("时间重新流动"),
    {constant_promise.Premise.PRIMARY_TIME_STOP,
     constant_promise.Premise.TIME_STOP_ON,
     constant_promise.Premise.TIRED_LE_84},
    constant.Behavior.TIME_STOP_OFF,
)
```

#### 9.2 搬运指令

**搬运对方**
```python
@add_instruct(
    constant.Instruct.CARRY_TARGET,
    constant.InstructType.ARTS,
    _("搬运对方"),
    {constant_promise.Premise.INTERMEDIATE_TIME_STOP,
     constant_promise.Premise.NOT_H,
     constant_promise.Premise.TIME_STOP_ON,
     constant_promise.Premise.NOT_CARRY_ANYBODY_IN_TIME_STOP,
     constant_promise.Premise.HAVE_TARGET,
     constant_promise.Premise.TIRED_LE_84},
    constant.Behavior.CARRY_TARGET,
)
```

#### 9.3 时停状态限制

许多指令在时停状态下被限制或解锁：
- **睡觉**：要求 `TIME_STOP_OFF`（时停时无法睡觉）
- **移动**：要求 `TIME_STOP_JUDGE_FOR_MOVE`（需要中级时停才能在时停中移动）
- **绝顶相关**：要求 `TIME_STOP_OFF`（时停时无法进行绝顶控制）

### 10. 无意识状态管理

#### 10.1 无意识状态类型
```python
unconscious_list = [
    _("无"),         # 0
    _("睡眠"),       # 1
    _("醉酒"),       # 2
    _("时停"),       # 3 - 时停状态
    _("平然催眠"),   # 4
    _("空气催眠"),   # 5
    _("体控催眠"),   # 6
    _("心控催眠"),   # 7
]
```

#### 10.2 时停无意识状态
- **状态值**：`sp_flag.unconscious_h = 3`
- **效果**：角色处于完全静止状态，无法进行任何行动
- **恢复**：时停关闭时自动恢复正常状态

### 11. 与其他系统的交互

#### 11.1 角色行为系统
- **时停开启**：暂停所有NPC的行为循环
- **时停关闭**：恢复正常的行为时间流
- **时间回退**：玩家行动后回退时间，保持时停效果

#### 11.2 经验系统
- **时姦经验**：时停状态下的性行为获得特殊经验
- **解锁条件**：时姦经验是广域时停的解锁条件之一

#### 11.3 理智系统
- **持续消耗**：时停状态下每分钟消耗2理智
- **自由活动**：让角色在时停中自由活动额外消耗50理智

#### 11.4 前提判断系统
- **状态检测**：各种指令通过前提判断检测时停状态
- **能力验证**：验证玩家是否拥有对应等级的时停能力

### 12. 数据结构

#### 12.1 全局状态
```python
class Cache:
    time_stop_mode: bool = False  # 时停模式开关
```

#### 12.2 玩家能力数据
```python
class PlAbility:
    carry_chara_id_in_time_stop: int = 0      # 时停中搬运的角色ID
    free_in_time_stop_chara_id: int = 0       # 时停中自由活动的角色ID
```

#### 12.3 角色状态数据
```python
class SpFlag:
    unconscious_h: int = 0  # 无意识状态（3为时停状态）

class HState:
    time_stop_orgasm_count: Dict[int, int] = {}  # 时停绝顶计数
    time_stop_release: bool = False              # 时停解放状态
```

### 13. 开发注意事项

#### 13.1 时间一致性
- 时停状态下必须确保时间回退机制正常工作
- 所有时间相关的计算都要考虑时停状态

#### 13.2 状态同步
- 时停开启/关闭时必须同步更新所有相关角色的状态
- 无意识状态的切换要与时停状态保持一致

#### 13.3 前提判断
- 所有涉及时停的指令都必须添加适当的前提判断
- 前提函数要考虑各种边界情况

#### 13.4 性能考虑
- 时停状态下跳过NPC行为循环，提高性能
- 避免在时停状态下进行不必要的计算

### 14. 扩展性设计

#### 14.1 未实装功能
- **完全时停**：高级时停能力
- **自由活动系统**：允许指定角色在时停中正常行动
- **时停中的特殊交互**：更多时停状态下的专属行为

#### 14.2 配置扩展
- 时停相关的所有数值都可以通过配置表调整
- 新的时停等级可以通过扩展素质系统添加

#### 14.3 状态扩展
- 可以添加更多类型的时停状态
- 支持部分时停、选择性时停等高级功能

## 总结

时间停止系统是erArk中最复杂的源石技艺系统之一，它通过全局状态管理、精确的时间控制、完善的前提判断和丰富的交互机制，为玩家提供了独特的游戏体验。该系统的设计充分考虑了与其他游戏系统的协调，确保了游戏整体的平衡性和一致性。