# 收藏品系统说明

## 系统概述

收藏品系统是erArk游戏中的重要功能模块，允许玩家收集不同类型的物品并获得相应的奖励。系统主要包含三大收藏品类型：**信物**、**内裤**、**袜子**，每种收藏品都有对应的解锁奖励机制。

## 核心数据结构

### PLAYER_COLLECTION 类 (`Script/Core/game_type.py:717`)

玩家收集品数据的核心结构体，包含以下关键字段：

```python
class PLAYER_COLLECTION:
    collection_bonus: Dict[int, bool]      # 收藏品的解锁奖励状态
    token_list: Dict[int, bool]            # 获得的NPC信物列表
    first_panties: Dict[int, str]          # 获得的处子血胖次
    npc_panties: Dict[int, list]           # 获得的角色胖次（永久）
    npc_panties_tem: Dict[int, list]       # 临时获得的角色胖次
    npc_socks: Dict[int, list]             # 获得的角色袜子（永久）
    npc_socks_tem: Dict[int, list]         # 临时获得的角色袜子
    eqip_token: List                       # 装备的信物 [可装备数量, 已装备列表]
    milk_total: Dict[int, int]             # 收集的各角色总乳汁量
    urine_total: Dict[int, int]            # 收集的各角色总圣水量
```

### Collection_bouns 类 (`Script/Config/config_def.py:400`)

收藏品奖励配置数据结构：

```python
class Collection_bouns:
    cid: int           # 奖励id
    type: str          # 收藏物类型（信物/内裤/袜子）
    count: int         # 解锁所需的收藏数量
    effect_1: int      # 奖励数据1（通常为至纯源石数量）
    effect_2: int      # 奖励数据2（信物装备上限等）
    effect_3: int      # 奖励数据3（预留）
    info: str          # 奖励信息描述
```

## 数据文件配置

### 收藏品奖励配置 (`data/csv/Collection_bouns.csv`)

定义收藏品解锁奖励的阶梯机制：

**信物奖励**：
- 1个：获得1至纯源石，装备上限提升至1
- 5个：获得3至纯源石，装备上限提升至3
- 10个：获得5至纯源石，装备上限提升至5
- 15/20/50/100个：逐步提升奖励和装备上限

**内裤奖励**：
- 10条：获得1至纯源石
- 30条：解锁"索要内裤"指令
- 100条：解锁情趣内衣服装类型（未实装）

**袜子奖励**：
- 10双：获得1至纯源石
- 30双：解锁"索要袜子"指令
- 100双：解锁袜子风潮服装类型（未实装）

### 服装模板配置 (`data/csv/ClothingTem.csv`)

定义所有可收集的服装物品，通过 `clothing_type` 字段区分类型：
- `clothing_type = 9`：内裤
- `clothing_type = 10`：袜子

### 服装类型配置 (`data/csv/ClothingType.csv`)

定义服装部位的属性和流通机制：
- 内裤（cid=9）：容积5-50-100，流通到私处相关部位
- 袜子（cid=10）：容积10-50-150-300-600，流通到脚部相关部位

## 核心功能模块

### 1. 收藏品面板 (`Script/UI/Panel/collection_panel.py`)

主要提供收藏品的展示和管理界面：

#### Collection_Panel 类
- **三大页面**：信物、内裤、袜子的分页显示
- **统计功能**：实时统计各类收藏品数量
- **奖励管理**：显示解锁条件和领取奖励
- **数据展示**：按角色分类显示收藏品详情

#### 关键方法：
- `draw()`：绘制主界面和各分页内容
- `change_panel()`：切换不同收藏品类型的显示
- `get_bonus()`：检查条件并领取解锁奖励
- `refresh_all_bonus()`：刷新所有未获得的解锁奖励

### 2. 收藏品处理函数

#### `collapse_collection()` 函数
负责将临时收藏品转移到永久收藏：

```python
def collapse_collection():
    """收起收集品 - 将临时收藏转为永久收藏"""
    # 处理内裤收集
    for npc_id in character_data.pl_collection.npc_panties_tem:
        for pan_id in character_data.pl_collection.npc_panties_tem[npc_id]:
            # 获取内裤名称并添加到永久收藏
            character_data.pl_collection.npc_panties[npc_id].append(pan_name)
    
    # 处理袜子收集（同样机制）
    # 清空临时收藏
```

### 3. 奖励刷新机制

#### `refresh_all_bonus()` 函数
在面板打开时自动刷新解锁状态：

```python
def refresh_all_bonus():
    """刷新所有未获得的解锁奖励"""
    for bonus_id in game_config.config_collection_bonus_data:
        if pl_character.pl_collection.collection_bonus[bonus_id]:
            # 刷新信物装备上限
            pl_character.pl_collection.eqip_token[0] = max(current, bonus_effect)
```

## 数据流转机制

### 收集流程
1. **临时收集**：游戏过程中获得的物品存储在 `*_tem` 字段中
2. **确认收集**：通过 `collapse_collection()` 将临时物品转移到永久收藏
3. **数量统计**：面板显示时实时统计各类收藏品数量
4. **奖励检查**：根据统计数量检查是否满足解锁条件

### 奖励领取流程
1. **条件检查**：比对收集数量与所需数量
2. **状态更新**：标记奖励为已获得状态
3. **效果应用**：发放至纯源石、提升装备上限等
4. **界面反馈**：显示获得奖励的提示信息

## 关联系统

### 1. 服装系统 (`Script/Design/clothing.py`)
- 提供收藏品的来源（角色穿着的服装）
- 通过服装模板配置收藏品属性

### 2. 角色系统
- 每个NPC都可以提供对应的收藏品
- 信物系统与角色好感度和特殊事件关联

### 3. 指令系统 (`Script/Design/handle_instruct.py`)
- "索要内裤"、"索要袜子"等指令的解锁
- 通过收藏品奖励扩展玩家可用指令

### 4. 资源系统
- 至纯源石作为收藏品奖励的主要资源
- 用于源石技艺的获得和升级

## 存档数据结构

收藏品数据通过 `Script/Core/save_handle.py` 进行存储，主要包含：

```python
# 存档中的收藏品数据
character_data.pl_collection = {
    'collection_bonus': {奖励ID: 是否已获得},
    'token_list': {角色ID: 是否获得信物},
    'first_panties': {角色ID: 处子内裤名称},
    'npc_panties': {角色ID: [内裤名称列表]},
    'npc_socks': {角色ID: [袜子名称列表]},
    'eqip_token': [装备上限, [已装备角色ID列表]]
}
```

## 开发扩展点

### 1. 新增收藏品类型
- 在 `PLAYER_COLLECTION` 类中添加新的字段
- 在 `Collection_bouns.csv` 中配置对应奖励
- 在面板代码中添加新的页面处理逻辑

### 2. 奖励效果扩展
- 通过 `effect_3` 字段扩展更多奖励类型
- 在 `get_bonus()` 方法中添加新的奖励处理逻辑

### 3. 收集机制优化
- 支持更复杂的收集条件（如特定角色、特定情况下获得）
- 添加收藏品品质系统（普通、珍贵、传说等）

## 技术实现细节

### 界面渲染
- 使用 `draw` 模块的各种绘制类进行界面构建
- 支持按钮交互和分页显示
- 自适应窗口宽度的文本排版

### 数据持久化
- 通过游戏存档系统自动保存收藏进度
- 支持存档版本兼容和数据迁移

### 性能优化
- 延迟加载收藏品数据
- 按需刷新奖励状态
- 优化大量收藏品的显示性能

## 调试和测试

### Debug模式支持
- `cache.debug_mode` 可跳过收藏条件直接解锁奖励
- 便于开发测试和内容验证

### 数据验证
- 检查服装模板配置的完整性
- 验证收藏品数量统计的准确性
- 确保奖励发放的正确性

该收藏品系统为游戏提供了丰富的收集要素和进度激励，通过合理的奖励机制鼓励玩家探索游戏内容，同时为后续功能扩展预留了充足的设计空间。