# 指令面板系统

## 概述

指令面板系统（`see_instruct_panel.py`）是 erArk 游戏中负责显示和管理玩家可执行指令的核心 UI 组件。该系统提供了复杂的指令过滤、分类显示和交互功能，是玩家与游戏进行互动的主要界面。

## 核心组件

### 1. 主要类

#### `SeeInstructPanel` 类
- **位置**: `Script/UI/Panel/see_instruct_panel.py`
- **功能**: 绘制和管理指令面板的主类
- **初始化**: 接收绘制宽度参数，初始化各种过滤器

### 2. 核心函数

#### `judge_single_instruct_filter()`
- **功能**: 判断单个指令是否通过过滤条件
- **参数**:
  - `instruct_id`: 指令 ID
  - `now_premise_data`: 当前前提数据
  - `now_type`: 当前指令类型
  - `use_type_filter_flag`: 是否使用类型过滤
  - `skip_h_judge`: 是否跳过 H 类指令判断
  - `skip_not_h_judge`: 是否跳过非 H 类指令判断
- **返回**: 过滤结果和更新的前提数据

## 数据源和配置

### CSV 配置文件

#### `InstructType.csv`
```csv
cid,name,color
0,系统,standard
1,日常,shadow_green
2,娱乐,light_french_beige
3,工作,grullo
4,技艺,light_steel_blue
5,猥亵,pale_chestnut
6,性爱,amarath_pink
```

#### `Instruct_Sex_Type.csv`
```csv
cid,name,color
0,基础,light_pink
1,侍奉,pastel_magenta
2,药物,princess_perfume
3,道具,rose_pink
4,插入,deep_pink
5,SM,crimson
6,技艺,light_steel_blue
```

### 常量定义

#### 指令类型常量 (`constant.py`)
```python
class InstructType:
    SYSTEM = 0      # 系统
    DAILY = 1       # 日常
    PLAY = 2        # 娱乐
    WORK = 3        # 工作
    ARTS = 4        # 技艺
    OBSCENITY = 5   # 猥亵
    SEX = 6         # 性爱

class SexInstructSubType:
    BASE = 0        # 基础
    WAIT_UPON = 1   # 侍奉
    DRUG = 2        # 药物
    ITEM = 3        # 道具
    INSERT = 4      # 插入
    SM = 5          # SM
    ARTS = 6        # 技艺
```

## 数据流处理

### 1. 指令数据初始化

```
CSV 文件 → buildconfig.py → JSON 配置 → 常量定义 → 缓存数据
```

1. **CSV 读取**: 从 `data/csv/InstructType.csv` 等文件读取配置
2. **数据编译**: `buildconfig.py` 将 CSV 转换为 JSON 和 Python 常量
3. **运行时加载**: 游戏启动时加载到 `cache` 中

### 2. 指令过滤流程

```
指令列表 → 类型过滤 → 前提检查 → 显示条件判断 → 最终显示列表
```

#### 过滤阶段：

1. **类型过滤**: 根据 `cache.instruct_type_filter` 过滤指令类型
2. **H 模式过滤**: 根据当前游戏状态判断是否显示 H 类指令
3. **前提检查**: 使用 `handle_premise.py` 检查指令前提条件
4. **特殊状态过滤**: 根据角色状态（如临盆、产后等）过滤不适用指令

### 3. 指令执行流程

```
用户点击 → handle_instruct() → 指令处理器 → 行为结算 → 状态更新
```

## 核心系统集成

### 1. 前提系统集成

- **文件**: `Script/Design/handle_premise.py`
- **功能**: 检查指令显示的前提条件
- **集成点**: `judge_single_instruct_filter()` 函数中调用

### 2. 指令处理系统集成

- **文件**: `Script/Design/handle_instruct.py`
- **功能**: 处理玩家选择的指令
- **集成点**: `handle_instruct()` 和 `handle_chara_diy_instruct()` 方法

### 3. 事件系统集成

- **文件**: `Script/UI/Panel/event_option_panel.py`
- **功能**: 处理角色自定义指令
- **集成点**: `get_target_chara_diy_instruct()` 函数获取角色专属指令

### 4. 主界面集成

- **文件**: `Script/UI/Panel/in_scene_panel.py`
- **使用方式**:
```python
instruct_panel = see_instruct_panel.SeeInstructPanel(self.width)
instruct_panel.draw()
ask_list.extend(instruct_panel.return_list)
```

## 缓存数据结构

### 过滤器相关缓存

```python
cache.instruct_type_filter = {
    0: 1,  # 系统指令开启
    1: 1,  # 日常指令开启
    2: 1,  # 娱乐指令开启
    # ...
}

cache.instruct_sex_type_filter = {
    0: 1,  # 基础H指令开启
    1: 0,  # 侍奉H指令关闭
    # ...
}

cache.instruct_index_filter = {
    指令ID: 1,  # 1=显示, 0=隐藏
    # ...
}
```

### 指令数据缓存

```python
constant.instruct_type_data = {
    指令类型ID: {指令ID集合},
    # ...
}

constant.instruct_premise_data = {
    指令ID: {前提集合},
    # ...
}

constant.handle_instruct_name_data = {
    指令ID: "指令显示名称",
    # ...
}
```

## 显示逻辑

### 1. 指令分类显示

- **H 模式**: 显示性爱子类型按钮
- **普通模式**: 显示主要指令类型按钮
- **特殊状态**: 根据角色状态自动隐藏不适用的指令类型

### 2. 颜色系统

- 每个指令类型都有对应的颜色配置
- 已选择的类型按钮显示为彩色
- 未选择的类型按钮显示为灰色

### 3. 布局算法

- 根据 `SINGLE_LINE_INSTRUCT_NUM` 设置每行显示的指令数量
- 使用 `DrawTextListPanel` 进行自动换行和布局

## 扩展机制

### 1. 角色自定义指令

- 通过事件系统支持角色专属指令
- 动态生成指令按钮
- 支持角色特定的颜色主题

### 2. 前提系统扩展

- 支持复杂的前提逻辑判断
- 可以添加新的前提类型
- 支持综合数值前提（CVP）

### 3. 指令处理器扩展

- 使用装饰器模式注册新指令
- 支持指令类型、名称、前提、行为 ID 的灵活配置

## 性能优化

### 1. 前提计算缓存

- 使用 `now_premise_data` 缓存已计算的前提结果
- 避免重复计算相同的前提条件

### 2. 绘制优化

- 记录绘制时间用于性能监控
- 使用面板复用减少重复创建

## 调试支持

### 1. Debug 模式

- `cache.debug_mode` 开启时强制显示所有指令
- 便于开发和测试

### 2. 日志记录

- 记录指令面板绘制时间
- 支持性能分析和优化

## 总结

指令面板系统是一个高度集成的复杂系统，它：

1. **连接多个子系统**: 前提系统、指令处理系统、事件系统等
2. **提供灵活的过滤机制**: 支持多层级的指令过滤
3. **支持动态扩展**: 可以轻松添加新的指令类型和处理逻辑
4. **优化用户体验**: 根据游戏状态自动调整显示内容
5. **性能友好**: 使用缓存和优化算法确保流畅的用户交互

该系统是 erArk 游戏用户界面的核心组件，为玩家提供了直观、高效的游戏操作体验。