# 招募系统

## 系统概述

招募系统是erArk游戏中罗德岛基地管理的核心子系统之一，负责管理干员的招募流程、招募策略和招募专员的工作安排。该系统通过文职部设施提供功能支持，允许玩家按照不同策略招募新的干员角色。

## 核心文件结构

### 主要代码文件
- **`Script/UI/Panel/recruit_panel.py`** - 招募面板主要逻辑和UI展示
- **`Script/Design/handle_premise.py`** - 包含招募相关的前提条件判断函数
- **`Script/Core/game_type.py`** - 定义招募相关的数据结构
- **`Script/Config/game_config.py`** - 招募策略配置数据管理
- **`Script/Config/config_def.py`** - 招募策略数据类定义

### 配置数据文件
- **`data/csv/Recruitment_Strategy.csv`** - 招募策略配置表
- **`data/csv/Facility.csv`** - 设施基础信息配置
- **`data/csv/Facility_effect.csv`** - 设施效果和等级配置
- **`data/talk/work/recruit.csv`** - 招募工作相关的口上文本

## 数据结构分析

### 核心数据结构

#### 1. 招募线数据 (recruit_line)
```python
# 位置: Script/Core/game_type.py line 1035
self.recruit_line: Dict[int, Tuple[float, int, set, float]] = {}
# 结构: 招募线id -> [招募进度, 招募策略id, 负责干员id集合, 招募效率百分比]
```

#### 2. 招募策略配置 (Recruitment_Strategy)
```python
# 位置: Script/Config/config_def.py line 1004
class Recruitment_Strategy:
    cid: int          # 招聘策略id
    name: str         # 招聘策略名
    introduce: str    # 招聘策略介绍
```

#### 3. 设施等级数据 (facility_level)
```python
# 位置: Script/Core/game_type.py line 941
self.facility_level: Dict[int, Tuple[int]] = {}
# 结构: 设施id -> 等级
```

### 招募策略类型 (CSV配置)
| 策略ID | 策略名称 | 功能描述 | 实装状态 |
|--------|----------|----------|----------|
| 0 | 随机招募当地干员 | 仅招募当前所在地的干员 | ✅ 已实装 |
| 1 | 招募全泰拉干员 | 招募范围扩大至全泰拉 | ✅ 已实装 |
| 2 | 招募关联干员 | 限定同势力干员 | ❌ 未实装 |
| 3 | 招募指定干员 | 指定特定干员 | ❌ 未实装 |
| 4 | 招募路人干员 | 招募NPC角色 | ❌ 未实装 |
| 11 | 停止招募 | 暂停招募活动 | ✅ 已实装 |

## 系统工作流程

### 1. 招募进度更新 (`update_recruit()`)

```python
# 触发条件: 定期调用，检查招募进度
# 位置: recruit_panel.py line 57-104

for recruit_line_id in cache.rhodes_island.recruit_line:
    if 招募进度 >= 100:
        # 完成招募，重置进度
        cache.rhodes_island.recruit_line[recruit_line_id][0] = 0
        
        # 根据招募策略筛选候选干员
        if recruitment_strategy == 0:  # 本地招募
            筛选出生地匹配的干员
        elif recruitment_strategy == 1:  # 全泰拉招募
            包含所有可招募干员
            
        # 随机选择一个干员加入已招募列表
        choice_id = random.choice(wait_id_list)
        cache.rhodes_island.recruited_id.add(choice_id)
```

### 2. 可招募干员筛选 (`find_recruitable_npc()`)

```python
# 筛选条件:
# - 不在已有干员列表中 (not in cache.npc_id_got)
# - 不是女儿角色 (Mother_id == 0 and AdvNpc <= 9000)
# - 角色数据存在 (in cache.character_data)
# - 非离线异常状态 (handle_normal_7)
# - 不在禁止NPC名单 (not in constant.ban_NPC_name_set)
# - 符合禁止干员设置 (base_setting[7] 检查)
```

### 3. 招募效率计算

```python
# 基础效率 = Σ(干员话术技能等级 * 5 * 能力调整系数)
# 最终效率 = 基础效率 * (1 + 设施效果/100)

character_effect = 5 * attr_calculation.get_ability_adjust(character_data.ability[40])
all_effect *= 1 + (facility_effect / 100)
```

## UI界面组件

### 主要面板功能

#### 1. 招募总览面板 (`Recruit_Panel.draw()`)
- 显示设施等级和招募线数量
- 显示当前国家可招募干员数量
- 显示已招募待确认的干员列表
- 各招募线的进度和策略展示

#### 2. 策略选择面板 (`select_recruitment_strategy()`)
- 根据文职部等级解锁可用策略
- 动态显示策略介绍和功能说明
- 支持策略切换和停止招募

#### 3. 工位调整面板 (`select_npc_position()`)
- 显示所有招募专员 (工作类型为71-人事)
- 支持干员在不同招募线间调动
- 实时显示各线人员配置和效率

### 关键UI交互流程

```python
# 1. 策略调整按钮
button_draw = draw.CenterButton(
    _(" [调整策略] "),
    cmd_func=self.select_recruitment_strategy,
    args=recruit_line_id
)

# 2. 人员调整功能
button_draw = draw.LeftButton(
    _("[002]工位调整"),
    cmd_func=self.select_npc_position
)

# 3. 专员选择按钮
button_draw = draw.CenterButton(
    _(" [{0}(话术lv{1}:{2}%)] "),
    cmd_func=self.settle_npc_id,
    args=chara_id
)
```

## 设施依赖关系

### 文职部设施配置
- **设施ID**: 7 (文职部)
- **等级效果**: 影响可用招募线数量和策略解锁
- **效率加成**: 每级提供不同的招募效率加成

| 等级 | 招募线数量 | 效率加成 | 解锁策略 |
|------|------------|----------|----------|
| 1 | 1条 | 0% | 随机招募当地干员 |
| 2 | 2条 | 5% | 招募全泰拉干员 |
| 3 | 3条 | 10% | 招募关联干员 |
| 4 | 4条 | 20% | 招募指定干员 |
| 5 | 5条 | 50% | 招募路人干员 |

### 人员配置限制
```python
# 每条招募线的人员上限
self.max_hr_in_line = now_level * 2  # 等级 * 2
```

## 与其他系统的交互

### 1. 角色管理系统
- **角色数据读取**: 从 `cache.character_data` 获取干员信息
- **角色能力计算**: 调用 `attr_calculation.get_ability_adjust()` 计算话术技能效果
- **工作类型检查**: 通过 `handle_premise.handle_work_is_hr()` 判断是否为招募专员

### 2. 基地管理系统  
- **设施等级**: 依赖 `cache.rhodes_island.facility_level[7]` 文职部等级
- **人员调动**: 调用 `basement.get_base_updata()` 更新基地状态
- **访客系统**: 排除访客角色参与招募工作

### 3. 前提条件系统
- **角色状态检查**: `handle_premise.handle_normal_7()` 检查角色可用性
- **工作类型验证**: `handle_premise.handle_work_is_hr()` 确认招募专员身份

### 4. 配置系统
- **策略数据**: 从 `game_config.config_recruitment_strategy` 加载
- **设施效果**: 从 `game_config.config_facility_effect_data` 和 `config_facility_effect` 获取

## 业务逻辑要点

### 1. 招募条件限制
- 干员必须不在当前队伍中
- 非女儿角色 (通过 Mother_id 和 AdvNpc 判断)
- 角色数据完整且非异常状态
- 符合玩家设置的招募限制

### 2. 效率计算机制
- 基于招募专员的话术技能等级 (ability[40])
- 设施等级提供乘法加成
- 停止招募状态时效率归零

### 3. 策略实现差异
- **本地招募**: 严格按出生地筛选
- **全泰拉招募**: 包含所有符合条件的干员
- **其他策略**: 当前均回退到全泰拉招募逻辑

### 4. 数据持久化
- 招募进度实时保存在 `cache.rhodes_island.recruit_line`
- 已招募干员暂存在 `cache.rhodes_island.recruited_id`
- 需要玩家手动确认才会正式加入队伍

## 扩展和优化建议

### 1. 未实装功能
- 招募关联干员 (同势力筛选)
- 招募指定干员 (精确指定)
- 招募路人干员 (NPC转换)

### 2. 性能优化
- 可招募干员列表可以缓存，减少重复计算
- 效率计算可以在人员变动时才重算
- UI刷新可以采用增量更新机制

### 3. 用户体验
- 增加招募预览功能
- 提供更详细的策略说明
- 支持批量操作和预设配置

这个招募系统展现了游戏中复杂的模拟经营机制，通过多层次的配置、计算和交互，为玩家提供了丰富的基地管理体验。