# 成就系统

## 1. 主要文件与结构

- **成就面板主代码**：`Script/UI/Panel/achievement_panel.py`
  - 包含成就结算、判定、提示、面板显示等全部核心逻辑。
- **成就数据表**：`data/csv/Achievement.csv`
  - 以表格形式定义所有成就的ID、名称、类型、难度、数值需求、前置、特殊标志、描述等。

## 2. 成就系统核心流程

### 2.1 成就结算流程
- 入口函数：`achievement_flow(achievement_type: str, achievement_id: int = 0)`
  - 根据成就类型或指定ID，自动判定并结算成就。
  - 支持类型映射（如“关系”“招募”等）和数值映射（如“周目”“龙门币”等）。
  - 结算后调用 `draw_achievement_notice` 显示获得提示。

### 2.2 通用结算与判定
- `settle_achievement(judge_value, achievement_ids, force=False)`
  - 支持单个或批量成就ID判定。
  - 判定条件：未达成且数值满足要求或强制结算。
  - 达成后更新缓存并返回已达成ID列表。

### 2.3 各类型成就结算
- 通过一组 `settle_chara_xxx` 函数实现（如 `settle_chara_relationship`、`settle_chara_recruit` 等）。
  - 每个函数统计相关数据（如爱侣数、招募数、访客数等），批量调用 `settle_achievement`。
  - 特殊类型（如群交、隐奸、睡奸、射精等）有专门的统计与判定逻辑。

### 2.4 成就面板与刷新
- `Achievement_Panel` 类负责成就面板的显示与交互。
  - 支持分页、刷新、成就状态（已达成/未达成/隐藏/前置等）图标与样式。
  - 刷新按钮会重新判定所有成就。

## 3. 成就数据表结构

- `Achievement.csv` 结构：
  - `cid`：成就ID（int）
  - `name`：成就名
  - `type`：成就类型（如“关系”“招募”等）
  - `difficulty`：难度等级
  - `value`：数值需求
  - `pre_id`：前置成就ID
  - `special`：是否为特殊/隐藏成就
  - `todo`：是否未实装
  - `description`：成就描述
- 每条成就数据会被自动加载为配置，供判定与面板显示使用。

## 4. 数据流与缓存

- 游戏缓存（`cache`）中保存所有成就达成状态、统计数据等。
- 成就判定时会实时读取角色、道具、外勤、服装、技能等多种数据。
- 达成成就后，缓存会被更新，面板会即时反映。

## 5. 约定与扩展

- 新增成就：只需在 `Achievement.csv` 添加新行，并在对应类型结算函数中补充判定逻辑。
- 注释与函数说明全部为中文，便于维护。
- 支持隐藏成就、前置成就、批量结算等多种复杂需求。

## 6. 相关依赖与调用

- 依赖 `Script/Core/game_type.py`（数据结构）、`Script/Config/game_config.py`（配置加载）、`Script/UI/Moudle/draw.py`（UI绘制）等。
- 相关数据如角色、道具、外勤、服装等均通过 `cache` 统一访问。

---

本说明文档用于指导开发者理解和扩展成就系统的数据处理与判定流程，详细代码逻辑请参考 `Script/UI/Panel/achievement_panel.py`。
