# 流水线工业制造生产系统说明

## 系统概述

流水线工业制造生产系统是erArk游戏中的核心基地功能之一，负责管理基地内的产品生产、资源消耗和效率优化。该系统通过多条流水线实现药剂、乳制品、香水等不同类型产品的自动化生产。

## 核心文件架构

### 主要代码文件

1. **UI面板文件**：`Script/UI/Panel/manage_assembly_line_panel.py`
   - 主要类：`Manage_Assembly_Line_Panel`
   - 功能：流水线管理界面、生产调整、工人配置

2. **基地逻辑文件**：`Script/Design/basement.py`
   - 功能：基地数据初始化、设施升级逻辑、流水线基础数据管理

3. **数据类型定义**：`Script/Core/game_type.py`
   - 主要类：`Rhodes_Island`
   - 功能：定义基地数据结构，包括流水线状态

### 数据配置文件

1. **产品配方**：`data/csv/ProductFormula.csv`
   - 结构：配方ID、产品ID、原料配方、难度等级
   - 示例：生产感染抑制剂需要普通药材10个，矿石病药材1个

2. **资源配置**：`data/csv/Resource.csv`
   - 结构：资源ID、名称、类型、价格、特产属性等
   - 涵盖：材料、药剂、乳制品、香水四大类别

3. **设施效果**：`data/csv/Facility_effect.csv`
   - 结构：设施ID、等级、效果数值、耗电量等
   - 功能：定义制造加工区不同等级的生产效率加成

## 数据结构详解

### 流水线数据结构

在`Rhodes_Island`类中定义：
```python
self.assembly_line: Dict[int, Tuple[int, set, int ,int]] = {}
```

数据格式：`流水线id:[0生产类型id, 1负责该线的干员id集合, 2总效率百分比, 3明日要变成的新生产类型, 4上次收菜的小时]`

### 产品配方数据结构

配方格式解析：
- 单一原料：`"11|10"` = 需要11号资源10个
- 多种原料：`"11|10&12|1"` = 需要11号资源10个AND 12号资源1个

### 资源分类体系

1. **材料类**（原料）
   - 普通药材(11)、矿石病药材(12)、工业材料(13)等

2. **药剂类**（产品）
   - 常规药物(21)、感染抑制剂小样(22)、感染抑制合剂(23)等

3. **乳制品类**（产品）
   - 鲜母乳(31)、母乳酸奶(32)、母乳奶片(33)等

4. **香水类**（产品）
   - 浓缩香精(41)、普通香水(42)、高级香水(43)等

## 核心功能模块

### 1. 流水线结算系统

**函数**：`settle_assembly_line(newdayflag=False, draw_flag=True)`

**功能流程**：
1. **时间计算**：计算自上次结算以来的时间差
2. **效率计算**：基地效率 + 设施效果 - 设备损坏
3. **原料检查**：验证每种原料的库存是否足够
4. **生产结算**：
   - 消耗原料：根据配方和生产数量扣除材料
   - 生产产品：将成品添加到仓库
   - 容量限制：检查仓库容量上限

**计算公式**：
```python
# 最大生产数量
produce_num_max = int(max_time * produce_effect * adjust)

# 实际生产数量（受原料限制）
for need_type in formula_data_now:
    now_type_max_produce_num = materials_resouce[need_type] // formula_data_now[need_type]
    produce_num = min(produce_num, now_type_max_produce_num)
```

### 2. 生产效率计算

**基础效率**：100%（基准值）

**设施加成**：
- 制造加工区等级1：0%
- 制造加工区等级2：5%
- 制造加工区等级3：10%
- 制造加工区等级4：20%
- 制造加工区等级5：50%

**干员加成**：
```python
character_effect = int(10 * attr_calculation.get_ability_adjust(character_data.ability[48]))
```
- 基于干员的制造能力(ability[48])
- 每级制造能力提供10%效率加成

**设备损坏影响**：
```python
damage_down = cache.rhodes_island.facility_damage_data[facility_str] * 2
adjust = (cache.rhodes_island.effectiveness - damage_down) / 100
```

### 3. 工人管理系统

**工人筛选条件**：
- 工作类型必须为121（生产工人）
- 排除玩家角色（ID=0）
- 排除访客角色

**工位调整功能**：
- 查看当前各流水线的工人配置
- 选择要调整的工人
- 指定目标流水线
- 执行工人转移

### 4. 生产配方管理

**配方解锁条件**：
```python
if formula_data.difficulty > now_level:
    flag_open = False
```
- 制造加工区等级必须达到配方要求的难度等级

**配方显示逻辑**：
- 按资源类型分组（药剂、乳制品、香水）
- 支持折叠/展开显示
- 显示生产消耗详情

## 系统交互关系

### 与其他系统的关联

1. **基地设施系统**
   - 依赖制造加工区等级解锁流水线数量
   - 受仓储区等级影响库存容量
   - 受动力区影响总体基地效率

2. **角色工作系统**
   - 工人能力影响生产效率
   - 工作类型决定参与资格
   - 工作时间影响生产持续性

3. **资源管理系统**
   - 消耗原料材料
   - 生产成品资源
   - 受仓库容量限制

4. **时间系统**
   - 自动按小时结算生产
   - 支持跨天计算
   - 记录上次结算时间

### 数据流向图

```
原料库存 → 配方需求检查 → 生产计算 → 成品入库
    ↑           ↓             ↑         ↓
设施等级 → 效率计算 ← 干员能力    仓库容量检查
    ↑           ↓
时间差计算 → 最大生产量
```

## 用户界面功能

### 主界面显示

1. **仓库状态**：
   - 当前仓库等级和容量
   - 各类资源的库存数量

2. **流水线状态**：
   - 当前生产的产品
   - 生产效率加成详情
   - 工人配置情况
   - 原料消耗信息

3. **操作按钮**：
   - [生产调整]：切换生产产品
   - [工人增减]：调整工人数量
   - [工位调整]：重新分配工人

### 交互流程

1. **生产调整流程**：
   ```
   选择流水线 → 查看可生产产品 → 按类型筛选 → 选择新产品 → 确认更改
   ```

2. **工位调整流程**：
   ```
   选择工人 → 查看当前配置 → 选择目标流水线 → 确认调整 → 更新基地数据
   ```

## 技术实现要点

### 性能优化

1. **批量计算**：所有流水线在同一个函数中统一结算
2. **缓存机制**：使用缓存存储计算结果，避免重复计算
3. **按需更新**：只在状态变更时重新计算基地数据

### 错误处理

1. **原料不足**：自动调整生产数量，不会产生负库存
2. **仓库满载**：限制产品数量至容量上限
3. **配方无效**：检查配方ID有效性和解锁状态

### 扩展性设计

1. **模块化结构**：UI层、逻辑层、数据层清晰分离
2. **配置驱动**：通过CSV文件配置产品和配方，无需修改代码
3. **事件系统**：支持生产完成事件触发其他系统响应

## 开发维护指南

### 添加新产品流程

1. 在`Resource.csv`中添加新资源定义
2. 在`ProductFormula.csv`中添加生产配方
3. 重新构建配置数据：`python buildconfig.py`
4. 测试生产流程和界面显示

### 调试建议

1. 开启debug模式查看详细计算过程
2. 检查流水线数据结构的完整性
3. 验证资源ID和配方ID的一致性
4. 监控生产效率计算的准确性

该系统为游戏提供了完整的自动化生产体验，通过合理的资源管理和效率优化，玩家可以构建高效的生产链条。