# 导航系统

## 系统概述

导航系统是erArk游戏中罗德岛基地在地图上移动的核心功能模块。该系统主要由导航面板UI、基地移动机制、地图数据处理和角色移动处理四个部分组成。

## 核心文件结构

### 主要代码文件

1. **导航面板UI层**
   - `Script/UI/Panel/navigation_panel.py` - 导航界面面板，提供基地移动的用户交互界面

2. **角色移动处理层**
   - `Script/Design/character_move.py` - 角色移动逻辑，处理主角在场景间的移动
   - `Script/Design/map_handle.py` - 地图数据处理，提供地图操作相关功能

3. **配置管理层**
   - `Script/Config/game_config.py` - 游戏配置加载和管理
   - `Script/Config/config_def.py` - 配置数据结构定义

### 数据配置文件

1. **CSV配置文件**
   - `data/csv/Birthplace.csv` - 出生地配置（27个出生地，包含罗德岛到各个国家）
   - `data/csv/City.csv` - 城市配置（96个城市，分布在各个国家）
   - `data/csv/MoveMenuType.csv` - 移动菜单类型配置（当前、收藏地点）

2. **地图数据文件**
   - `data/MapData` - 预处理的所有地图数据（二进制格式）
   - `data/PlaceData` - 预处理的所有地点数据（二进制格式）
   - `data/SceneData` - 预处理的所有场景数据（二进制格式）
   - `data/ScenePath` - 寻路路径配置文件
   - `data/map/*/Map.json` - 各个区域的地图配置文件
   - `data/map/*/Scene.json` - 各个场景的具体配置文件

## 系统架构和数据流

### 1. 数据加载流程

```
CSV文件 → buildconfig.py → JSON配置 → game_config.py → 内存中的配置对象
```

1. **配置构建阶段**：
   - `buildconfig.py` 读取CSV文件生成JSON配置
   - 生成配置定义文件 `config_def.py`

2. **运行时加载阶段**：
   - `game_config.py` 加载JSON配置到内存
   - 创建配置对象：`config_birthplace`、`config_city`、`config_move_menu_type`

### 2. 导航面板数据流

```
用户操作 → Navigation_Panel → Base_function_class → 地图数据查询 → 移动处理
```

**关键组件：**

1. **Navigation_Panel类**：
   - 主导航面板，处理地图显示和用户交互
   - 管理当前查看的地图路径 `self.now_map`
   - 绘制地图场景和移动按钮

2. **Base_function_class类**：
   - 提供基础移动功能
   - `move_judge()` - 判断基地是否可以移动到指定场景
   - `move_to_scene()` - 执行基地移动操作

3. **MoveMenuPanel类**：
   - 快捷移动菜单面板
   - 支持不同移动类型切换（当前、收藏地点）

4. **MapSceneNameDraw类**：
   - 绘制指定地图的场景名列表
   - 提供快捷移动按钮

### 3. 基地移动机制

```
用户选择目标 → 燃料检查 → 距离计算 → 确认对话 → 移动执行 → 到达判定
```

**核心流程：**

1. **移动前检查**：
   - 检查是否正在移动中
   - 检查是否为临近地点
   - 检查燃料是否充足

2. **移动参数计算**：
   - 移动距离：基于地图路径边缘数据
   - 移动时间：`7 + 距离 * 3` 天
   - 燃料消耗：`500 * 距离` 单位

3. **移动执行**：
   - 设置移动目标和到达时间：`cache.rhodes_island.move_target_and_time`
   - 扣除燃料：`cache.rhodes_island.materials_resouce[15] -= need_fuel`
   - Debug模式下立即到达

4. **到达判定**：
   - `judge_arrive()` 函数定期检查是否到达
   - 到达后处理外交官状态变更
   - 清零移动目标并显示到达提示

### 4. 地图数据组织

```
泰拉大陆 → 各个国家 → 城市 → 具体场景
```

**数据结构层次：**

1. **出生地配置**（`config_birthplace`）：
   - 国家级别的地点配置
   - 包含27个国家和地区
   - 每个出生地有初始感染率设置

2. **城市配置**（`config_city`）：
   - 城市级别的地点配置
   - 包含96个城市，隶属于不同国家
   - 通过 `country_id` 关联到出生地

3. **地图路径**（`path_edge`）：
   - 存储地点间的连通关系和距离
   - 支持寻路算法计算最短路径
   - 区分临近地点和非直达地点

### 5. 角色移动系统

```
角色选择目标 → 寻路计算 → 移动状态设置 → 行为执行 → 到达处理
```

**与基地移动的区别：**

1. **作用域不同**：
   - 基地移动：国家间的长距离移动
   - 角色移动：场景间的短距离移动

2. **处理机制不同**：
   - 基地移动：基于时间的异步处理
   - 角色移动：基于行为系统的即时处理

## 配置数据结构

### 1. 出生地配置（Birthplace）

```python
class Birthplace:
    cid: int           # 出生地ID
    name: str          # 出生地名
    inmap: int         # 是否出现在大地图中
    infect_rate: float # 初始源石病感染率
```

### 2. 城市配置（City）

```python
class City:
    cid: int        # 城市ID
    name: str       # 城市名
    country_id: int # 所属国家ID
```

### 3. 移动菜单类型（MoveMenuType）

```python
class MoveMenuType:
    cid: int   # 移动类型ID
    name: str  # 名字（当前、收藏地点）
```

## 关键缓存数据

### 1. 罗德岛基地状态

```python
cache.rhodes_island.current_location[0]  # 当前所在国家ID
cache.rhodes_island.current_location[1]  # 当前所在城市ID
cache.rhodes_island.move_target_and_time # [目标国家ID, 预留, 到达时间]
cache.rhodes_island.materials_resouce[15] # 燃料资源数量
```

### 2. 地图数据缓存

```python
cache.map_data[map_path_str]  # 地图数据
map_data.path_edge           # 路径边缘数据（连通性和距离）
map_data.map_draw           # 地图绘制数据
```

## 系统交互流程

### 1. 用户发起移动请求

1. 用户在导航面板点击目标地点按钮
2. 系统调用 `move_judge()` 进行移动前检查
3. 根据检查结果显示不同的反馈信息

### 2. 移动确认和执行

1. 系统显示移动成本和时间确认对话
2. 用户确认后调用 `move_to_scene()` 执行移动
3. 设置移动目标和到达时间，扣除燃料

### 3. 移动状态监控

1. 游戏主循环定期调用 `judge_arrive()` 检查是否到达
2. 到达后更新基地位置，处理外交官状态
3. 显示到达提示并清理移动状态

## 扩展和维护要点

### 1. 添加新地点

1. 在 `Birthplace.csv` 或 `City.csv` 中添加新配置
2. 在地图JSON文件中添加对应的地图数据
3. 运行 `buildconfig.py` 重新构建配置

### 2. 修改移动机制

1. 移动成本计算在 `move_judge()` 方法中
2. 移动时间计算公式：`7 + 距离 * 3` 天
3. 燃料消耗公式：`500 * 距离` 单位

### 3. 界面定制

1. 地图显示逻辑在 `Navigation_Panel.draw()` 方法中
2. 按钮样式和颜色可以根据不同状态定制
3. 支持多种移动菜单类型的扩展

## 代码依赖关系

```
navigation_panel.py
├── Script.UI.Moudle (draw, panel) - UI绘制组件
├── Script.Core (缓存、流程、文本处理) - 核心功能
├── Script.Design (map_handle, attr_text, game_time) - 设计层功能
├── Script.Config (game_config, normal_config) - 配置管理
└── Script.Settle.default - 结算处理

map_handle.py
├── Script.Core (cache_control, game_type) - 核心数据类型
├── Script.Config.game_config - 游戏配置
└── data/ScenePath - 寻路路径数据

character_move.py
├── Script.Core (cache_control, constant, game_type) - 核心功能
├── Script.Design (map_handle, update) - 地图处理和更新
└── Script.UI.Moudle.draw - UI绘制
```

这个导航系统设计合理，分层明确，扩展性良好，是erArk游戏中重要的基础功能模块。