# 妊娠系统说明文档

## 概述

妊娠系统是erArk游戏中的核心功能之一，负责管理角色的生殖周期、受精、怀孕、分娩和育儿等完整流程。该系统涉及多个模块的协调工作，包括角色状态管理、时间系统、UI界面、数据存储等。

## 系统架构

### 核心模块

#### 1. 主要处理模块 (`Script/Design/pregnancy.py`)

这是妊娠系统的核心模块，包含以下主要功能：

**受精相关函数：**
- `get_fertilization_rate(character_id)` - 根据V精液量计算受精概率
- `check_fertilization(character_id)` - 根据受精概率判断是否受精

**妊娠阶段管理：**
- `check_pregnancy(character_id)` - 判断是否由受精变为怀孕
- `check_near_born(character_id)` - 判断是否开始临盆
- `check_born(character_id)` - 判断是否开始生产
- `check_rearing(character_id)` - 判断是否开始育儿
- `check_rearing_complete(character_id)` - 判断是否完成育儿

**成长系统：**
- `check_grow_to_loli(character_id)` - 判断是否成长为萝莉
- `check_grow_to_girl(character_id)` - 判断是否成长为少女
- `chest_grow(character_id)` - 进行胸部生长判定
- `body_part_grow(character_id)` - 进行其他部位生长判定

**全流程管理：**
- `check_all_pregnancy(character_id)` - 进行受精怀孕的全流程检查
- `update_reproduction_period(character_id)` - 刷新生理周期

### 2. 常量定义模块

#### 行为常量 (`Script/Core/constant/SecondBehavior.py`)
定义了妊娠相关的二段行为常量：
- `FERTILIZATION` - 受精结算
- `FERTILIZATION_FAILED` - 受精失败结算
- `PREGNANCY` - 妊娠结算
- `PARTURIENT` - 临盆结算
- `BORN` - 分娩前对话
- `POSTPARTUM` - 产后对话 + 获得产后素质
- `REARING` - 育儿结算
- `REARING_COMPLETE` - 育儿完成结算
- `CHILD_TO_LOLI` - 婴儿成长为萝莉
- `LOLI_TO_GIRL` - 萝莉成长为少女

#### 前提条件 (`Script/Core/constant_promise.py`)
包含妊娠相关的前提条件判断，用于指令可用性检查。

#### 效果常量 (`Script/Core/constant_effect.py`)
定义妊娠相关的状态变化效果。

### 3. 结算系统模块

#### 二段效果结算 (`Script/Settle/Second_effect.py`)
处理妊娠相关的二段行为效果，包括状态转换和属性变化。

#### 默认结算 (`Script/Settle/default.py`)
包含妊娠相关的默认结算逻辑。

#### 实时结算 (`Script/Settle/realtime_settle.py`)
处理妊娠状态的实时更新。

#### 每日结算 (`Script/Settle/past_day_settle.py`)
管理妊娠的每日进展和时间推进。

### 4. 角色系统集成

#### 角色管理 (`Script/Design/character.py`, `character_handle.py`)
集成妊娠数据到角色系统中，管理角色的妊娠状态。

#### 素质管理 (`Script/Design/handle_talent.py`)
管理妊娠相关的素质（ID 20-24）：
- 素质20：受精
- 素质21：妊娠
- 素质22：临盆
- 素质23：产后
- 素质24：育儿

#### 前提处理 (`Script/Design/handle_premise.py`)
处理妊娠相关的条件判断。

### 5. UI界面模块

#### 身体信息面板 (`Script/UI/Panel/body_info_panel.py`)
显示妊娠状态和相关身体信息。

#### 体检管理面板 (`Script/UI/Panel/physical_check_and_manage.py`)
提供妊娠健康监测功能。

#### 射精面板 (`Script/UI/Panel/ejaculation_panel.py`)
处理可能导致妊娠的射精事件。

#### 特殊事件面板 (`Script/UI/Panel/sp_event_panel.py`)
管理妊娠相关的特殊事件和里程碑。

## 数据结构

### CSV配置文件

#### 1. 生殖周期配置 (`data/csv/Reproduction_period.csv`)
定义7个生理周期阶段：
- 安全日、普通日、危险日、排卵日等
- 每个阶段具有不同的受孕风险级别

#### 2. 素质配置 (`data/csv/Talent.csv`)
包含妊娠相关的素质定义：
- ID 20-26：受精、妊娠、临盆、产后、育儿、孕肚等

#### 3. 身体道具配置 (`data/csv/Body_Item.csv`)
妊娠相关的身体道具：
- ID 10：排卵促进药
- ID 11：事前避孕药
- ID 12：事后避孕药
- ID 13：避孕套

#### 4. 行为数据 (`data/csv/Behavior_Data.csv`)
妊娠相关的行为定义：
- 避孕药使用行为
- 排卵促进行为
- 受精和妊娠状态变化行为

#### 5. 行为效果 (`data/csv/Behavior_Effect.csv`)
将行为与结算效果关联：
- ID 452-453：避孕药效果
- ID 1123-1124：二次避孕效果
- ID 1311-1319：妊娠周期效果

### 对话系统

#### 系统对话 (`data/talk/system/second_pregnancy.csv`)
主要的妊娠系统对话。

#### 药物对话
- `birth_control_pills_before.csv` - 事前避孕药对话
- `birth_control_pills_after.csv` - 事后避孕药对话
- `clomid.csv` - 排卵促进药对话

#### 身体部位对话
- `womb_s_A.csv` - 子宫相关对话
- `vagina_s_A.csv` - 阴道相关对话

## 系统流程

### 受精流程

1. **计算受精率** (`get_fertilization_rate`)
   - 基于V精液量和精液浓度计算基础概率
   - 考虑避孕药、排卵促进药等修正因子
   - 生理周期修正（排卵日概率最高）
   - 催眠强制排卵效果
   - 玩家天赋修正（浓厚精液等）

2. **受精判定** (`check_fertilization`)
   - 仅在排卵日进行判定
   - 检查是否已受精
   - 考虑未初潮、机械体等特殊情况
   - 随机数判定是否受精成功
   - 处理无意识妊娠情况

### 妊娠阶段流程

1. **受精 → 妊娠** (`check_pregnancy`)
   - 受精后90天（游戏内30天）转为妊娠
   - 获得妊娠、孕肚、泌乳素质
   - 根据罩杯大小设置乳汁上限

2. **妊娠 → 临盆** (`check_near_born`)
   - 受精后260天进入临盆期
   - 角色会住院待产
   - 清零身体污浊状态

3. **临盆 → 生产** (`check_born`)
   - 每日递增20%生产概率
   - 触发生产特殊事件面板

4. **生产 → 产后** (通过特殊事件面板处理)
   - 创建新生儿角色
   - 转为产后状态

5. **产后 → 育儿** (`check_rearing`)
   - 产后2天开始育儿
   - 行动重心转为照顾婴儿

6. **育儿完成** (`check_rearing_complete`)
   - 育儿90天后完成
   - 婴儿成长为幼女
   - 失去育儿和泌乳素质

### 成长流程

1. **幼女 → 萝莉** (`check_grow_to_loli`)
   - 出生后270天成长为萝莉
   - 第二性征发育，迎来初潮
   - 胸部生长判定

2. **萝莉 → 少女** (`check_grow_to_girl`)
   - 出生后450天成长为少女
   - 身体完全发育
   - 胸部和其他部位生长判定

## 系统特色

### 1. 现实化的生理周期
- 完整的7阶段生理周期模拟
- 不同阶段的受孕概率差异
- 排卵日的特殊机制

### 2. 丰富的干预手段
- 多种避孕方式（事前/事后避孕药、避孕套）
- 促排卵药物
- 催眠强制排卵
- 玩家天赋影响

### 3. 完整的生命周期
- 从受精到成年的完整过程
- 每个阶段的特殊状态和行为
- 遗传系统（母亲影响子女发育）

### 4. 深度的系统集成
- 与角色系统的深度集成
- 与时间系统的协调
- 与UI系统的完整交互
- 与对话系统的丰富内容

## 关键时间节点

- 受精后90天：转为妊娠
- 受精后260天：进入临盆
- 生产后2天：开始育儿
- 生产后90天：完成育儿
- 出生后270天：成长为萝莉
- 出生后450天：成长为少女

## 系统依赖

### 输入依赖
- 角色身体状态（精液量、生理周期）
- 游戏时间系统
- 角色素质和关系数据
- 道具和药物状态

### 输出影响
- 角色素质变化
- 角色行为限制
- UI界面显示
- 对话系统触发
- 新角色创建

## 开发注意事项

1. **时间同步**：妊娠系统高度依赖游戏时间，需要确保时间系统的准确性
2. **状态一致性**：多个模块都涉及妊娠状态，需要保持数据一致性
3. **UI反馈**：妊娠状态变化需要及时的UI反馈
4. **存档兼容**：妊娠数据的存档和读取需要保持兼容性
5. **测试覆盖**：复杂的状态转换需要完善的测试覆盖

这个系统展现了erArk游戏在角色生命周期管理方面的深度设计，通过细致的状态管理和丰富的交互机制，为玩家提供了一个完整而真实的妊娠体验系统。