# 多周目结算与继承系统

## 概述

`Script/UI/Panel/new_round.py` 实现了游戏的周目结算与继承系统，这是一个元进度机制，允许玩家在游戏重新开始时保留部分进度。该系统通过周目点数的分配，让玩家决定继承哪些内容到新的游戏周目中。

## 系统架构

### 1. 核心类结构

```python
class New_Round_Handle:
    """角色创建页面对象"""
    # 主要属性：
    - pl_abi_and_exp_count      # 继承玩家能力和经验等级
    - pl_originium_arts_count   # 继承玩家源石技艺等级
    - pl_extra_growth_count     # 继承玩家属性上限成长等级
    - pl_collection_count       # 继承玩家收藏品等级
    - chara_fon_and_trust_count # 继承干员好感和信任等级
    - chara_abi_and_exp_count   # 继承干员能力和经验等级
    - round_point_all           # 总周目点数
    - round_point_cost          # 周目点数消耗
    - farewell_npc_id          # 送别干员id
```

### 2. 系统入口

- **主要入口**：`Script/UI/Panel/originium_arts.py` 
  - 通过按钮 `[012]Re:败者食尘` 触发
  - 调用 `new_round_for_sure()` 函数创建 `New_Round_Handle` 实例

### 3. 数据配置

#### CSV数据文件
- `data/csv/New_Round_Inherit.csv`：定义继承类型、等级、比例和点数消耗

#### 配置加载
- `Script/Config/game_config.py`
  - `config_new_round_inherit`：继承配置字典
  - `config_new_round_inherit_type_data`：按类型和等级组织的嵌套字典

## 周目点数系统

### 点数来源

1. **当前周目数**
   - 计算公式：`周目数 × 20`
   - 存储在 `cache.game_round`

2. **陷落干员**
   - 遍历 `cache.npc_id_got` 中的所有干员
   - 检查是否有陷落天赋（通过 `handle_talent.have_fall_talent()`）
   - 点数计算：`(陷落天赋ID % 10) × 2`

3. **收藏品**
   - 内裤数量：`pl_character_data.pl_collection.npc_panties`
   - 袜子数量：`pl_character_data.pl_collection.npc_socks`
   - 点数计算：`内裤总数 + 袜子总数`

4. **调试模式**
   - 如果 `cache.debug_mode` 为真，额外增加9999点

### 点数消耗

每个继承类型都有多个等级（0-5），等级越高：
- 继承比例越高
- 消耗点数越多

## 继承类型详解

### 1. 博士的源石技艺 (Type 0)
- **继承内容**：ID范围301-350的天赋
- **特殊计算**：基于已有源石技艺的级别计算消耗
  - 初级（304,307,310,316,331）：每个10点
  - 中级（305,308,311,317,332）：每个30点
  - 高级（306,309,312,318,333）：每个60点
  - 特级（334）：120点

### 2. 博士的能力与经验 (Type 1)
- **继承内容**：
  - 所有能力值（`character_data.ability`）
  - 所有经验值（`character_data.experience`）
- **继承方式**：按比例继承 `原值 × 继承比例 / 100`

### 3. 博士的属性上限成长 (Type 2)
- **继承内容**：
  - 体力上限（hit_point_max）
  - 气力上限（mana_point_max）
  - 理智上限（sanity_point_max）
  - 精液上限（semen_point_max）
- **特殊计算**：
  - HP/MP：每50点消耗1周目点
  - 理智/精液：每1点消耗1周目点

### 4. 博士的收藏品 (Type 3)
- **继承内容**：内裤和袜子收藏
- **继承方式**：按比例继承收藏品数量

### 5. 干员的好感与信任 (Type 4)
- **继承内容**：
  - 干员信任度（`trust`）
  - 对玩家好感度（`favorability[0]`）
- **前提条件**：仅限已陷落干员

### 6. 干员的能力与经验 (Type 5)
- **继承内容**：
  - 干员能力值
  - 干员经验值
- **前提条件**：仅限已陷落干员

## 送别系统

### 功能说明
- 玩家可选择一名已陷落的干员进行送别
- 被选中的干员会获得 `second_behavior["new_round_farewell"] = 1` 标记
- 系统会显示该干员的送别对话（通过 `talk.must_show_talk_check()`）

## 新周目启动流程

### 1. 继承玩家数据 (`inherit_player_data()`)
1. 深拷贝旧玩家数据
2. 创建新的玩家角色
3. 根据继承等级应用各项属性
4. 保留玩家名字

### 2. 继承干员数据 (`inherit_npc_data()`)
1. 深拷贝所有角色数据
2. 重新初始化所有角色
3. 对已陷落的干员应用继承
4. 更新 `cache.npc_id_got`

### 3. 重置游戏数据 (`reset_game_data()`)
1. 保存需要保留的数据：
   - 游戏周目数（+1）
   - 角色数据
   - 已获得的NPC列表
   - 世界设置
   - 系统设置
2. 重置游戏核心数据
3. 恢复保留的数据
4. 根据继承的角色开放相应宿舍

## 相关常量与行为

### 行为常量
- `Script/Core/constant/SecondBehavior.py`
  - `NEW_ROUND_FAREWELL = 57`：新周目送别行为

### 缓存变量
- `cache.game_round`：当前游戏周目数
- `cache.npc_id_got`：已获得的NPC集合
- `cache.debug_mode`：调试模式标志

## UI交互设计

### 面板布局
1. **标题栏**：显示"周目点数结算"
2. **点数统计区**：
   - 当前周目数和获得点数
   - 陷落干员列表（可展开/折叠）
   - 收藏品统计
   - 总周目点数
3. **继承选项区**：
   - 6个继承类别，每个都可单独调整等级
   - 显示当前等级、继承比例和消耗点数
   - [提高]/[降低]按钮调整等级
4. **送别干员区**：
   - 显示当前选择的送别干员
   - [更改送别干员]按钮
5. **确认区**：
   - 显示总消耗和剩余点数
   - [确定]按钮（仅在点数足够时显示）

### 交互特性
- 可展开/折叠的详细信息面板
- 实时更新点数消耗和剩余
- 等级调整有上下限限制
- 点数不足时无法确认

## 开发注意事项

1. **数据安全**：使用深拷贝避免数据污染
2. **继承计算**：所有继承值都使用整数截断
3. **UI适配**：支持正常绘制和Web绘制两种模式
4. **扩展性**：继承类型通过CSV配置，易于添加新类型

## 相关文件快速索引

- 入口触发：`Script/UI/Panel/originium_arts.py`
- 配置定义：`data/csv/New_Round_Inherit.csv`
- 配置加载：`Script/Config/game_config.py`
- 角色初始化：`Script/Design/character_handle.py`
- 天赋检查：`Script/Design/handle_talent.py`
- 对话系统：`Script/Design/talk.py`
- 游戏初始化：`Script/UI/Flow/creator_character_flow.py`