# 外勤委托系统

## 概述
外勤委托系统是游戏中的一个重要功能，允许玩家派遣干员执行各种任务以获得资源、经验、素质等奖励。本文档详细说明了外勤委托系统的数据结构、代码逻辑以及相关文件之间的关系。

## 核心文件关系

### 1. 数据文件：`/data/csv/Commission.csv`
存储所有委托任务的原始数据，包含以下字段：
- `cid`：委托ID（唯一标识）
- `name`：委托名称
- `country_id`：国家ID（-1表示通用委托）
- `level`：委托等级（1-6级）
- `type`：委托类型（资源/源石/成长/势力/角色/支线）
- `people`：需要派遣的人数
- `time`：耗时天数
- `demand`：具体需求（特殊格式字符串）
- `reward`：具体奖励（特殊格式字符串）
- `related_id`：关联的前置委托ID（-1表示无）
- `special`：是否为特殊委托（0=常规，1=特殊）
- `description`：委托描述

### 2. 配置定义：`/Script/Config/config_def.py`
定义了`Commission`类，作为委托数据的Python对象模型。

### 3. 配置加载：`/Script/Config/game_config.py`
- 定义全局配置字典：
  - `config_commission`：存储所有委托对象
  - `config_commission_id_by_country`：按国家分组的委托ID列表
- `load_commission()`函数负责从JSON加载并创建委托对象

### 4. UI面板：`/Script/UI/Panel/field_commission_panel.py`
实现委托系统的用户界面和核心逻辑功能。

## 数据流程

```
Commission.csv → buildconfig.py → data.json → game_config.load_commission() → 游戏使用
```

1. **构建阶段**：`buildconfig.py`读取CSV文件，转换为JSON格式
2. **加载阶段**：游戏启动时，`game_config.py`从JSON加载数据
3. **运行阶段**：游戏通过配置字典访问委托数据

## 需求和奖励格式

### 需求/奖励类型前缀

#### 资源类（r_）- `/data/csv/Resource.csv`
- `r_1_100`：100龙门币
- `r_2_50`：50合成玉  
- `r_3_5`：5至纯源石
- `r_4_10`：10粉红凭证

#### 能力类（a_）- `/data/csv/Ability.csv`
**基础能力（类型3）：**
- `a_30_5`：5技巧
- `a_31_3`：3顺从  

**技能类能力（类型4）：**
- `a_40_3`：3话术技能
- `a_41_4`：4指挥技能

**性技类能力（类型5）：**
- `a_70_2`：2指技
- `a_71_3`：3舌技

#### 经验类（e_）- `/data/csv/Experience.csv`
**技能经验（类型11）：**
- `e_80_10`：10对话经验
- `e_81_20`：20战斗经验

**身体经验（类型1）：**
- `e_0_5`：5皮肤经验
- `e_1_3`：3胸部经验

#### 宝珠类（j_）- `/data/csv/Juel.csv`
- `j_0_100`：100皮肤快感珠
- `j_1_50`：50胸部快感珠

#### 素质类（t_）- `/data/csv/Talent.csv`
**性素质（类型0）：**
- `t_0_1`：获得处女素质（`t_0_0`取消）
- `t_1_1`：获得A处女素质

**身体素质（类型1）：**
- 各种身体特征相关素质

**精神素质（类型2）：**
- 各种精神状态相关素质

#### 角色类（c_）
- `c_291_1`：需要291号角色参与（1=包含，0=不包含）

#### 委托状态类（m_）
- `m_56_-1`：56号委托变为不可完成（-1=不可完成，0=可进行，1=已完成）

#### 声望类（声望_）- `/data/csv/Nation.csv`
- `声望_0_50`：当地声望+50（0=当地声望）
- `声望_11_30`：阿戈尔声望+30

#### 好感类（好感_）
- `好感_7_100`：7号角色好感+100

#### 信赖类（信赖_）
- `信赖_15_50`：15号角色信赖+50

#### 攻略类（攻略_）
- `攻略_291_3`：291号角色攻略程度设为3（0~4级）

#### 特产类（特产_）- `/data/csv/Resource.csv`（101-299号资源）
- `特产_1_50`：50阿戈尔示波器（出生地1-阿戈尔的1级特产）
- `特产_2_30`：30金杯啤酒（出生地2-玻利瓦尔的1级特产）
- `特产_3_20`：20武士刀（出生地3-东的1级特产）

#### 追捕类（追捕_）
- 用于追捕逃犯等特殊任务

### 复合需求
使用`&`连接多个需求，如：`a_42_4&a_45_4`表示需要42号能力4点且45号能力4点。

## 核心功能函数

### `get_commission_demand_and_reward()`
处理委托的需求检查和奖励发放：
- 解析需求/奖励字符串
- 检查是否满足条件
- 扣除/增加相应资源
- 返回满足状态和描述文本

### `process_commission_text()`
处理单个需求/奖励文本项：
- 解析文本格式
- 获取对应的资源/能力等数据
- 执行扣除或增加操作
- 生成显示文本

### `update_field_commission()`
更新外勤委托状态：
- 判断进行中的委托是否完成
- 结算完成的委托奖励
- 刷新可接取的委托列表

### `create_temp_commission()`
动态创建临时委托：
- 用于特殊事件生成的委托
- 自动分配可用的委托ID
- 更新CSV文件以持久化

## 委托执行流程

1. **展示阶段**
   - 根据罗德岛位置获取当地委托
   - 过滤满足条件的委托（等级、前置等）
   - 显示委托列表

2. **准备阶段**
   - 选择派遣人员（满足人数要求）
   - 选择载具（满足运载量要求）
   - 检查其他需求（资源、能力等）

3. **执行阶段**
   - 扣除所需资源
   - 设置人员离线状态
   - 记录委托开始时间和预计完成时间
   - 考虑载具速度对时间的影响

4. **结算阶段**
   - 检查委托是否到期
   - 发放奖励（资源、经验、素质等）
   - 处理特殊奖励（新干员、载具等）
   - 人员上线并触发相关事件

## 特殊机制

### 载具系统
- 载具提供运载量，满足委托的运输需求
- 载具速度影响委托完成时间
- 载具可能在委托中损坏

### 招募机制
- 某些委托完成后可能招募到新干员
- 概率与委托等级相关
- 只能招募当地出生的干员

### 动态委托
- 支持运行时创建临时委托
- 用于特殊事件（如追捕逃犯）
- 自动持久化到CSV文件

## 与其他系统的交互

1. **角色系统**：检查角色能力、设置离线状态
2. **资源系统**：扣除和增加各类资源
3. **声望系统**：影响国家/势力声望
4. **时间系统**：计算委托完成时间
5. **地图系统**：根据位置显示不同委托
6. **事件系统**：触发委托相关的特殊事件

## 扩展说明

### 添加新委托
1. 在`Commission.csv`中添加新行
2. 运行`buildconfig.py`重新构建
3. 委托会自动加载到游戏中

### 添加新的需求/奖励类型
1. 在`process_commission_text()`中添加新的类型处理
2. 实现对应的检查和结算逻辑
3. 更新相关的显示文本生成

### 国家特定委托
- 设置`country_id`为特定国家ID
- 委托只在罗德岛位于该国家时显示
- 通用委托使用`country_id = -1`

## 注意事项

1. 委托ID必须唯一，建议使用分段管理（如1-999通用，1000+特殊）
2. 需求和奖励格式必须严格遵循约定，否则解析会出错
3. 特殊委托完成后会加入`finished_field_commissions_set`，不可重复完成
4. 动态创建的委托会追加到CSV文件末尾，注意备份

## 附录：CSV数据文件对照表

### 核心数据文件

| 前缀类型 | 对应CSV文件 | 描述 | 重要字段 |
|---------|------------|------|----------|
| `r_` | `/data/csv/Resource.csv` | 资源配置 | `cid`(资源ID), `name`(资源名), `type`(类型), `price`(价格), `specialty`(特产地) |
| `a_` | `/data/csv/Ability.csv` | 能力配置 | `cid`(能力ID), `ability_type`(能力类型), `name`(能力名) |
| `e_` | `/data/csv/Experience.csv` | 经验配置 | `cid`(经验ID), `name`(经验名), `type`(经验类型) |
| `j_` | `/data/csv/Juel.csv` | 宝珠配置 | `cid`(宝珠ID), `name`(宝珠名) |
| `t_` | `/data/csv/Talent.csv` | 素质配置 | `cid`(素质ID), `Talent_type`(素质类型), `name`(素质名), `heredity`(可遗传) |
| `c_` | `/data/Character.json` | 角色数据 | adv编号对应角色ID |
| 声望_ | `/data/csv/Nation.csv` | 势力配置 | `cid`(势力ID), `name`(势力名), `country`(所属国家) |
| 特产_ | `/data/csv/Resource.csv` | 地区特产 | `specialty`字段标识出身地，101-299为特产资源 |
| - | `/data/csv/Birthplace.csv` | 出生地配置 | `cid`(出生地ID), `name`(出生地名), `inmap`(是否在大地图), `infect_rate`(感染率) |
| - | `/data/csv/Commission.csv` | 委托配置 | 主要配置文件，包含所有委托数据 |

### 资源类型详细说明（Resource.csv）

| 资源ID范围 | 类型 | 说明 | 示例 |
|-----------|------|------|------|
| 1-4 | 货币 | 龙门币、合成玉、至纯源石、粉红凭证 | `r_1_100`(100龙门币) |
| 11-16 | 材料 | 药材、工业材料、燃料等基础材料 | `r_11_10`(10普通药材) |
| 21-24 | 药剂 | 各类治疗药物 | `r_22_2`(2感染抑制剂小样) |
| 31-36 | 乳制品 | 母乳相关制品 | `r_31_5`(5鲜母乳) |
| 41-44 | 香水 | 各等级香水制品 | `r_42_1`(1普通香水) |
| 101-299 | 特产 | 各地区特产物品 | `特产_1_50`(50阿戈尔示波器) |

### 能力类型详细说明（Ability.csv）

| 能力类型 | ID范围 | 说明 | 示例 |
|---------|--------|------|------|
| 0-感度 | 0-8, 100-102 | 各部位感度能力 | `a_0_5`(5皮肤感度) |
| 1-扩张 | 9-12 | 各部位扩张程度 | `a_9_3`(3阴道扩张) |
| 2-刻印 | 13-19 | 各类心理刻印 | `a_13_2`(2快乐刻印) |
| 3-基础 | 30-36 | 基础属性能力 | `a_30_5`(5技巧) |
| 4-技能 | 40-49 | 各类生活技能 | `a_42_4`(4战斗技能) |
| 5-性技 | 70-76, 90 | 性技能和隐蔽 | `a_70_3`(3指技) |

### 经验类型详细说明（Experience.csv）

| 经验类型 | ID范围 | 说明 | 示例 |
|---------|--------|------|------|
| 1-身体经验 | 0-7, 153-155 | 各部位敏感经验 | `e_0_10`(10皮肤经验) |
| 2-绝顶经验 | 10-17, 20-26, 111, 156-158 | 各种绝顶相关经验 | `e_20_5`(5绝顶经验) |
| 4-无意识经验 | 70-79, 159-161 | 无意识状态经验 | `e_70_3`(3无意识皮肤经验) |
| 6-特殊经验 | 20-26 | 射精、喷乳等特殊经验 | `e_21_2`(2射精经验) |
| 8-体位经验 | 141-152 | 各种体位经验 | `e_141_1`(1正常位经验) |
| 9-特殊状态 | 120-127 | 催眠、时姦等经验 | `e_122_1`(1催眠经验) |
| 11-技能经验 | 80-93 | 各类生活技能经验 | `e_81_20`(20战斗经验) |

### 素质类型详细说明（Talent.csv）

| 素质类型 | ID范围 | 说明 | 示例 |
|---------|--------|------|------|
| 0-性素质 | 0-199 | 性相关素质状态 | `t_0_1`(获得处女素质) |
| 1-身体素质 | 200-299 | 身体特征素质 | `t_200_1`(获得某身体素质) |
| 2-精神素质 | 300-399 | 精神状态素质 | `t_300_1`(获得某精神素质) |
| 3-技术素质 | 400-499 | 技能相关素质 | `t_400_1`(获得某技术素质) |
| 4-其他素质 | 500+ | 其他特殊素质 | `t_500_1`(获得其他素质) |

### 出生地与特产对应关系（Birthplace.csv + Resource.csv）

| 出生地ID | 出生地名 | 对应特产资源ID | 特产名称示例 |
|---------|----------|---------------|-------------|
| 0 | 罗德岛 | 无 | 无特产 |
| 1 | 阿戈尔 | 101-103 | 示波器、小帮手、蓝图芯片 |
| 2 | 玻利瓦尔 | 111-113 | 金杯啤酒、咖啡豆、翡翠咖啡 |
| 3 | 东 | 121 | 武士刀 |
| 4 | 哥伦比亚 | 131-132 | 噪音引擎、飞行芯片 |
| 5 | 卡西米尔 | 141-143 | 纪念模型、器械零件、竞技证券 |
| 6 | 卡兹戴尔 | 151-152 | 炉渣、粗制糖块 |
| 7 | 拉特兰 | 161 | 蚀刻弹弹壳 |
| 8 | 莱塔尼亚 | 171-173 | 贵族铸币、调律追忆、扩音器 |
| ... | ... | ... | ... |

### 数据文件依赖关系

```
委托系统数据流：
Commission.csv → buildconfig.py → data.json → game_config.py → 游戏运行

引用关系：
Commission.csv 引用→ Resource.csv (资源奖励/需求)
Commission.csv 引用→ Ability.csv (能力需求)
Commission.csv 引用→ Experience.csv (经验奖励)
Commission.csv 引用→ Juel.csv (宝珠奖励)
Commission.csv 引用→ Talent.csv (素质奖励)
Commission.csv 引用→ Nation.csv (声望奖励)
Commission.csv 引用→ Birthplace.csv (地区特产)
```

### 使用注意事项

1. **资源ID对应**：`r_` 前缀后的数字必须与 `Resource.csv` 中的 `cid` 字段对应
2. **能力ID对应**：`a_` 前缀后的数字必须与 `Ability.csv` 中的 `cid` 字段对应  
3. **经验ID对应**：`e_` 前缀后的数字必须与 `Experience.csv` 中的 `cid` 字段对应
4. **特产格式**：`特产_出生地ID_数量`，出生地ID对应 `Birthplace.csv`
5. **声望格式**：`声望_势力ID_变化值`，势力ID对应 `Nation.csv`（0为当地声望）
6. **复合需求**：使用 `&` 连接，如 `a_42_4&a_45_4&r_13_10`