# 基建系统说明文档

## 概述

基建系统是erArk游戏中的核心管理模块，负责处理罗德岛舰船内各种设施的建设、升级和管理。该系统通过CSV数据文件配置，提供了完整的UI界面和逻辑处理。

## 核心文件组成

### 1. 主要代码文件

#### building_panel.py (`Script/UI/Panel/building_panel.py`)
基建系统的主要UI面板，负责：
- 显示设施总览和详细信息
- 处理设施升级操作
- 管理贸易区子设施建设
- 提供交互式界面

#### basement.py (`Script/Design/basement.py`)
基建系统的核心逻辑处理模块，负责：
- 初始化基地数据结构
- 实时更新设施状态和效果
- 计算电力消耗和供给平衡
- 处理设施开放条件判断

### 2. 数据文件 (CSV)

#### Facility.csv (`data/csv/Facility.csv`)
定义所有基建设施的基本信息：
- `cid`: 设施编号
- `name`: 设施名称
- `type`: 设施类型(-1为区块，-2为通用，其他为子设施)
- `info`: 设施介绍信息

主要设施包括：
- 控制中枢 (000)：核心设施，控制其他设施等级上限
- 动力区 (001)：提供电力
- 工程部 (002)：工程建设
- 仓储区 (003)：物资存储
- 宿舍区 (004)：干员居住
- 生活娱乐区 (005)：娱乐设施
- 医疗部 (006)：治疗设施
- 文职部 (007)：人事办公
- 科研部 (008)：研究设施
- 训练场 (009)：锻炼设施
- 图书馆 (010)：学习设施
- 贸易区 (011)：商业设施
- 制造加工区 (012)：生产设施
- 访客区 (013)：外交设施
- 机库 (014)：载具管理
- 教育区 (015)：教育设施
- 疗养庭院 (016)：农业设施
- 大浴场 (017)：洗浴设施
- 甲板 (018)：室外设施
- 关押区 (019)：监禁设施
- 保卫科 (020)：安全设施

#### Facility_effect.csv (`data/csv/Facility_effect.csv`)
定义设施在不同等级下的效果：
- `cid`: 效果编号
- `name`: 设施名称
- `level`: 设施等级(1-5)
- `effect`: 设施效果数值
- `power_use`: 耗电量
- `resouce_use`: 升级所需基建材料
- `money_use`: 升级所需龙门币
- `info`: 效果描述

#### Facility_open.csv (`data/csv/Facility_open.csv`)
定义待开放设施的配置：
- `cid`: 设施编号
- `name`: 设施名称
- `zone_cid`: 开放所需的区块等级
- `NPC_id`: 开放所需的干员编号
- `info`: 介绍信息

包括：
- 贸易区子设施(151-168)：各种商店、餐厅、酒店
- 宿舍房间(1107-1913)：各楼层房间
- 客房(2001-2012)：访客住宿

### 3. 数据结构

#### Rhodes_Island类 (`Script/Core/game_type.py`)
核心数据结构，存储基地所有状态：

```python
class Rhodes_Island:
    facility_level: Dict[int, int]      # 设施等级
    facility_open: Dict[int, bool]      # 设施开放状态
    power_use: int                      # 当前用电量
    power_max: int                      # 总供电量
    materials_resouce: Dict[int, int]   # 资源数量
    shop_open_list: List[str]           # 已开放商店列表
    people_max: int                     # 干员人数上限
    warehouse_capacity: int             # 仓库容量
    patient_max: int                    # 患者收治上限
    # ... 其他设施相关属性
```

## 系统工作流程

### 1. 初始化流程

```python
# basement.py - get_base_zero()
def get_base_zero():
    """初始化基地数据，所有设施设为1级，设施关闭，资源清零"""
    base_data = game_type.Rhodes_Island()
    # 设施等级初始化为1
    for all_cid in game_config.config_facility:
        base_data.facility_level[all_cid] = 1
    # 设施开放状态初始化为关闭
    for all_cid in game_config.config_facility_open:
        base_data.facility_open[all_cid] = False
    # 资源数量初始化为0
    for all_cid in game_config.config_resouce:
        base_data.materials_resouce[all_cid] = 0
```

### 2. 实时更新流程

```python
# basement.py - get_base_updata()
def get_base_updata():
    """根据设施等级更新全部数值"""
    cache.rhodes_island.power_use = 0
    
    # 遍历所有设施
    for all_cid in game_config.config_facility:
        level = cache.rhodes_island.facility_level[all_cid]
        facility_name = game_config.config_facility[all_cid].name
        facility_cid = game_config.config_facility_effect_data[facility_name][level]
        
        # 累加电力消耗
        cache.rhodes_island.power_use += game_config.config_facility_effect[facility_cid].power_use
        
        # 根据设施类型更新对应属性
        if facility_name == "动力区":
            cache.rhodes_island.power_max = game_config.config_facility_effect[facility_cid].effect
        elif facility_name == "仓储区":
            cache.rhodes_island.warehouse_capacity = game_config.config_facility_effect[facility_cid].effect
        # ... 其他设施的特殊处理
```

### 3. UI交互流程

```python
# building_panel.py - Building_Panel类
class Building_Panel:
    def draw(self):
        """绘制基建界面"""
        # 1. 更新基地数据
        basement.get_base_updata()
        
        # 2. 显示资源情况
        power_use = cache.rhodes_island.power_use
        power_max = cache.rhodes_island.power_max
        money = cache.rhodes_island.materials_resouce[1]
        
        # 3. 遍历显示所有设施
        for all_cid in game_config.config_facility:
            facility_data = game_config.config_facility[all_cid]
            # 显示设施信息和升级按钮
            
        # 4. 处理用户交互
        yrn = flow_handle.askfor_all(return_list)
```

### 4. 设施升级流程

```python
def level_up(self, facility_cid: int):
    """设施升级处理"""
    # 1. 获取当前和下级设施数据
    facility_data_now = game_config.config_facility_effect[facility_cid]
    facility_data_next = game_config.config_facility_effect[facility_cid+1]
    
    # 2. 检查升级条件
    # - 电力是否足够
    # - 龙门币是否足够
    # - 控制中枢等级是否满足
    
    # 3. 执行升级
    if 满足条件:
        cache.rhodes_island.materials_resouce[1] -= facility_data_next.money_use
        cache.rhodes_island.facility_level[all_cid] += 1
        basement.get_base_updata()  # 更新基地数据
```

### 5. 贸易区建设流程

```python
def build_trade_sub_panel(self, facility_cid: int):
    """贸易区子设施建设"""
    # 1. 根据贸易区等级显示可建设施
    for facility_open_cid in range(150,170):
        if facility_open_cid in game_config.config_facility_open:
            open_data = game_config.config_facility_open[facility_open_cid]
            
            # 2. 检查是否已建设
            if cache.rhodes_island.facility_open[facility_open_cid] == 1:
                continue
                
            # 3. 检查等级限制
            if facility_cid < 114 and open_data.info == "酒店":
                continue  # 等级不够无法建设酒店
                
    # 4. 执行建设
    cache.rhodes_island.facility_open[facility_open_cid] = 1
    cache.rhodes_island.shop_open_list.append(open_data.name)
    basement.get_base_updata()
```

## 系统特点

### 1. 层级设计
- **区块级设施**：主要功能区域，控制整体能力
- **子设施**：区块内的具体建筑，提供细分功能
- **等级系统**：1-5级递进，每级提升效果和解锁新功能

### 2. 资源管理
- **电力系统**：动力区提供电力，其他设施消耗电力
- **经济系统**：龙门币作为升级货币
- **容量限制**：各类设施都有人数或数量上限

### 3. 依赖关系
- **控制中枢**：决定其他设施的最高等级
- **前置条件**：某些设施需要特定等级或干员才能开放
- **联动效果**：设施之间存在功能联动

### 4. 可扩展性
- **CSV配置**：通过修改CSV文件即可增加新设施
- **模块化设计**：UI、逻辑、数据分离，便于维护
- **事件驱动**：通过`get_base_updata()`统一更新状态

## 开发维护要点

### 1. 添加新设施
1. 在`Facility.csv`中添加设施基本信息
2. 在`Facility_effect.csv`中添加各等级效果
3. 在`basement.py`的`get_base_updata()`中添加专门处理逻辑
4. 在`game_type.py`的`Rhodes_Island`类中添加相关属性

### 2. 修改升级条件
- 在`building_panel.py`的`level_up_info()`中修改检查逻辑
- 确保电力、资源、等级等约束条件正确

### 3. 扩展UI功能
- 在`Building_Panel`类中添加新的面板类型
- 注意保持界面的响应性和用户友好性

### 4. 性能优化
- `get_base_updata()`会频繁调用，需要优化计算效率
- 大量设施数据可考虑缓存机制

## 与其他系统的关联

### 1. 角色系统
- 宿舍区限制干员总数
- 工作分配依赖设施开放状态
- 干员能力影响设施效率

### 2. 经济系统
- 设施升级消耗龙门币
- 商店系统依赖贸易区建设
- 生产设施影响资源产出

### 3. 事件系统
- 设施损坏事件
- 访客系统依赖访客区
- 医疗事件依赖医疗部

### 4. 存档系统
- 基地状态需要完整保存和恢复
- 设施等级和开放状态的持久化

这个基建系统为游戏提供了丰富的管理玩法，通过合理的设施规划和资源分配，玩家可以不断提升基地的各项能力，支撑更复杂的游戏内容。