# 口上系统 (Talk System Documentation)

## 概述

口上系统，即角色交互文本系统，是erArk游戏中文本展示的核心模块，位于`Script/Design/talk.py`。角色交互文本会分为通用角色文本（地文）和角色专属文本（口上）两个部分。该系统管理角色在各种行为和状态下的对话文本显示，支持动态文本生成、AI增强、多语言翻译等功能。

## 系统架构

### 核心组件

1. **主要处理函数**
   - `handle_talk(character_id)`: 处理行为结算对话
   - `handle_second_talk(character_id, behavior_id)`: 处理二段行为结算对话
   - `handle_talk_sub(character_id, behavior_id)`: 内置循环部分，负责文本权重计算
   - `choice_talk_from_talk_data(now_talk_data, behavior_id)`: 从候选文本中选择合适的对话
   - `handle_talk_draw(character_id, talk_text, now_talk_id)`: 处理文本绘制和显示

2. **辅助函数**
   - `code_text_to_draw_text(talk_text, character_id)`: 将文本代码转化为显示文本
   - `talk_common_judge(now_talk, character_id)`: 处理通用占位符替换
   - `special_code_judge(now_talk)`: 处理特殊代码转换
   - `check_not_draw_talk()`: 检测是否需要跳过文本显示

### 数据结构

#### 配置数据（来源于JSON文件）

1. **Character_Talk.json**
   - 存储所有角色的对话文本数据
   - 结构：`{"Talk": {"data": [...]}}`
   - 每条数据包含：cid、behavior_id、adv_id、premise、context等

2. **Talk_Common.json**
   - 存储通用文本组件数据（纸娃娃地文）
   - 结构：`{"Talk_Common": {"data": [...]}}`
   - 支持部位化和动态替换

#### 运行时配置（game_config.py）

```python
config_talk: Dict[str, config_def.Talk] = {}  # 主要对话配置
config_talk_data: Dict[int, Set] = {}  # 行为ID到对话ID的映射
config_talk_data_by_chara_adv: Dict[int, int] = {}  # 按角色ADV分类的对话数据
config_talk_premise_data: Dict[int, Set] = {}  # 对话前提条件数据
config_talk_common_data: Dict[int, config_def.Talk_Common] = {}  # 通用文本数据
config_talk_common_cid_list_by_type: Dict[str, List] = {}  # 按类型分组的通用文本
config_talk_common_premise_data: Dict[int, Set] = {}  # 通用文本前提条件
```

## 数据流程

### 1. 数据构建阶段 (buildconfig.py)

1. **CSV处理**: 虽然当前主要使用JSON，但支持从`data/talk/`目录读取CSV文件
2. **JSON生成**: 将处理后的数据写入`Character_Talk.json`和`Talk_Common.json`
3. **配置加载**: 游戏启动时通过`game_config.load_talk()`和`game_config.load_talk_common()`加载配置

### 2. 运行时处理流程

#### 主要对话处理流程

```
游戏行为触发 → settle_behavior.py → handle_talk(character_id)
                                      ↓
检查位置/收藏模式 → handle_talk_sub() → 计算文本权重
                                      ↓
choice_talk_from_talk_data() → 选择最终文本 → handle_talk_draw()
                                              ↓
特殊代码处理 → AI文本生成/翻译 → 文本绘制显示
```

#### 权重计算机制

1. **前提条件检查**: 使用`handle_premise.get_weight_from_premise_dict()`计算权重
2. **特殊权重加成**:
   - 角色专属文本：权重×10
   - 时停解放状态：权重×10  
   - 女儿角色相关：权重×5
3. **随机选择**: 从最高权重组中随机选择一条文本

## 文本处理机制

### 1. 占位符系统

对话文本支持丰富的占位符替换：

- **角色信息**: `{Name}`, `{NickName}`, `{PlayerName}` 等
- **场景信息**: `{SceneName}`, `{TargetSceneName}` 等
- **物品信息**: `{FoodName}`, `{BookName}`, `{AllFoodName}` 等
- **服装信息**: `{TargetPanName}`, `{UpClothName}` 等

### 2. 通用文本系统（纸娃娃地文）

- **动态生成**: 通过`{行为ID}`格式调用通用文本
- **部位组合**: 支持按身体部位分组的文本组合
- **前提筛选**: 根据当前状态筛选合适的通用文本

### 3. 特殊代码处理

- **`<jump>`**: 无停顿换行符
- **换行符转换**: `\\n` → `\n`

## AI集成

### 1. 文本生成AI

- **触发条件**: `cache.ai_setting.ai_chat_setting[1] == True`
- **处理函数**: `handle_chat_ai.judge_use_text_ai()`
- **生成类型**: 地文扩展、角色口上生成

### 2. 翻译功能

- **多语言支持**: 非中文环境下自动翻译
- **翻译设置**: `cache.ai_setting.ai_chat_translator_setting`
- **翻译范围**: 角色口上、地文描述

## 显示控制

### 1. 跳过机制

- **位置检查**: 角色与玩家不在同一位置时跳过
- **收藏模式**: 非收藏角色的文本跳过
- **智能跟随**: 跟随模式下的特定文本跳过
- **时间限制**: 移动文本的小时内重复限制

### 2. 显示设置

- **通用文本开关**: `cache.all_system_setting.draw_setting[2]`
- **NPC移动文本**: `cache.all_system_setting.draw_setting[8]`
- **每日招呼**: `cache.all_system_setting.draw_setting[9]`

### 3. 绘制样式

- **角色颜色**: 根据角色设置应用文本颜色
- **等待模式**: `LineFeedWaitDraw` vs `NormalDraw`
- **特殊样式**: 绝顶、射精等特殊状态的颜色标记

## 二段行为系统

### 1. 处理流程

- **触发检查**: `character_data.second_behavior` 中的非零值
- **必须显示**: 通过`must_show_talk_check()`强制显示重要状态
- **效果结算**: 同时触发对应的二段行为效果

### 2. 特殊状态文本

- **绝顶相关**: 多重绝顶、部位绝顶、强度分级
- **刻印获得**: 快乐、屈服、苦痛等刻印提示
- **生理反应**: 喷乳、漏尿等特殊反应

## 系统集成

### 1. 与主游戏循环的集成

1. **行为结算**: 在`settle_behavior.handle_settle_behavior()`中调用
2. **时间点**: 行为效果结算之前显示文本
3. **事件控制**: 通过`skip_instruct_talk`标志控制是否跳过

### 2. 与其他系统的协作

- **前提系统**: 依赖`handle_premise`进行条件判断
- **角色系统**: 获取角色状态、位置、关系信息
- **服装系统**: 动态获取当前穿着信息
- **AI系统**: 文本生成和翻译功能

## 配置和维护

### 1. 数据更新流程

1. 修改`data/talk/`下的CSV文件（如果使用CSV）
2. 或直接修改JSON文件
3. 运行`python buildconfig.py`重新构建配置
4. 游戏内使用`reload_talk_data()`热重载

### 2. 扩展方法

- **新增对话**: 在JSON中添加新的talk条目
- **新增通用文本**: 在Talk_Common.json中添加组件
- **新增占位符**: 在`code_text_to_draw_text()`中扩展替换逻辑

## 性能考虑

1. **缓存机制**: 前提条件计算结果缓存避免重复计算
2. **延迟加载**: 大文本文件按需加载
3. **权重优化**: 提前终止低权重文本的计算

## 调试和测试

1. **调试输出**: 代码中包含丰富的调试print语句（被注释）
2. **文本验证**: 检查占位符替换和特殊代码处理
3. **权重测试**: 验证不同条件下的文本选择逻辑

## 注意事项

1. **多线程安全**: 系统主要在主线程中运行，需注意AI调用的异步处理
2. **内存管理**: 大量文本数据需要合理的内存管理
3. **错误处理**: 文本缺失或格式错误时的降级处理
4. **本地化**: 多语言环境下的字符编码和显示问题