# 动力系统管理工作流

## 概述

动力系统负责罗德岛基地的供电策略、发电设施、蓄电池与调控员等运行数据，并提供完整的 UI 面板供玩家在动力调度室调整策略。系统当前覆盖传统发电、清洁能源、人力发电，以及蓄电池储能与每日结算。

## 核心代码模块

### `Script/UI/Panel/manage_power_system_panel.py`
- `_init_power_runtime_fields()`：在读取存档或旧版本数据时补全 `cache.rhodes_island` 的动力相关字段，并为未实装区块设定默认策略。
- `_get_operator_power_bonus()`：根据 `power_operator_ids_list` 统计调控员效率，使用能力 48（制造技能）换算倍率，并区分主调控员与辅助调控员的贡献。
- `_recalc_battery_capacity()` 与 `_calculate_battery_self_discharge()`：按 `battery_list` 与 `Power_Storage.csv` 重新计算最大储能，并在日结时模拟逐台电池的自放电。
- `get_theoretical_*()` 系列：
  - `get_theoretical_fire_generation()`：同步主反应炉等级，结合副炉计划燃料与调控员加成计算火电理论值，可返回详细字典。
  - `get_theoretical_clean_generation()`：按水/风/光设备数量与调控员加成估算清洁能源，移动状态下自动停用水/风。
  - `get_theoretical_power_consumption()` 与 `get_zone_power_consumption()`：遍历 `config_facility` 与 `config_supply_strategy` 叠加区块策略修正后得到总耗电。
- `settle_power_system()`：按“火力发电→清洁能源→蓄电/亏电”流程进行每日结算，自动扣除燃料（资源 15）、处理蓄电补缺或溢出，并返回缺电比例与文本描述。
- `store_power_by_human_power()`：处理人力发电室的绝顶发电逻辑，读取 `Power_Generation.csv` 的“人力”区间，根据绝顶等级与是否为玩家放大产出，并削减角色欲情槽。
- `Manage_Power_System_Panel`：主面板，提供概览并拆分四个子界面：供电策略、调控员、发电设施、蓄电池。UI 统一使用 `draw` 与 `flow_handle.askfor_all()`，确保 Web/Tk 双模兼容。

### 关联模块
- `Script/UI/Panel/building_panel.py`：在基建面板顶部显示理论供需，点击“动力区”进入策略详情。
- `Script/UI/Panel/manage_basement_panel.py`：在“管理罗德岛系统”中调度此面板。
- `Script/Design/handle_instruct.py`：指令 `MANAGE_POWER_SYSTEM` 直接打开面板，`MANAGE_FACILITY_POWER` 处理实际调控行为。
- `Script/Design/basement.py`：维护 `power_operator_ids_list`，并在刷新岗位信息时同步供能调控员列表（工作类型 11）。
- `Script/Design/settle_behavior.py` 与 `Script/Settle/Second_effect.py`：在高潮结算、人力发电室的二结算回调中调用 `store_power_by_human_power()`。

## 运行期数据结构

`Script/Core/game_type.py` 中 `Rhodes_Island` 的动力字段：
- `power_storage` / `power_storage_max`：当前储能与容量，由 `_recalc_battery_capacity()` 更新。
- `power_operator_ids_list`：供能调控员 ID 列表，结合 `main_power_facility_operator_ids`（火/水/风/光四槽）计算效率。
- `orundum_reactor_list`：`[主反应炉等级, 副反应炉启用数量]`，主炉等级与动力区设施等级同步。
- `other_power_facility_list`：`[水力, 风力, 光伏]` 设备数量，人力发电按行为触发。
- `battery_list`：`[L1, L2, L3]` 电池数量，对应不同容量与自放电率。
- `power_supply_strategy`：各区块供电策略 ID（参见 `Supply_Strategy.csv`）。
- `materials_resouce`：资源仓库。动力系统使用的关键资源为燃料 15、副反应炉模块 51、蓄电池模块 52、清洁能源模块 53。

## CSV 与配置映射

- `data/csv/Power_Generation.csv`：`category` 列定义主反应炉、副反应炉、水力、风力、光伏、人力等条目；`level` 区分不同工况或绝顶等级；`value` 为理论产能或燃料消耗量。
- `data/csv/Power_Storage.csv`：按等级提供单体容量与自放电率；`config_power_storage_level_index` 生成映射供面板查询。
- `data/csv/Supply_Strategy.csv`：定义策略倍率（标准、超额、断电、备用、节能），对应 UI 中的循环切换。
- `data/csv/Facility.csv` 与 `Facility_effect.csv`：区块层级、子设施耗电、等级信息。`get_zone_power_consumption()` 根据名称、`type` 与效果表匹配耗电。
- `data/csv/Resource.csv`：提供资源 ID 与说明，供燃料/模块等提示文本使用。

所有 CSV 变更需执行 `python buildconfig.py` 以生成 `Script/Config/config_def.py` 与 `game_config` 的缓存映射。

## 理论值计算流程

1. **火力发电**：
   - 主炉等级直接取 `facility_level[1]`。
   - 副炉每日计划燃料 = 副炉数量 × `Power_Generation.csv` 中“副反应炉”的基础值。
   - 调控员加成：主调控员按类型专属加成，其他调控员贡献 1/5。
   - 理论发电量 = 计划燃料 × 主炉效率 × 调控员倍率。
2. **清洁能源**：
   - 读取设备数量与固定等级（目前默认 level=3），再乘以 `random.uniform(0.8, 1.2)` 模拟环境波动。
   - 行驶状态 (`move_target_and_time[0] != 0`) 时，水力/风力归零。
   - 不满足设施等级要求时（风力 <4，光伏 <5）禁止调整并显示不可用提示。
3. **耗电计算**：
   - 遍历所有 `type == -1` 的区块，读取对应设施耗电，并乘以策略系数。
   - 子设施归属通过 CID、名称包含或 `type == zone_cid` 判定。

## 每日结算流程

`settle_power_system()` 在每日循环或调试时执行（`basement.py` 中预留调用示例）：
1. 计算火电理论值，按实际燃料库存扣除资源 15，产能随燃料占比缩放。
2. 计算清洁能源产出并累加。
3. 比较总发电与总耗电：
   - 若不足：优先消耗蓄电池，无法覆盖时返回缺口比例（用于后续效率惩罚拓展）。
   - 若有余：先处理自放电，再将盈余充电，超出容量部分视为浪费。
4. 文本报告通过 `draw.WaitDraw()` 输出，可用于日志或 UI。

## UI 交互划分

- **概览页**：展示理论供需、储能、调控员、各能源设施数量，入口按钮指向四个子界面。
- **供电策略**：逐区块显示当前策略与耗电，提供 `[-]` / `[+]` 轮换策略；策略数据来源 `Supply_Strategy.csv`。
- **调控员管理**：
  - 显示总加成与数量。
  - 调用 `manage_basement_panel.change_npc_work_out` 进行岗位增减。
  - 主调控员任命通过公共 NPC 选择面板，避免多槽重复。
- **发电设施管理**：
  - 汇总燃料库存与可支撑天数。
  - 调整副反应炉数量、清洁能源设备数量（受模块与等级双重限制）。
  - 展示模块库存（资源 51/53）与设施不可用原因。
- **蓄电池管理**：
  - 调整 L1~L3 电池数量，受模块（资源 52）与区块等级限制。
  - 即时刷新总容量与自放电率。

## 人力发电逻辑

- 触发条件：角色处在人力发电室并完成不同强度的高潮（第二结算常量 `STORE_*_ORGASM_CHARGE`）。
- 绝顶等级对应 `Power_Generation.csv` 的“人力”条目；超多重绝顶以 4 次为基线并按 4 的指数级放大。
- 玩家（角色 ID 0）额外获得 10 倍电量；高潮后将欲情槽 (`status_data[12]`) 减半。
- 可通过 `draw_flag` 控制是否即时输出提示，避免在离线或批量结算时刷屏。

## 扩展与维护建议

1. **新增能源类型**：
   - 扩充 `Power_Generation.csv` 并在 `other_power_facility_list` 或新字段中存储数量。
   - 在面板与 `get_theoretical_*` 中补充计算与显示逻辑。
2. **策略/事件联动**：
   - 可在缺电时触发随机事件或降低 `cache.rhodes_island.effectiveness`，接口可扩展在 `settle_power_system()` 返回的缺口比例之上。
3. **引入天气/环境系统**：
   - 当前清洁能源默认读取 level=3，可与天气模块建立映射替换固定等级与随机振幅。
4. **自动每日结算**：
   - 目前 `basement.py` 中的调用被注释，建议在每日刷新流程中集成 `settle_power_system(draw_flag=False)`，再视需要输出摘要。
5. **数据刷新**：
   - 修改 CSV 后务必运行 `python buildconfig.py`，保证 `game_config` 映射包含新条目。

## 注意事项

- UI 对齐依赖 `attr_calculation.pad_display_width()`，在新增字符串时需考虑全角字符宽度以防错位。
- `power_supply_strategy` 默认仅包含主区块，新增区块或策略时务必在初始化流程中同步。
- 旧存档可能缺少扩展模块字段，`_init_power_runtime_fields()` 会兜底，但新增字段后建议编写迁移逻辑。
- 清洁能源与蓄电池的上限计算使用模块库存与区块等级叠加，进行脚本修改时注意保持这一校验顺序，防止负值或超限。