# 剧情文本 → 外勤委托 数据化工作流

适用范围：将活动/章节的关卡剧情（txt/总结md）转化为一组可游玩的外勤委托（Commission.csv），确保语义贴合、格式合法、可被 buildconfig.py 正确解析并在游戏内出现。

## 输入
- 剧情素材：按关卡或场景拆分（GT-1…GT-6、EX/HX），建议先整理为《剧情总结.md》。
- 现有数据：`data/csv/Commission.csv`
- 相关字典 CSV：资源与物资(`data/csv/Resource.csv`)、角色能力(`data/csv/Ability.csv`)、角色经验(`data/csv/Experience.csv`)、角色宝珠奖励(`data/csv/Juel.csv`)、角色势力(`data/csv/Nation.csv`)、角色出身地(`data/csv/Birthplace.csv`)。

## 输出
- 一批新增的委托条目（建议使用一个连续的 ID 区段，如 2601+），并写入 `data/csv/Commission.csv`。
- 委托彼此使用 `related_id` 形成链式或树状进度；`special=1` 标记一次性/剧情型。

## 字段与格式速查
- 列顺序（保持不变）：
  - `cid,name,country_id,level,type,people,time,demand,reward,related_id,special,description`
- 类型枚举：`type` 取值（资源/源石/成长/势力/角色/支线）——剧情型建议用“支线”。
- 需求/奖励语法：
  - 以 `&` 连接多项；前缀对照参见《外勤委托系统.md》：`r_`资源、`a_`能力、`e_`经验、`j_`宝珠、`t_`素质、`c_`角色、`m_`状态、`声望_`势力声望、`特产_`地区特产等。
  - 无需求写“无”。
- 注意：CSV 用英文逗号分隔；文本内如需逗号，使用中文逗号或用换行 `\n`；避免破坏列。

## 映射步骤（Checklist）
1. 关卡卡点拆解：为每个关键节点定义一个委托（“救援”“突围”“陷阱清理”“对峙”“善后”等）。
2. 难度与耗时分配：按剧情紧急度设置 `level`（1-5）与 `time`（天），现场战斗更偏 `a_42`（战斗）、医疗为 `a_46`，工程为 `a_48`，指挥为 `a_41`，谈判/学术为 `a_40/a_45`。
3. 需求侧：
   - 作战：`a_42_X`；医疗：`a_46_X`；工程：`a_48_X`；指挥：`a_41_X`；谈判/知识：`a_40_X/a_45_X`；资源：`r_XX_数`；复合用 `&`。
4. 奖励侧：
   - 通用经验：`e_81` 战斗、`e_90` 医疗、`e_87` 指挥、`e_90` 工程、`e_80/82` 交流/学术；根据节点大小配置 `5/10/20/35/50`。
   - 声望：`声望_0_30/50/100` 随剧情影响加权；必要时给 `r_` 少量物资或 `j_` 代币。
5. 关联：
   - 用 `related_id` 串起剧情链（首个用 `-1`），保持可追踪的推进顺序。
6. 标记：
   - 剧情型建议 `special=1` 表示一次性完成。
7. 描述：
   - 用2句话到4句话概述行动目标与节点处置，每句话不少于50中文字符，详细概括节点剧情。文本风格与给出的示例保持一致。

## 模板
```
260X,委托名,-1,等级,支线,人数,耗时,需求,奖励,上一ID,1,委托描述
```
示例：
```
2601,滴水村救援行动,-1,2,支线,2,1,a_42_3&a_46_2,e_81_10&声望_0_30,-1,1,因为宝藏传说而动荡不安的滴水村，迎来了一位来自维多利亚的潇洒骑警：格拉尼。在救下了被严刑拷打的可萝尔后，格拉尼承诺会帮助滴水村。\n躲藏在阁楼之中的格拉尼和可萝尔详细讨论了关于宝藏的情报，可萝尔并没有全盘托出。就在二人打算行动之时，窗外竟然有人飞了出去？
```

## 质量检查
- 语法：前缀合法、`&` 拼接正确、无多余空格；`related_id` 存在或为 `-1`。
- CSV：英文逗号分隔；多行描述用 `\n`；不在中间出现未转义英文逗号。
- 解析：运行 `python buildconfig.py`，确认无 KeyError/字段缺失。

## 构建与验证
1. 执行构建：运行 `python buildconfig.py`（工作区根目录）。
2. 启动游戏/加载数据：`python game.py`；在对应面板查看是否出现新委托。
3. Web 渲染模式：`config.ini` 设置 `web_draw = 1` 可调试 Web UI；必要时 `debug = 1`。

## 常见问题
- 新增前缀？在 `process_commission_text()` 增加解析并实现结算；同时更新该文档“前缀对照”。
- ID 冲突？改用新的连续区段；保持唯一性。
- 文案太长？摘要到 2-4 句，详细剧情放在总结文档里。
