# 剧情总结工作流（可复用指引）

本指引用于：当你提供若干剧情文本（txt）时，快速生成一份结构化、可检索的 Markdown 剧情总结文档，并落库归档。

适用范围：Arknights/活动章节/支线等剧情文本；也可拓展到其他模块的事件/口上整理。

---

## 1. 输入规范
- 文件来源：`data/data_from_game/<章节名>/` 下的若干 `*.txt`。
- 文件命名建议：`<关卡ID>_<标题>_<0/1>_<行动前/行动后>.txt`（例：`GT-5_各抒己见_0_行动前.txt`）。
- 必备内容：
  - 关卡名与阶段（前/后）。
  - 主要人物对白与舞台指示（如 [Background]、[PlayMusic] 等）——总结时只抽要点，不逐字抄录。
- 提交方式：一次性提供全部相关 txt，或分批补充（需在总结文档中追加或完善已有内容）。

## 2. 输出目标
- 生成 `剧情总结.md`：
  - 放置路径：`data/data_from_game/<章节名>/剧情总结.md`
  - 包含：概述、角色与阵营、时间线、逐关卡详述、对白摘要、关键设定、主题冲突、关系变化、伏笔与未解、结局快照、关卡要点速查。
  - 要求：
    - 不大段复刻台词，使用“要点化摘要”。
    - 关卡顺序与编号严谨（先 GT-1…GT-6，再 EX/HX）。

## 3. 操作步骤（Checklist）
1) 收集与排序
- 按关卡编号与阶段（前/后）整理清单：GT-1…GT-6、EX-?、HX-?。
- 记录每个文件的“场景/冲突/发展/结果”四要素。

2) 角色与阵营提炼
- 列表化主要角色、组织与动机（示例：格拉尼、可萝尔、大鲍勃、斯卡蒂、整合运动、各赏金猎人团、临光、凯尔希、幽灵鲨等）。

3) 时间线编排
- 将关键事件串联，标注转折与因果（谁做了什么→导致什么）。

4) 分章详述（逐关卡）
- 模板：
  - 标题：`### <关卡ID> <标题>（行动前/后）`
  - 内容：
    - 场景
    - 冲突/事件
    - 发展/信息揭示
    - 结果/去向
    - 对白摘要（列 3–6 条关键台词或信息点）

5) 关键设定与物件
- 汇总特殊机制/道具/世界观：如“钥匙需血脉并会吸血”“森林暗号与陷阱体系”“骑士陵墓传统”“融芯/核心/记忆块”等。

6) 主题与关系
- 主题：责任与牺牲、生存与伦理、强者与规训、秘密与代价等。
- 关系：主要角色间立场与变化。

7) 伏笔与未解
- 标出未来可能展开的问题与线索。

8) 关卡要点速查
- 用 1–2 行/关卡的流水账速记，便于快速回忆。

9) 保存与更新
- 初次创建：新建 `剧情总结.md`。
- 后续补充：以“增量追加”方式补小节，或完善既有内容；更新时间线与速查列表。

## 4. 文档模板（可直接拷贝）

```markdown
# <章节名> 剧情总览（含 GT/EX/HX 等）

- 文档目的：……
- 覆盖范围：GT-1…GT-6（前/后）+ EX/HX（后）。

## 目录
- 概述
- 主要角色与阵营
- 时间线总览
- 分章详述（逐关卡）
  - GT-1 …（前/后）
  - GT-2 …（前/后）
  - …
  - EX-…（后）
  - HX-…（后）
- 关键设定与物件
- 主题与冲突
- 关系与立场变化
- 伏笔与未解
- 结局状态快照
- 附：关卡要点速查

---

## 概述
（2–4 段，交代冲突本体、核心目标与外力介入）

## 主要角色与阵营
- 角色A：目标/特征
- 角色B：目标/特征
- 组织/势力：目标/手段

## 时间线总览
1. GT-1（前/后）：……
2. GT-2（前/后）：……
…

## 分章详述（逐关卡）
### GT-1 <标题>（行动前/后）
- 场景：
- 冲突：
- 发展：
- 结果：
- 对白摘要：
  - 要点1
  - 要点2

（按关卡递推）

## 关键设定与物件
- 设定/道具A：说明
- 设定/道具B：说明

## 主题与冲突
- 主题A：说明
- 主题B：说明

## 关系与立场变化
- A ⇄ B：变化要点

## 伏笔与未解
- 线索A：说明

## 结局状态快照
- 地点/人物：状态

## 附：关卡要点速查
- GT-1：一句话
- GT-2：一句话
```

## 5. 质量检查（Quality Gates）
- 结构：目录完整；关卡顺序正确；每关有“对白摘要”。
- 内容：无长段逐字引用；摘要准确不歪曲含义；设定与名词一致。
- 可维护性：后续补充能按模板无缝追加；时间线与速查同步更新。

## 6. 常见问题
- Q：没有“行动前”的文本怎么办？
  - A：在该小节注明“本关行动前无对白/按后段承接”，不要空缺。
- Q：补充零散文件会打乱结构？
  - A：坚持“增量追加”，并在时间线与速查处做对应增修。

---

维护者提示：若用于 Web 渲染，请避免嵌套过深的列表；必要时为每关添加锚点（如 `### GT-1 …`），以便目录链接。
