# 农业生产系统说明

## 系统概述

农业生产系统是erArk游戏中的核心基地管理功能之一，主要负责药材和香料的生产，为基地的医疗和香薰系统提供原材料支持。该系统通过药田和温室两种设施进行生产，并与基地的人员管理、资源存储、设施升级等多个子系统深度集成。

## 核心文件结构

### 主要代码文件

#### 1. 农业生产面板 (`Script/UI/Panel/agriculture_production_panel.py`)
- **功能**: 农业生产的主要UI界面和生产结算逻辑
- **核心类**: `Agriculture_Production_Panel`
- **关键函数**:
  - `settle_agriculture_line()`: 每日农业生产结算
  - `select_agriculture_line_produce()`: 选择生产作物
  - `change_agriculture_line_produce()`: 更改生产线种植内容

#### 2. 基地管理系统 (`Script/Design/basement.py`)
- **功能**: 基地设施管理和资源更新的核心逻辑
- **关键函数**:
  - `get_base_zero()`: 初始化农业生产线数据结构
  - `get_base_updata()`: 更新设施效果和生产效率
  - `update_base_resouce_newday()`: 每日资源结算
  - `update_work_people()`: 分配农业工作人员

#### 3. 基地管理面板 (`Script/UI/Panel/manage_basement_panel.py`)
- **功能**: 基地管理的主界面，提供农业系统的访问入口
- **特性**: 资源概览、人员分配、设施管理

## 数据结构设计

### 农业生产线数据结构

```python
# 药田生产线 (cache.rhodes_island.herb_garden_line)
herb_garden_line[line_id] = [
    resource_id,     # 生产的资源ID (0=未种植, 11=普通药材)
    worker_set,      # 分配的工作人员集合
    efficiency,      # 当前生产效率百分比
    unused_field,    # 未使用字段
    harvest_hour     # 收获时间 (小时)
]

# 温室生产线 (cache.rhodes_island.green_house_line)
green_house_line[line_id] = [
    resource_id,     # 生产的资源ID (0=未种植, 16=香料)
    worker_set,      # 分配的工作人员集合
    efficiency,      # 当前生产效率百分比
    unused_field,    # 未使用字段
    harvest_hour     # 收获时间 (小时)
]
```

### 资源配置数据

#### 主要农业资源 (`data/csv/Resource.csv`)

| 资源ID | 资源名称 | 类型 | 价格 | 用途 |
|--------|----------|------|------|------|
| 11 | 普通药材 | 材料 | 1000 | 各类常见病和内外伤治疗所用的药材 |
| 16 | 香料 | 材料 | 100 | 各类香料，用以调制香精的原料，可以用来制作各种香水 |

#### 设施配置 (`data/csv/Facility.csv`)

| 设施ID | 设施名称 | 类型 | 功能描述 |
|--------|----------|------|----------|
| 16 | 疗养庭院 | -1 | 农业的相关场所，升级可以解锁更多的农业设施和提高生产效率 |

#### 设施效果配置 (`data/csv/Facility_effect.csv`)

| 效果ID | 设施名称 | 等级 | 效果 | 耗电量 | 功能描述 |
|--------|----------|------|------|--------|----------|
| 161 | 疗养庭院 | 1 | 0% | 10 | 开放基础设施:【药田】 |
| 162 | 疗养庭院 | 2 | 5% | 15 | 开放新设施:【温室】，生产效率加成提升至5% |
| 163 | 疗养庭院 | 3 | 20% | 30 | 开放新设施:【香熏治疗室】，生产效率加成提升至20% |
| 164 | 疗养庭院 | 4 | 50% | 50 | 生产效率加成提升至50%，每日可进行两次香薰疗愈 |
| 165 | 疗养庭院 | 5 | 100% | 80 | 生产效率加成提升至100%，每日可进行三次香薰疗愈 |

## 生产机制详解

### 生产计算公式

```python
# 基础生产量计算
max_time = 10  # 每日基础生产时间
produce_effect = production_line[2] / 100  # 生产效率百分比转换
adjust = (effectiveness - damage_down) / 100  # 总调整系数

# 最终生产数量
produce_num = int(max_time * produce_effect * adjust)
```

### 效率加成计算

1. **设施等级加成**: 基于疗养庭院的等级提供基础效率
2. **人员能力加成**: 工作人员的农业技能等级 × 10%
3. **设备故障减成**: 设施损坏时降低生产效率

```python
# 效率加成计算示例
facility_effect = game_config.config_facility_effect[facility_cid].effect
character_effect = int(10 * attr_calculation.get_ability_adjust(character_data.ability[47]))
all_effect = facility_effect + sum(character_effects)
```

### 生产结算流程

1. **每日结算触发**: 通过 `basement.update_base_resouce_newday()` 调用
2. **遍历生产线**: 分别处理药田和温室的所有生产线
3. **计算产量**: 根据效率和调整系数计算实际产量
4. **资源更新**: 将产量添加到基地资源存储
5. **容量检查**: 确保不超过仓库存储上限
6. **状态重置**: 重置收获时间标记

## 人员管理系统

### 工作类型配置 (`data/csv/WorkType.csv`)

| 工作ID | 工作名称 | 所需能力 | 工作地点 |
|--------|----------|----------|----------|
| 161 | 药材种植员 | 农业技能(47) | 药田 |
| 162 | 花草种植员 | 农业技能(47) | 温室 |

### 人员分配机制

- **自动分配**: 系统根据角色的农业技能自动分配到相应生产线
- **技能要求**: 需要具备农业技能(Ability ID: 47)
- **效率贡献**: 技能等级越高，提供的生产效率加成越大

## 相关系统集成

### 1. 香薰治疗系统
- **原料来源**: 使用农业系统生产的香料(资源ID: 16)
- **处理流程**: 香料 → 浓缩香精 → 各类香薰产品
- **文件位置**: `Script/UI/Panel/aromatherapy_panel.py`

### 2. 资源存储系统
- **存储限制**: 受仓库等级限制，超出容量时停止生产
- **资源统计**: 所有农业产品纳入基地资源管理
- **容量计算**: `cache.rhodes_island.warehouse_capacity`

### 3. 设施升级系统
- **升级条件**: 需要工业材料和龙门币
- **效果提升**: 每级提升生产效率并解锁新设施
- **电力消耗**: 高等级设施需要更多电力支持

## 用户界面设计

### 主界面功能

1. **资源概览**: 显示当前仓库容量和农业资源数量
2. **生产线状态**: 展示每条生产线的当前作物和效率
3. **效率详情**: 详细显示设施等级和人员贡献的效率加成
4. **生产调整**: 允许玩家更改生产线的种植内容
5. **人员管理**: 提供种植员增减的管理入口

### 交互流程

```
主面板 → 生产调整 → 选择作物 → 确认更改
      ↓
   人员管理 → 工作分配 → 效率计算
```

## 开发注意事项

### 代码结构特点

1. **模块化设计**: UI逻辑与业务逻辑分离
2. **数据驱动**: 大量使用CSV配置文件驱动功能
3. **实时更新**: 通过 `get_base_updata()` 保持数据同步
4. **错误处理**: 包含设备故障、容量限制等异常情况处理

### 扩展接口

- **新作物类型**: 通过修改 `Resource.csv` 和生产逻辑添加
- **新设施类型**: 通过 `Facility.csv` 和 `Facility_effect.csv` 配置
- **新工作类型**: 通过 `WorkType.csv` 添加专业化工作角色

### 性能考虑

- **批量处理**: 每日结算时批量处理所有生产线
- **缓存机制**: 使用 `cache_control.cache` 管理游戏状态
- **效率计算**: 预计算并缓存复杂的效率公式结果

## 总结

农业生产系统是erArk游戏中一个复杂而完整的子系统，它不仅提供了基础的资源生产功能，还与人员管理、设施升级、香薰治疗等多个系统形成了有机的整体。该系统的设计体现了数据驱动、模块化和可扩展的软件架构原则，为游戏的深度和可玩性提供了重要支撑。

通过深入理解这个系统的设计思路和实现细节，开发者可以更好地维护和扩展相关功能，同时也可以将其作为设计其他游戏系统的参考模板。