# 催眠系统

## 系统概述

催眠系统是erArk游戏中源石技艺系统的核心子系统，允许玩家（博士）通过消耗理智对NPC角色施展催眠，控制其行为和意识状态。催眠系统包含多种催眠类型，从基础的平然催眠到高级的心控催眠，每种类型都有不同的效果和使用条件。

## 核心文件结构

### 主要代码文件

1. **Script/UI/Panel/originium_arts.py** - 催眠系统主面板和核心逻辑
   - `calculate_hypnosis_sanity_cost()` - 计算催眠理智消耗
   - `hypnosis_degree_calculation()` - 计算催眠深度增长
   - `hypnosis_degree_limit_calculation()` - 计算催眠深度上限
   - `evaluate_hypnosis_completion()` - 判断催眠完成并结算

2. **Script/Core/game_type.py** - 催眠数据结构定义
   - `HYPNOSIS` 类 - 催眠状态数据结构
   - `SP_FLAG` 类中的 `unconscious_h` - 无意识状态标记

3. **Script/Design/handle_talent.py** - 催眠素质处理
   - `have_hypnosis_talent()` - 检查玩家催眠能力
   - `npc_gain_hypnosis_talent()` - NPC获得催眠素质

4. **Script/Design/handle_instruct.py** - 催眠指令处理
   - `handle_hypnosis_one()` - 单人催眠指令
   - `handle_deepening_hypnosis()` - 加深催眠指令
   - `handle_hypnosis_all()` - 集体催眠指令
   - `handle_hypnosis_*()` - 各种催眠效果指令

5. **Script/Design/handle_premise.py** - 催眠前提判断
   - 催眠状态相关的前提条件判断函数

6. **Script/Design/settle_behavior.py** - 催眠行为结算
   - 催眠相关行为的结算和效果处理

7. **Script/Design/handle_npc_ai_in_h.py** - H状态下的催眠AI处理
   - 催眠状态下NPC的行为控制逻辑

### 配置数据文件

1. **data/csv/Hypnosis_Type.csv** - 催眠类型配置表
2. **data/csv/Hypnosis_Talent_Of_Pl.csv** - 玩家催眠素质配置表
3. **data/csv/Hypnosis_Talent_Of_Npc.csv** - NPC催眠素质配置表
4. **data/csv/Roleplay.csv** - 角色扮演配置表
5. **data/talk/arts/hypnosis_*.csv** - 催眠相关对话文本

## 系统架构

### 1. 催眠数据结构

#### 1.1 HYPNOSIS类（催眠状态数据）
```python
class HYPNOSIS:
    hypnosis_degree: float = 0          # 催眠程度（0-200%）
    increase_body_sensitivity: bool     # 体控-敏感度提升
    force_ovulation: bool              # 体控-强制排卵
    blockhead: bool                    # 体控-木头人
    active_h: bool                     # 体控-逆推
    roleplay: int = 0                  # 心控-角色扮演类型
    pain_as_pleasure: bool             # 心控-苦痛快感化
```

#### 1.2 无意识状态标记（SP_FLAG.unconscious_h）
```python
unconscious_h: int = 0  # [0否,1睡眠,2醉酒,3时停,4平然,5空气,6体控,7心控]
```

#### 1.3 玩家催眠能力数据
```python
hypnosis_type: int = 0                 # 当前选择的催眠类型
air_hypnosis_position: str = ""        # 空气催眠位置记录
```

### 2. 催眠类型体系

#### 2.1 催眠类型分类

| 催眠类型ID | 名称 | 需要素质ID | 催眠深度要求 | unconscious_h值 | 效果描述 |
|-----------|------|-----------|-------------|-----------------|----------|
| 0 | 无 | 331 | 50% | 0 | 手动选择催眠类型 |
| 1 | 平然 | 331 | 50% | 4 | 目标接受不合理行为 |
| 2 | 空气 | 333 | 100% | 5 | 目标视博士为空气 |
| 3 | 体控 | 334 | 200% | 6 | 控制目标身体 |
| 4 | 心控 | 334 | 200% | 7 | 控制目标心理 |

#### 2.2 催眠素质等级

**玩家催眠素质：**
- 331：平然催眠（最高50%催眠深度）
- 332：深度催眠（最高100%催眠深度）
- 333：空气催眠（最高100%催眠深度）
- 334：完全催眠（最高200%催眠深度）

**NPC被催眠素质：**
- 71：被初级催眠（催眠深度≥50%）
- 72：被深度催眠（催眠深度≥100%）
- 73：被完全催眠（催眠深度≥200%）

### 3. 催眠机制详解

#### 3.1 催眠深度计算
```python
def hypnosis_degree_calculation(target_character_id: int) -> float:
    # 基础增长值
    base_addition = 1
    
    # 根据玩家催眠能力调整系数
    hypnosis_degree_adjust = 2  # 基础系数
    if pl_character_data.talent[334]:      # 完全催眠
        hypnosis_degree_adjust = 6
    elif pl_character_data.talent[333]:    # 空气催眠
        hypnosis_degree_adjust = 4
    
    # 调香状态加成
    if target_character_data.sp_flag.aromatherapy == 6:
        hypnosis_degree_adjust += 5
    
    # 无觉刻印能力加成
    hypnosis_degree_adjust *= attr_calculation.get_ability_adjust(target_character_data.ability[19])
    
    # 随机系数0.5-1.5
    hypnosis_degree_adjust *= random.uniform(0.5, 1.5)
    
    # 最终计算并保留1位小数
    return round(base_addition * hypnosis_degree_adjust, 1)
```

#### 3.2 理智消耗计算
```python
def calculate_hypnosis_sanity_cost(character_id: int) -> int:
    base_cost = 10
    if character_data.talent[73]:      # 被完全催眠
        return 1
    elif character_data.talent[72]:   # 被深度催眠
        return base_cost + 20
    elif character_data.talent[71]:   # 被初级催眠
        return base_cost + 15
    else:
        return base_cost + 10
```

#### 3.3 催眠深度上限
根据玩家拥有的催眠素质确定：
- 素质331：上限50%
- 素质332：上限100%
- 素质333：上限100%
- 素质334：上限200%

### 4. 催眠效果系统

#### 4.1 平然催眠（unconscious_h = 4）
- **效果**：目标正常交互但接受不合理行为
- **持续条件**：直到目标睡觉或博士主动解除
- **行为影响**：目标不会认为被做了不该做的事

#### 4.2 空气催眠（unconscious_h = 5）
- **效果**：目标视博士为空气，忽略博士行为
- **特殊要求**：需要可锁门的场所，自动锁门
- **持续条件**：离开当前场所时自动解除
- **位置记录**：`pl_ability.air_hypnosis_position`记录催眠位置

#### 4.3 体控催眠（unconscious_h = 6）
- **效果**：身体听从命令，精神正常但无法控制身体
- **持续条件**：直到猥亵或H结束
- **可用效果**：
  - 敏感度提升（`increase_body_sensitivity`）
  - 强制排卵（`force_ovulation`）
  - 木头人状态（`blockhead`）
  - 逆推状态（`active_h`）

#### 4.4 心控催眠（unconscious_h = 7）
- **效果**：精神完全服从，无条件接受指令
- **持续条件**：永久持续直到博士主动解除
- **可用效果**：
  - 角色扮演（`roleplay`）
  - 苦痛快感化（`pain_as_pleasure`）

### 5. 角色扮演系统（重要更新）

心控催眠可设置角色扮演类型，这是催眠系统的核心功能之一。近期进行了重大重构和AI文本生成功能集成。

#### 5.1 系统架构重构
角色扮演系统经历了重大重构，现在支持：
- **多层分类体系**：主类型 + 子类型的二级分类结构
- **智能选择逻辑**：根据已选择的类型自动限制可选项
- **展开/收起界面**：支持分类折叠的用户友好界面
- **冲突检测机制**：自动处理特殊类与普通类的互斥关系

#### 5.2 角色扮演分类体系

**5.2.1 家庭类（主类型：家庭，子类型：无）**
- 1：妻子 - 感情深厚的夫妻关系
- 2：姐姐 - 照顾弟弟的亲姐姐
- 3：妹妹 - 依赖哥哥的亲妹妹
- 4：女儿 - 天真可爱的亲生女儿
- 5：妈妈 - 有保护欲和溺爱的母亲

**5.2.2 职业类（主类型：职业，多种子类型）**

*校园子类：*
- 11：小学生 - 天真无邪，充满好奇心
- 12：初中生 - 叛逆期但依赖大人
- 13：高中生 - 青春活泼，面临升学压力
- 14：大学生 - 追求梦想和独立
- 15：教师 - 负责教导学生的老师

*护士子类：*
- 21：护士 - 温柔体贴的专业护士

*偶像子类：*
- 24：偶像 - 国民级美少女偶像

*女仆子类：*
- 25：家庭女仆 - 家庭雇佣的女仆
- 26：咖啡厅女仆 - 女仆咖啡厅工作的女仆

*巫女子类：*
- 27：巫女 - 神社的巫女

*其他职业：*
- 22：警察 - 维护社会秩序的警察
- 23：白领 - 工作繁忙的公司职员

**5.2.3 关系类（主类型：关系，多种子类型）**

*非家庭子类：*
- 31：陌生人 - 没有任何关系的陌生人
- 34：同事 - 工作上互相支持的同事
- 35：邻居 - 住在隔壁的邻居

*校园子类：*
- 32：师生 - 教导的师生关系
- 33：同学 - 亲密的同班同学

**5.2.4 人外类（主类型：人外）**

*特殊子类：*
- 51：宠物猫 - 以为自己是猫的角色
- 52：宠物狗 - 以为自己是狗的角色

*无子类：*
- 53：魅魔 - 以吸取精气为生的魅魔

**5.2.5 场景类（主类型：场景，多种子类型）**

*通用子类：*
- 101：电车痴汉 - 拥挤电车上的痴汉行为
- 102：户外当众 - 公共场所的亲密行为
- 103：公共厕所（主动） - 主动等待的肉便器
- 104：公共厕所（被动） - 被绑架的肉便器

*特殊子类：*
- 105：俘虏拷问 - 审讯官对俘虏的调教
- 107：战败魔法少女 - 魔物对魔法少女的调教
- 124：偶像枕营业 - 偶像为获得机会的交易

*各职业对应子类：*
- 106：榨精护士（护士子类）
- 108：VTuber直播中（家庭子类）
- 109：向神灵祭祀（巫女子类）
- 110：向自己祭祀（巫女子类）
- 111：女仆惩罚调教（家庭女仆子类）
- 112：女仆咖啡厅里菜单（咖啡厅女仆子类）
- 121：偶像台前准备室（偶像子类）
- 122：偶像单人LIVE（偶像子类）
- 123：偶像演出后粉丝答谢（偶像子类）
- 131：放学后教室H（校园子类）
- 132：体育仓库H（校园子类）
- 133：天台H（校园子类）
- 134：学校厕所H（校园子类）
- 135：保健室H（校园子类）

#### 5.3 选择规则和限制

**5.3.1 基本规则**
- 非特殊类中，每个主类型可各选一个，同时起效
- 特殊类（宠物猫、宠物狗、俘虏拷问、战败魔法少女、偶像枕营业）与其他催眠相冲突，只能单独起效
- 选择特殊类时，会清空所有其他已选项目

**5.3.2 子类型联动机制**
- 职业类选择后，可进一步选择其他类中带有相同子类型前缀的场景
- 例如：选择"护士"后，可选择"榨精护士"场景
- 选择"校园"相关职业后，可选择各种校园场景

**5.3.3 互斥关系**
- 非家庭子类与家庭类互斥，不能同时选择
- 同学与教师互斥，不能同时选择
- 特殊子类项目之间互斥

#### 5.4 AI文本生成集成（新功能）

角色扮演催眠现已完全集成到AI文本生成系统中：

**5.4.1 AI提示词生成**
- 在`handle_chat_ai.py`中的`build_user_prompt()`函数处理角色扮演数据
- 自动将角色扮演信息传递给AI模型作为角色设定
- 支持多个角色扮演同时生效的复杂提示词构建

**5.4.2 动态角色信息构建**
```python
# 角色扮演信息提取和处理
if handle_premise.handle_hypnosis_roleplay(npc_character_id):
    sub_name = game_config.config_hypnosis_sub_type[12].name
    sub_info = game_config.config_hypnosis_sub_type[12].introduce
    hypnosis_name += " " + sub_name
    new_info += sub_info
    # 遍历所有已选择的角色扮演类型
    if len(npc_character_data.hypnosis.roleplay):
        for roleplay_id in npc_character_data.hypnosis.roleplay:
            roleplay_data = game_config.config_roleplay[roleplay_id]
            roleplay_info = roleplay_data.info
            new_info += " " + roleplay_info
```

**5.4.3 配置数据驱动**
- 通过`cache.ai_setting.send_data_flags[61]`控制催眠信息是否发送给AI
- 支持用户自定义AI文本生成中是否包含角色扮演信息
- 角色扮演信息会动态影响AI生成的文本内容和语调

#### 5.5 新版用户界面系统

**5.5.1 `Chose_Roleplay_Type_Panel`类**
完全重构的角色扮演选择面板，提供以下功能：

- **分类展开/收起**：`toggle_type_expand()`方法支持按类型折叠显示
- **智能选择判断**：`judge_can_select()`方法处理复杂的选择限制逻辑
- **缓存机制**：使用`selected_roleplay_cache`临时存储选择，确认后再应用
- **冲突检测**：自动处理特殊类与普通类的互斥关系
- **联动选择**：支持职业-场景子类型的联动选择机制

**5.5.2 用户交互流程**
```
1. 进入角色扮演选择面板
2. 按类型展开/收起显示选项
3. 根据已选项目动态调整可选范围
4. 临时缓存用户选择
5. 确认后应用到角色数据
6. 自动触发AI文本生成系统更新
```

**5.5.3 数据结构变化**
角色扮演数据现在存储为列表格式：
```python
# 旧版本（单一角色扮演）
character_data.hypnosis.roleplay: int = 0

# 新版本（多角色扮演支持）
character_data.hypnosis.roleplay: List[int] = []
```

### 6. 催眠执行流程

#### 6.1 催眠指令执行流程
```
1. 检查前提条件（理智、体力、场景等）
2. 消耗理智（根据目标催眠素质计算）
3. 计算催眠深度增长
4. 累加到目标催眠深度
5. 判断是否达到所需深度
6. 如达到：设置无意识状态，解锁特殊指令
7. 如未达到：提示需要更深催眠
```

#### 6.2 催眠完成判断
```python
def evaluate_hypnosis_completion(character_id: int):
    # 获取当前选择的催眠类型
    now_hypnosis_type = pl_character_data.pl_ability.hypnosis_type
    hypnosis_degree_need = game_config.config_hypnosis_type[now_hypnosis_type].hypnosis_degree
    
    # 检查催眠深度是否足够
    if character_data.hypnosis.hypnosis_degree >= hypnosis_degree_need:
        # 设置无意识状态
        character_data.sp_flag.unconscious_h = now_hypnosis_type + 3
        
        # 空气催眠特殊处理：记录位置并锁门
        if now_hypnosis_type == 2:
            pl_character_data.pl_ability.air_hypnosis_position = pl_character_data.position
            # 强制锁门逻辑
            
        return 1  # 催眠成功
    else:
        return 0  # 催眠失败
```

### 7. 催眠状态下的行为控制

#### 7.1 H状态下的行为限制
```python
# H状态或木头人时，行动锁死为等待不动
if character_data.sp_flag.is_h or character_data.hypnosis.blockhead:
    # 特殊情况例外处理
    if character_data.behavior.behavior_id == constant.Behavior.SLEEP:  # 睡奸例外
        return 1
    if not handle_premise.handle_normal_6(character_id):  # 6异常例外
        return 1
```

#### 7.2 催眠状态自动解除条件
```python
# 结束睡眠猥亵状态
if handle_premise.handle_unconscious_flag_1(character_id):
    character_data.sp_flag.unconscious_h = 0

# 结束空气催眠（离开位置时）
if (handle_premise.handle_unconscious_flag_5(character_id) and 
    character_data.position != pl_character_data.pl_ability.air_hypnosis_position):
    character_data.sp_flag.unconscious_h = 0
```

#### 7.3 逆推行为处理
```python
# 如果对方不是主动H状态，则返回
if (target_character_data.hypnosis.active_h == False and 
    target_character_data.h_state.npc_active_h == False):
    return 0
```

### 8. 前提条件系统

#### 8.1 催眠状态判断前提
- `IN_HYPNOSIS` - 自己处于催眠状态（unconscious_h in [4,5,6,7]）
- `NOT_IN_HYPNOSIS` - 自己未处于催眠状态
- `TARGET_IN_HYPNOSIS` - 交互对象处于催眠状态
- `TARGET_NOT_IN_HYPNOSIS` - 交互对象未处于催眠状态

#### 8.2 催眠效果相关前提
- `SELF_HYPNOSIS_INCREASE_BODY_SENSITIVITY` - 自己被体控-敏感度提升
- `TARGET_HYPNOSIS_FORCE_OVULATION` - 交互对象被体控-强制排卵
- `TARGET_HYPNOSIS_BLOCKHEAD` - 交互对象被体控-木头人
- `TARGET_HYPNOSIS_ACTIVE_H` - 交互对象被体控-逆推
- `TARGET_HYPNOSIS_ROLEPLAY_*` - 交互对象被心控-特定角色扮演
- `TARGET_HYPNOSIS_PAIN_AS_PLEASURE` - 交互对象被心控-苦痛快感化

#### 8.3 催眠能力前提
- `PRIMARY_HYPNOSIS` - 拥有初级催眠能力（素质331）
- `ADVANCED_HYPNOSIS` - 拥有高级催眠能力（素质333或334）
- `UNCONSCIOUS_HYPNOSIS_FLAG` - 目标处于催眠无意识状态

### 9. 催眠相关指令

#### 9.1 基础催眠指令
- `HYPNOSIS_ONE` - 单人催眠
- `DEEPENING_HYPNOSIS` - 加深催眠
- `HYPNOSIS_ALL` - 集体催眠
- `CHANGE_HYPNOSIS_MODE` - 切换催眠模式
- `HYPNOSIS_CANCEL` - 解除催眠

#### 9.2 体控催眠指令
- `HYPNOSIS_INCREASE_BODY_SENSITIVITY` - 体控-敏感度提升
- `HYPNOSIS_FORCE_CLIMAX` - 体控-强制绝顶
- `HYPNOSIS_FORCE_OVULATION` - 体控-强制排卵
- `HYPNOSIS_BLOCKHEAD` - 体控-木头人
- `HYPNOSIS_ACTIVE_H` - 体控-逆推

#### 9.3 心控催眠指令
- `HYPNOSIS_ROLEPLAY` - 心控-角色扮演设置（已重构为面板系统）
- `HYPNOSIS_PAIN_AS_PLEASURE` - 心控-苦痛快感化

**角色扮演指令特殊处理：**
```python
# 心控-角色扮演需要单独绘制面板
if behavbior_cid == "hypnosis_roleplay":
    now_draw = Chose_Roleplay_Type_Panel(self.width)
    now_draw.draw()
    character_data: game_type.Character = cache.character_data[0]
    target_data: game_type.Character = cache.character_data[character_data.target_character_id]
    # 只有在选择了角色扮演后才执行结算
    if len(target_data.hypnosis.roleplay) != 0:
        handle_instruct.chara_handle_instruct_common_settle(behavbior_cid)
```

### 10. 催眠素质获得机制

#### 10.1 玩家催眠素质获得
通过源石技艺面板的能力获得与升级系统：
- **至纯源石消费**：花费10^(等级-1)个至纯源石直接获得
- **特殊条件解锁**：满足催眠经验和总催眠深度要求

#### 10.2 NPC催眠素质获得
```python
def npc_gain_hypnosis_talent(character_id: int):
    # 检查催眠深度是否达到要求
    if character_data.hypnosis.hypnosis_degree >= now_data.hypnosis_degree:
        # 获得催眠素质
        character_data.talent[now_data.hypnosis_talent_id] = 1
        # 触发二段行为结算
        character_data.second_behavior[now_data.second_behavior_id] = 1
```

### 11. 催眠与其他系统的交互

#### 11.1 与行为系统的交互
- 催眠状态影响NPC的行为选择逻辑
- 不同催眠类型解锁不同的特殊指令
- 催眠状态下的行为结算有特殊规则

#### 11.2 与AI系统的交互
- H状态下，催眠角色的AI行为被特殊处理
- 木头人状态锁死为等待不动
- 逆推状态影响主动H行为判断

#### 11.3 与素质系统的交互
- 催眠本质上是特殊的素质获得过程
- 催眠深度影响素质获得的判断
- 催眠素质影响其他系统的前提判断

#### 11.4 与结算系统的交互
- 催眠状态在行为结算中有特殊显示
- 苦痛快感化影响痛苦相关的结算
- 催眠度变化会在结算中显示

#### 11.5 与状态机系统的交互
- 催眠状态触发特定的二段行为
- 不同催眠深度对应不同的状态机分支

### 12. 开发注意事项

#### 12.1 数值平衡
- 理智消耗需要与游戏整体平衡匹配
- 催眠深度增长包含随机性，需考虑数值波动
- 不同催眠类型的深度要求形成递进关系

#### 12.2 状态管理
- 催眠状态需要与其他无意识状态互斥
- 空气催眠的位置绑定需要特殊处理
- 催眠状态的持续性条件需要准确判断

#### 12.3 前提条件
- 各催眠指令都有复杂的前提条件判断
- 催眠状态的前提判断需要考虑多种情况
- 催眠效果的前提判断需要精确到具体类型

#### 12.4 AI行为
- 催眠状态下的NPC行为需要特殊处理
- 不同催眠类型对AI行为的影响不同
- 需要考虑催眠状态下的例外情况

#### 12.5 用户体验
- 催眠深度和类型的显示需要清晰
- 催眠失败时需要给出明确提示
- 催眠效果的持续时间需要明确说明

### 13. 近期重要更新记录

#### 13.1 角色扮演系统重构（重大更新）

**更新历史：**
- `410cef38` - 实装：（催眠）初步重构了新的角色扮演催眠系统
- `25c33861` - 实装：（催眠）重构了新的角色扮演催眠系统  
- `cc06064c` - 实装：（催眠）增加了AI生成的角色扮演催眠的催眠指令地文
- `b4b65536` - 实装：（催眠）实装了AI文本生成功能中对于角色扮演催眠的支持
- `3ee1ec6c` - 调整：增加了在切换催眠模式面板中，对于体控、心控的各子项的说明

**核心变化：**
1. **数据结构升级**：从单一`int`类型升级为`List[int]`，支持多角色扮演
2. **界面系统重构**：全新的分类展开/收起界面，改善用户体验
3. **AI集成**：完整集成到AI文本生成系统，自动应用角色设定
4. **选择逻辑优化**：智能的冲突检测和联动选择机制

#### 13.2 技术迁移注意事项

**13.2.1 数据兼容性**
```python
# 旧版本数据需要迁移
if isinstance(character_data.hypnosis.roleplay, int):
    # 将单一值转换为列表
    old_value = character_data.hypnosis.roleplay
    character_data.hypnosis.roleplay = [old_value] if old_value > 0 else []
```

**13.2.2 前提条件更新**
角色扮演相关的前提条件需要适配新的列表结构：
```python
def handle_hypnosis_roleplay(character_id: int) -> bool:
    character_data = cache.character_data[character_id]
    return len(character_data.hypnosis.roleplay) > 0
```

**13.2.3 AI系统集成**
确保AI文本生成正确处理多角色扮演：
```python
if len(npc_character_data.hypnosis.roleplay):
    for roleplay_id in npc_character_data.hypnosis.roleplay:
        roleplay_data = game_config.config_roleplay[roleplay_id]
        roleplay_info = roleplay_data.info
        new_info += " " + roleplay_info
```

### 14. 扩展性考虑

#### 14.1 新催眠类型
- 系统架构支持添加新的催眠类型
- 配置表驱动的设计便于扩展
- unconscious_h值预留了扩展空间

#### 14.2 新催眠效果
- HYPNOSIS数据结构预留了扩展字段
- 可以添加新的体控或心控效果
- 角色扮演系统支持新的扮演类型和更复杂的分类体系

#### 14.3 催眠素质扩展
- 催眠素质ID有扩展空间
- 可以添加更多等级的催眠能力
- 支持更复杂的催眠素质获得条件

#### 14.4 与新系统的集成
- 催眠系统的模块化设计便于与新系统集成
- 前提条件系统支持新的催眠相关判断
- 结算系统可以扩展新的催眠效果处理
- AI文本生成系统完全支持催眠状态的动态变化

## 总结

催眠系统是erArk中一个复杂而完整的游戏机制，通过多层次的数据结构、详细的状态管理、丰富的效果类型和完善的交互逻辑，为玩家提供了深度的角色控制体验。

**近期重大改进包括：**

1. **角色扮演系统重构**：从简单的单一选择升级为支持多角色扮演的复杂分类体系，大幅增强了玩法的深度和多样性

2. **AI文本生成集成**：完整集成到AI文本生成系统，使催眠状态能够动态影响AI生成的文本内容，大幅提升了游戏的沉浸感

3. **用户界面优化**：全新的分类展开/收起界面设计，智能的选择判断逻辑，以及完善的冲突检测机制，极大改善了用户体验

4. **技术架构升级**：采用更现代的数据结构和设计模式，提高了系统的可维护性和扩展性

这些改进使催眠系统成为了一个更加强大、灵活且用户友好的游戏核心机制。系统的模块化设计和配置驱动的架构确保了未来功能的轻松扩展和维护。