# 事件系统

erArk游戏的事件系统是一个基于前提条件、权重计算和随机选择的动态事件触发机制。本文档详细描述了事件系统的组成部分、工作流程以及各个组件之间的关系。

## 核心组件

### 1. 主要文件

- **`Script/Design/event.py`**: 事件系统的核心处理模块
- **`Script/UI/Panel/draw_event_text_panel.py`**: 事件文本绘制面板
- **`Script/UI/Panel/event_option_panel.py`**: 事件选项面板
- **`Script/Design/settle_behavior.py`**: 行为结算系统（包含事件结算）
- **`Script/Design/handle_premise.py`**: 前提条件处理系统

### 2. 数据文件

- **`data/event/event.json`**: 主要事件数据文件
- **`data/event/milk.json`**: 特定类型事件数据
- **`data/event/hold.json`**: 特定类型事件数据
- **`data/Character_Event.json`**: 角色专属事件数据
- **`game_config.config_event`**: 编译后的事件配置数据
- **`game_config.config_event_status_data`**: 行为-事件映射关系

## 事件系统工作流程

### 1. 事件触发入口

事件系统的主要入口是 `handle_event()` 函数，在以下情况下被调用：
- 角色行为结算时（`settle_behavior.py`）
- 指令执行前后（通过 `event_before_instrust_flag` 参数控制）

### 2. 事件筛选过程

```python
def handle_event(character_id: int, event_before_instrust_flag = False):
```

事件筛选按以下步骤进行：

#### 步骤1：行为匹配
- 根据角色当前的 `behavior_id` 查找对应的事件列表
- 从 `game_config.config_event_status_data` 中获取该行为的所有可能事件

#### 步骤2：角色专属事件过滤
- 检查事件的 `adv_id` 字段：
  - 如果为空或"0"，则为通用事件
  - 如果有具体值，则为角色专属事件
- 根据事件触发者（sys_0 = 玩家触发，sys_1 = NPC触发）进行匹配

#### 步骤3：事件类型过滤
- `event_before_instrust_flag = True` 时，跳过 `type = 1` 的事件（指令后事件）
- 只处理 `type = 0` 或 `type = 2` 的事件

#### 步骤4：触发记录检查
- `this_event_in_triggered_record`: 事件必须在历史触发记录中
- `this_event_not_in_triggered_record`: 事件不能在历史触发记录中
- `this_event_in_today_triggered_record`: 事件必须在今日触发记录中
- `this_event_not_in_today_triggered_record`: 事件不能在今日触发记录中

#### 步骤5：前提条件计算
- 调用 `handle_premise.get_weight_from_premise_dict()` 计算前提权重
- 前提权重 > 0 的事件进入候选列表

### 3. 事件选择与执行

#### 权重随机选择
- 将通过筛选的事件按权重分组
- 使用 `value_handle.get_rand_value_for_value_region()` 随机选择权重级别
- 从该权重级别的事件中随机选择一个

#### 事件执行
- 创建 `DrawEventTextPanel` 对象进行文本绘制
- 特殊处理：如果事件类型为2且包含效果`10012`，则设置跳过指令口上

## 事件数据结构

### 事件配置格式
```json
{
    "event_id": {
        "uid": "唯一标识符",
        "adv_id": "角色专属ID（0为通用）",
        "behavior_id": "关联的行为ID",
        "start": "开始时间",
        "type": "事件类型（0/1/2）",
        "text": "事件文本内容",
        "premise": {
            "前提ID": "权重值"
        },
        "effect": {
            "效果ID": "效果值"
        }
    }
}
```

### 事件类型说明
- **Type 0**: 普通事件
- **Type 1**: 指令后事件（需要指令执行后才能触发）
- **Type 2**: 指令前事件（可以跳过指令直接触发）

## 事件文本处理

### 文本绘制系统
`DrawEventTextPanel` 类负责事件文本的显示：

#### 特殊文本处理
- **子事件文本**: 包含"|"分隔符，提取分隔符后的内容
- **DIY事件文本**: 包含两个"|"分隔符，提取第三部分内容
- **代码词语转换**: 通过 `talk.code_text_to_draw_text()` 转换特殊代码

#### 显示控制
- 检查玩家是否在收藏模式
- 验证玩家与角色的位置关系
- 应用角色专属的文本颜色样式

## 子事件系统

### 子事件识别
- 通过前提条件 `option_son` 识别
- 通过 `CVP_A1_Son` 前提识别
- 在 `event_option_panel.py` 中进行复杂的子事件处理

### 子事件处理流程
1. 检查主事件是否包含子事件前提
2. 计算子事件的权重和条件
3. 生成子事件选项供玩家选择
4. 根据选择触发相应的子事件

## 与其他系统的关联

### 行为系统
- 每个行为（behavior）都可以关联多个事件
- 通过 `config_event_status_data` 建立映射关系
- 行为结算时自动触发相关事件

### 前提系统
- 依赖 `handle_premise.py` 进行复杂的前提条件计算
- 支持角色属性、状态、位置等多种前提类型
- 支持权重累加和优先级判定

### 效果系统
- 事件可以产生各种效果（effect）
- 效果在 `settle_behavior.py` 中进行处理
- 支持属性修改、状态变更等

### 口上系统
- 事件文本与角色口上系统集成
- 支持动态文本替换和角色专属内容
- 可以跳过指令口上（通过效果10012）

## 配置构建流程

### 数据编译
通过 `buildconfig.py` 将JSON事件数据编译为：
- Python配置对象（`config_def.py`）
- 运行时配置字典（`game_config.py`）
- 行为-事件映射关系

### 本地化支持
- 支持多语言文本
- 通过PO文件系统进行翻译管理
- 动态文本替换和格式化

## 性能优化

### 缓存机制
- 使用 `calculated_premise_dict` 缓存前提计算结果
- 避免重复计算相同的前提条件
- 提高事件筛选效率

### 权重计算优化
- 采用分层权重系统
- 支持权重范围随机选择
- 减少不必要的计算开销

## 调试与开发

### 调试功能
- 事件ID记录和跟踪
- 前提条件计算日志
- 触发记录管理

### 开发工具
- ArkEditor提供可视化事件编辑
- 支持实时预览和测试
- 前提条件验证工具

## 总结

erArk的事件系统是一个高度模块化、可扩展的动态事件处理框架。它通过前提条件、权重计算和随机选择机制，为游戏提供了丰富的交互体验。系统设计考虑了性能、可维护性和扩展性，支持角色专属事件、多语言本地化和复杂的事件关联关系。