# in_scene_panel场景互动界面

## 概述

`in_scene_panel.py` 是 erArk 游戏中的核心界面之一，负责显示场景互动界面。这是玩家在游戏中进行角色交互的主要界面，显示当前场景中的所有角色、角色状态、可用指令等信息。

## 文件位置
- 主文件：`/Script/UI/Panel/in_scene_panel.py`
- 类名：`InScenePanel`

## 核心功能

### 1. 场景信息显示
- 显示游戏时间（通过 `game_info_panel.GameTimeInfoPanel`）
- 显示当前位置（使用 `attr_text.get_scene_path_text()` 格式化）
- 显示门锁状态（通过 `handle_premise.handle_place_door_close()` 检查）
- 显示场景中的所有角色列表

### 2. 角色交互管理
- 自动设置交互对象：
  - 如果场景中有NPC，且当前交互对象不在场景中，自动切换到第一个NPC
  - 如果刚移动到新场景，自动选择第一个NPC
  - 如果场景中没有NPC，交互对象设为自己（ID=0）
- 支持角色收藏筛选功能（`cache.is_collection`）

### 3. 面板布局控制
- 支持显示/隐藏以下面板：
  - 状态栏（index=0）：角色状态信息
  - 服装栏（index=1）：角色服装信息
  - 身体栏（index=2）：角色身体状态
  - 图片栏（index=4）：角色立绘
  - 详细污浊（index=5）：详细的污浊信息
- 通过 `cache.scene_panel_show[]` 数组控制面板可见性

## 主要组件集成

### 1. 角色信息显示组件

#### CharacterInfoHead（角色头部信息）
- 显示玩家和交互对象的基本状态
- 包含HP、MP、体力等数值
- 双栏布局：左侧玩家，右侧交互对象

#### SeeCharacterStatusPanel（状态详情面板）
- 显示详细的角色状态
- 可通过按钮切换显示/隐藏
- 仅在有交互对象时显示

### 2. 服装与身体状态组件

#### SeeCharacterClothPanel（服装面板）
- 显示角色当前穿着的服装
- 显示服装的污损状态
- 支持查看脱下的衣物

#### SeeCharacterBodyPanel（身体面板）
- 显示角色身体各部位的状态
- 包含污浊程度、插入状态等信息
- 支持详细/简略显示切换

### 3. 特殊模式组件

#### SeeGroupSexInfoPanel（群交模式面板）
- 仅在 `cache.group_sex_mode` 激活时显示
- 显示群交活动的参与者和状态

#### See_Hidden_Sex_InfoPanel（隐奸模式面板）
- 通过 `handle_premise.handle_hidden_sex_mode_ge_1()` 判断激活
- 显示隐秘行动的状态和发现概率

### 4. 图像显示组件

#### CharacterImageListDraw（角色图像列表）
- 显示场景中所有角色的立绘
- 支持特殊状态下的断面图显示
- 可通过按钮切换显示/隐藏

### 5. 指令面板组件

#### SeeInstructPanel（指令面板）
- 显示所有可用的玩家指令
- 根据当前状态和前置条件动态过滤指令
- 是玩家进行游戏操作的主要接口

## 数据流程

### 1. 位置数据处理
```python
# 获取玩家位置（列表格式）
pl_character_data.position  # 例如：['中枢', '博士办公室']

# 转换为字符串路径
scene_path_str = map_handle.get_map_system_path_str_for_list(position)
# 结果：'中枢/博士办公室'

# 获取场景数据
scene_data = cache.scene_data[scene_path_str]

# 格式化显示文本
position_text = attr_text.get_scene_path_text(position)
# 结果：'控制中枢-博士办公室'
```

### 2. 角色列表处理
```python
# 获取场景中的角色
character_set = scene_data.character_list.copy()
character_set.remove(0)  # 移除玩家自己

# 应用收藏筛选
if cache.is_collection:
    character_list = [i for i in character_set if i in pl_character_data.collection_character]
else:
    character_list = list(character_set)
```

### 3. 面板渲染流程
1. 清屏（Web模式）
2. 绘制标题栏
3. 显示时间和位置
4. 显示角色列表
5. 绘制显示/隐藏按钮
6. 根据配置显示各个子面板
7. 显示指令面板
8. 收集所有按钮返回值
9. 等待用户输入

## 性能优化

- 使用时间测量监控绘制性能
- 日志记录关键步骤耗时
- Web模式下批量更新以减少通信开销

## 缓存变量使用

### 主要缓存变量
- `cache.character_data[0]`：玩家角色数据
- `cache.scene_data`：所有场景数据字典
- `cache.now_panel_id`：当前面板ID
- `cache.scene_panel_show[]`：面板显示状态数组
- `cache.is_collection`：是否启用收藏筛选
- `cache.group_sex_mode`：群交模式标志
- `cache.all_system_setting.draw_setting`：系统绘制设置
- `cache.pl_pre_behavior_instruce`：玩家之前的行为指令列表

## Web模式支持

- 通过 `cache.web_mode` 判断是否为Web模式
- Web模式下需要额外的清屏操作
- 使用 `io_init.clear_screen()` 和 `io_init.clear_order()`

## 与其他系统的关系

1. **游戏主循环**：作为 `constant.Panel.IN_SCENE` 面板被主循环调用
2. **角色行为系统**：显示角色状态，提供指令接口
3. **地图系统**：显示位置信息，处理场景数据
4. **事件系统**：通过指令面板触发各种事件
5. **前置条件系统**：通过 `handle_premise` 检查各种条件

## 扩展要点

1. 添加新面板：
   - 在 `cache.scene_panel_show` 数组中添加新索引
   - 创建对应的显示/隐藏按钮
   - 在合适位置添加面板绘制代码

2. 修改交互逻辑：
   - 修改角色自动选择逻辑（117-130行）
   - 调整面板显示条件

3. 性能优化：
   - 减少不必要的重绘
   - 优化大量角色时的显示逻辑
   - 考虑延迟加载或分页显示